/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.commands;

public class SerialCommand {
    protected static final String BLANK = " ";
    protected static final String PREFIX_HEX = "0x";
    protected static final long TIMEOUT = 10000L;
    private String command = null;
    private long timeout = 10000L;

    public SerialCommand() {
    }

    public SerialCommand(String command) {
        this.init(command);
    }

    private void init(String command) {
        this.setCommand(command);
    }

    public String getCommand() {
        return this.command;
    }

    protected void setCommand(String command) {
        this.command = command;
    }

    public long getTimeout() {
        if (this.timeout < 10000L) {
            this.timeout = 10000L;
        }
        return this.timeout;
    }

    public long calculateTimeOut(String length) {
        return SerialCommand.getLength(length) / 8L;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected static long getLength(String hexlength) {
        if (hexlength == null || hexlength.length() == 0) {
            return 0L;
        }
        int indexOf = hexlength.toLowerCase().indexOf("x");
        try {
            return Long.parseLong(hexlength.substring(indexOf + 1), 16);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

