/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model;

import com.hisilicon.fastboot.model.PCNetworkInfo;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.config.BurnConfig;
import com.hisilicon.fastboot.model.define.IConfig;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.utilitily.IPUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BoardConfig
implements IConfig {
    public static final String DIVIDEE_SYMBOLS1 = ",";
    public static final String DIVIDEE_SYMBOLS2 = ";";
    public static final List<PCNetworkInfo> pcNetworkInfoList = IPUtils.getPCNetworkInfo();
    private String mac = null;
    private String ip = "192.168.1.2";
    private String subnetMask = "255.255.255.0";
    private String gateway = "192.168.1.1";
    private int frequency;
    private int smallboradmodel;
    private ToolType toolType;

    public BoardConfig(ToolType toolType) {
        this.toolType = toolType;
        if (toolType == ToolType.Composite) {
            String serverIP = this.getServerIPForBoradIP();
            if (serverIP == null) {
                return;
            }
            String ip = FastbootPreferences.CONFIG.getClientIP();
            if (!IPUtils.isBlank(ip)) {
                this.ip = ip;
            } else if (serverIP.lastIndexOf(".") > 0) {
                String defaultIpAddress;
                this.ip = defaultIpAddress = String.valueOf(serverIP.substring(0, serverIP.lastIndexOf("."))) + ".0";
                FastbootPreferences.CONFIG.setClientIP(defaultIpAddress);
            }
            String gateway = FastbootPreferences.CONFIG.getClientGateway();
            if (!IPUtils.isBlank(gateway)) {
                this.gateway = gateway;
            } else if (pcNetworkInfoList != null) {
                if (pcNetworkInfoList.size() > 0) {
                    int i = 0;
                    while (i < pcNetworkInfoList.size()) {
                        PCNetworkInfo pcNetworkInfo = pcNetworkInfoList.get(i);
                        String localGateway = pcNetworkInfo.getGateway();
                        String localIp = pcNetworkInfo.getIp();
                        if (serverIP.equalsIgnoreCase(localIp) && localGateway.lastIndexOf(".") > 0) {
                            this.gateway = localGateway;
                            FastbootPreferences.CONFIG.setClientGateway(localGateway);
                        }
                        ++i;
                    }
                } else {
                    FastbootPreferences.CONFIG.setClientNetmask(this.subnetMask);
                }
            } else {
                FastbootPreferences.CONFIG.setClientGateway(this.gateway);
            }
            String subnetMask = FastbootPreferences.CONFIG.getClientNetmask();
            if (!IPUtils.isBlank(subnetMask)) {
                this.subnetMask = subnetMask;
            } else if (pcNetworkInfoList != null) {
                if (pcNetworkInfoList.size() > 0) {
                    int i = 0;
                    while (i < pcNetworkInfoList.size()) {
                        PCNetworkInfo pcNetworkInfo = pcNetworkInfoList.get(i);
                        String localSubnetMask = pcNetworkInfo.getSubnetMask();
                        String localIp = pcNetworkInfo.getIp();
                        if (serverIP.equalsIgnoreCase(localIp) && localSubnetMask.lastIndexOf(".") > 0) {
                            this.subnetMask = localSubnetMask;
                            FastbootPreferences.CONFIG.setClientNetmask(localSubnetMask);
                        }
                        ++i;
                    }
                } else {
                    FastbootPreferences.CONFIG.setClientNetmask(this.subnetMask);
                }
            } else {
                FastbootPreferences.CONFIG.setClientNetmask(this.subnetMask);
            }
            String mac = FastbootPreferences.CONFIG.getClientMac();
            this.mac = IPUtils.isValidMac(mac) ? mac : IPUtils.generatorMAC();
        } else {
            String serverIP = this.getServerIPForBoradIP();
            BoardConfig boardConfig = BurnConfig.getBoardConfig();
            if (boardConfig == null) {
                return;
            }
            String ip = boardConfig.getIp();
            String gateway = boardConfig.getGateway();
            String subnetMask = boardConfig.getSubnetMask();
            String mac = boardConfig.getMac();
            this.initIP(toolType, serverIP, ip);
            this.initGateway(toolType, serverIP, gateway);
            this.initSubnetMask(toolType, serverIP, subnetMask);
            this.initMac(mac);
        }
    }

    private void initMac(String mac) {
        this.mac = IPUtils.isValidMac(mac) ? mac : IPUtils.generatorMAC();
    }

    private void initSubnetMask(ToolType platformType, String serverIP, String subnetMask) {
        if (!IPUtils.isBlank(subnetMask)) {
            this.subnetMask = subnetMask;
        } else if (pcNetworkInfoList != null && pcNetworkInfoList.size() > 0) {
            int i = 0;
            while (i < pcNetworkInfoList.size()) {
                PCNetworkInfo pcNetworkInfo = pcNetworkInfoList.get(i);
                String localSubnetMask = pcNetworkInfo.getSubnetMask();
                String localIp = pcNetworkInfo.getIp();
                if (serverIP.equalsIgnoreCase(localIp) && localSubnetMask.lastIndexOf(".") > 0) {
                    this.subnetMask = localSubnetMask;
                }
                ++i;
            }
        }
    }

    private void initGateway(ToolType platformType, String serverIP, String gateway) {
        if (!IPUtils.isBlank(gateway)) {
            this.gateway = gateway;
        } else if (pcNetworkInfoList != null && pcNetworkInfoList.size() > 0) {
            int i = 0;
            while (i < pcNetworkInfoList.size()) {
                PCNetworkInfo pcNetworkInfo = pcNetworkInfoList.get(i);
                String localGateway = pcNetworkInfo.getGateway();
                String localIp = pcNetworkInfo.getIp();
                if (serverIP.equalsIgnoreCase(localIp) && localGateway.lastIndexOf(".") > 0) {
                    this.gateway = localGateway;
                }
                ++i;
            }
        }
    }

    private void initIP(ToolType platformType, String serverIP, String ip) {
        if (!IPUtils.isBlank(ip)) {
            this.ip = ip;
        } else if (serverIP.lastIndexOf(".") > 0) {
            String defaultIpAddress = "0.0.0.0";
            this.ip = defaultIpAddress = String.valueOf(serverIP.substring(0, serverIP.lastIndexOf("."))) + ".0";
        }
    }

    private String getServerIPForBoradIP() {
        String serverIp;
        block10: {
            serverIp = null;
            String configServerIP = null;
            if (this.toolType == ToolType.Composite) {
                configServerIP = FastbootPreferences.CONFIG.getServerIP();
            } else if (BurnConfig.getLocalConfig() != null) {
                configServerIP = BurnConfig.getLocalConfig().getServerIp();
            }
            String[] serverIps = IPUtils.getServerIps();
            if (IPUtils.isValidIP(configServerIP)) {
                if (Arrays.asList(serverIps).contains(configServerIP)) {
                    serverIp = configServerIP;
                } else if (serverIps.length > 0) {
                    serverIp = serverIps[0];
                }
            } else {
                try {
                    serverIp = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    if (serverIps.length <= 0) break block10;
                    serverIp = serverIps[0];
                }
            }
        }
        return serverIp;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getIp() {
        return this.ip;
    }

    public String getMac() {
        return this.mac;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
    }

    public static List<BoardConfig> load(ToolType toolType) {
        ArrayList<BoardConfig> boardConfigs = new ArrayList<BoardConfig>();
        String[] config = FastbootPreferences.CONFIG.getClientWholeConfig().split(DIVIDEE_SYMBOLS2);
        BoardConfig convert = null;
        String[] stringArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            convert = BoardConfig.convert(string, toolType);
            if (convert != null) {
                boardConfigs.add(convert);
            }
            ++n2;
        }
        return boardConfigs;
    }

    public static String save(List<BoardConfig> boardConfigs) {
        StringBuilder sb = new StringBuilder();
        for (BoardConfig boardConfig : boardConfigs) {
            if (sb.length() > 0) {
                sb.append(DIVIDEE_SYMBOLS2);
            }
            sb.append(boardConfig.toString());
        }
        return sb.toString();
    }

    public static BoardConfig convert(String setting, ToolType toolType) {
        String[] value = setting.split(DIVIDEE_SYMBOLS1);
        if (value.length != 4) {
            return null;
        }
        BoardConfig boardConfig = new BoardConfig(toolType);
        boardConfig.setMac(value[0]);
        boardConfig.setIp(value[1]);
        boardConfig.setSubnetMask(value[2]);
        boardConfig.setGateway(value[3]);
        return boardConfig;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getSmallboradmodel() {
        return this.smallboradmodel;
    }

    public void setSmallboradmodel(int smallboradmodel) {
        this.smallboradmodel = smallboradmodel;
    }

    public String toString() {
        return String.valueOf(this.mac) + DIVIDEE_SYMBOLS1 + this.ip + DIVIDEE_SYMBOLS1 + this.subnetMask + DIVIDEE_SYMBOLS1 + this.gateway;
    }
}

