/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model;

import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.cmdline.CmdType;
import com.hisilicon.fastboot.model.config.BurnConfig;
import com.hisilicon.fastboot.model.define.IConfig;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.utilitily.IPUtils;
import com.hisilicon.fastboot.views.CmdMain;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.soyatec.connector.api.serial.SerialHelper;

public class LocalConfig
implements IConfig {
    private String comPort = null;
    private String serverIp;

    public LocalConfig(ToolType toolType) {
        if (toolType == ToolType.Cmdline) {
            this.localCmdlineConfig();
        } else {
            this.localComposite();
        }
    }

    private void localComposite() {
        block11: {
            String serial = FastbootPreferences.CONFIG.getSerial();
            if (serial != null) {
                List listSerialPorts = SerialHelper.listSerialPorts();
                if (listSerialPorts.contains(serial)) {
                    this.comPort = serial;
                } else if (!listSerialPorts.isEmpty()) {
                    this.comPort = (String)listSerialPorts.get(0);
                }
            }
            String serverIP = FastbootPreferences.CONFIG.getServerIP();
            String[] serverIps = IPUtils.getServerIps();
            if (IPUtils.isValidIP(serverIP)) {
                if (Arrays.asList(serverIps).contains(serverIP)) {
                    this.serverIp = serverIP;
                } else if (serverIps.length > 0) {
                    this.serverIp = serverIps[0];
                }
            } else {
                try {
                    this.serverIp = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    if (serverIps.length <= 0) break block11;
                    this.serverIp = serverIps[0];
                }
            }
        }
    }

    private void localCmdlineConfig() {
        block13: {
            CmdType curCmdType;
            String serial = "";
            String serverIP = "";
            LocalConfig localConfig = BurnConfig.getLocalConfig();
            if (localConfig != null) {
                serial = localConfig.getComPort();
                serverIP = localConfig.getServerIp();
            }
            if ((curCmdType = CmdMain.getCurCmdType()) != null && curCmdType == CmdType.burn) {
                if (serial != null) {
                    List listSerialPorts = SerialHelper.listSerialPorts();
                    if (listSerialPorts.contains(serial)) {
                        this.comPort = serial;
                    } else if (!listSerialPorts.isEmpty()) {
                        this.comPort = (String)listSerialPorts.get(0);
                    }
                }
                String[] serverIps = IPUtils.getServerIps();
                if (IPUtils.isValidIP(serverIP)) {
                    if (Arrays.asList(serverIps).contains(serverIP)) {
                        this.serverIp = serverIP;
                    } else if (serverIps.length > 0) {
                        this.serverIp = serverIps[0];
                    }
                } else {
                    try {
                        this.serverIp = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        if (serverIps.length <= 0) break block13;
                        this.serverIp = serverIps[0];
                    }
                }
            }
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public String getComPort() {
        return this.comPort;
    }

    public void setComPort(String comPort) {
        this.comPort = comPort;
    }
}

