/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.define;

import com.hisilicon.fastboot.Activator;
import com.hisilicon.fastboot.consoles.FastbootConsoleFactory;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.ILog;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.event.IFastbootEventListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public interface IFastbootProgressMonitor
extends ILog {
    public static final IFastbootProgressMonitor PROGRESSMONITORCOMPOSITE = new NullProgressMonitor(ToolType.Composite);
    public static final IFastbootProgressMonitor PROGRESSMONITORCMDLINE = new NullProgressMonitor(ToolType.Cmdline);

    public void addListener(IFastbootEventListener var1);

    public void removeListener(IFastbootEventListener var1);

    public FastbootEvent getEvent();

    public void begin();

    public void finish();

    public void highlight(PartitionItem var1);

    public void updateLength(long var1);

    public void log(String var1);

    public static class NullProgressMonitor
    implements IFastbootProgressMonitor {
        public SimpleDateFormat dateFormat = new SimpleDateFormat();
        private FastbootEvent event = new FastbootEvent();
        private FileOutputStream LOG = null;
        private ToolType toolType;
        private List<IFastbootEventListener> listeners = new ArrayList<IFastbootEventListener>();

        public NullProgressMonitor(ToolType toolType) {
            this.toolType = toolType;
        }

        @Override
        public FastbootEvent getEvent() {
            return this.event;
        }

        @Override
        public void addListener(IFastbootEventListener iFastbootEventListener) {
            if (iFastbootEventListener == null) {
                return;
            }
            if (!this.listeners.contains(iFastbootEventListener)) {
                this.listeners.add(iFastbootEventListener);
            }
        }

        @Override
        public void removeListener(IFastbootEventListener iFastbootEventListener) {
            if (iFastbootEventListener == null) {
                return;
            }
            if (this.listeners.contains(iFastbootEventListener)) {
                this.listeners.remove(iFastbootEventListener);
            }
        }

        @Override
        public void print(String str) {
            if (str == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.print(str);
            } else {
                FastbootConsoleFactory.getDebugConsole().getDefaultStream().print(str);
            }
        }

        @Override
        public void println(String str) {
            if (str == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.println(str);
            } else {
                FastbootConsoleFactory.getDebugConsole().getDefaultStream().println(str);
            }
        }

        @Override
        public void error(String err) {
            if (err == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.error(err);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getReceivedStream().print(err);
            }
        }

        @Override
        public void errorln(String err) {
            if (err == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.errorln(err);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getReceivedStream().println(err);
            }
        }

        @Override
        public void warn(String warning) {
            if (warning == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.warn(warning);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getWarningStream().print(warning);
            }
        }

        @Override
        public void warnln(String warning) {
            if (warning == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.warningln(warning);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getWarningStream().println(warning);
            }
        }

        @Override
        public void info(String info) {
            if (info == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.info(info);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getInfoStream().print(info);
            }
        }

        @Override
        public void infoln(String info) {
            if (info == null) {
                return;
            }
            if (ToolType.Cmdline == this.toolType) {
                Log.infoln(info);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getInfoStream().println(info);
            }
        }

        @Override
        public void begin() {
            if (ToolType.Composite == this.toolType) {
                if (this.event != null) {
                    Activator.getDefault().setEvent(this.event);
                }
                try {
                    this.LOG = Log.getLog();
                    this.LOG.write((String.valueOf(this.dateFormat.format(new Date())) + "\n\r\n").getBytes(System.getProperty("file.encoding")));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IFastbootEventListener l : NullProgressMonitor.this.listeners) {
                            l.started(NullProgressMonitor.this.getEvent());
                        }
                    }
                });
            } else {
                for (IFastbootEventListener l : this.listeners) {
                    l.started(this.getEvent());
                }
            }
        }

        @Override
        public void finish() {
            try {
                if (ToolType.Composite == this.toolType) {
                    Activator default1 = Activator.getDefault();
                    if (default1 == null) {
                        return;
                    }
                    default1.setEvent(null);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (IFastbootEventListener l : NullProgressMonitor.this.listeners) {
                                l.finished(NullProgressMonitor.this.getEvent());
                            }
                            NullProgressMonitor.this.getEvent().setType(null);
                        }
                    });
                } else {
                    for (IFastbootEventListener l : this.listeners) {
                        l.finished(this.getEvent());
                    }
                    this.getEvent().setType(null);
                }
            }
            finally {
                if (this.LOG != null) {
                    try {
                        this.LOG.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        @Override
        public void highlight(PartitionItem part) {
            if (part == null) {
                return;
            }
            final ArrayList<PartitionItem> list = new ArrayList<PartitionItem>();
            list.add(part);
            if (ToolType.Cmdline == this.toolType) {
                for (IFastbootEventListener l : this.listeners) {
                    l.hightLight(list);
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IFastbootEventListener l : NullProgressMonitor.this.listeners) {
                            l.hightLight(list);
                        }
                    }
                });
            }
        }

        @Override
        public void updateLength(final long length) {
            if (ToolType.Cmdline == this.toolType) {
                for (IFastbootEventListener l : this.listeners) {
                    l.updateLength(length);
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IFastbootEventListener l : NullProgressMonitor.this.listeners) {
                            l.updateLength(length);
                        }
                    }
                });
            }
        }

        @Override
        public void log(String log) {
            try {
                if (this.LOG != null && log != null && log.length() > 0) {
                    this.LOG.write(log.getBytes(System.getProperty("file.encoding")));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

