/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.BoardConfig;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.serial.workers.AbstractBurnerWorker;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.CallLibUSBWorker;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.hisilicon.fastboot.utilitily.IPUtils;
import com.hisilicon.fastboot.views.FastbootView;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.tftp.hitool.TFTPService;

public abstract class AbstractBurner {
    protected String msg_serialPort_cannot_be_connected = "Can not connect to the Serial Port! It may be in use.";
    private BurnContext burnContext;
    protected String programmerFile;
    protected ToolType toolType;

    public AbstractBurner(BurnContext burnContext, ToolType toolType) {
        this.burnContext = burnContext;
        this.toolType = toolType;
    }

    public String getProgrammerFile() {
        return this.programmerFile;
    }

    public void setProgrammerFile(String file) {
        this.programmerFile = file;
    }

    public BurnContext getBurnContext() {
        return this.burnContext;
    }

    protected void handleTftpStartFailed() {
        if (this.toolType == ToolType.Composite) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
        } else {
            Log.errorln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
        }
    }

    protected void getTftpPreferenceValue() {
        boolean isSupportTFTPWin = ((UnknownDevice)this.burnContext.getDeviceSetting()).isSupportTFTPWin();
        if (isSupportTFTPWin) {
            if (this.toolType == ToolType.Composite) {
                TFTPService.setWinSizeOpen((boolean)FastbootPreferences.isOpenTftpWindowSize());
                TFTPService.setWinSizeBlockCount((int)FastbootPreferences.getInt("hisilicon.fastboot.tftp.windowSize.blockCount"));
                TFTPService.setSettingRetransmit((int)FastbootPreferences.getInt("hisilicon.fastboot.tftp.retry.count"));
                TFTPService.setSettingIgnoreBlockAck((boolean)FastbootPreferences.isTftpIgnoreBlockAck());
            } else {
                TFTPService.setWinSizeOpen((boolean)PreferenceConfig.isTftpWinSizeOpen());
                TFTPService.setWinSizeBlockCount((int)PreferenceConfig.getTftpWinSizeBlockCount());
                TFTPService.setSettingRetransmit((int)PreferenceConfig.getTftpRetryCount());
                TFTPService.setSettingIgnoreBlockAck((boolean)PreferenceConfig.isTftpLostEnable());
            }
        } else {
            TFTPService.setWinSizeBlockCount((int)1);
        }
    }

    /*
     * Exception decompiling
     */
    public SerialPort openSerailPort(IFastbootProgressMonitor monitor, AbstractBurnerWorker worker, String serialPortName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract AbstractBurnerWorker getBurnerWorker();

    protected IStatus validSerialPort() {
        boolean needCheckSerial;
        LocalConfig localConfig = this.burnContext.getLocalConfig();
        String comPort = localConfig.getComPort();
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean bl = needCheckSerial = transferWay == TransferWay.Serial || transferWay == TransferWay.Net || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress;
        if (needCheckSerial && (comPort == null || comPort.isEmpty())) {
            return this.error(Messages.AbstractBurner_msg_serialPort_is_null);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validLocalConfig() {
        IStatus validSerialPort = this.validSerialPort();
        if (!this.isOK(validSerialPort)) {
            return validSerialPort;
        }
        return Status.OK_STATUS;
    }

    protected void handleSerialPortInUse(IFastbootProgressMonitor monitor, PortInUseException e) {
        if (monitor != null) {
            monitor.getEvent().setType(null);
            monitor.getEvent().setSuccess(false);
            monitor.warnln(this.msg_serialPort_cannot_be_connected);
        }
        if (this.toolType == ToolType.Composite) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)AbstractBurner.this.msg_serialPort_cannot_be_connected);
                }
            });
        } else {
            Log.errorln(this.msg_serialPort_cannot_be_connected);
        }
    }

    protected void showProgressDialog(Job job) {
        if (job == null) {
            return;
        }
        job.setUser(true);
    }

    protected IStatus validNetConfig() {
        IStatus local;
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        if (transferWay != TransferWay.JTAGAndNet && !this.isOK(local = this.validLocalConfig())) {
            return local;
        }
        if (transferWay != TransferWay.Net && transferWay != TransferWay.UsbTransNet && transferWay != TransferWay.JTAGAndNet) {
            return null;
        }
        IStatus check = this.checkServieIP();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.validBoardConfig();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.validSameNet();
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    protected IStatus checkServieIP() {
        String[] serverIps = IPUtils.getServerIps();
        String currentServerIp = this.burnContext.getLocalConfig().getServerIp();
        boolean flag = false;
        int i = 0;
        while (i < serverIps.length) {
            if (serverIps[i].equalsIgnoreCase(currentServerIp)) {
                flag = true;
                break;
            }
            ++i;
        }
        if (!flag) {
            return this.error(Messages.PartitionBurner_msg_check_serviceIp);
        }
        return Status.OK_STATUS;
    }

    private IStatus validSameNet() {
        BoardConfig boardConfig = this.burnContext.getBoardConfig();
        String gateway = boardConfig.getGateway();
        String ip = boardConfig.getIp();
        String subnetMask = boardConfig.getSubnetMask();
        LocalConfig localConfig = this.burnContext.getLocalConfig();
        String serverIp = localConfig.getServerIp();
        if (gateway.equals(ip)) {
            return this.error(Messages.AbstractBurner_msg_gateway_and_ip_are_same);
        }
        if (ip.equals(serverIp)) {
            return this.error(Messages.AbstractBurner_msg_boardip_and_serverip_are_same);
        }
        boolean needCheckSameNetWork = false;
        needCheckSameNetWork = this.toolType == ToolType.Composite ? FastbootPreferences.isCheckSameNetWork() : PreferenceConfig.isCheckNetWork();
        if (needCheckSameNetWork) {
            if (!IPUtils.isOnTheSameNetIP(gateway, ip, subnetMask)) {
                return this.error(Messages.AbstractBurner_msg_boardip_and_serverip_are_same);
            }
            if (!IPUtils.isOnTheSameNetIP(serverIp, ip, subnetMask)) {
                return this.error(Messages.AbstractBurner_msg_boardip_and_serverip_are_not_on_the_same_net);
            }
        }
        return null;
    }

    protected IStatus validBoardConfig() {
        LocalConfig localConfig = this.burnContext.getLocalConfig();
        String serverIp = localConfig.getServerIp();
        if (serverIp == null || serverIp.isEmpty()) {
            return this.error(Messages.AbstractBurner_msg_serverIP_is_null);
        }
        BoardConfig boardConfig = this.burnContext.getBoardConfig();
        String mac = boardConfig.getMac();
        if (mac == null || mac.isEmpty()) {
            return this.error(Messages.AbstractBurner_msg_macAddress_is_null);
        }
        if (!IPUtils.isValidMac(mac)) {
            return this.error(Messages.AbstractBurner_msg_macAddress_is_invalid);
        }
        int i = 0;
        while (i < mac.length()) {
            if ((i + 1) % 3 == 0 ? mac.charAt(i) != ':' : mac.charAt(i) == ':') {
                return this.error(Messages.AbstractBurner_msg_macAddress_is_invalid);
            }
            ++i;
        }
        String ip = boardConfig.getIp();
        if (ip == null || ip.isEmpty()) {
            return this.error(Messages.AbstractBurner_msg_serverIP_is_null);
        }
        String subnetMask = boardConfig.getSubnetMask();
        if (IPUtils.isBlank(subnetMask)) {
            return this.error(Messages.AbstractBurner_msg_subnetMask_is_null);
        }
        String gateway = boardConfig.getGateway();
        if (IPUtils.isBlank(gateway)) {
            return this.error(Messages.AbstractBurner_msg_gateway_is_null);
        }
        return Status.OK_STATUS;
    }

    public IStatus error(String msg) {
        if (HiToolUtils.isCmdLine()) {
            Log.errorln(msg);
        }
        return new Status(4, "com.hisilicon.fastboot", msg);
    }

    protected boolean isOK(IStatus status) {
        return status == null || status.isOK();
    }

    public IStatus checkBeforeBurn() {
        return this.validNetConfig();
    }

    protected void shutDownTFTP(final IFastbootProgressMonitor fastbootMonitor) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog d = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                        try {
                            d.run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        monitor.setTaskName(Messages.AbstractBurner_shuting_down_TFTP_Server_Please_wait_for_a_moment);
                                        TFTPService.TFTPSERVICE.stop();
                                    }
                                    finally {
                                        fastbootMonitor.finish();
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }).start();
    }

    protected void closeByTrans() {
        boolean isJtag;
        AbstractBurnerWorker worker = this.getBurnerWorker();
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean isI2C = transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean isUsb = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        boolean bl = isJtag = transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAGAndSerial;
        if (isI2C) {
            I2cCommand.I2cCloseChannel();
            worker.infoln("\nI2C channels were closed successfully.");
        } else if (isUsb) {
            CallLibUSBWorker.closeUsb();
            worker.infoln("\nUSB channels were closed successfully.");
        } else if (isJtag) {
            if (FastbootView.isHi3231V530Series() && FastbootView.isFastbootStart()) {
                String resetCommand = "reset";
                try {
                    worker.sendCommandNoReturnValue(resetCommand);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ReceiveTimeOutException e) {
                    e.printStackTrace();
                }
            }
            CallLibJTAGWorker.releaseJtag();
            worker.infoln("\nJTAG channels were closed successfully.");
        }
    }
}

