/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.commands.I2cCommand;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IBootBurner;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.model.monitor.CmdMonitor;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.AbstractBurnerWorker;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import com.hisilicon.fastboot.ui.burners.tabs.BootTab;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.hisilicon.fastboot.views.FastbootView;
import gnu.io.SerialPort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class FastbootBurner
extends AbstractBurner
implements IBootBurner {
    private FlashType flashType;
    private String file;
    private ToolType toolType;

    public FastbootBurner(BurnContext burnContext, ToolType toolType) {
        super(burnContext, toolType);
        this.toolType = toolType;
    }

    protected IFrameSetting getFrameSetting() {
        return this.getBurnContext().getDeviceSetting().getFrameSetting();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        final LocalConfig config = this.getBurnContext().getLocalConfig();
        final FastbootBurnerWorker worker = (FastbootBurnerWorker)this.getBurnerWorker();
        final BurnContext context = this.getBurnContext();
        worker.setProgressMonitor(fastbootMonitor);
        if (HiToolUtils.isCmdLine()) {
            CmdMonitor monitor = new CmdMonitor();
            try {
                try {
                    worker.burn(monitor, this.getFlashType(), this.getFile());
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fastbootMonitor == null) return;
                    fastbootMonitor.finish();
                    this.closeByTrans();
                    return;
                }
                catch (ReceiveTimeOutException e) {
                    e.printStackTrace();
                    if (fastbootMonitor == null) return;
                    fastbootMonitor.finish();
                    this.closeByTrans();
                    return;
                }
            }
            finally {
                if (fastbootMonitor != null) {
                    fastbootMonitor.finish();
                    this.closeByTrans();
                }
            }
        } else {
            Job fastbootJob = new Job("Burn Fastboot"){

                protected IStatus run(IProgressMonitor monitor) {
                    boolean needOpenSerial;
                    TransferWay transferWay = FastbootBurner.this.getBurnContext().getTransferWay();
                    boolean bl = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial && !((UnknownDevice)FastbootBurner.this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom();
                    if (needOpenSerial) {
                        monitor.beginTask("Open Serial Port", 10);
                        SerialPort serialPort = FastbootBurner.this.openSerailPort(fastbootMonitor, worker, config.getComPort());
                        monitor.beginTask("Open Serial Port", 20);
                        if (serialPort == null) {
                            return null;
                        }
                    } else if (fastbootMonitor != null) {
                        fastbootMonitor.begin();
                    }
                    if (FastbootView.isHi3731V110()) {
                        worker.setProgressMonitor(monitor);
                        if (!worker.sendTranslateWayFrame(transferWay)) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (context.getTransferWay() == TransferWay.I2CBootrom) {
                        if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                            worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is 0x" + Integer.toHexString(52));
                        } else {
                            return null;
                        }
                    }
                    try {
                        try {
                            worker.burn(monitor, FastbootBurner.this.getFlashType(), FastbootBurner.this.getFile());
                        }
                        catch (Throwable e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(fastbootJob);
            fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                    FastbootBurner.this.closeByTrans();
                }
            });
            fastbootJob.schedule();
        }
    }

    @Override
    public IStatus checkBeforeBurn() {
        IStatus validSerialPort = this.validSerialPort();
        if (!this.isOK(validSerialPort)) {
            return validSerialPort;
        }
        if (this.flashType == null) {
            return this.error(Messages.AbstractBurner_msg_falshType_is_null);
        }
        if (this.file == null || this.file.trim().length() == 0) {
            return this.error(Messages.AbstractBurner_msg_file_path_does_not_select);
        }
        File theFile = new File(this.file);
        if (!theFile.exists()) {
            return this.error(Messages.AbstractBurner_msg_the_file_does_not_exist);
        }
        if (theFile.isDirectory()) {
            return this.error(Messages.AbstractBurner_msg_the_file_can_not_be_a_directory);
        }
        if (this.file.length() == 0) {
            return this.error(NLS.bind((String)Messages.AbstractBurner_msg_the_file_size_must_be_nonzero, (Object)1));
        }
        if (!(FastbootView.isHi3251Series() || FastbootView.isHi3731Series() || FastbootView.isHi3231Series() || theFile.length() <= 0x100000L)) {
            return this.error(Messages.AbstractBurner_msg_the_bootFile_size_must_be_less_than_1m);
        }
        return null;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public FlashType getFlashType() {
        return this.flashType;
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(Messages.FastbootBurner_Step_1);
        steps.add(Messages.FastbootBurner_Step_2);
        steps.add(Messages.FastbootBurner_Step_3);
        steps.add(Messages.FastbootBurner_Step_4);
        return steps;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    @Override
    public ITab getTab() {
        return new BootTab();
    }

    @Override
    protected AbstractBurnerWorker getBurnerWorker() {
        return new FastbootBurnerWorker(this.getFrameSetting(), this, this.toolType);
    }

    @Override
    public ChipID getChipID() {
        return null;
    }

    @Override
    public void setFlashId(ChipID chipId) {
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor, String directory) {
    }
}

