/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners.bvt;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.commands.NetCommand;
import com.hisilicon.fastboot.model.FileInfo;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.PartitionBurnerWorker;
import java.io.IOException;

public class BVTPartitionBurnerWorker
extends PartitionBurnerWorker {
    public BVTPartitionBurnerWorker(IBurner burner, ToolType toolType) {
        super(burner, toolType);
    }

    @Override
    public boolean sendStartFrame(FileInfo fileInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBStartFrame();
        }
        String temp = null;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.frameSetting.getSendStartFrameTimeout()) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            this.onAdataAvailable(serialReceived);
            temp = serialReceived.toString();
            int indexOf = temp.indexOf("     ");
            if (indexOf == -1) continue;
            try {
                this.sendBytes(new byte[]{-86});
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean setupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        this.infoln("waiting phy ready, it will take 8s.");
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            NetCommand[] commands;
            String usbTransNetCmd;
            if (transferWay == TransferWay.UsbTransNet && !this.sendCommand(usbTransNetCmd = "usb start")) {
                this.returnError(Messages.Fastboot_NotSupportUsbTransNetWay);
                return false;
            }
            NetCommand[] netCommandArray = commands = this.buildNetCommands(transferWay);
            int n = commands.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                NetCommand command = netCommandArray[n2];
                if (!this.sendCommand(command)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

