/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.unknown;

import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.ICommonBurner;
import com.hisilicon.fastboot.model.devices.IEmmcBurner;
import com.hisilicon.fastboot.model.devices.IFileSystemSetting;
import com.hisilicon.fastboot.model.devices.IMergeBurner;
import com.hisilicon.fastboot.model.devices.IPartitionBurner;
import com.hisilicon.fastboot.model.devices.unknown.UDProperties;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.util.ArrayList;

public class UDFileSystemSetting
implements IFileSystemSetting {
    FileSystem[] fileSystemsForPartitionBurner;
    FileSystem[] fileSystemsForEmmcBurner;
    FileSystem[] fileSystemsForMerge;
    FileSystem[] fileSystemsForCommonBurner;
    FileSystem[] fileSystemsForCmdLine;

    private UDFileSystemSetting() {
    }

    public static UDFileSystemSetting build(UDProperties properties) {
        UDFileSystemSetting fileSystemSetting = new UDFileSystemSetting();
        if (fileSystemSetting.init(properties)) {
            return fileSystemSetting;
        }
        return null;
    }

    private boolean init(UDProperties properties) {
        String boardType;
        Integer squashFsInt;
        if (properties == null) {
            return false;
        }
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        fsList.add(FileSystem.none);
        Integer yaffsInt = properties.queryForInteger("YAFFS");
        if (yaffsInt != null && yaffsInt == 1) {
            fsList.add(FileSystem.yaffs);
        }
        if ((squashFsInt = properties.queryForInteger("SQUASHFS")) != null && squashFsInt == 1) {
            fsList.add(FileSystem.squashFs);
        }
        if ((boardType = properties.queryForString("TYPE")) != null && (boardType.equals("STB") || boardType.equals("BVT"))) {
            fsList.add(FileSystem.ubiFs);
        }
        this.fileSystemsForPartitionBurner = new FileSystem[fsList.size()];
        fsList.toArray(this.fileSystemsForPartitionBurner);
        Integer extInt = properties.queryForInteger("EXT");
        if (extInt != null && extInt == 1) {
            fsList.add(FileSystem.ext3);
        }
        fsList.add(FileSystem.f2fs);
        this.fileSystemsForMerge = new FileSystem[fsList.size()];
        fsList.toArray(this.fileSystemsForMerge);
        if (HiToolUtils.isCmdLine()) {
            this.fileSystemsForCmdLine = new FileSystem[fsList.size()];
            fsList.toArray(this.fileSystemsForCmdLine);
        } else {
            this.fileSystemsForCommonBurner = new FileSystem[fsList.size()];
            fsList.toArray(this.fileSystemsForCommonBurner);
        }
        fsList.clear();
        fsList.add(FileSystem.none);
        if (extInt != null && extInt == 1) {
            fsList.add(FileSystem.ext3);
        }
        fsList.add(FileSystem.f2fs);
        if (squashFsInt != null && squashFsInt == 1) {
            fsList.add(FileSystem.squashFs);
        }
        this.fileSystemsForEmmcBurner = new FileSystem[fsList.size()];
        fsList.toArray(this.fileSystemsForEmmcBurner);
        return true;
    }

    @Override
    public FileSystem[] getFileSystems(IBurner burner) {
        if (HiToolUtils.isCmdLine()) {
            return this.getFileSystemsForCmdLine();
        }
        if (burner instanceof ICommonBurner) {
            return this.getFileSystemsForCommonBurner();
        }
        if (burner instanceof IEmmcBurner) {
            return this.getFileSystemsForEmmcBurner();
        }
        if (burner instanceof IMergeBurner) {
            return this.getFileSystemsForMerge();
        }
        if (burner instanceof IPartitionBurner) {
            return this.getFileSystemsForPartitionBurner();
        }
        return FileSystem.values();
    }

    @Override
    public String[] getFileSystemNames(IBurner burner) {
        FileSystem[] fileSystems = this.getFileSystems(burner);
        String[] result = new String[fileSystems.length];
        int i = 0;
        while (i < result.length) {
            result[i] = fileSystems[i].name();
            ++i;
        }
        return result;
    }

    @Override
    public FileSystem findFileSystem(String name) {
        FileSystem[] values;
        FileSystem[] fileSystemArray = values = FileSystem.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystem fileSystem = fileSystemArray[n2];
            if (fileSystem.name().equalsIgnoreCase(name)) {
                return fileSystem;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public FileSystem findFileSystem(IBurner burner, String name) {
        FileSystem[] values;
        FileSystem[] fileSystemArray = values = this.getFileSystems(burner);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystem fileSystem = fileSystemArray[n2];
            if (fileSystem.name().equalsIgnoreCase(name)) {
                return fileSystem;
            }
            ++n2;
        }
        return null;
    }

    public FileSystem[] getFileSystemsForPartitionBurner() {
        return (FileSystem[])this.fileSystemsForPartitionBurner.clone();
    }

    public FileSystem[] getFileSystemsForEmmcBurner() {
        return (FileSystem[])this.fileSystemsForEmmcBurner.clone();
    }

    public FileSystem[] getFileSystemsForMerge() {
        return (FileSystem[])this.fileSystemsForMerge.clone();
    }

    public FileSystem[] getFileSystemsForCommonBurner() {
        return (FileSystem[])this.fileSystemsForCommonBurner.clone();
    }

    public FileSystem[] getFileSystemsForCmdLine() {
        return (FileSystem[])this.fileSystemsForCmdLine.clone();
    }
}

