/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.unknown;

import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IBurnerContext;
import com.hisilicon.fastboot.model.devices.IDeviceSetting;
import com.hisilicon.fastboot.model.devices.IFileSystemSetting;
import com.hisilicon.fastboot.model.devices.IFlashSetting;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.devices.unknown.UDBurnerContext;
import com.hisilicon.fastboot.model.devices.unknown.UDFileSystemSetting;
import com.hisilicon.fastboot.model.devices.unknown.UDFlashSetting;
import com.hisilicon.fastboot.model.devices.unknown.UDFrameSetting;
import com.hisilicon.fastboot.model.devices.unknown.UDProperties;
import com.hisilicon.fastboot.utilitily.AESUtils;
import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.api.chips.Tool;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class UnknownDevice
implements IDeviceSetting {
    public static final int EXIST = 1;
    private static final String DEVICE_SETTING_FOLDER = "Resources/Common/ChipProperties/";
    private static final String AES_KEY = "HiReg-5D765B15-8F5B-46DC-9B7C-80322B8F74E4";
    private static boolean isOpenLightDebug;
    private BurnContext burnContext;
    private IFrameSetting frameSetting;
    private IBurnerContext burnerContext;
    private IFlashSetting flashSetting;
    private IFileSystemSetting fileSystemSetting;
    private String name;
    private UDProperties properties;
    private boolean isValid;
    private int emmcType;
    private int nandIPVer;
    private int spinandIPVer;
    private int emmcWriteCommand;
    private boolean isSupportUsb2eth;
    private boolean isSupportJTAGAndUsb2eth;
    private boolean isSupportTFTPWin;
    private boolean isNotSupportNet;
    private boolean isSupportUart2Compress;
    private boolean isSupportUsb2I2c;
    private boolean isSupportBurnByLibBootrom;
    private boolean isSupportDebugDDrTraining;
    private String nandPinSaveMode;
    private String spiNandPinSaveMode;
    private String nandAlignmentType;
    private boolean isSupportNandEmpty;
    private boolean isSupportSPINandEmpty;
    private boolean isSupportDDrTrainingDelay;
    private boolean isSupportI2CBootrom;
    private boolean isSupportUSBBootrom;
    private boolean isSupportUSBNonNude;
    private boolean isSupportNETNonNude;
    private boolean isSupportJTAGAndNet;
    private boolean isSupportJTAGAndSerial;
    private boolean isSupportJTAG;
    private boolean isSupportCommonPartition;
    private boolean isSupportUfs;

    public UnknownDevice(String name, ToolType toolType) {
        this.name = name;
        this.loadChipProperties(toolType);
    }

    public String getChipName(String name) {
        ArrayList<Chip> chipList = HiToolUtils.getChip("Resources/Common/ChipProperties/Profile.hitool");
        if (chipList == null) {
            return name;
        }
        for (Chip chip : chipList) {
            ArrayList toolList;
            if (!name.equalsIgnoreCase(chip.getName()) || (toolList = chip.getToolList()) == null) continue;
            for (Tool tool : toolList) {
                if (!"HiBurn".equals(tool.getId())) continue;
                String param = tool.getParam();
                if (param == null) {
                    return name;
                }
                String[] keyvalue = param.split("=");
                if (keyvalue.length != 2 || !"type".equalsIgnoreCase(keyvalue[0].trim())) continue;
                return keyvalue[1];
            }
        }
        return name;
    }

    private void loadChipProperties(ToolType toolType) {
        String propertiesFile = null;
        String filePath = null;
        if (toolType == ToolType.Composite) {
            propertiesFile = DEVICE_SETTING_FOLDER + this.name + ".chip";
            filePath = FileUtils.toAbsolutePath(propertiesFile);
            IFastbootProgressMonitor monitor = IFastbootProgressMonitor.PROGRESSMONITORCOMPOSITE;
            monitor.println("chip Name filePath : " + filePath + "\n");
        } else {
            propertiesFile = DEVICE_SETTING_FOLDER + this.getChipName(this.name) + ".chip";
            filePath = FileUtils.toAbsolutePath(propertiesFile, toolType);
        }
        if (!FileUtils.isExists(filePath)) {
            this.isValid = false;
            return;
        }
        this.properties = new UDProperties();
        byte[] definitionData = AESUtils.decrypt(FileUtils.readAllBytes(filePath), AES_KEY);
        try {
            String[] definitionLines;
            String[] stringArray = definitionLines = new String(definitionData, System.getProperty("file.encoding")).split("\r\n");
            int n = definitionLines.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ppt;
                String s = stringArray[n2];
                String line = s.trim().replace("\t", "");
                if (!line.startsWith("[") && line.contains("=") && (ppt = line.split("=")).length > 1) {
                    this.properties.set(ppt[0], ppt[1]);
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.burnContext = new BurnContext(toolType);
        this.burnContext.setDeviceSetting(this);
        this.loadCaOrFlash();
        this.loadTransport();
        this.loadMakeImg();
        this.loadDDRTraning();
        this.loadInterfaceConfig();
        this.frameSetting = UDFrameSetting.build(this.properties);
        this.burnerContext = UDBurnerContext.build(this.properties, this, toolType);
        this.flashSetting = UDFlashSetting.build(this.properties);
        this.fileSystemSetting = UDFileSystemSetting.build(this.properties);
        this.isValid = this.frameSetting != null && this.burnerContext != null && this.flashSetting != null && this.fileSystemSetting != null;
    }

    private void loadInterfaceConfig() {
        Integer commonPartition = this.properties.queryForInteger("CommonPartition");
        this.isSupportCommonPartition = commonPartition != null && commonPartition == 1;
    }

    private void loadDDRTraning() {
        Integer debugDDrTraining = this.properties.queryForInteger("DebugDDrTraining");
        this.isSupportDebugDDrTraining = debugDDrTraining != null && debugDDrTraining == 1;
        Integer ddrTrainingDelay = this.properties.queryForInteger("DDrTrainingDelay");
        this.isSupportDDrTrainingDelay = ddrTrainingDelay != null && ddrTrainingDelay == 1;
    }

    private void loadMakeImg() {
        String nandPinSaveModeStr = this.properties.queryForString("NandPinSaveMode");
        this.nandPinSaveMode = nandPinSaveModeStr != null ? nandPinSaveModeStr : null;
        String spiNandPinSaveModeStr = this.properties.queryForString("SPINandPinSaveMode");
        this.spiNandPinSaveMode = spiNandPinSaveModeStr != null ? spiNandPinSaveModeStr : null;
        String nandAlignmentTypeStr = this.properties.queryForString("NANDAlignmentType");
        this.nandAlignmentType = nandAlignmentTypeStr != null && !nandAlignmentTypeStr.isEmpty() ? nandAlignmentTypeStr : null;
        Integer nandEmpty = this.properties.queryForInteger("NandEmpty");
        this.isSupportNandEmpty = nandEmpty != null && nandEmpty == 1;
        Integer spiNandEmpty = this.properties.queryForInteger("SPINandEmpty");
        this.isSupportSPINandEmpty = spiNandEmpty != null && spiNandEmpty == 1;
    }

    private void loadTransport() {
        Integer jtagandusb2eth = this.properties.queryForInteger("JTAGANDUSB2ETH");
        this.isSupportJTAGAndUsb2eth = jtagandusb2eth != null && jtagandusb2eth == 1;
        Integer usb2eth = this.properties.queryForInteger("USB2ETH");
        this.isSupportUsb2eth = usb2eth != null && usb2eth == 1;
        Integer tftpWin = this.properties.queryForInteger("TFTPWIN");
        this.isSupportTFTPWin = tftpWin != null && tftpWin == 1;
        Integer notSupportNet = this.properties.queryForInteger("NOTSUPPORTNET");
        this.isNotSupportNet = notSupportNet != null && notSupportNet == 1;
        Integer uart2Compress = this.properties.queryForInteger("UART2COMPRESS");
        this.isSupportUart2Compress = uart2Compress != null && uart2Compress == 1;
        Integer usb2i2c = this.properties.queryForInteger("USB2I2C");
        this.isSupportUsb2I2c = usb2i2c != null && usb2i2c == 1;
        Integer burnByLibBootrom = this.properties.queryForInteger("BurnByLibBootrom");
        this.isSupportBurnByLibBootrom = burnByLibBootrom != null && burnByLibBootrom == 1;
        Integer i2cBootrom = this.properties.queryForInteger("I2CBootrom");
        this.isSupportI2CBootrom = i2cBootrom != null && i2cBootrom == 1;
        Integer usbBootrom = this.properties.queryForInteger("USBBootrom");
        this.isSupportUSBBootrom = usbBootrom != null && usbBootrom == 1;
        Integer usbNonNude = this.properties.queryForInteger("USBNonNude");
        this.isSupportUSBNonNude = usbNonNude != null && usbNonNude == 1;
        Integer netNonNude = this.properties.queryForInteger("NETNonNude");
        this.isSupportNETNonNude = netNonNude != null && netNonNude == 1;
        Integer jtagAndNet = this.properties.queryForInteger("JTAGAndNet");
        this.isSupportJTAGAndNet = jtagAndNet != null && jtagAndNet == 1;
        Integer jtagAndSerial = this.properties.queryForInteger("JTAGAndSerial");
        this.isSupportJTAGAndSerial = jtagAndSerial != null && jtagAndSerial == 1;
        Integer jtag = this.properties.queryForInteger("JTAG");
        this.isSupportJTAG = jtag != null && jtag == 1;
        Integer ufsInt = this.properties.queryForInteger("UFS");
        this.isSupportUfs = ufsInt != null && ufsInt == 1;
    }

    private void loadCaOrFlash() {
        Integer nandBurnIP;
        Integer caValue = this.properties.queryForInteger("CA");
        if (caValue != null && caValue == 1) {
            this.burnContext.setPlatformType(PlatformType.CA);
        }
        this.nandIPVer = (nandBurnIP = this.properties.queryForInteger("NANDBURN")) != null ? nandBurnIP : -1;
        Integer spiNandBurnIP = this.properties.queryForInteger("SPINANDBURN");
        this.spinandIPVer = spiNandBurnIP != null ? spiNandBurnIP : -1;
        Integer emmcBurnCommand = this.properties.queryForInteger("EMMCBURN");
        this.emmcWriteCommand = emmcBurnCommand != null ? emmcBurnCommand : -1;
    }

    public static void loadLightDebug(String chipName) {
        String propertiesFile = DEVICE_SETTING_FOLDER + chipName + ".chip";
        if (!FileUtils.isExists(FileUtils.toAbsolutePath(propertiesFile))) {
            return;
        }
        UDProperties properties = new UDProperties();
        byte[] definitionData = AESUtils.decrypt(FileUtils.readAllBytes(FileUtils.toAbsolutePath(propertiesFile)), AES_KEY);
        try {
            String[] definitionLines;
            String[] stringArray = definitionLines = new String(definitionData, System.getProperty("file.encoding")).split("\r\n");
            int n = definitionLines.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ppt;
                String s = stringArray[n2];
                String line = s.trim().replace("\t", "");
                if (!line.startsWith("[") && line.contains("=") && (ppt = line.split("=")).length > 1) {
                    properties.set(ppt[0], ppt[1]);
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Integer lightDebugInt = properties.queryForInteger("LIGHTDEBUG");
        isOpenLightDebug = lightDebugInt != null ? lightDebugInt == 1 : false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IFrameSetting getFrameSetting() {
        return this.frameSetting;
    }

    @Override
    public IBurnerContext getBurnerContext() {
        return this.burnerContext;
    }

    @Override
    public BurnContext getBurnContext() {
        return this.burnContext;
    }

    @Override
    public IFlashSetting getFlashSetting() {
        return this.flashSetting;
    }

    @Override
    public IFileSystemSetting getFileSystemSetting() {
        return this.fileSystemSetting;
    }

    public UDProperties getProperties() {
        return this.properties;
    }

    public int getNandIPVer() {
        return this.nandIPVer;
    }

    public int getSpinandIPVer() {
        return this.spinandIPVer;
    }

    public int getEmmcWriteCmdType() {
        return this.emmcWriteCommand;
    }

    public void setEmmcType(int type) {
        this.emmcType = type;
    }

    public int getEmmcType() {
        return this.emmcType;
    }

    public static boolean isOpenLightDebug() {
        return isOpenLightDebug;
    }

    public boolean isSupportUsb2eth() {
        return this.isSupportUsb2eth;
    }

    public boolean isSupportTFTPWin() {
        return this.isSupportTFTPWin;
    }

    public boolean isSupportUart2Compress() {
        return this.isSupportUart2Compress;
    }

    public boolean isSupportUsb2I2c() {
        return this.isSupportUsb2I2c;
    }

    public void setSupportUsb2I2c(boolean isSupportUsb2I2c) {
        this.isSupportUsb2I2c = isSupportUsb2I2c;
    }

    public boolean isNotSupportNet() {
        return this.isNotSupportNet;
    }

    public boolean isSupportBurnByLibBootrom() {
        return this.isSupportBurnByLibBootrom;
    }

    public boolean isSupportDebugDDrTraining() {
        return this.isSupportDebugDDrTraining;
    }

    public String getNandPinSaveMode() {
        return this.nandPinSaveMode;
    }

    public String getSpiNandPinSaveMode() {
        return this.spiNandPinSaveMode;
    }

    public String getNandAlignmentType() {
        return this.nandAlignmentType;
    }

    public boolean isSupportNandEmpty() {
        return this.isSupportNandEmpty;
    }

    public boolean isSupportSPINandEmpty() {
        return this.isSupportSPINandEmpty;
    }

    public boolean isSupportDDrTrainingDelay() {
        return this.isSupportDDrTrainingDelay;
    }

    public boolean isSupportI2CBootrom() {
        return this.isSupportI2CBootrom;
    }

    public boolean isSupportUSBBootrom() {
        return this.isSupportUSBBootrom;
    }

    public boolean isSupportUSBNonNude() {
        return this.isSupportUSBNonNude;
    }

    public boolean isSupportNETNonNude() {
        return this.isSupportNETNonNude;
    }

    public void setSupportNETNonNude(boolean isSupportNETNonNude) {
        this.isSupportNETNonNude = isSupportNETNonNude;
    }

    public boolean isSupportJTAGAndUsb2eth() {
        return this.isSupportJTAGAndUsb2eth;
    }

    public boolean isSupportJTAGAndSerial() {
        return this.isSupportJTAGAndSerial;
    }

    public boolean isSupportJTAGAndNet() {
        return this.isSupportJTAGAndNet;
    }

    public boolean isSupportJTAG() {
        return this.isSupportJTAG;
    }

    public boolean isSupportCommonPartition() {
        return this.isSupportCommonPartition;
    }

    public boolean isSupportUfs() {
        return this.isSupportUfs;
    }

    public void setSupportUfs(boolean isSupportUfs) {
        this.isSupportUfs = isSupportUfs;
    }

    public String queryForString(String propertyType) {
        if (this.properties != null) {
            return this.properties.queryForString(propertyType);
        }
        return null;
    }
}

