/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.packagers.nand;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.cmdline.adapter.NandImg;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.packagers.nand.FlashOption;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPCommon;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV600;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV620;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NandImageDialog
extends Dialog {
    protected Shell shell;
    private Text textOobSize;
    private Combo comboBlockSize;
    private Button buttonRandom;
    private Combo comboNandType;
    private FlashOption[] options;
    private FlashOption selectedFlashOption;
    private int blockSize;
    private boolean isSelectRandom;
    private NandIPCommon nandIp;

    public NandImageDialog(Shell parent, int style, NandIPCommon nandIp, IBurner burner) {
        super(parent, style);
        this.options = nandIp.getAvailableOptions(burner);
        this.nandIp = nandIp;
        this.setText(Messages.NandImageDialog_Title);
        this.createContents();
    }

    public FlashOption getSelectedFlashOption() {
        return this.selectedFlashOption;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public Object open() {
        int i = 0;
        while (i < this.options.length) {
            this.comboNandType.add(this.options[i].toString());
            ++i;
        }
        Monitor primary = Display.getCurrent().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return null;
    }

    private void createContents() {
        int i;
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(320, 240);
        this.shell.setText(this.getText());
        GridLayout gl_shell = new GridLayout(2, false);
        gl_shell.verticalSpacing = 8;
        gl_shell.horizontalSpacing = 8;
        gl_shell.marginHeight = 8;
        gl_shell.marginWidth = 8;
        this.shell.setLayout((Layout)gl_shell);
        Label lblNandType = new Label((Composite)this.shell, 0);
        lblNandType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNandType.setText(Messages.NandImageDialog_NandType);
        this.comboNandType = new Combo((Composite)this.shell, 8);
        this.comboNandType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboNandType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FlashOption option = NandImageDialog.this.options[NandImageDialog.this.comboNandType.getSelectionIndex()];
                if (option.getOOBSize() != -1) {
                    NandImageDialog.this.textOobSize.setText(String.valueOf(option.getOOBSize()));
                } else {
                    NandImageDialog.this.textOobSize.setText("");
                }
                if (NandImageDialog.this.nandIp instanceof NandIPV620) {
                    NandImageDialog.this.comboBlockSize.setEnabled(true);
                    if (option.getPageType().getPageSize() >= 8192) {
                        NandImageDialog.this.buttonRandom.setEnabled(true);
                    }
                } else if (option.getPageType().getPageSize() >= 8192) {
                    NandImageDialog.this.buttonRandom.setEnabled(true);
                } else {
                    NandImageDialog.this.buttonRandom.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblOobSize = new Label((Composite)this.shell, 0);
        lblOobSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOobSize.setText(Messages.NandImageDialog_OOBSize);
        this.textOobSize = new Text((Composite)this.shell, 2048);
        this.textOobSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblRandomization = new Label((Composite)this.shell, 0);
        lblRandomization.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblRandomization.setText(Messages.NandImageDialog_Randomization);
        final Button btnCheckButton = new Button((Composite)this.shell, 32);
        btnCheckButton.setEnabled(false);
        btnCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(NandImageDialog.this.nandIp instanceof NandIPV620)) {
                    NandImageDialog.this.comboBlockSize.setEnabled(btnCheckButton.getSelection());
                }
                NandImageDialog.this.isSelectRandom = true;
            }
        });
        btnCheckButton.setText("");
        this.buttonRandom = btnCheckButton;
        Label lblBlockSize = new Label((Composite)this.shell, 0);
        lblBlockSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblBlockSize.setText(Messages.NandImageDialog_BlockSize);
        this.comboBlockSize = new Combo((Composite)this.shell, 8);
        if (this.nandIp instanceof NandIPV600 || this.nandIp instanceof NandIPV620) {
            this.comboBlockSize.setEnabled(true);
        } else {
            this.comboBlockSize.setEnabled(false);
        }
        if (this.nandIp instanceof NandIPV620) {
            i = 0;
            while (i < NandImg.getBlockSizeStrsV620().length) {
                this.comboBlockSize.add(NandImg.getBlockSizeStrsV620()[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < NandImg.getBlockSizeStrs().length) {
                this.comboBlockSize.add(NandImg.getBlockSizeStrs()[i]);
                ++i;
            }
        }
        this.comboBlockSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTips = new Label((Composite)this.shell, 64);
        lblTips.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        lblTips.setText(Messages.NandImageDialog_Tips);
        lblTips.setForeground(new Color((Device)Display.getCurrent(), 255, 0, 0));
        Composite compositeButtons = new Composite((Composite)this.shell, 0);
        GridLayout gl_compositeButtons = new GridLayout(2, false);
        gl_compositeButtons.marginWidth = 0;
        gl_compositeButtons.marginHeight = 0;
        compositeButtons.setLayout((Layout)gl_compositeButtons);
        compositeButtons.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Button btnMake = new Button(compositeButtons, 0);
        btnMake.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NandImageDialog.this.comboNandType.getSelectionIndex() == -1) {
                    MessageDialog.openWarning((Shell)NandImageDialog.this.shell, (String)"HiBurn", (String)Messages.NandImageDialog_NandTypeError);
                    return;
                }
                if (NandImageDialog.this.textOobSize.getText() == null || NandImageDialog.this.textOobSize.getText().length() == 0 || !NandImageDialog.this.textOobSize.getText().matches("^[0-9]*$")) {
                    MessageDialog.openWarning((Shell)NandImageDialog.this.shell, (String)"HiBurn", (String)Messages.NandImageDialog_OOBSizeError);
                    return;
                }
                if (Integer.parseInt(NandImageDialog.this.textOobSize.getText()) == 0) {
                    MessageDialog.openWarning((Shell)NandImageDialog.this.shell, (String)"HiBurn", (String)Messages.NandImageDialog_OOBSizeError);
                    return;
                }
                if (NandImageDialog.this.buttonRandom.getEnabled() && NandImageDialog.this.buttonRandom.getSelection() && NandImageDialog.this.comboBlockSize.getSelectionIndex() == -1) {
                    MessageDialog.openWarning((Shell)NandImageDialog.this.shell, (String)"HiBurn", (String)Messages.NandImageDialog_BlockSizeError);
                    return;
                }
                if (NandImageDialog.this.nandIp instanceof NandIPV620 && NandImageDialog.this.comboBlockSize.getSelectionIndex() == -1) {
                    MessageDialog.openWarning((Shell)NandImageDialog.this.shell, (String)"HiBurn", (String)Messages.NandImageDialog_BlockSize_NotSelected_Error);
                    return;
                }
                NandImageDialog.this.selectedFlashOption = new FlashOption(NandImageDialog.this.options[NandImageDialog.this.comboNandType.getSelectionIndex()].getEccType(), NandImageDialog.this.options[NandImageDialog.this.comboNandType.getSelectionIndex()].getPageType(), Integer.parseInt(NandImageDialog.this.textOobSize.getText()));
                if (NandImageDialog.this.nandIp instanceof NandIPV620) {
                    NandImageDialog.this.blockSize = NandImg.getBlockSizeSizesV620()[NandImageDialog.this.comboBlockSize.getSelectionIndex()];
                } else if (NandImageDialog.this.comboBlockSize.getSelectionIndex() < 0) {
                    NandImageDialog.this.blockSize = -1;
                } else {
                    NandImageDialog.this.blockSize = NandImg.getBlockSizeSizesV620()[NandImageDialog.this.comboBlockSize.getSelectionIndex()];
                }
                NandImageDialog.this.shell.close();
            }
        });
        GridData gd_btnMake = new GridData(16384, 1024, false, true, 1, 1);
        gd_btnMake.widthHint = 80;
        btnMake.setLayoutData((Object)gd_btnMake);
        btnMake.setText(Messages.NandImageDialog_Make);
        Button btnCancel = new Button(compositeButtons, 0);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NandImageDialog.this.shell.close();
            }
        });
        GridData gd_btnCancel = new GridData(16384, 1024, false, true, 1, 1);
        gd_btnCancel.widthHint = 80;
        btnCancel.setLayoutData((Object)gd_btnCancel);
        btnCancel.setText(Messages.NandImageDialog_Close);
        this.shell.pack();
    }

    public Combo getComboBlockSize() {
        return this.comboBlockSize;
    }

    public void setComboBlockSize(Combo comboBlockSize) {
        this.comboBlockSize = comboBlockSize;
    }

    public boolean isSelectRandom() {
        return this.isSelectRandom;
    }

    public void setSelectRandom(boolean isSelectRandom) {
        this.isSelectRandom = isSelectRandom;
    }
}

