/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.packagers.nand.ip;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.packagers.nand.FlashOption;
import com.hisilicon.fastboot.packagers.nand.PageType;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCBase;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCType;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCV610;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCV620;
import com.hisilicon.fastboot.packagers.nand.ip.INandSetting;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV500;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV600;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV610;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV620;
import com.hisilicon.fastboot.utilitily.BytesUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NandIPCommon
implements INandSetting {
    public static final String NAND = "Nand";
    public static final String SPINAND = "SPINand";
    public static final int NandIP_V500 = 500;
    public static final int NandIP_V600 = 600;
    public static final int NandIP_V610 = 610;
    public static final int NandIP_V611 = 611;
    public static final int NandIP_V620 = 620;
    protected static final int REVERSE_DATA_LENTH = 32;
    private static final String[] PIN_SAVE_MODE_ARRAY = new String[]{"nandcv200mode", "98cv200mode"};
    protected static final int DEFAULT_OOB_SIZE = 32;
    protected String curSelectedNandWay;

    protected byte[] genPageDataBytes(ECCBase ecc, FlashOption option, byte[] data, int ctrlSize, int eccSize) {
        byte[] result = BytesUtils.genBytesWithFF(option.getPageType().getPageSize() + option.getOOBSize());
        int pageSize = option.getPageType().getPageSize();
        int totalLen = pageSize + 2 + ctrlSize;
        int partCount = pageSize / 1024;
        int partSize = totalLen / partCount;
        int i = 0;
        while (i < partCount) {
            byte[] part = new byte[partSize];
            byte[] partForEcc = new byte[partSize];
            BytesUtils.copyBytes(part, data, 0, i * partSize, partSize);
            BytesUtils.copyBytes(partForEcc, data, 0, i * partSize, partSize);
            byte[] eccBuffer = BytesUtils.genBytesWithFF(eccSize);
            ECCType type = option.getEccType();
            if (type == ECCType.Ecc4bit) {
                ecc.ecc_4bit_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc16bit1k) {
                ecc.ecc_16bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc24bit1k) {
                ecc.ecc_24bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc40bit1k) {
                ecc.ecc_40bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc64bit1k) {
                ecc.ecc_64bit1k_gen(partForEcc, partSize, eccBuffer);
            } else {
                return null;
            }
            if (i < partCount - 1) {
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, partSize);
                BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize, 0, eccSize);
            } else {
                int lastPartDataSize = partSize - 2 - ctrlSize;
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, lastPartDataSize);
                BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + lastPartDataSize, 0, eccSize);
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize) + lastPartDataSize + eccSize, lastPartDataSize + 2, ctrlSize);
            }
            ++i;
        }
        i = result.length - 1;
        while (i > pageSize + 1) {
            result[i] = result[i - 2];
            --i;
        }
        result[pageSize] = data[pageSize];
        result[pageSize + 1] = data[pageSize + 1];
        return result;
    }

    protected byte[] genPageDataBytesFor610(ECCV610 ecc, FlashOption option, byte[] data, int ctrlSize, int eccSize) {
        byte[] result = BytesUtils.genBytesWithFF(option.getPageType().getPageSize() + option.getOOBSize());
        int pageSize = option.getPageType().getPageSize();
        int totalLen = pageSize + 2 + ctrlSize;
        int partCount = pageSize / 1024;
        int partSize = totalLen / partCount;
        int i = 0;
        while (i < partCount) {
            byte[] part = new byte[partSize];
            byte[] partForEcc = new byte[partSize];
            BytesUtils.copyBytes(part, data, 0, i * partSize, partSize);
            BytesUtils.copyBytes(partForEcc, data, 0, i * partSize, partSize);
            byte[] eccBuffer = BytesUtils.genBytesWithFF(eccSize);
            ECCType type = option.getEccType();
            if (type == ECCType.Ecc4bit) {
                ecc.ecc_8bit_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc13bit) {
                ecc.ecc_13bit_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc24bit) {
                ecc.ecc_24bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc27bit) {
                ecc.ecc_27bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc41bit) {
                ecc.ecc_41bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc60bit) {
                ecc.ecc_60bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc80bit) {
                ecc.ecc_80bit1k_gen(partForEcc, partSize, eccBuffer);
            } else {
                return null;
            }
            if (i < partCount - 1) {
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, partSize);
                BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize, 0, eccSize);
            } else {
                int lastPartDataSize = partSize - 2 - ctrlSize;
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, lastPartDataSize);
                BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + lastPartDataSize, 0, eccSize);
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize) + lastPartDataSize + eccSize, lastPartDataSize + 2, ctrlSize);
            }
            ++i;
        }
        i = result.length - 1;
        while (i > pageSize + 1) {
            result[i] = result[i - 2];
            --i;
        }
        result[pageSize] = data[pageSize];
        result[pageSize + 1] = data[pageSize + 1];
        return result;
    }

    protected byte[] genPageDataBytesForV620(ECCV620 ecc, FlashOption option, byte[] data, int ctrlSize, int eccSize) {
        boolean isSomeOption;
        byte[] result = BytesUtils.genBytesWithFF(option.getPageType().getPageSize() + option.getOOBSize());
        int pageSize = option.getPageType().getPageSize();
        int totalLen = pageSize + 2 + ctrlSize;
        int partCount = pageSize / 1024;
        int partSize = totalLen / partCount;
        int i = 0;
        while (i < partCount) {
            int lastPartDataSize;
            byte[] part = new byte[partSize];
            byte[] partForEcc = new byte[partSize];
            BytesUtils.copyBytes(part, data, 0, i * partSize, partSize);
            BytesUtils.copyBytes(partForEcc, data, 0, i * partSize, partSize);
            byte[] eccBuffer = BytesUtils.genBytesWithFF(eccSize);
            ECCType type = option.getEccType();
            if (type == ECCType.Ecc4bit) {
                ecc.ecc_4bit_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc8bit512) {
                ecc.ecc_8bit_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc24bit1k) {
                ecc.ecc_24bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc40bit1k) {
                ecc.ecc_40bit1k_gen(partForEcc, partSize, eccBuffer);
            } else if (type == ECCType.Ecc64bit1k) {
                ecc.ecc_64bit1k_gen(partForEcc, partSize, eccBuffer);
            } else {
                return null;
            }
            if (option.getPageType() == PageType.Size16K) {
                if (option.getEccType() == ECCType.Ecc40bit1k) {
                    if (i < partCount - 2) {
                        BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, partSize);
                        BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize, 0, eccSize);
                    } else if (i == partCount - 2) {
                        BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, partSize);
                        BytesUtils.copyBytes(result, data, i * (partSize + eccSize) + partSize + 14, pageSize, 2);
                        BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize, 0, 14);
                        BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize + 2 + 14, 14, 56);
                    } else {
                        lastPartDataSize = partSize - 2 - ctrlSize;
                        BytesUtils.copyBytes(result, part, i * (partSize + eccSize) + 2, 0, lastPartDataSize);
                        BytesUtils.copyBytes(result, data, i * (partSize + eccSize) + 2 + lastPartDataSize + eccSize, pageSize + 2, ctrlSize);
                        BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + 2 + lastPartDataSize, 0, eccSize);
                    }
                }
                if (option.getEccType() == ECCType.Ecc64bit1k) {
                    if (i < partCount - 2) {
                        BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, partSize);
                        BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize, 0, eccSize);
                    } else if (i == partCount - 2) {
                        BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, 452);
                        BytesUtils.copyBytes(result, data, i * (partSize + eccSize) + 452, pageSize, 2);
                        BytesUtils.copyBytes(result, part, i * (partSize + eccSize) + 452 + 2, 452, 574);
                        BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + 452 + 2 + 574, 0, 112);
                    } else {
                        lastPartDataSize = partSize - 2 - ctrlSize;
                        BytesUtils.copyBytes(result, part, i * (partSize + eccSize) + 2, 0, lastPartDataSize);
                        BytesUtils.copyBytes(result, data, i * (partSize + eccSize) + 2 + lastPartDataSize + eccSize, pageSize + 2, ctrlSize);
                        BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + 2 + lastPartDataSize, 0, eccSize);
                    }
                }
            } else if (option.getPageType() == PageType.Size8K && option.getEccType() == ECCType.Ecc64bit1k) {
                if (i < partCount - 1) {
                    BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, partSize);
                    BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize, 0, eccSize);
                } else {
                    BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, 212);
                    BytesUtils.copyBytes(result, data, i * (partSize + eccSize) + 212, pageSize, 2);
                    BytesUtils.copyBytes(result, part, i * (partSize + eccSize) + 212 + 2, 212, 784);
                    BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + 212 + 2 + 784, 0, eccSize);
                    BytesUtils.copyBytes(result, data, i * (partSize + eccSize) + 212 + 2 + 784 + 112, pageSize + 2, ctrlSize);
                }
            } else if (i < partCount - 1) {
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, partSize);
                BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + partSize, 0, eccSize);
            } else {
                lastPartDataSize = partSize - 2 - ctrlSize;
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize), 0, lastPartDataSize);
                BytesUtils.copyBytes(result, eccBuffer, i * (partSize + eccSize) + lastPartDataSize, 0, eccSize);
                BytesUtils.copyBytes(result, part, i * (partSize + eccSize) + lastPartDataSize + eccSize, lastPartDataSize + 2, ctrlSize);
            }
            ++i;
        }
        boolean bl = isSomeOption = option.getPageType() != PageType.Size16K || option.getEccType() != ECCType.Ecc40bit1k && option.getEccType() != ECCType.Ecc64bit1k;
        if (isSomeOption) {
            boolean needInsertBB;
            boolean bl2 = needInsertBB = option.getPageType() != PageType.Size8K || option.getEccType() != ECCType.Ecc64bit1k;
            if (needInsertBB) {
                int i2 = result.length - 1;
                while (i2 > pageSize + 1) {
                    result[i2] = result[i2 - 2];
                    --i2;
                }
                result[pageSize] = data[pageSize];
                result[pageSize + 1] = data[pageSize + 1];
            }
        }
        return result;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(String.valueOf(hv) + ",");
            ++i;
        }
        return stringBuilder.toString();
    }

    /*
     * Exception decompiling
     */
    public void make(String outputPath, FlashOption option, List<PartitionItem> partitions, int blockSize, boolean isSelectRandom, IFastbootProgressMonitor fastbootMonitor, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 26[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void makeEmtpyFlag(FlashOption option, byte[] pagebuf) {
        int emptyFlagIndex = option.getPageType() == PageType.Size2K && option.getEccType() == ECCType.Ecc1bit ? option.getPageType().getPageSize() + NandIPV500.getOobfree2k1bit()[0] + NandIPV500.getHinfc504EpmPos() : option.getPageType().getPageSize() + NandIPV500.getOobfreeDef()[0] + NandIPV500.getHinfc504EpmPos();
        pagebuf[emptyFlagIndex] = 0;
        pagebuf[emptyFlagIndex + 1] = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void differenceBlockSize(PartitionItem item, int blockSize) {
        long length = item.getFile().length();
        int differenceValue = (int)length % blockSize;
        if (differenceValue == 0) return;
        byte[] temp = new byte[blockSize - differenceValue];
        RandomAccessFile tempFile = null;
        try {
            try {
                tempFile = new RandomAccessFile(item.getFile(), "rw");
                tempFile.seek(length);
                tempFile.write(temp);
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (tempFile == null) return;
                try {
                    tempFile.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (tempFile == null) return;
                try {
                    tempFile.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (tempFile != null) {
                try {
                    tempFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static NandIPCommon chooseNandVersion(UnknownDevice device) {
        NandIPCommon nandSet = null;
        if (device.getNandIPVer() == 500) {
            nandSet = new NandIPV500();
        } else if (device.getNandIPVer() == 600) {
            nandSet = new NandIPV600();
        } else if (device.getNandIPVer() == 610) {
            nandSet = new NandIPV610();
        } else if (device.getNandIPVer() == 620) {
            nandSet = new NandIPV620();
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"HiBurn", (String)Messages.NandImage_DoNotSupport);
            return null;
        }
        return nandSet;
    }

    public static NandIPCommon chooseSPINandVersion(UnknownDevice device) {
        NandIPCommon nandSet = null;
        if (device.getSpinandIPVer() == 500) {
            nandSet = new NandIPV500();
        } else if (device.getSpinandIPVer() == 600) {
            nandSet = new NandIPV600();
        } else if (device.getSpinandIPVer() == 610) {
            nandSet = new NandIPV610();
        } else if (device.getSpinandIPVer() == 620) {
            nandSet = new NandIPV620();
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"HiBurn", (String)Messages.NandImage_DoNotSupport);
            return null;
        }
        return nandSet;
    }

    @Override
    public FlashOption[] getAvailableOptions(IBurner burner) {
        return null;
    }

    @Override
    public byte[] genPageData(byte[] pagebuf, FlashOption option, int oobSize) {
        return null;
    }

    public String getCurSelectedNandWay() {
        return this.curSelectedNandWay;
    }

    public void setCurSelectedNandWay(String curSelectedNandWay) {
        this.curSelectedNandWay = curSelectedNandWay;
    }

    public static String[] getPinSaveModeArray() {
        return (String[])PIN_SAVE_MODE_ARRAY.clone();
    }
}

