/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.packagers.nand.ip;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.unknown.UDProperties;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.packagers.nand.BlockType;
import com.hisilicon.fastboot.packagers.nand.FlashOption;
import com.hisilicon.fastboot.packagers.nand.NandCRandom;
import com.hisilicon.fastboot.packagers.nand.PageType;
import com.hisilicon.fastboot.packagers.nand.ReverseBlockSizeSector;
import com.hisilicon.fastboot.packagers.nand.ReversePageEccSector;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCType;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCV600;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPCommon;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV620;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.utilitily.BytesUtils;
import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class NandIPV600
extends NandIPCommon {
    private IBurner burner;
    private String boardType;
    private static int NANDIP_V600 = 1536;
    static final ReversePageEccSector[] hifmc100_page_ecc_reverse_sector = new ReversePageEccSector[]{new ReversePageEccSector(NANDIP_V600, PageType.Size2K, ECCType.Ecc4bit, 0), new ReversePageEccSector(NANDIP_V600, PageType.Size2K, ECCType.Ecc24bit1k, 1), new ReversePageEccSector(NANDIP_V600, PageType.Size4K, ECCType.Ecc4bit, 2), new ReversePageEccSector(NANDIP_V600, PageType.Size4K, ECCType.Ecc24bit1k, 3), new ReversePageEccSector(NANDIP_V600, PageType.Size8K, ECCType.Ecc24bit1k, 4), new ReversePageEccSector(NANDIP_V600, PageType.Size8K, ECCType.Ecc40bit1k, 5), new ReversePageEccSector(NANDIP_V600, PageType.Size16K, ECCType.Ecc40bit1k, 6), new ReversePageEccSector(NANDIP_V600, PageType.Size16K, ECCType.Ecc64bit1k, 7), new ReversePageEccSector(NANDIP_V600, PageType.Size8K, ECCType.Ecc64bit1k, 8)};
    private static final ReverseBlockSizeSector[] hifmc100_blocksize_reverse_sector = new ReverseBlockSizeSector[]{new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize64, 0), new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize128, 1), new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize256, 2), new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize512, 3)};

    @Override
    public FlashOption[] getAvailableOptions(IBurner burner) {
        this.burner = burner;
        UDProperties properties = ((UnknownDevice)burner.getBurnContext().getDeviceSetting()).getProperties();
        this.boardType = properties.queryForString("TYPE");
        Integer spiNand = properties.queryForInteger("SPINANDBURN");
        if (this.boardType != null && this.boardType.equalsIgnoreCase("BVT")) {
            if (spiNand != null && spiNand != -1) {
                return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, 60), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, 116), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, 88), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, 200)};
            }
            return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, 64), new FlashOption(ECCType.Ecc16bit1k, PageType.Size2K, 88), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, 128), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, 128), new FlashOption(ECCType.Ecc16bit1k, PageType.Size4K, 144), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, 200), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, 368)};
        }
        return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, 64), new FlashOption(ECCType.Ecc16bit1k, PageType.Size2K, 88), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, 128), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, 128), new FlashOption(ECCType.Ecc16bit1k, PageType.Size4K, 144), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, 200), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, 368), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, 600), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, 1200)};
    }

    @Override
    public byte[] genPageData(byte[] pagebuf, FlashOption option, int oobSize) {
        ECCV600 ecc = new ECCV600();
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 14);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 14);
            }
        }
        if (option.getEccType() == ECCType.Ecc16bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                if (oobSize == 8) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 6, 28);
                }
                if (oobSize == 32) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
                if (oobSize == 88) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (oobSize == 16) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 14, 28);
                }
                if (oobSize == 32) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
                if (oobSize == 128) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
                if (oobSize == 144) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
            }
        } else if (option.getEccType() == ECCType.Ecc24bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
        } else if (option.getEccType() == ECCType.Ecc40bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 70);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 70);
            }
        } else if (option.getEccType() == ECCType.Ecc64bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 112);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 112);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void make(String outputPath, FlashOption option, List<PartitionItem> partitions, int blockSize, boolean isSelectRandom, IFastbootProgressMonitor fastbootMonitor, IProgressMonitor monitor) {
        fastbootMonitor.infoln("\nStart to make nand burner image...");
        fastbootMonitor.infoln("Options: " + option.toString() + "\n");
        monitor.beginTask(Messages.NandImageDialog_Title, partitions.size());
        randomPageNum = isSelectRandom != false && blockSize > -1 ? (randomPageNum = blockSize / 8192) : -1;
        var10_9 = partitions.iterator();
        block29: while (true) {
            block55: {
                if (!var10_9.hasNext()) {
                    fastbootMonitor.infoln("\nImage creating operation ends. All of the selected partitions are processed.");
                    monitor.done();
                    return;
                }
                item = var10_9.next();
                if (monitor.isCanceled()) {
                    return;
                }
                v0 = itemState = item.isChecked() == false || item.getFile() == null;
                if (itemState) {
                    monitor.worked(1);
                    continue;
                }
                this.differenceBlockSize(item, blockSize);
                fastbootMonitor.info("Make image for '" + item.getFile().getName() + "'...");
                pageCheckSize = item.getFileSystem() == FileSystem.yaffs ? (pageCheckSize = option.getPageType().getPageSize() + option.getOOBSize()) : option.getPageType().getPageSize();
                pageCount = item.getFileSystem() == FileSystem.yaffs ? (int)(item.getFile().length() / (long)pageCheckSize) : (int)((item.getFile().length() + (long)pageCheckSize - 1L) / (long)pageCheckSize);
                outFile = new File(String.valueOf(outputPath) + File.separator + item.getFile().getName() + ".burn");
                if (outFile.exists()) {
                    FileUtils.deleteFile(outFile);
                }
                inRanFile = null;
                outRanFile = null;
                ret = true;
                try {
                    inRanFile = new RandomAccessFile(item.getFile(), "r");
                    outRanFile = new RandomAccessFile(outFile, "rw");
                    pageMakeSize = option.getPageType().getPageSize() + option.getOOBSize();
                    start = item.getStart();
                    reversePageEccEec = 0;
                    reverseBlockEec = 0;
                    page0ReverseFlag = false;
                    page1ReverseFlag = false;
                    nandPinSaveMpde = false;
                    nandPinSaveMpde = HiToolUtils.isCmdLine() != false ? PreferenceConfig.isImgOpenPinSaveMode() : FastbootPreferences.isNandPinSaveMpde();
                    supportPinSaveMode = false;
                    supportEmpty = false;
                    curPinSaveMode = null;
                    if (this.boardType.equalsIgnoreCase("BVT")) {
                        v1 = isNand = this.curSelectedNandWay != null && this.curSelectedNandWay.equalsIgnoreCase("Nand") != false;
                        if (isNand) {
                            curPinSaveMode = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getNandPinSaveMode();
                            v2 = pinSaveMode = curPinSaveMode != null && curPinSaveMode.isEmpty() == false;
                            if (pinSaveMode) {
                                supportPinSaveMode = true;
                            }
                            supportEmpty = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportNandEmpty();
                        } else if (this.curSelectedNandWay.equalsIgnoreCase("SPINand")) {
                            curPinSaveMode = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getSpiNandPinSaveMode();
                            v3 = pinSaveMode = curPinSaveMode != null && curPinSaveMode.isEmpty() == false;
                            if (pinSaveMode) {
                                supportPinSaveMode = true;
                            }
                            supportEmpty = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportSPINandEmpty();
                        }
                    }
                    v4 = isSupport = nandPinSaveMpde != false && supportPinSaveMode != false && start == 0L;
                    if (isSupport) {
                        isNandcv200 = curPinSaveMode != null && curPinSaveMode.equalsIgnoreCase(NandIPV600.getPinSaveModeArray()[0]) != false;
                        sector = isNandcv200 != false ? NandIPV620.getHinfc620PageEccReverseSector() : (ReversePageEccSector[])NandIPV600.hifmc100_page_ecc_reverse_sector.clone();
                        pageType = option.getPageType();
                        pageSizeEccReverseSector = this.getPageSizeEccReverseSectorByInputSector(pageType, eccType = option.getEccType(), sector);
                        if (pageSizeEccReverseSector != null) {
                            reversePageEccEec = pageSizeEccReverseSector.getReverse_sec();
                        }
                        if ((blockSizeReverseSector = this.getBlockSizeReverseSector(blockSize, pageType)) != null) {
                            reverseBlockEec = blockSizeReverseSector.getReverse_sec();
                        }
                    }
                    i = 0;
                    if (true) ** GOTO lbl143
                }
                catch (FileNotFoundException e) {
                    block53: {
                        try {
                            fastbootMonitor.warnln("FAILED! (Source file not found.)");
                            monitor.worked(1);
                            break block53;
                        }
                        catch (Throwable var36_41) {
                            try {
                                this.closeStream(inRanFile);
                            }
                            catch (IOException e) {
                                fastbootMonitor.warnln("FAILED! (Close file error.)");
                            }
                            try {
                                this.closeStream(outRanFile);
                            }
                            catch (IOException e) {
                                fastbootMonitor.warnln("FAILED! (Close file error.)");
                            }
                            if (ret) {
                                throw var36_41;
                            }
                            FileUtils.deleteFile(outFile);
                            monitor.worked(1);
                            continue;
                        }
lbl92:
                        // 1 sources

                        while (true) {
                            try {
                                this.closeStream(inRanFile);
                            }
                            catch (IOException e) {
                                fastbootMonitor.warnln("FAILED! (Close file error.)");
                            }
                            try {
                                this.closeStream(outRanFile);
                            }
                            catch (IOException e) {
                                fastbootMonitor.warnln("FAILED! (Close file error.)");
                            }
                            if (ret) {
                                return;
                            }
                            FileUtils.deleteFile(outFile);
                            monitor.worked(1);
                            continue block29;
                            break;
                        }
                        {
                            block54: {
                                do {
                                    pagebuf = BytesUtils.genBytesWithFF(pageMakeSize);
                                    try {
                                        inRanFile.seek(i * pageCheckSize);
                                        this.doEmptyForBVT(option, item, pageCheckSize, inRanFile, supportEmpty, pagebuf);
                                    }
                                    catch (IOException e) {
                                        fastbootMonitor.warnln("FAILED! (Read data error.)");
                                        ret = false;
                                        break block54;
                                    }
                                    data = null;
                                    try {
                                        data = this.genPageData(pagebuf, option, option.getOOBSize());
                                        if (randomPageNum > -1) {
                                            random = new NandCRandom();
                                            random.page_random_gen(data, option.getPageType().getPageSize(), option.getOOBSize(), i % randomPageNum);
                                        }
                                        if (isSupport) {
                                            if (!page0ReverseFlag) {
                                                page0ReverseOff = 32 * reversePageEccEec;
                                                NandIPV600.reverseBuf(data, page0ReverseOff, 32);
                                            }
                                            v5 = reverse = page0ReverseFlag != false && page1ReverseFlag == false;
                                            if (reverse) {
                                                page1ReverseOff = 32 * reverseBlockEec;
                                                NandIPV600.reverseBuf(data, page1ReverseOff, 32);
                                                page1ReverseFlag = true;
                                            }
                                            page0ReverseFlag = true;
                                        }
                                        outRanFile.seek(i * pageMakeSize);
                                        outRanFile.write(data);
                                    }
                                    catch (Exception e) {
                                        fastbootMonitor.warnln("FAILED! (Data convert error.)");
                                        ret = false;
                                        break block54;
                                    }
                                    ++i;
lbl143:
                                    // 2 sources

                                    if (i >= pageCount) break block54;
                                } while (!monitor.isCanceled());
                                ** continue;
                            }
                            ret = this.setEmptyFlag(option, blockSize, fastbootMonitor, item, pageCheckSize, pageCount, outRanFile, pageMakeSize, supportEmpty);
                            if (ret) break block55;
                        }
                        try {
                            this.closeStream(inRanFile);
                        }
                        catch (IOException e) {
                            fastbootMonitor.warnln("FAILED! (Close file error.)");
                        }
                        try {
                            this.closeStream(outRanFile);
                        }
                        catch (IOException e) {
                            fastbootMonitor.warnln("FAILED! (Close file error.)");
                        }
                        if (ret) {
                            return;
                        }
                        FileUtils.deleteFile(outFile);
                        monitor.worked(1);
                        continue;
                    }
                    try {
                        this.closeStream(inRanFile);
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    try {
                        this.closeStream(outRanFile);
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    if (ret) continue;
                    FileUtils.deleteFile(outFile);
                    monitor.worked(1);
                    continue;
                }
            }
            try {
                this.closeStream(inRanFile);
            }
            catch (IOException e) {
                fastbootMonitor.warnln("FAILED! (Close file error.)");
            }
            try {
                this.closeStream(outRanFile);
            }
            catch (IOException e) {
                fastbootMonitor.warnln("FAILED! (Close file error.)");
            }
            if (!ret) {
                FileUtils.deleteFile(outFile);
                monitor.worked(1);
                continue;
            }
            fastbootMonitor.info("OK!");
            fastbootMonitor.warnln("(Start Address = 0x" + Long.toHexString(item.getStart()) + ", Length = 0x" + Long.toHexString(item.getLength()) + ")");
            monitor.worked(1);
        }
    }

    private void doEmptyForBVT(FlashOption option, PartitionItem item, int pageCheckSize, RandomAccessFile inRanFile, boolean supportEmpty, byte[] pagebuf) throws IOException {
        boolean isEmptyAndBVT;
        int read = inRanFile.read(pagebuf, 0, pageCheckSize);
        if (read < 0) {
            System.out.println("Read Error.");
        }
        boolean bl = isEmptyAndBVT = this.boardType != null && this.boardType.equalsIgnoreCase("BVT") && supportEmpty;
        if (isEmptyAndBVT) {
            int bvtPageEmptyFlag = option.getPageType().getPageSize() + 32;
            if (item.getFileSystem() == FileSystem.ubiFs) {
                if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                    pagebuf[bvtPageEmptyFlag - 1] = 0;
                    pagebuf[bvtPageEmptyFlag - 2] = 0;
                }
            } else {
                pagebuf[bvtPageEmptyFlag - 1] = 0;
                pagebuf[bvtPageEmptyFlag - 2] = 0;
            }
        }
    }

    private void closeStream(RandomAccessFile inRanFile) throws IOException {
        if (inRanFile != null) {
            inRanFile.close();
        }
    }

    private boolean setEmptyFlag(FlashOption option, int blockSize, IFastbootProgressMonitor fastbootMonitor, PartitionItem item, int pageCheckSize, int pageCount, RandomAccessFile outRanFile, int pageMakeSize, boolean supportEmpty) {
        boolean isSupportEmpty;
        boolean ret = true;
        boolean bl = isSupportEmpty = this.boardType != null && this.boardType.equalsIgnoreCase("BVT") && supportEmpty;
        if (isSupportEmpty) {
            int page_num_incl_data = pageCount;
            int page_per_block = blockSize / option.getPageType().getPageSize();
            int page_num_total_block = page_num_incl_data & ~(page_per_block - 1);
            int page_num_fill_null = (page_num_total_block += (page_num_incl_data & page_per_block - 1) > 0 ? page_per_block : 0) - page_num_incl_data;
            while (page_num_fill_null-- > 0) {
                byte[] pagebuf = BytesUtils.genBytesWithFF(pageMakeSize);
                int bvtPageEmptyFlag = option.getPageType().getPageSize() + 32;
                if (item.getFileSystem() == FileSystem.ubiFs) {
                    if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                        pagebuf[bvtPageEmptyFlag - 1] = 0;
                        pagebuf[bvtPageEmptyFlag - 2] = 0;
                    }
                } else {
                    pagebuf[bvtPageEmptyFlag - 1] = 0;
                    pagebuf[bvtPageEmptyFlag - 2] = 0;
                }
                byte[] data = null;
                try {
                    data = this.genPageData(pagebuf, option, option.getOOBSize());
                    outRanFile.write(data);
                }
                catch (Exception e) {
                    fastbootMonitor.warnln("FAILED! (Write Empty flag error.)");
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }

    private ReversePageEccSector getPageSizeEccReverseSectorByInputSector(PageType pagetype, ECCType ecctype, ReversePageEccSector[] sector) {
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getEcctype() == ecctype && sector[i].getPagetype() == pagetype) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private ReverseBlockSizeSector getBlockSizeReverseSector(int blocksize, PageType pageType) {
        int pageNum = blocksize / pageType.getPageSize();
        ReverseBlockSizeSector[] sector = hifmc100_blocksize_reverse_sector;
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getBlocktype().getSize() == pageNum) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private static void reverseBuf(byte[] buf, int startOff, int reverseLen) {
        int i = startOff;
        while (i < startOff + reverseLen) {
            buf[i] = ~buf[i];
            ++i;
        }
    }

    public boolean checkBufferFF(byte[] pagebuf, int length) {
        int index = 0;
        while (index < length) {
            if (pagebuf[index] != -1) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public String toString() {
        return "HiNand IP V600";
    }
}

