/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.packagers.nand.ip;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.unknown.UDProperties;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.packagers.nand.BlockType;
import com.hisilicon.fastboot.packagers.nand.FlashOption;
import com.hisilicon.fastboot.packagers.nand.NandCRandom;
import com.hisilicon.fastboot.packagers.nand.PageType;
import com.hisilicon.fastboot.packagers.nand.ReverseBlockSizeSector;
import com.hisilicon.fastboot.packagers.nand.ReversePageEccSector;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCType;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCV620;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPCommon;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPV600;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.utilitily.BytesUtils;
import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class NandIPV620
extends NandIPCommon {
    private static Map<String, Integer> map = new HashMap<String, Integer>();
    private static int NANDIP_V620 = 1568;
    private static String[] FMCV100LIST = new String[]{"Hi3716MV410", "Hi3716MV420", "Hi3716MV410_CA", "Hi3716MV420_CA", "Hi3716MV410_CA_N", "Hi3716MV420_CA_N", "Hi3751V620", "Hi3796MV200", "Hi3716MV430", "Hi3796CV300", "Hi3716MV450", "Hi3796AV200", "Hi3716MV410", "Hi3798CV200", "Hi3798MV200", "Hi3798MV300", "Hi3798MV310", "Hi3798MV300E", "Hi3798MV320", "Hi3561MV100", "Hi3798MV200H", "Hi3798MV300H", "Hi3716DV110", "Hi3716DV110H", "Hi3716MV330", "Hi3716MV330_CA"};
    private IBurner burner;
    private static final ReversePageEccSector[] hinfc620_page_ecc_reverse_sector = new ReversePageEccSector[]{new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc8bit512, 0), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc4bit, 1), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc4bit, 1), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc24bit1k, 2), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc8bit512, 3), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc4bit, 4), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc4bit, 4), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc24bit1k, 5), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc24bit1k, 6), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc40bit1k, 7), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc40bit1k, 8), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc64bit1k, 9), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc64bit1k, 10)};
    private static final ReversePageEccSector[] hinfc620_page_ecc_reverse_sector_fmcv100 = new ReversePageEccSector[]{new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc4bit, 0), new ReversePageEccSector(NANDIP_V620, PageType.Size2K, ECCType.Ecc24bit1k, 1), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc4bit, 2), new ReversePageEccSector(NANDIP_V620, PageType.Size4K, ECCType.Ecc24bit1k, 3), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc24bit1k, 4), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc40bit1k, 5), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc40bit1k, 6), new ReversePageEccSector(NANDIP_V620, PageType.Size16K, ECCType.Ecc64bit1k, 7), new ReversePageEccSector(NANDIP_V620, PageType.Size8K, ECCType.Ecc64bit1k, 8)};
    private static final ReverseBlockSizeSector[] hinfc620_blocksize_reverse_sector = new ReverseBlockSizeSector[]{new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize64, 0), new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize128, 1), new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize256, 2), new ReverseBlockSizeSector(NANDIP_V620, BlockType.BlockSize512, 3)};
    private String boardType;

    public NandIPV620() {
        map.put("2k4bit", 60);
        map.put("2k8bit", 64);
        map.put("2k13bit", 64);
        map.put("2k24bit", 116);
        map.put("2k27bit", 128);
        map.put("4k4bit", 88);
        map.put("4k8bit", 128);
        map.put("4k13bit", 112);
        map.put("4k24bit", 200);
        map.put("4k27bit", 224);
        map.put("8k24bit", 368);
        map.put("8k27bit", 416);
        map.put("8k40bit", 592);
        map.put("8k41bit", 608);
        map.put("8k60bit", 896);
        map.put("8k64bit", 928);
        map.put("8k80bit", 1152);
        map.put("16k40bit", 1152);
        map.put("16k41bit", 1184);
        map.put("16k60bit", 1760);
        map.put("16k64bit", 1824);
        map.put("16k80bit", 1376);
    }

    @Override
    public FlashOption[] getAvailableOptions(IBurner burner) {
        this.burner = burner;
        UDProperties properties = ((UnknownDevice)burner.getBurnContext().getDeviceSetting()).getProperties();
        this.boardType = properties.queryForString("TYPE");
        if (this.boardType != null && this.boardType.equalsIgnoreCase("BVT")) {
            return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, -1), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size16K, -1)};
        }
        if (this.isFMCV100()) {
            return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size2K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, -1), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, -1), new FlashOption(ECCType.Ecc64bit1k, PageType.Size16K, -1)};
        }
        return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size2K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, -1), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc8bit512, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, -1), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, -1)};
    }

    @Override
    public byte[] genPageData(byte[] pagebuf, FlashOption option, int oobSize) {
        ECCV620 ecc = new ECCV620();
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 14);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 14);
            }
        }
        if (option.getEccType() == ECCType.Ecc8bit512) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 6, 28);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 14, 28);
            }
        }
        if (option.getEccType() == ECCType.Ecc24bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 42);
            }
        }
        if (option.getEccType() == ECCType.Ecc40bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 70);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 70);
            }
        }
        if (option.getEccType() == ECCType.Ecc64bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 112);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytesForV620(ecc, option, pagebuf, 30, 112);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void make(String outputPath, FlashOption option, List<PartitionItem> partitions, int blockSize, boolean isSelectRandom, IFastbootProgressMonitor fastbootMonitor, IProgressMonitor monitor) {
        usedOobSize = 0;
        usedOobSize = this.getUsedOobSize(option);
        fastbootMonitor.infoln("\nStart to make nand burner image...");
        fastbootMonitor.infoln("Options: " + option.toString() + "\n");
        monitor.beginTask(Messages.NandImageDialog_Title, partitions.size());
        randomPageNum = -1;
        if (isSelectRandom && blockSize > -1) {
            randomPageNum = option.getPageType().getPageSize() == PageType.Size16K.getPageSize() ? blockSize / option.getPageType().getPageSize() : blockSize / 8192;
        }
        var11_10 = partitions.iterator();
        block27: while (true) lbl-1000:
        // 8 sources

        {
            block85: {
                if (!var11_10.hasNext()) {
                    fastbootMonitor.infoln("\nImage creating operation ends. All of the selected partitions are processed.");
                    monitor.done();
                    return;
                }
                item = var11_10.next();
                if (monitor.isCanceled()) {
                    return;
                }
                v0 = itemState = item.isChecked() == false || item.getFile() == null;
                if (itemState) {
                    monitor.worked(1);
                    continue;
                }
                this.differenceBlockSize(item, blockSize);
                fastbootMonitor.info("Make image for '" + item.getFile().getName() + "'...");
                pageCheckSize = option.getPageType().getPageSize();
                if (item.getFileSystem() == FileSystem.yaffs) {
                    pageCheckSize = this.boardType != null && this.boardType.equalsIgnoreCase("BVT") != false ? option.getPageType().getPageSize() + option.getOOBSize() : option.getPageType().getPageSize() + 32;
                }
                pageCount = (int)((item.getFile().length() + (long)pageCheckSize - 1L) / (long)pageCheckSize);
                fileSystem = item.getFileSystem();
                if (fileSystem == FileSystem.yaffs) {
                    pageCount = (int)(item.getFile().length() / (long)pageCheckSize);
                }
                if ((outFile = new File(String.valueOf(outputPath) + File.separator + item.getFile().getName() + ".burn")).exists()) {
                    FileUtils.deleteFile(outFile);
                }
                inRanFile = null;
                outRanFile = null;
                ret = true;
                try {
                    inRanFile = new RandomAccessFile(item.getFile(), "r");
                    outRanFile = new RandomAccessFile(outFile, "rw");
                    pageMakeSize = option.getPageType().getPageSize() + 32;
                    if (this.boardType != null && this.boardType.equalsIgnoreCase("BVT")) {
                        pageMakeSize = option.getPageType().getPageSize() + option.getOOBSize();
                    }
                    start = item.getStart();
                    reversePageEccEec = 0;
                    reverseBlockEec = 0;
                    page0ReverseFlag = false;
                    page1ReverseFlag = false;
                    nandPinSaveMpde = false;
                    nandPinSaveMpde = HiToolUtils.isCmdLine() != false ? PreferenceConfig.isImgOpenPinSaveMode() : FastbootPreferences.isNandPinSaveMpde();
                    if (this.isHi3716MV310Series() && this.curSelectedNandWay != null && this.curSelectedNandWay.equals("SPINand")) {
                        nandPinSaveMpde = false;
                    }
                    curPinSaveMode = null;
                    supportEmpty = false;
                    if (this.curSelectedNandWay != null) {
                        if (this.curSelectedNandWay.equals("Nand")) {
                            curPinSaveMode = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getNandPinSaveMode();
                            supportEmpty = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportNandEmpty();
                        } else if (this.curSelectedNandWay.equals("SPINand")) {
                            curPinSaveMode = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getSpiNandPinSaveMode();
                            supportEmpty = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportSPINandEmpty();
                        }
                    }
                    if (nandPinSaveMpde && start == 0L) {
                        sector = null;
                        sector = curPinSaveMode != null && curPinSaveMode.equalsIgnoreCase(NandIPV620.getPinSaveModeArray()[0]) ? (this.isFMCV100() ? NandIPV620.hinfc620_page_ecc_reverse_sector_fmcv100 : NandIPV620.hinfc620_page_ecc_reverse_sector) : (curPinSaveMode != null && curPinSaveMode.equalsIgnoreCase(NandIPV620.getPinSaveModeArray()[1]) != false ? (ReversePageEccSector[])NandIPV600.hifmc100_page_ecc_reverse_sector.clone() : (this.isFMCV100() != false ? (ReversePageEccSector[])NandIPV620.hinfc620_page_ecc_reverse_sector_fmcv100.clone() : (ReversePageEccSector[])NandIPV620.hinfc620_page_ecc_reverse_sector.clone()));
                        pageType = option.getPageType();
                        eccType = option.getEccType();
                        pageSizeEccReverseSector = this.getPageSizeEccReverseSector(pageType, eccType, sector);
                        if (pageSizeEccReverseSector != null) {
                            reversePageEccEec = pageSizeEccReverseSector.getReverse_sec();
                        }
                        if ((blockSizeReverseSector = this.getBlockSizeReverseSector(blockSize, pageType)) != null) {
                            reverseBlockEec = blockSizeReverseSector.getReverse_sec();
                        }
                    }
                    i = 0;
                    if (true) ** GOTO lbl196
                }
                catch (FileNotFoundException e) {
                    fastbootMonitor.warnln("FAILED! (Source file not found.)");
                    monitor.worked(1);
                    try {
                        if (inRanFile != null) {
                            inRanFile.close();
                        }
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    try {
                        if (outRanFile != null) {
                            outRanFile.close();
                        }
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    if (ret) ** GOTO lbl-1000
                    FileUtils.deleteFile(outFile);
                    monitor.worked(1);
                }
                catch (Throwable var39_54) {
                    try {
                        if (inRanFile != null) {
                            inRanFile.close();
                        }
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    try {
                        if (outRanFile != null) {
                            outRanFile.close();
                        }
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    if (ret) {
                        throw var39_54;
                    }
                    FileUtils.deleteFile(outFile);
                    monitor.worked(1);
                }
                continue;
lbl113:
                // 1 sources

                while (true) {
                    try {
                        if (inRanFile != null) {
                            inRanFile.close();
                        }
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    try {
                        if (outRanFile != null) {
                            outRanFile.close();
                        }
                    }
                    catch (IOException e) {
                        fastbootMonitor.warnln("FAILED! (Close file error.)");
                    }
                    if (ret) {
                        return;
                    }
                    FileUtils.deleteFile(outFile);
                    monitor.worked(1);
                    continue block27;
                    break;
                }
                {
                    block83: {
                        do {
                            block84: {
                                block82: {
                                    pagebuf = BytesUtils.genBytesWithFF(pageMakeSize);
                                    try {
                                        inRanFile.seek(i * pageCheckSize);
                                        read = inRanFile.read(pagebuf, 0, pageCheckSize);
                                        if (read < 0) {
                                            System.out.println("Read Error.");
                                        }
                                        v1 = isBVT = this.boardType != null && this.boardType.equalsIgnoreCase("BVT") != false;
                                        if (isBVT) {
                                            bvtPageEmptyFlag = option.getPageType().getPageSize() + 32;
                                            if (fileSystem == FileSystem.ubiFs) {
                                                if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                                                    pagebuf[bvtPageEmptyFlag - 1] = 0;
                                                    pagebuf[bvtPageEmptyFlag - 2] = 0;
                                                }
                                                break block82;
                                            } else {
                                                pagebuf[bvtPageEmptyFlag - 1] = 0;
                                                pagebuf[bvtPageEmptyFlag - 2] = 0;
                                            }
                                            break block82;
                                        }
                                        if (fileSystem == FileSystem.ubiFs) {
                                            if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                                                pagebuf[pageMakeSize - 1] = 0;
                                                pagebuf[pageMakeSize - 2] = 0;
                                            }
                                        } else {
                                            pagebuf[pageMakeSize - 1] = 0;
                                            pagebuf[pageMakeSize - 2] = 0;
                                        }
                                    }
                                    catch (IOException e) {
                                        fastbootMonitor.warnln("FAILED! (Read data error.)");
                                        ret = false;
                                        break block83;
                                    }
                                }
                                data = null;
                                try {
                                    data = this.genPageData(pagebuf, option, option.getOOBSize());
                                    if (data == null) break block83;
                                    if (randomPageNum > 0) {
                                        random = new NandCRandom();
                                        if (usedOobSize != 0) {
                                            random.page_random_genV610(data, option.getPageType().getPageSize(), usedOobSize, i % randomPageNum);
                                        } else {
                                            random.page_random_genV610(data, option.getPageType().getPageSize(), option.getOOBSize(), i % randomPageNum);
                                        }
                                    }
                                    if (nandPinSaveMpde && start == 0L) {
                                        if (!page0ReverseFlag) {
                                            page0ReverseOff = 32 * reversePageEccEec;
                                            NandIPV620.reverseBuf(data, page0ReverseOff, 32);
                                        }
                                        if (page0ReverseFlag && !page1ReverseFlag) {
                                            page1ReverseOff = 32 * reverseBlockEec;
                                            NandIPV620.reverseBuf(data, page1ReverseOff, 32);
                                            page1ReverseFlag = true;
                                        }
                                        page0ReverseFlag = true;
                                    }
                                    outRanFile.seek(i * (option.getPageType().getPageSize() + option.getOOBSize()));
                                    outRanFile.write(data);
                                    if (outRanFile.length() % (long)(option.getPageType().getPageSize() + option.getOOBSize()) != 0L) {
                                        fastbootMonitor.warnln("FAILED! (Could not write output file.)");
                                        ret = false;
                                    }
                                    break block84;
                                }
                                catch (Exception e) {
                                    fastbootMonitor.warnln("FAILED! (Data convert error.)");
                                    ret = false;
                                    e.printStackTrace();
                                }
                                break block83;
                            }
                            ++i;
lbl196:
                            // 2 sources

                            if (i >= pageCount) break block83;
                        } while (!monitor.isCanceled());
                        ** continue;
                    }
                    if (!supportEmpty) break block85;
                    currentPageIndex = pageCount;
                    page_num_incl_data = pageCount;
                    page_per_block = blockSize / option.getPageType().getPageSize();
                    page_num_total_block = page_num_incl_data & ~(page_per_block - 1);
                    page_num_fill_null = (page_num_total_block += (page_num_incl_data & page_per_block - 1) > 0 ? page_per_block : 0) - page_num_incl_data;
                    while (page_num_fill_null-- > 0) {
                        block87: {
                            block86: {
                                pagebuf = BytesUtils.genBytesWithFF(pageMakeSize);
                                v2 = isBVT = this.boardType != null && this.boardType.equalsIgnoreCase("BVT") != false;
                                if (!isBVT) break block86;
                                bvtPageEmptyFlag = option.getPageType().getPageSize() + 32;
                                if (fileSystem == FileSystem.ubiFs) {
                                    if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                                        pagebuf[bvtPageEmptyFlag - 1] = 0;
                                        pagebuf[bvtPageEmptyFlag - 2] = 0;
                                    }
                                    break block87;
                                } else {
                                    pagebuf[bvtPageEmptyFlag - 1] = 0;
                                    pagebuf[bvtPageEmptyFlag - 2] = 0;
                                }
                                break block87;
                            }
                            if (fileSystem == FileSystem.ubiFs) {
                                if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                                    pagebuf[pageMakeSize - 1] = 0;
                                    pagebuf[pageMakeSize - 2] = 0;
                                }
                            } else {
                                pagebuf[pageMakeSize - 1] = 0;
                                pagebuf[pageMakeSize - 2] = 0;
                            }
                        }
                        data = null;
                        try {
                            data = this.genPageData(pagebuf, option, option.getOOBSize());
                            if (randomPageNum > -1) {
                                random = new NandCRandom();
                                if (usedOobSize != 0) {
                                    random.page_random_genV610(data, option.getPageType().getPageSize(), usedOobSize, currentPageIndex % randomPageNum);
                                } else {
                                    random.page_random_genV610(data, option.getPageType().getPageSize(), option.getOOBSize(), currentPageIndex % randomPageNum);
                                }
                            }
                            outRanFile.write(data);
                            ++currentPageIndex;
                        }
                        catch (Exception e) {
                            fastbootMonitor.warnln("FAILED! (Write Empty flag error.)");
                            ret = false;
                            break;
                        }
                    }
                }
            }
            try {
                if (inRanFile != null) {
                    inRanFile.close();
                }
            }
            catch (IOException e) {
                fastbootMonitor.warnln("FAILED! (Close file error.)");
            }
            try {
                if (outRanFile != null) {
                    outRanFile.close();
                }
            }
            catch (IOException e) {
                fastbootMonitor.warnln("FAILED! (Close file error.)");
            }
            if (!ret) {
                FileUtils.deleteFile(outFile);
                monitor.worked(1);
                continue;
            }
            fastbootMonitor.info("OK!");
            fastbootMonitor.warnln("(Start Address = 0x" + Long.toHexString(item.getStart()) + ", Length = 0x" + Long.toHexString(item.getLength()) + ")");
            monitor.worked(1);
        }
    }

    public boolean checkBufferFF(byte[] pagebuf, int length) {
        int index = 0;
        while (index < length) {
            if (pagebuf[index] != -1) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public static void printHexString(byte[] b) {
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            System.out.print(String.valueOf(hex.toUpperCase()) + ",");
            ++i;
        }
    }

    private static void reverseBuf(byte[] buf, int startOff, int reverseLen) {
        int i = startOff;
        while (i < startOff + reverseLen) {
            buf[i] = ~buf[i];
            ++i;
        }
    }

    private ReversePageEccSector getPageSizeEccReverseSector(PageType pagetype, ECCType ecctype, ReversePageEccSector[] sector) {
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getEcctype() == ecctype && sector[i].getPagetype() == pagetype) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private ReverseBlockSizeSector getBlockSizeReverseSector(int blocksize, PageType pageType) {
        int pageNum = blocksize / pageType.getPageSize();
        ReverseBlockSizeSector[] sector = null;
        sector = hinfc620_blocksize_reverse_sector;
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getBlocktype().getSize() == pageNum) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private int getUsedOobSize(FlashOption option) {
        int usedOobSize = 0;
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k4bit") != null) {
                    return map.get("2k4bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k4bit") != null) {
                return map.get("4k4bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc8bit512) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k8bit") != null) {
                    return map.get("2k8bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k8bit") != null) {
                return map.get("4k8bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc13bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k13bit") != null) {
                    return map.get("2k13bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k13bit") != null) {
                return map.get("4k13bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc24bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k24bit") != null) {
                    return map.get("2k24bit");
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (map.get("4k24bit") != null) {
                    return map.get("4k24bit");
                }
            } else if (option.getPageType() == PageType.Size8K && map.get("8k24bit") != null) {
                return map.get("8k24bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc27bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k27bit") != null) {
                    return map.get("2k27bit");
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (map.get("4k27bit") != null) {
                    return map.get("4k27bit");
                }
            } else if (option.getPageType() == PageType.Size8K && map.get("8k27bit") != null) {
                return map.get("8k27bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc40bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k40bit") != null) {
                    return map.get("8k40bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k40bit") != null) {
                return map.get("16k40bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc41bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k41bit") != null) {
                    return map.get("8k41bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k41bit") != null) {
                return map.get("16k41bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc60bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k60bit") != null) {
                    return map.get("8k60bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k60bit") != null) {
                return map.get("16k60bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc64bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k64bit") != null) {
                    return map.get("8k64bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k64bit") != null) {
                return map.get("16k64bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc80bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k80bit") != null) {
                    return map.get("8k80bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k80bit") != null) {
                return map.get("16k80bit");
            }
        }
        return usedOobSize;
    }

    public String toString() {
        return "HiNand IP V620";
    }

    private boolean isFMCV100() {
        String chipName = HiToolUtils.getChipName();
        if (chipName == null) {
            return false;
        }
        if (chipName.contains("-")) {
            chipName = chipName.replace("-", "_");
        }
        String[] stringArray = FMCV100LIST;
        int n = FMCV100LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (chipName.equalsIgnoreCase(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isHi3716MV310Series() {
        boolean result;
        String chipName = HiToolUtils.getChipName();
        if (chipName == null) {
            return false;
        }
        if (chipName.contains("-")) {
            chipName = chipName.replace("-", "_");
        }
        boolean bl = result = chipName.equalsIgnoreCase("Hi3716MV310") || chipName.equalsIgnoreCase("Hi3716MV310_CA") || chipName.equalsIgnoreCase("Hi3716MV320") || chipName.equalsIgnoreCase("Hi3110EV500") || chipName.equalsIgnoreCase("Hi3110EV500_CA");
        return result;
    }

    public static ReversePageEccSector[] getHinfc620PageEccReverseSector() {
        return (ReversePageEccSector[])hinfc620_page_ecc_reverse_sector.clone();
    }
}

