/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.preferences;

import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.preferences.JTAGPreferencePage;
import com.hisilicon.fastboot.preferences.PreferenceConstants;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.hisilicon.fastboot.utilitily.IPUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class FastbootPreferenceInitializer
extends AbstractPreferenceInitializer
implements PreferenceConstants {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = FastbootPreferences.getPreferenceStore();
        store.setDefault("hisilicon.fastboot.console.out.debug", false);
        store.setDefault("hisilicon.fastboot.update.bootrags", false);
        store.setDefault("hisilicon.fastboot.check.network", true);
        store.setDefault("hisilicon.fastboot.dialogs.on", true);
        store.setDefault("hisilicon.fastboot.config.client.mac", IPUtils.generatorMAC());
        store.setDefault("hisilicon.fastboot.config.client.gateway", "0.0.0.0");
        store.setDefault("hisilicon.fastboot.config.client.ip", "0.0.0.0");
        store.setDefault("hisilicon.fastboot.config.client.netmask", "0.0.0.0");
        store.setDefault("hisilicon.fastboot.dialogs.on", true);
        store.setDefault("hisilicon.fastboot.tftp.losingpackage.count", 15);
        store.setDefault("hisilicon.fastboot.tftp.windowSize.blockCount", 3);
        store.setDefault("hisilicon.fastboot.tftp.losingpackage.enable", true);
        store.setDefault("hisilicon.fastboot.tftp.timeout.noresponse", 10);
        store.setDefault("hisilicon.fastboot.tftp.split.fileSize", 128);
        store.setDefault("hisilicon.fastboot.tftp.retry.count", 5);
        store.setDefault("hisilicon.fastboot.tftp.speed", 1024);
        store.setDefault("hisilicon.fastboot.tftp.port", 69);
        String ChinName = HiToolUtils.getChipName();
        UnknownDevice properties = new UnknownDevice(ChinName, ToolType.Composite);
        String boardType = properties.queryForString("TYPE");
        if (boardType != null && boardType.equalsIgnoreCase("DPT")) {
            store.setDefault("hisilicon.fastboot.commands.speed.emmc_write", 1024);
        } else {
            store.setDefault("hisilicon.fastboot.commands.speed.emmc_write", 3072);
        }
        store.setDefault("hisilicon.fastboot.commands.serial_command_timeout", 30);
        store.setDefault("hisilicon.fastboot.i2c.baudrate", "900K");
        store.setDefault("hisilicon.fastboot.i2c.deviceAddress", 56);
        store.setDefault("hisilicon.fastboot.i2c.delay", 50);
        store.setDefault("hisilicon.fastboot.i2c.timeout", 60000);
        store.setDefault("hisilicon.fastboot.jtag.small.borad.model", JTAGPreferencePage.getJtagSmallModelTypeList()[0][0]);
        store.setDefault("hisilicon.fastboot.i2c.retry.count", 30);
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            store.setDefault("hisilicon.fastboot.config.serial", "COM1");
        } else if ("linux".equals(os)) {
            store.setDefault("hisilicon.fastboot.config.serial", "/dev/ttyS0");
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"hisilicon.fastboot.console.out.rgb.default", (RGB)RGB_DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"hisilicon.fastboot.console.out.rgb.info", (RGB)RGB_INFO);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"hisilicon.fastboot.console.out.rgb.received", (RGB)RGB_RECEIVED);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"hisilicon.fastboot.console.out.rgb.warning", (RGB)RGB_WARNING);
        store.setDefault("hisilicon.fastboot.config.imageFill.nand.pinSaveMode", true);
        store.setDefault("hisilicon.fastboot.tftp.crc.check", true);
        store.setDefault("hisilicon.fastboot.tftp.windowSize.open", true);
        store.setDefault("hisilicon.fastboot.config.imageFill", "0x00");
        store.setDefault("hisilicon.fastboot.config.ethact", "Auto");
        store.setDefault("hisilicon.fastboot.config.emmcErase", false);
        store.setDefault("hisilicon.fastboot.config.emmcErase.beforeBurn", false);
    }
}

