/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.preferences;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.ProductLine;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.preferences.PreferenceConstants;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.views.FastbootView;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JTAGPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
PreferenceConstants {
    public static final String ID = "com.hisilicon.fastboot.preferences.JTAGPreferencePage";
    private static final String[][] JTAGSMALLMODELTYPELIST = new String[][]{{"HiSTBUSB2JTAG VER.B / VER.C", "HiSTBUSB2JTAG VER.B / VER.C"}, {"HiSTBUSB2JTAG VER.A", "HiSTBUSB2JTAG VER.A"}};
    private static final String[][] JTAGSMALLMODELTYPELIST_Hi3716MV430 = new String[][]{{"HiSTBUSB2JTAG VER.B / VER.C", "HiSTBUSB2JTAG VER.B / VER.C"}};
    private static final String[][] JTAGSMALLMODELTYPELIST_Hi3716MV420_CA_N = new String[][]{{"HiSTBUSB2JTAG VER.A", "HiSTBUSB2JTAG VER.A"}};
    private static final String[][] JTAGSMALLMODELTYPELIST_DPT = new String[][]{{"HISDPTUSB2JTAG", "HISDPTUSB2JTAG"}};
    private Button jtagSmallModelButton;

    public static String[][] getJTAGSMALLMODELTYPELIST() {
        return (String[][])JTAGSMALLMODELTYPELIST.clone();
    }

    public static String[][] getJtagSmallModelTypeList() {
        String[][] entryNamesAndValues = null;
        String chipType = FastbootView.getCurrentChipType();
        entryNamesAndValues = ProductLine.PRODUCTLINE.DPT.name().equalsIgnoreCase(chipType) ? JTAGSMALLMODELTYPELIST_DPT : (FastbootView.isHi3716MV430_CA_N_Series() ? JTAGSMALLMODELTYPELIST_Hi3716MV430 : (FastbootView.isHi3716MV420_CA_N_Series() ? JTAGSMALLMODELTYPELIST_Hi3716MV420_CA_N : JTAGSMALLMODELTYPELIST));
        return (String[][])entryNamesAndValues.clone();
    }

    public JTAGPreferencePage() {
        super(0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(FastbootPreferences.getPreferenceStore());
    }

    protected void createFieldEditors() {
        String chipType = FastbootView.getCurrentChipType();
        if (ProductLine.PRODUCTLINE.BVT.name().equalsIgnoreCase(chipType)) {
            return;
        }
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, false));
        Group jtagCommonadGroup = new Group(parent, 0);
        jtagCommonadGroup.setLayout((Layout)new GridLayout(2, false));
        jtagCommonadGroup.setLayoutData((Object)new GridData(4, 1, true, false));
        jtagCommonadGroup.setText(Messages.JTAGPreferencePage_Title);
        if (ProductLine.PRODUCTLINE.STB.name().equalsIgnoreCase(chipType)) {
            Label jtagSmallModellable = new Label((Composite)jtagCommonadGroup, 0);
            jtagSmallModellable.setText(Messages.JTAGPreferencePage_JTAGTestSignel);
            this.jtagSmallModelButton = new Button((Composite)jtagCommonadGroup, 0);
            this.jtagSmallModelButton.setText(Messages.JTAGPreferencePage_Start);
            this.jtagSmallModelButton.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    boolean isEnd;
                    new CallLibJTAGWorker(null, null, null, ToolType.Composite);
                    LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                    LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
                    if (JTAGPreferencePage.this.jtagSmallModelButton.getText().equals(Messages.JTAGPreferencePage_Start)) {
                        String jtagSmallBoradModel = FastbootPreferences.getJtagSmallBoradModel();
                        int ft2232Chip = jtagSmallBoradModel.equals(JTAGSMALLMODELTYPELIST[0][0]) ? 0 : 1;
                        CallLibJTAGWorker.jtag_SetFT2232Chip(ft2232Chip);
                        boolean isStart = CallLibJTAGWorker.jtag_StartSignalTest();
                        if (isStart) {
                            JTAGPreferencePage.this.jtagSmallModelButton.setText(Messages.JTAGPreferencePage_Stop);
                        }
                    } else if (JTAGPreferencePage.this.jtagSmallModelButton.getText().equals(Messages.JTAGPreferencePage_Stop) && (isEnd = CallLibJTAGWorker.jtag_StopSignalTest())) {
                        JTAGPreferencePage.this.jtagSmallModelButton.setText(Messages.JTAGPreferencePage_Start);
                    }
                }

                public void mouseUp(MouseEvent e) {
                }
            });
        }
        ComboFieldEditor jtagSmallModelCombo = new ComboFieldEditor("hisilicon.fastboot.jtag.small.borad.model", Messages.JTAGPreferencePage_JtagSmallBoardModel, JTAGPreferencePage.getJtagSmallModelTypeList(), (Composite)jtagCommonadGroup);
        this.addField((FieldEditor)jtagSmallModelCombo);
    }

    public void dispose() {
        String chipType = FastbootView.getCurrentChipType();
        if (ProductLine.PRODUCTLINE.STB.name().equalsIgnoreCase(chipType)) {
            if (this.jtagSmallModelButton.getText().equals(Messages.JTAGPreferencePage_Stop)) {
                CallLibJTAGWorker.jtag_StopSignalTest();
            }
            FastbootView.setJtagRate();
        }
        super.dispose();
    }
}

