/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.commands.EraseCommand;
import com.hisilicon.fastboot.commands.INFOCommand;
import com.hisilicon.fastboot.commands.MWCommand;
import com.hisilicon.fastboot.commands.NetCommand;
import com.hisilicon.fastboot.commands.ReadCommand;
import com.hisilicon.fastboot.commands.SFCommand;
import com.hisilicon.fastboot.commands.TFTPCommand;
import com.hisilicon.fastboot.commands.UnZipCommand;
import com.hisilicon.fastboot.commands.WriteCommand;
import com.hisilicon.fastboot.jna.LibJTAGByJNA;
import com.hisilicon.fastboot.model.BoardConfig;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.ChipID;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.devices.burners.AddressBurner;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.model.struct.XmodelParameter;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.serial.workers.CallLibUSBWorker;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import com.hisilicon.fastboot.serial.workers.WorkerUtility;
import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.GZipUtils;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.hisilicon.fastboot.views.FastbootView;
import com.soyatec.hisilicon.platform.api.statistics.HiToolStatistics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.soyatec.tftp.hitool.TFTPService;
import org.soyatec.tftp.tftp4java.prefences.TFTPPreferences;

public class AddressBurnerWorker
extends FastbootBurnerWorker {
    private static long tempFileDivisionSize = 0L;
    static int FILE_PART_SIZE_32 = 0x2000000;
    static String BurntLengthGreaterEraseLength = "Burning Failed.\nReal burnt length is greater than the erase length, Please modify the length of the partition.";
    private final BoardConfig board;
    private final LocalConfig local;

    public AddressBurnerWorker(IBurner burner, ToolType toolType) {
        super(burner.getBurnContext().getDeviceSetting().getFrameSetting(), burner, toolType);
        this.burner = burner;
        BurnContext burnContext = burner.getBurnContext();
        this.local = burnContext.getLocalConfig();
        this.board = burnContext.getBoardConfig();
    }

    public boolean burn(IProgressMonitor uimonitor, File file, FlashType flashType, FileSystem fileSystem, String startAddress, ChipID chipID) throws IOException {
        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Burn By Address", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
        String versionInfo = this.getVersionInfo("Burn By Address");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        try {
            boolean isResetJtag;
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("Burn Address", 100);
            FastbootEvent event = AddressBurnerWorker.getMonitor().getEvent();
            event.init(EventType.BURN);
            AddressBurnerWorker.getMonitor().begin();
            TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
            if (transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom) {
                boolean bl = this.burnSinglePartByI2c(uimonitor, file, startAddress, flashType, false, chipID);
                return bl;
            }
            if (transferWay == TransferWay.USBNonNude) {
                boolean result = this.bootromByNonNude(uimonitor);
                if (!result) {
                    return false;
                }
                result = this.downloadBootByUSB(uimonitor, file);
                if (!result) {
                    return false;
                }
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, 100, 4);
                uimonitor.setTaskName("Burning " + file.getName());
                ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
                hasFlashTypes.add(flashType);
                boolean loadVersionInfo = this.loadVersionInfo();
                if (!loadVersionInfo || this.version == null) {
                    if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                        this.loadBlockSizes(hasFlashTypes, chipID, false);
                        this.warningln("Warning: Failed to load version info!");
                    } else {
                        this.returnError("Failed to load version info!");
                        return false;
                    }
                }
                this.loadBlockSizes(hasFlashTypes, chipID, false);
                boolean burnFile = this.burnFile(subProgressMonitor, file, fileSystem, flashType, Long.parseLong(startAddress, 16), chipID);
                event.setSuccess(burnFile);
                if (burnFile) {
                    this.infoln("\nAddress burnt successfully.");
                } else {
                    this.returnError("\nFailed to burn by address!");
                }
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
                boolean bl = burnFile;
                return bl;
            }
            uimonitor.setTaskName("Init Board");
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, 100, 4);
            if (HiToolUtils.isJTagTransferMode(this.getBurner().getBurnContext().getTransferWay())) {
                new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor, this.toolType);
                LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
            }
            ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
            hasFlashTypes.add(flashType);
            boolean initBoard = this.initBoard(hasFlashTypes, true);
            if (!initBoard) {
                return false;
            }
            if (transferWay == TransferWay.Uart2Compress) {
                this.getTempFileDivisionSize();
            } else if (this.isNeedSetupNet(transferWay) && !this.setupNetwork(transferWay)) {
                this.returnError("Failed to setup network!");
                return false;
            }
            uimonitor.setTaskName("Burning " + file.getName());
            boolean burnFile = this.burnFile(subProgressMonitor, file, fileSystem, flashType, Long.parseLong(startAddress, 16), chipID);
            event.setSuccess(burnFile);
            if (burnFile) {
                this.infoln("\nAddress burnt successfully.");
            } else {
                this.returnError("\nFailed to burn by address!");
            }
            boolean bl = isResetJtag = !(!FastbootView.isHi3231V530Series() && !FastbootView.isHi3796MV200Series() && !FastbootView.isHi3716MV410_CA_N_Series() || transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial);
            if (!isResetJtag) {
                String resetCommand = "reset";
                this.sendCommandNoReturnValue(resetCommand);
            }
            boolean bl2 = burnFile;
            return bl2;
        }
        catch (ReceiveTimeOutException e) {
            this.returnError("\nConnection Interrupted, please try again.\n");
            return false;
        }
        finally {
            this.printCrcValue(file);
            uimonitor.done();
        }
    }

    protected boolean burnFile(SubProgressMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long start, ChipID chipID) throws IOException, ReceiveTimeOutException {
        long blockSize = 0L;
        if (flashType == FlashType.spi) {
            blockSize = this.getSpiBlockSize();
        } else {
            blockSize = this.getNandBlockSize();
            if (this.isPage() && start != 0L) {
                blockSize = this.getPageSize();
            }
        }
        if (blockSize <= 0L) {
            String error = "Failed to get blocksize for the Flash \t" + flashType.name();
            this.returnError(error);
            return false;
        }
        if (start % blockSize != 0L) {
            String error = "Address is not block aligned!\nBlock size:\t" + blockSize;
            this.returnError(error);
            return false;
        }
        fileSystem = FileSystem.none;
        if (FileSystem.isYaffsFile(this.burner, file)) {
            fileSystem = FileSystem.yaffs;
        }
        long fileSize = file.length();
        long writeLength = 0L;
        writeLength = fileSize % blockSize != 0L ? blockSize * (fileSize / blockSize + 1L) : fileSize;
        long eraseLength = writeLength;
        if (start != 0L && this.isPage()) {
            long nandBlockSize = this.getNandBlockSize();
            eraseLength = fileSize % nandBlockSize != 0L ? nandBlockSize * (fileSize / nandBlockSize + 1L) : fileSize;
        }
        if (FileSystem.yaffs == fileSystem) {
            writeLength = fileSize;
        }
        long filePartSize = FILE_PART_SIZE_32;
        if (FileSystem.yaffs == fileSystem) {
            long[] yaffsPageandOOBSize = this.getYaffsPageandOOBSize();
            long ulPageSize = yaffsPageandOOBSize[0];
            long ulOOBSize = yaffsPageandOOBSize[1];
            if (0L == ulPageSize || 0L == ulOOBSize) {
                this.returnError("Failed to get yaffs block size!");
                return false;
            }
            writeLength = fileSize;
            filePartSize = (long)FILE_PART_SIZE_32 / blockSize * (blockSize + blockSize / ulPageSize * ulOOBSize);
        }
        AddressBurnerWorker.getMonitor().updateLength(writeLength);
        if (writeLength > filePartSize) {
            return this.burnLargeFile(subProgressMonitor, file, fileSystem, flashType, filePartSize, start, eraseLength, writeLength, chipID);
        }
        return this.burnSmallFile(subProgressMonitor, file, fileSystem, flashType, start, eraseLength, writeLength, chipID);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean burnLargeFile(SubProgressMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long filePartSize, long start, long eraseLength, long adjustedTotalWriteLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        tasks = (int)(file.length() / filePartSize + 1L);
        subProgressMonitor.beginTask("", tasks * 100 + 5);
        inputStream = null;
        result = true;
        try {
            if (flashType == FlashType.spi && !(result = this.sendCommand(SFCommand.getInstance(chipID)))) {
                var42_13 = result;
                return var42_13;
            }
            eraseCommand = EraseCommand.erase(flashType, Long.toHexString(start), Long.toHexString(eraseLength));
            result = this.sendCommand(eraseCommand);
            subProgressMonitor.worked(5);
            if (!result) {
                var42_14 = result;
                return var42_14;
            }
            v0 = fileVaild = file.exists() != false && file.isFile() != false;
            if (fileVaild) {
                inputStream = new FileInputStream(file);
            }
            buffer = new byte[0x200000];
            times = 0;
            address = start;
            totalLength = file.length();
            while (result && totalLength > 0L) {
                block49: {
                    partfile = null;
                    partLength = 0;
                    try {
                        read = -1;
                        partFilePath = this.getBurner().getBurnContext().isTftpOccupied() != false ? (partFilePath = String.valueOf(file.getPath()) + ".part" + times) : String.valueOf(HiToolUtils.getInstallPath()) + File.separator + file.getName() + ".part" + times;
                        partfile = new File(partFilePath);
                        isCreate = FileUtils.isCreateNewFile(partfile);
                        if (!isCreate) {
                            this.returnError(NLS.bind((String)Messages.AddressBurnerWorker_PartFile_Create_Failed, (Object)partfile.getPath()));
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var39_49) {
                        FileUtils.deleteFile(partfile);
                        throw var39_49;
                    }
                    FileUtils.deleteFile(partfile);
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        this.switchTFTPDownloadHome(partfile.getParentFile());
                        outputtream = null;
                        try {
                            outputtream = new FileOutputStream(partfile);
                            length = (int)Math.min(filePartSize, (long)buffer.length);
                            while ((long)partLength < filePartSize && result && (read = inputStream.read(buffer, 0, length)) > 0) {
                                outputtream.write(buffer, 0, read);
                                v1 = length = filePartSize - (long)(partLength += read) < (long)buffer.length ? (int)(filePartSize - (long)partLength) : buffer.length;
                            }
                        }
                        finally {
                            if (outputtream != null) {
                                try {
                                    outputtream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        totalLength -= (long)partLength;
                        subProgressMonitor.worked(5);
                        if ((long)partLength < filePartSize) {
                            partLength = (int)(adjustedTotalWriteLength % filePartSize);
                        }
                        ddrAddress = this.getHexStartAddress();
                        unzipAddr = Long.toHexString(AddressBurnerWorker.tempFileDivisionSize + (long)this.getHexStartAddressForInt());
                        if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                            ddrAddress = unzipAddr;
                        }
                        subProgressMonitor.setTaskName("Sending MW command.");
                        memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), Long.toHexString(partLength));
                        result = this.sendCommand(memsetCommand);
                        subProgressMonitor.worked(2);
                        writeCommand = this.getWriteCommand(fileSystem, flashType, times, address, partLength, ddrAddress);
                        readFileLen = 0L;
                        xmodelPar = new XmodelParameter(file.length(), readFileLen);
                        result = this.downloadFileByTrans(subProgressMonitor, result, xmodelPar, partfile, 90);
                        if (result) ** GOTO lbl-1000
                        var40_47 = result;
                    }
                    FileUtils.deleteFile(partfile);
                    return var40_47;
lbl-1000:
                    // 1 sources

                    {
                        readFileLen += partfile.length();
                        result = this.unzipForUart2Compress(unzipAddr, writeCommand);
                        if (result) ** GOTO lbl-1000
                        var40_48 = result;
                    }
                    FileUtils.deleteFile(partfile);
                    return var40_48;
lbl-1000:
                    // 1 sources

                    {
                        result = this.sendCommand(writeCommand);
                        burnCount = 1;
                        result = this.checkBlockFlash(subProgressMonitor, result, writeCommand, burnCount);
                        if (start + eraseLength >= (address = this.handleRealBurnLen(fileSystem, flashType, filePartSize, address))) ** GOTO lbl-1000
                        this.returnError(AddressBurnerWorker.BurntLengthGreaterEraseLength);
                    }
                    FileUtils.deleteFile(partfile);
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        subProgressMonitor.worked(5);
                        ++times;
                        if (result) break block49;
                    }
                    FileUtils.deleteFile(partfile);
                    break;
                }
                FileUtils.deleteFile(partfile);
            }
            var42_15 = result;
            return var42_15;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            subProgressMonitor.done();
        }
    }

    private WriteCommand getWriteCommand(FileSystem fileSystem, FlashType flashType, int times, long address, int partLength, String ddrAddress) {
        WriteCommand writeCommand = WriteCommand.write(flashType, ddrAddress, Long.toHexString(address), Long.toHexString(partLength));
        if (fileSystem == FileSystem.yaffs) {
            writeCommand = times == 0 ? WriteCommand.writeYaffs(flashType, ddrAddress, Long.toHexString(address), Long.toHexString(partLength)) : WriteCommand.writeYaffsuc(flashType, ddrAddress, Long.toHexString(address), Long.toHexString(partLength));
        }
        if (fileSystem == FileSystem.ubiFs) {
            writeCommand = WriteCommand.writeUbiFs(flashType, ddrAddress, Long.toHexString(address), Long.toHexString(partLength));
        }
        return writeCommand;
    }

    private long handleRealBurnLen(FileSystem fileSystem, FlashType flashType, long filePartSize, long address) {
        boolean isYaffs;
        boolean bl = isYaffs = fileSystem == FileSystem.yaffs || FlashType.nand == flashType;
        if (isYaffs) {
            long realBurnLength = this.getRealBurnLength();
            if (realBurnLength == -1L) {
                this.returnError("Failed to get real burt length.");
                return address;
            }
            if (realBurnLength == 0L) {
                this.infoln("Warning:HiBurn didn't receive the real burning length from the board, so please try to use the release version of the boot");
            }
            address += realBurnLength;
        } else {
            address += filePartSize;
        }
        return address;
    }

    private boolean checkBlockFlash(SubProgressMonitor subProgressMonitor, boolean result, WriteCommand writeCommand, int burnCount) throws IOException, ReceiveTimeOutException {
        while (!result) {
            String returnString = this.getCurReceived();
            if (!returnString.contains("WARNING: block is marked as bad")) break;
            this.warningln("A block is marked as bad block, burning the file again,the current is the " + burnCount + " times");
            subProgressMonitor.setTaskName("Writing...");
            result = this.sendCommand(writeCommand);
            ++burnCount;
        }
        return result;
    }

    private boolean unzipForUart2Compress(String unzipAddr, WriteCommand writeCommand) throws IOException, ReceiveTimeOutException {
        if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
            UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
            return this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
        }
        return true;
    }

    protected boolean downloadFileByTrans(SubProgressMonitor subProgressMonitor, boolean result, XmodelParameter xmodelPar, File partfile, int progressWork) throws IOException, ReceiveTimeOutException {
        boolean isUSB;
        subProgressMonitor.setTaskName("Downloading File : " + partfile.getName());
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean isI2C = transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean bl = isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        if (transferWay == TransferWay.Serial) {
            result = this.downloadFileSerial(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, progressWork, 4), xmodelPar, partfile, false);
        } else if (transferWay == TransferWay.Uart2Compress) {
            File compressFile = GZipUtils.compress(this.uimonitor, partfile, false, true);
            if (compressFile == null) {
                this.returnError(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)partfile));
                return false;
            }
            result = this.downloadFileSerial(new SubProgressMonitor((IProgressMonitor)subProgressMonitor, progressWork, 4), xmodelPar, compressFile, false);
            if (compressFile.exists()) {
                FileUtils.deleteFile(compressFile);
            }
        } else if (!isI2C) {
            if (isUSB) {
                this.infoln("\nSend command:\tDownloading File : " + partfile.getName());
                result = CallLibUSBWorker.downloadFileByUsb(this.frameSetting, this.burner, subProgressMonitor, partfile, this.getHexStartAddressForInt());
                subProgressMonitor.worked(progressWork);
                if (!result) {
                    this.returnError(Messages.ERROR_INFO_USB_DOWNLOAD_FAILED);
                    return false;
                }
            } else if (transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial) {
                result = this.jtagAndCheckCRC(partfile);
                subProgressMonitor.worked(progressWork);
                if (!result) {
                    this.returnError(Messages.FAILED_TO_DOWNLOAD_FILE_BY_JTAG);
                    return false;
                }
            } else {
                boolean openTftpCrcCheck = true;
                if (HiToolUtils.isCmdLine()) {
                    openTftpCrcCheck = PreferenceConfig.isTftpCrcCheck() && !FastbootView.isHi3231V530Series();
                } else {
                    boolean bl2 = openTftpCrcCheck = FastbootPreferences.isOpenTftpCrcCheck() && !FastbootView.isHi3231V530Series();
                }
                if (openTftpCrcCheck) {
                    int retransmitCount = 0;
                    while (retransmitCount < 3) {
                        result = this.tftpAndCheckCRC(subProgressMonitor, partfile, openTftpCrcCheck);
                        if (!result) {
                            ++retransmitCount;
                            continue;
                        }
                        break;
                    }
                } else {
                    result = this.tftpAndCheckCRC(subProgressMonitor, partfile, openTftpCrcCheck);
                }
                subProgressMonitor.worked(progressWork);
                if (!result) {
                    this.returnError(Messages.Partition_TFTP_CRC_Failed);
                    return false;
                }
            }
        }
        return result;
    }

    protected boolean burnSmallFile(SubProgressMonitor subProgressMonitor, File file, FileSystem fileSystem, FlashType flashType, long address, long eraseLength, long writeLength, ChipID chipID) throws IOException, ReceiveTimeOutException {
        subProgressMonitor.beginTask("", 100);
        try {
            boolean validFile;
            boolean result = true;
            String hexAddress = Long.toHexString(address);
            String hexWriteLength = Long.toHexString(writeLength);
            String hexEraseLength = Long.toHexString(eraseLength);
            EraseCommand eraseCommand = EraseCommand.erase(flashType, hexAddress, hexEraseLength);
            String ddrAddress = this.getHexStartAddress();
            String unzipAddr = Long.toHexString(tempFileDivisionSize + (long)this.getHexStartAddressForInt());
            if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                ddrAddress = unzipAddr;
            }
            WriteCommand writeCommand = WriteCommand.write(flashType, ddrAddress, hexAddress, hexWriteLength);
            if (fileSystem == FileSystem.yaffs) {
                writeCommand = WriteCommand.writeYaffs(flashType, ddrAddress, hexAddress, hexWriteLength);
            }
            if (fileSystem == FileSystem.ubiFs) {
                writeCommand = WriteCommand.writeUbiFs(flashType, ddrAddress, hexAddress, hexWriteLength);
            }
            boolean bl = validFile = file != null && file.exists() && file.isFile();
            if (validFile) {
                subProgressMonitor.setTaskName("Sending MW command.");
                MWCommand memsetCommand = MWCommand.mwAddress(this.getHexStartAddress(), hexWriteLength);
                result = this.sendCommand(memsetCommand);
                subProgressMonitor.worked(2);
                if (result) {
                    subProgressMonitor.setTaskName("Downloading File : " + file.getName());
                    XmodelParameter xmodelPar = new XmodelParameter(file.length(), 0L);
                    result = this.downloadFileByTrans(subProgressMonitor, result, xmodelPar, file, 95);
                    if (!result) {
                        boolean bl2 = result;
                        return bl2;
                    }
                }
            }
            if (result && flashType == FlashType.spi) {
                result = this.sendCommand(SFCommand.getInstance(chipID));
                subProgressMonitor.worked(1);
            }
            if (result) {
                subProgressMonitor.setTaskName("Erasing...");
                result = this.sendCommand(eraseCommand);
            }
            subProgressMonitor.worked(1);
            if (result && validFile) {
                if (this.getBurner().getBurnContext().getTransferWay() == TransferWay.Uart2Compress) {
                    UnZipCommand unZipCommand = UnZipCommand.unzip(this.getHexStartAddress(), unzipAddr);
                    result = this.sendCommand(unZipCommand.toString(), unZipCommand.calculateTimeOut(Long.toHexString(tempFileDivisionSize)));
                }
                subProgressMonitor.setTaskName("Writing...");
                result = this.sendCommand(writeCommand);
            }
            int burnCount = 1;
            boolean bl3 = result = this.checkBlockFlash(subProgressMonitor, result, writeCommand, burnCount);
            return bl3;
        }
        finally {
            subProgressMonitor.done();
        }
    }

    public IBurner getBurner() {
        return this.burner;
    }

    @Override
    protected String getStartMessage() {
        return super.getStartMessage();
    }

    protected boolean initSpi(ChipID chipId) throws IOException, ReceiveTimeOutException {
        return this.initSpi(this.getFlashType(), chipId);
    }

    protected boolean initSpi(FlashType flashType, ChipID ChipId) throws IOException, ReceiveTimeOutException {
        boolean bRet = true;
        if (flashType == FlashType.spi) {
            bRet = this.sendCommand(SFCommand.getInstance(ChipId));
        }
        return bRet;
    }

    @Override
    public void switchTFTPDownloadHome(File file) {
        if (file == null) {
            return;
        }
        if (!TFTPService.TFTPSERVICE.isStart()) {
            return;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if (file.isDirectory()) {
            TFTPService.TFTPSERVICE.setServerDirectory(file);
            this.infoln("\tTftp server Download Home switched to <" + file.getAbsolutePath() + ">");
        }
    }

    public boolean upload(IProgressMonitor uimonitor, File file, FileSystem uploadFileSystem, String address, String length, boolean needStartBoot, ChipID chipId) throws IOException {
        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Upload By Address", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
        String versionInfo = this.getVersionInfo("Upload By Address");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        if (HiToolUtils.isJTagTransferMode(this.getBurner().getBurnContext().getTransferWay())) {
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, 100, 4);
            new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor, this.toolType);
            LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
            LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
        }
        try {
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("", 100);
            FastbootEvent event = AddressBurnerWorker.getMonitor().getEvent();
            event.init(EventType.UPLOAD);
            uimonitor.setTaskName("Init Board");
            FlashType flashType = this.getFlashType();
            ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
            hasFlashTypes.add(flashType);
            if (needStartBoot) {
                if (!this.initBoard(hasFlashTypes, false)) {
                    String error = "Failed to initialize the board!";
                    this.returnError(error);
                    return false;
                }
                TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
                if (this.isNeedSetupNet(transferWay) && !this.setupNetwork(transferWay)) {
                    this.returnError("Failed to setup network!");
                    return false;
                }
            }
            uimonitor.worked(5);
            ReadCommand readCommand = null;
            if (FileSystem.yaffs != uploadFileSystem) {
                readCommand = ReadCommand.read(flashType, this.getHexStartAddress(), address, length);
            } else {
                readCommand = ReadCommand.readYaffs(flashType, this.getHexStartAddress(), address, length);
                uploadFileSystem = null;
            }
            boolean bRet = true;
            bRet = this.initSpi(flashType, chipId);
            uimonitor.setTaskName("Reading Content");
            if (bRet) {
                bRet = this.sendCommand(readCommand);
            }
            uimonitor.worked(10);
            uimonitor.setTaskName("Uploading Content");
            if (bRet) {
                try {
                    bRet = this.uploadByTrans(uimonitor, Long.parseLong(length, 16), file);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            event.setSuccess(bRet);
            if (bRet) {
                this.infoln("Uploaded successfully by Address.");
            } else {
                this.returnError("Failed to upload by Address!");
            }
            boolean bl = bRet;
            return bl;
        }
        catch (ReceiveTimeOutException e) {
            this.returnError("\nConnection Interrupted, please try again.\n");
            return false;
        }
        finally {
            uimonitor.done();
        }
    }

    protected boolean uploadByTrans(IProgressMonitor uiMonitor, long length, File tmpFile) throws IOException, ReceiveTimeOutException {
        boolean isOnlyJTAG;
        boolean result = false;
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        boolean isSerial = transferWay == TransferWay.Serial || transferWay == TransferWay.Uart2Compress;
        boolean isI2C = transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean isUSB = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
        boolean bl = isOnlyJTAG = transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndSerial;
        if (isSerial) {
            result = this.upload(new SubProgressMonitor(uiMonitor, 98, 4), tmpFile, this.getHexStartAddress(), Long.toHexString(length));
        } else if (isI2C) {
            this.returnError(NLS.bind((String)Messages.ERROR_INFO_Cur_TransferMode_NoSupport_Upload, (Object)"I2C"));
        } else {
            if (isUSB) {
                this.returnError(NLS.bind((String)Messages.ERROR_INFO_Cur_TransferMode_NoSupport_Upload, (Object)"USB"));
                return false;
            }
            if (isOnlyJTAG) {
                this.infoln("\nSend command:\tDumping File by JTAG: " + tmpFile.getName());
                result = CallLibJTAGWorker.dumpFileByJtag(tmpFile.getPath(), this.getHexStartAddressForInt(), length);
            } else {
                this.switchTFTPDownloadHome(tmpFile);
                TFTPCommand uploadCommand = TFTPCommand.upload(tmpFile, this.getHexStartAddress(), Long.toHexString(length));
                result = this.sendCommand(uploadCommand);
            }
        }
        return result;
    }

    protected void deleteTempFile(File file) {
        long startTime = System.currentTimeMillis();
        long outTime = 2000L;
        while (file != null && !file.delete() && System.currentTimeMillis() - startTime < outTime) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (file != null && file.exists()) {
            this.warning(NLS.bind((String)Messages.AddressBurnerWorker_PartFile_Delete_Failed, (Object)file.getAbsolutePath()));
        }
    }

    protected void setMessage(String mesg) {
        if (AddressBurnerWorker.getMonitor() != null) {
            AddressBurnerWorker.getMonitor().getEvent().setMessage(mesg);
        }
        this.warningln(mesg);
    }

    protected boolean downloadFileSerial(File file, String hexStartAddress) throws IOException, ReceiveTimeOutException {
        this.info("downloadFileSerial: file=" + file.getAbsolutePath() + "\taddress=" + hexStartAddress);
        boolean result = false;
        FileInputStream in = null;
        byte[] content = null;
        try {
            in = new FileInputStream(file);
            content = new byte[in.available()];
            int read = in.read(content);
            if (read != content.length) {
                this.warning("File length is read.");
            }
            this.info("length=\t" + read);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        String seriadownloadCommand = "loady 0x" + this.getHexStartAddress() + "\n";
        result = this.sendCommand(seriadownloadCommand, 3000L);
        this.info("seriadownloadCommand=\t" + result + "\n");
        if (result) {
            result = this.sendXModem(content);
        }
        return result;
    }

    protected long getRealBurnLength() {
        String strBurnInfo = this.getCurReceived();
        if ((strBurnInfo = strBurnInfo.replaceAll("[EOT]", "").trim()).length() == 0) {
            return 0L;
        }
        String FLAG = "len_incl_bad is ";
        int beginIndex = strBurnInfo.indexOf(FLAG);
        if (beginIndex == -1) {
            return 0L;
        }
        int endIndex = strBurnInfo.indexOf("\r\n", beginIndex += FLAG.length());
        String strRealBurnLength = strBurnInfo.substring(beginIndex, endIndex);
        long parseLong = -1L;
        try {
            parseLong = Long.parseLong(strRealBurnLength);
        }
        catch (Exception e) {
            parseLong = -1L;
            this.warningln("Failed to parse to number from '" + strRealBurnLength + "'.");
        }
        return parseLong;
    }

    long[] getYaffsPageandOOBSize() throws IOException, ReceiveTimeOutException {
        String strNandInfo = "";
        if (this.sendCommand(INFOCommand.info(FlashType.nand))) {
            strNandInfo = this.getCurReceived();
        } else if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
            strNandInfo = this.ubootStartLog;
        }
        long pageSize = WorkerUtility.ReceiveHelper.getPageSize(strNandInfo);
        long oobSize = WorkerUtility.ReceiveHelper.getOobSize(strNandInfo);
        if (pageSize < 0L || oobSize < 0L) {
            return new long[2];
        }
        return new long[]{pageSize, oobSize};
    }

    public boolean initBoard(ArrayList<FlashType> hasFlashTypes, boolean isBurn) throws IOException, ReceiveTimeOutException {
        if (HiToolUtils.isDebugOn()) {
            this.println("InitBoard Start");
        }
        if (((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            if (!this.programmerDownload(null, ((AbstractBurner)((Object)this.burner)).getProgrammerFile())) {
                this.returnError("Failed to download fastboot!");
                return false;
            }
        } else {
            boolean isReplaceBoot;
            String programmerFile = ((AbstractBurner)((Object)this.burner)).getProgrammerFile();
            String file = ((AddressBurner)this.burner).getFile();
            String address = ((AddressBurner)this.burner).getAddress();
            ChipID chipID = ((AddressBurner)this.burner).getChipID();
            boolean bl = isReplaceBoot = isBurn && address != null && address.equals("0") && programmerFile == null && chipID != null && chipID == ChipID.chip0;
            if (isReplaceBoot) {
                programmerFile = file;
            }
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.NonCA ? !this.bootDownload(programmerFile) : !this.programmerDownload(null, programmerFile)) {
                return false;
            }
        }
        this.version = null;
        boolean loadVersionInfo = this.loadVersionInfo();
        if (!loadVersionInfo || this.version == null) {
            if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
                this.warningln("Warning: Failed to load version info!");
            } else {
                this.returnError("Failed to load version info!");
                return false;
            }
        }
        this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
        TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
        if (this.isNeedSetupNet(transferWay)) {
            this.setupNetwork(transferWay);
        }
        return true;
    }

    protected void loadBlockSizes(ChipID chipID) {
        FlashType[] flashTypes;
        FlashType[] flashTypeArray = flashTypes = this.getBurner().getBurnContext().getDeviceSetting().getFlashSetting().getFlashTypes(this.getBurner());
        int n = flashTypes.length;
        int n2 = 0;
        while (n2 < n) {
            FlashType flash = flashTypeArray[n2];
            if (flash == FlashType.spi) {
                this.setSpiBlockSize(this.getBlockSize(FlashType.spi, chipID, false));
            } else if (flash == FlashType.nand) {
                this.setNandBlockSize(this.getBlockSize(FlashType.nand, chipID, false));
            }
            ++n2;
        }
    }

    protected void loadBlockSizes(ArrayList<FlashType> hasFlashTypes, ChipID chipID, boolean isFastboot) {
        if (hasFlashTypes == null) {
            return;
        }
        for (FlashType flash : hasFlashTypes) {
            if (flash == FlashType.spi) {
                this.getBlockSize(FlashType.spi, chipID, isFastboot);
                continue;
            }
            if (flash != FlashType.nand) continue;
            this.getBlockSize(FlashType.nand, chipID, isFastboot);
        }
    }

    public boolean erase(IProgressMonitor uimonitor, String address, String length) throws IOException {
        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Erase By Address", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
        String versionInfo = this.getVersionInfo("Erase By Address");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        try {
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("", 100);
            AddressBurnerWorker.getMonitor().getEvent().init(EventType.ERASE);
            uimonitor.setTaskName("Init Board");
            if (HiToolUtils.isJTagTransferMode(this.getBurner().getBurnContext().getTransferWay())) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(uimonitor, 100, 4);
                new CallLibJTAGWorker(this.frameSetting, this.burner, subProgressMonitor, this.toolType);
                LibJTAGByJNA.instance.jtag_RegisterPrint(CallLibJTAGWorker.JTAGPRINTINFOCALLBACK);
                LibJTAGByJNA.instance.jtag_RegisterCancel(CallLibJTAGWorker.CANCELCALLBACK);
            }
            long blockSize = 0L;
            FlashType flashType = this.getFlashType();
            ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
            hasFlashTypes.add(flashType);
            boolean result = true;
            TransferWay transferWay = this.getBurner().getBurnContext().getTransferWay();
            if (transferWay == TransferWay.USBNonNude) {
                result = this.bootromByNonNude(uimonitor);
                if (!result) {
                    return false;
                }
                boolean loadVersionInfo = this.loadVersionInfo();
                if (!loadVersionInfo || this.version == null) {
                    if (this.burner.getBurnContext().getPlatformType() == PlatformType.CA) {
                        this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
                        this.warningln("Warning: Failed to load version info!");
                    } else {
                        this.returnError("Failed to load version info!");
                        return false;
                    }
                }
                this.loadBlockSizes(hasFlashTypes, ((AddressBurner)this.burner).getCurrentChipId(), false);
            } else {
                result = this.initBoard(hasFlashTypes, false);
                if (!result) {
                    return false;
                }
            }
            if (this.getFlashType() == FlashType.spi) {
                blockSize = this.getSpiBlockSize();
            } else {
                blockSize = this.getNandBlockSize();
                if (this.isPage()) {
                    blockSize = this.getPageSize();
                }
            }
            long addr = Long.parseLong(address, 16);
            if (addr % blockSize != 0L) {
                String error = "Address is not block aligned!\nBlock size:\t" + blockSize;
                this.returnError(error);
                return false;
            }
            long len = Long.parseLong(length, 16);
            if (len % blockSize != 0L) {
                String error = "Length is not block aligned!\nBlock size:\t" + blockSize;
                this.returnError(error);
                return false;
            }
            uimonitor.worked(20);
            if (flashType == FlashType.spi) {
                result = this.sendCommand(SFCommand.getInstance(((AddressBurner)this.burner).getCurrentChipId()));
            }
            if (result) {
                result = this.sendCommand(EraseCommand.erase(flashType, address, length));
            }
            if (result) {
                boolean isResetJtag;
                this.infoln("Flash erased successfully!");
                transferWay = this.getBurner().getBurnContext().getTransferWay();
                boolean bl = isResetJtag = !(!FastbootView.isHi3231V530Series() && !FastbootView.isHi3796MV200Series() && !FastbootView.isHi3716MV410_CA_N_Series() || transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial);
                if (!isResetJtag) {
                    String resetCommand = "reset";
                    this.sendCommandNoReturnValue(resetCommand);
                }
            } else {
                this.returnError("Failed to Erase Flash by address!");
            }
            boolean bl = result;
            return bl;
        }
        catch (ReceiveTimeOutException e) {
            this.returnError("\nConnection Interrupted, please try again.\n");
            return false;
        }
        finally {
            uimonitor.done();
        }
    }

    @Override
    protected NetCommand[] buildNetCommands(TransferWay transferWay) {
        String ethactID = null;
        if (this.toolType == ToolType.Composite) {
            IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
            ethactID = preferences.getString("hisilicon.fastboot.config.ethact");
        } else {
            ethactID = String.valueOf(PreferenceConfig.getCmdEthact());
        }
        NetCommand[] commands = null;
        if (ethactID == null) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[5];
        }
        if (ethactID != null && !ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
            commands = new NetCommand[6];
        }
        String serverIp = null;
        commands[0] = this.toolType == ToolType.Composite ? ((serverIp = TFTPPreferences.getPRETFTPSERVERIP()) != null && !serverIp.isEmpty() ? NetCommand.setServerIP(serverIp) : NetCommand.setServerIP(this.local.getServerIp())) : NetCommand.setServerIP(this.local.getServerIp());
        commands[1] = transferWay == TransferWay.UsbTransNet ? NetCommand.setClientMAC("") : NetCommand.setClientMAC(this.board.getMac());
        commands[2] = NetCommand.setClientIP(this.board.getIp());
        commands[3] = NetCommand.setClientNetMask(this.board.getSubnetMask());
        commands[4] = NetCommand.setClientGateway(this.board.getGateway());
        if (ethactID != null) {
            if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[0])) {
                return commands;
            }
            if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[1])) {
                commands[5] = NetCommand.setEthact("0");
            } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[2])) {
                commands[5] = NetCommand.setEthact("1");
            } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[3])) {
                commands[5] = NetCommand.setEthact("2");
            } else if (ethactID.equalsIgnoreCase(NetCommand.getKeyEthact()[4])) {
                commands[5] = NetCommand.setEthact("3");
            } else {
                return commands;
            }
        }
        return commands;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean setupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        try {
            NetCommand[] commands;
            boolean isUsbToEthernet = this.getBurner().getBurnContext().isUsbToEthernet();
            if (transferWay == TransferWay.UsbTransNet || isUsbToEthernet) {
                String usbTransNetCmd = "usb start";
                if (!this.sendCommand(usbTransNetCmd)) {
                    this.returnError(Messages.Fastboot_NotSupportUsbTransNetWay);
                    return false;
                }
                String returnStr = this.getCurReceived();
                String[] split = returnStr.split("\r\n");
                boolean foundFlag = false;
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.contains("Ethernet Device(s) found")) {
                        foundFlag = true;
                        int flagIndex = line.indexOf("Ethernet Device(s) found");
                        String usb2ethCountStr = "";
                        if (flagIndex < 2) {
                            this.returnError(Messages.Burner_NotFoundUsb2EthPort);
                            return false;
                        }
                        usb2ethCountStr = line.substring(flagIndex - 2, flagIndex).trim();
                        try {
                            int usb2ethCount = Integer.parseInt(usb2ethCountStr);
                            if (usb2ethCount <= 0) {
                                this.returnError(Messages.Burner_NotFoundUsb2EthPort);
                                return false;
                            }
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.returnError(Messages.Burner_NotFoundUsb2EthPort);
                            return false;
                        }
                    }
                    ++n2;
                }
                if (!foundFlag) {
                    this.returnError(Messages.Burner_NotFoundUsb2EthPort);
                    return false;
                }
            }
            NetCommand[] netCommandArray = commands = this.buildNetCommands(transferWay);
            int n = commands.length;
            int n3 = 0;
            while (n3 < n) {
                NetCommand command = netCommandArray[n3];
                if (!this.sendCommand(command)) {
                    return false;
                }
                ++n3;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FastbootView.setStartNetwork(false);
        return true;
    }

    protected String calculateBurnTotalTime(long burnTotalTime) {
        StringBuilder burnTotalTimeStr = new StringBuilder();
        long hours = burnTotalTime % 86400000L / 3600000L;
        long minutes = burnTotalTime % 3600000L / 60000L;
        long seconds = burnTotalTime % 60000L / 1000L;
        if (hours != 0L) {
            burnTotalTimeStr.append(hours);
            burnTotalTimeStr.append(" ");
            burnTotalTimeStr.append(Messages.AbstractBurner_BurnTotalTime_hours);
        }
        if (minutes != 0L) {
            burnTotalTimeStr.append(minutes);
            burnTotalTimeStr.append(" ");
            burnTotalTimeStr.append(Messages.AbstractBurner_BurnTotalTime_minutes);
        }
        if (seconds != 0L) {
            burnTotalTimeStr.append(seconds);
            burnTotalTimeStr.append(" ");
            burnTotalTimeStr.append(Messages.AbstractBurner_BurnTotalTime_seconds);
        }
        return burnTotalTimeStr.toString();
    }
}

