/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.sparse;

import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.sparse.SparseChunkHeader;
import com.hisilicon.fastboot.sparse.SparseHeader;
import com.hisilicon.fastboot.utilitily.BytesUtils;
import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.jface.preference.IPreferenceStore;

public class SparseFileAgent {
    static final int SEPARATE_CHUNKLEN = 0x500000;

    public static boolean isAndroidSparseFile(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.length() < 28L) {
            return false;
        }
        RandomAccessFile randFile = null;
        SparseHeader header = new SparseHeader();
        try {
            try {
                randFile = new RandomAccessFile(file, "r");
                byte[] data = new byte[28];
                randFile.read(data);
                header.fromBytes(data);
            }
            catch (IOException e) {
                try {
                    if (randFile != null) {
                        randFile.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                if (randFile != null) {
                    randFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return header.magic == -316211398 && header.major_version == 1 && header.file_hdr_sz == 28;
    }

    public static boolean isAndroidSparseFile(byte[] data) {
        if (data.length < 28) {
            return false;
        }
        SparseHeader header = new SparseHeader();
        header.fromBytes(data);
        return header.magic == -316211398 && header.major_version == 1 && header.file_hdr_sz == 28;
    }

    public static File unsparse(File file) {
        String fillData = null;
        if (HiToolUtils.isCmdLine()) {
            fillData = String.valueOf(PreferenceConfig.getImgFillData());
        } else {
            IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
            fillData = preferences.getString("hisilicon.fastboot.config.imageFill");
        }
        String newFilePath = String.valueOf(file.getParent()) + File.separator + file.getName() + ".unsparse";
        long byteNum = 0L;
        RandomAccessFile randFile = null;
        RandomAccessFile outFile = null;
        try {
            randFile = new RandomAccessFile(file, "r");
            outFile = new RandomAccessFile(newFilePath, "rw");
            byte[] sparseHeaderData = new byte[28];
            randFile.seek(0L);
            int readLen = randFile.read(sparseHeaderData);
            if (readLen != sparseHeaderData.length) {
                return null;
            }
            outFile.seek(0L);
            SparseHeader sparseHeader = new SparseHeader();
            sparseHeader.fromBytes(sparseHeaderData);
            byteNum += 28L;
            int i = 0;
            while (i < sparseHeader.total_chunks) {
                byte[] chunkHeaderData = new byte[12];
                int read = randFile.read(chunkHeaderData);
                if (read < 0) {
                    System.out.println("Read Error");
                }
                SparseChunkHeader chunkHeader = new SparseChunkHeader();
                chunkHeader.fromBytes(chunkHeaderData);
                System.out.println("CHUNK: " + i + " type = " + chunkHeader.chunk_type + " chunk_sz = " + chunkHeader.chunk_sz + " Total Bytes = " + (byteNum += 12L));
                if (chunkHeader.chunk_type == -13631) {
                    int chunkLen = chunkHeader.chunk_sz * sparseHeader.blk_sz;
                    int chunkDataSpaceCount = (chunkLen + 0x500000 - 1) / 0x500000;
                    int chunkDataSpaceSpace = chunkLen % 0x500000;
                    if (chunkDataSpaceCount == 0) {
                        byte[] chunkData = new byte[chunkLen];
                        read = randFile.read(chunkData);
                        if (read < 0) {
                            System.out.println("Read Error");
                        }
                        outFile.write(chunkData);
                        byteNum += (long)chunkLen;
                    } else {
                        int j = 0;
                        while (j < chunkDataSpaceCount) {
                            int len;
                            byte[] chunkData = null;
                            if (j == chunkDataSpaceCount - 1) {
                                if (chunkDataSpaceSpace == 0) {
                                    chunkData = new byte[0x500000];
                                    len = 0x500000;
                                } else {
                                    chunkData = new byte[chunkDataSpaceSpace];
                                    len = chunkDataSpaceSpace;
                                }
                            } else {
                                chunkData = new byte[0x500000];
                                len = 0x500000;
                            }
                            read = randFile.read(chunkData);
                            if (read < 0) {
                                System.out.println("Read Error");
                            }
                            outFile.write(chunkData);
                            byteNum += (long)len;
                            ++j;
                        }
                    }
                } else if (chunkHeader.chunk_type == -13629) {
                    int chunkLen = chunkHeader.chunk_sz * sparseHeader.blk_sz;
                    int n = 0;
                    while (n < chunkHeader.chunk_sz) {
                        byte[] bytes = new byte[sparseHeader.blk_sz];
                        if (fillData.equals("0xFF")) {
                            bytes = BytesUtils.genBytesWithFF(sparseHeader.blk_sz);
                        }
                        outFile.write(bytes);
                        ++n;
                    }
                    byteNum += (long)chunkLen;
                } else if (chunkHeader.chunk_type == -13630) {
                    byte[] fill_val = new byte[4];
                    int len = randFile.read(fill_val, 0, fill_val.length);
                    if (len < 0) {
                        System.out.println("Read Error.");
                    }
                    byte[] fill_data = BytesUtils.genBytesFillValues(chunkHeader.chunk_sz * sparseHeader.blk_sz, fill_val);
                    outFile.write(fill_data);
                    byteNum += (long)fill_val.length;
                } else {
                    outFile.close();
                    FileUtils.deleteFile(new File(newFilePath));
                    return null;
                }
                try {
                    ++i;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        finally {
            if (randFile != null) {
                try {
                    randFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new File(newFilePath);
    }
}

