/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.thread;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.consoles.FastbootConsoleFactory;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.EmmcPartitionBurnerWorker;
import com.hisilicon.fastboot.sparse.SparseChunkHeader;
import com.hisilicon.fastboot.sparse.SparseFileAgent;
import com.hisilicon.fastboot.sparse.SparseHeader;
import com.hisilicon.fastboot.thread.PartitionTempObj;
import com.hisilicon.fastboot.thread.TempFileInfo;
import com.hisilicon.fastboot.utilitily.BufferedRandomAccessFile;
import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.GZipUtils;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LargeFileTogetherThread {
    protected static final int SECTOR_SIZE = 512;
    private boolean stopFlag;
    private ArrayList<PartitionTempObj> partitionTempObjList;
    private static final int FILE_BLOCK_SIZE_32 = 0x2000000;
    private static final int SEPARATE_CHUNKLEN = 0x500000;
    private EmmcPartitionBurnerWorker emmcPartitionBurnerWorker;
    private boolean tftpOccupied;

    public LargeFileTogetherThread(EmmcPartitionBurnerWorker emmcPartitionBurnerWorker) {
        this.emmcPartitionBurnerWorker = emmcPartitionBurnerWorker;
        this.partitionTempObjList = new ArrayList();
        this.partitionTempObjList.clear();
    }

    public void stop() {
        this.stopFlag = true;
    }

    /*
     * Unable to fully structure code
     */
    public void startMakeZipFile(IProgressMonitor uiMonitor, List<PartitionItem> parts, long tempFileDivisionSize, IFastbootProgressMonitor monitor) throws IOException, ReceiveTimeOutException {
        this.tftpOccupied = this.emmcPartitionBurnerWorker.getBurner().getBurnContext().isTftpOccupied();
        zipAndPageTimeLogger = this.emmcPartitionBurnerWorker.getZipAndPageTimeLogger();
        this.stopFlag = false;
        partIndex = 0;
        while (partIndex < parts.size()) {
            block20: {
                block22: {
                    block24: {
                        block23: {
                            block19: {
                                block17: {
                                    block18: {
                                        block21: {
                                            if (uiMonitor.isCanceled()) {
                                                this.clearTempFile();
                                                break;
                                            }
                                            if (this.stopFlag) {
                                                this.clearTempFile();
                                                break;
                                            }
                                            partitionTempObj = new PartitionTempObj();
                                            partitionItem = parts.get(partIndex);
                                            if (!partitionItem.isChecked() || (file = partitionItem.getFile()) == null || !file.exists() || (filePartSize = file.length()) < 0x2000000L) break block20;
                                            fileSystem = partitionItem.getFileSystem();
                                            partitionName = partitionItem.getName();
                                            if (partitionName == null) {
                                                partitionName = "";
                                            }
                                            zipAndPageTimeLogger.logStart(partitionName, partitionItem.getFile().length());
                                            totalTempCount = (int)((filePartSize + tempFileDivisionSize - 1L) / tempFileDivisionSize);
                                            partitionTempObj.setPartitionName(partitionName);
                                            partitionTempObj.setTotalTempCount(totalTempCount);
                                            isSparse = (fileSystem == FileSystem.ext3 || fileSystem == FileSystem.f2fs) && SparseFileAgent.isAndroidSparseFile(file) != false;
                                            result = true;
                                            partitionTempObj.setNeedWaitZip(true);
                                            if (filePartSize <= tempFileDivisionSize) break block21;
                                            this.emmcPartitionBurnerWorker.getSpellingSparseFileLogger().logStart(file.getName(), filePartSize);
                                            result = isSparse != false ? this.createSparseTempFile(uiMonitor, partIndex, file, result, partitionTempObj, tempFileDivisionSize, monitor) : this.createTempFile(uiMonitor, partIndex, file, tempFileDivisionSize, result, partitionTempObj, monitor);
                                            this.emmcPartitionBurnerWorker.getSpellingSparseFileLogger().logEnd();
                                            break block22;
                                        }
                                        partFilePath = null;
                                        partFilePath = this.tftpOccupied != false ? String.valueOf(file.getParent()) + File.separator + partIndex + file.getName() : String.valueOf(HiToolUtils.getInstallPath()) + File.separator + partIndex + file.getName();
                                        partFile = new File(partFilePath);
                                        copy = FileUtils.copy(uiMonitor, file, partFile);
                                        if (!copy) {
                                            monitor.println(NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)partFile));
                                            Display.getDefault().asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)NLS.bind((String)Messages.ERROR_INFO_DISK_SPACE_LOW, (Object)partFile));
                                                }
                                            });
                                            return;
                                        }
                                        if (!isSparse) break block23;
                                        inFile = null;
                                        inFile = new RandomAccessFile(file, "r");
                                        sparseHeaderData = new byte[28];
                                        inFile.seek(0L);
                                        read = inFile.read(sparseHeaderData);
                                        if (read < 0) {
                                            System.out.println("Read Error");
                                        }
                                        sparseHeader = new SparseHeader();
                                        sparseHeader.fromBytes(sparseHeaderData);
                                        tempFileBurnNeedSize = (long)sparseHeader.blk_sz * sparseHeader.total_blks;
                                        zipTempFile = GZipUtils.compress(uiMonitor, partFile, false, this.tftpOccupied);
                                        if (zipTempFile != null) break block17;
                                        if (inFile == null) break block18;
                                        inFile.close();
                                    }
                                    return;
                                }
                                try {
                                    try {
                                        if (partFile != null && partFile.exists()) {
                                            FileUtils.deleteFile(partFile);
                                        }
                                        tempFileInfo = new TempFileInfo();
                                        tempFileInfo.setZipTempFile(zipTempFile);
                                        tempFileInfo.setTempFileBurnNeedSize(tempFileBurnNeedSize);
                                        tempFileInfo.setStartAddressOffset(0L);
                                        tempFileInfo.setBurnState(false);
                                        partitionTempObj.getTempFileInfoList().add(tempFileInfo);
                                        if (this.partitionTempObjList.contains(partitionTempObj)) break block19;
                                        this.partitionTempObjList.add(partitionTempObj);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        if (inFile == null) ** GOTO lbl103
                                        inFile.close();
                                    }
                                }
                                catch (Throwable var29_28) {
                                    if (inFile != null) {
                                        inFile.close();
                                    }
                                    throw var29_28;
                                }
                            }
                            if (inFile != null) {
                                inFile.close();
                            }
                            break block24;
                        }
                        zipTempFile = GZipUtils.compress(uiMonitor, partFile, false, this.tftpOccupied);
                        if (zipTempFile == null) {
                            return;
                        }
                        tempFileInfo = new TempFileInfo();
                        tempFileInfo.setZipTempFile(zipTempFile);
                        tempFileInfo.setTempFileBurnNeedSize(file.length());
                        tempFileInfo.setStartAddressOffset(0L);
                        tempFileInfo.setBurnState(false);
                        partitionTempObj.getTempFileInfoList().add(tempFileInfo);
                        if (!this.partitionTempObjList.contains(partitionTempObj)) {
                            this.partitionTempObjList.add(partitionTempObj);
                        }
                    }
                    if (partFile != null && partFile.exists() && !(isDelete = FileUtils.deleteFile(partFile))) {
                        monitor.println(NLS.bind((String)Messages.FileDeleteFailed, (Object)partFile));
                    }
                }
                partitionTempObj.setNeedWaitZip(false);
                zipAndPageTimeLogger.logEnd();
            }
            ++partIndex;
        }
    }

    public long getTempFileSize(long ddrFreeSize) {
        long blockNumber = ddrFreeSize / 0x2000000L;
        if (blockNumber <= 0L) {
            blockNumber = 1L;
        }
        return 0x2000000L * blockNumber;
    }

    public void clearTempFile() {
        int i = 0;
        while (i < this.partitionTempObjList.size()) {
            PartitionTempObj partitionTempObj = this.partitionTempObjList.get(i);
            List<TempFileInfo> tempFileInfoList = partitionTempObj.getTempFileInfoList();
            int j = 0;
            while (j < tempFileInfoList.size()) {
                File zipTempFile;
                TempFileInfo tempFileInfo = tempFileInfoList.get(j);
                if (tempFileInfo != null && (zipTempFile = tempFileInfo.getZipTempFile()).exists()) {
                    this.deleteTempFile(zipTempFile);
                }
                ++j;
            }
            ++i;
        }
    }

    private void deleteTempFile(File file) {
        long startTime = System.currentTimeMillis();
        long outTime = 5000L;
        while (file != null && !file.delete() && System.currentTimeMillis() - startTime < outTime) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (file != null && file.exists()) {
            FastbootConsoleFactory.getDebugConsole().getWarningStream().println(String.valueOf(file.getName()) + " failed to automatically deleted, please removed manually!");
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean createTempFile(IProgressMonitor uiMonitor, int partIndex, File file, long tempFileDivisionSize, boolean result, PartitionTempObj partitionTempObj, IFastbootProgressMonitor monitor) throws FileNotFoundException, IOException {
        FileInputStream inputStream = null;
        int tempTimes = 0;
        try {
            block23: {
                long startAddrOffset;
                long totalLength;
                byte[] buffer;
                block22: {
                    if (file == null) return result;
                    if (!file.exists()) return result;
                    if (!file.isFile()) return result;
                    inputStream = new FileInputStream(file);
                    buffer = new byte[0x200000];
                    totalLength = file.length();
                    startAddrOffset = 0L;
                    if (!true) break block22;
                    if (!result) return result;
                    if (totalLength <= 0L) break block23;
                }
                do {
                    File partfile = null;
                    int partLength = 0;
                    try {
                        int read = -1;
                        boolean tftpOccupied = this.emmcPartitionBurnerWorker.getBurner().getBurnContext().isTftpOccupied();
                        String partFilePath = null;
                        partFilePath = tftpOccupied ? String.valueOf(file.getParent()) + partIndex + file.getName() + ".part" + tempTimes++ : String.valueOf(HiToolUtils.getInstallPath()) + File.separator + partIndex + file.getName() + ".part" + tempTimes++;
                        partfile = new File(partFilePath);
                        boolean createNewFile = partfile.createNewFile();
                        if (!createNewFile) {
                            System.out.println("Failed to create file " + partfile.getName());
                        }
                        FileOutputStream outputtream = null;
                        try {
                            outputtream = new FileOutputStream(partfile);
                            int length = (int)Math.min(tempFileDivisionSize, (long)buffer.length);
                            while ((long)partLength < tempFileDivisionSize && result && (read = inputStream.read(buffer, 0, length)) > 0) {
                                ((OutputStream)outputtream).write(buffer, 0, read);
                                length = tempFileDivisionSize - (long)(partLength += read) < (long)buffer.length ? (int)(tempFileDivisionSize - (long)partLength) : buffer.length;
                            }
                        }
                        finally {
                            if (outputtream != null) {
                                ((OutputStream)outputtream).close();
                            }
                        }
                        File zipTempFile = GZipUtils.compress(uiMonitor, partfile, false, tftpOccupied);
                        if (zipTempFile == null) {
                            return false;
                        }
                        TempFileInfo tempFileInfo = new TempFileInfo();
                        tempFileInfo.setZipTempFile(zipTempFile);
                        tempFileInfo.setStartAddressOffset(startAddrOffset);
                        tempFileInfo.setTempFileBurnNeedSize(partLength);
                        tempFileInfo.setBurnState(false);
                        partitionTempObj.getTempFileInfoList().add(tempFileInfo);
                        if (!this.partitionTempObjList.contains(partitionTempObj)) {
                            this.partitionTempObjList.add(partitionTempObj);
                        }
                        startAddrOffset += (long)partLength;
                        totalLength -= (long)partLength;
                    }
                    finally {
                        if (partfile != null && partfile.exists()) {
                            FileUtils.deleteFile(partfile);
                        }
                    }
                    if (!result) return result;
                } while (totalLength > 0L);
            }
            return result;
        }
        finally {
            partitionTempObj.setTotalTempCount(partitionTempObj.getTempFileInfoList().size());
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean createSparseTempFile(IProgressMonitor uiMonitor, int partIndex, File file, boolean result, PartitionTempObj partitionTempObj, long ddrUsableSize, IFastbootProgressMonitor monitor) throws FileNotFoundException, IOException {
        inFile = null;
        outFile = null;
        tmpFile = null;
        tempTimes = 0;
        try {
            inFile = new BufferedRandomAccessFile(file, "r");
            tmpFile = this.createTempFile(partIndex, file, tempTimes);
            ++tempTimes;
            readLength = 0L;
            sparseHeaderData = new byte[28];
            inFile.seek(0L);
            readHeadLen = inFile.read(sparseHeaderData);
            if (readHeadLen != sparseHeaderData.length) {
                return false;
            }
            readLength += 28L;
            sparseHeader = new SparseHeader();
            sparseHeader.fromBytes(sparseHeaderData);
            partNeedSize = 0L;
            partBlk = 0;
            partSize = 0;
            partChunkNum = 0;
            offset = 0L;
            isDelete = FileUtils.deleteFile(tmpFile);
            if (!isDelete) {
                monitor.println(NLS.bind((String)Messages.FileDeleteFailed, (Object)tmpFile));
            }
            outFile = new BufferedRandomAccessFile(tmpFile, "rw");
            outFile.seek(0L);
            outFile.write(SparseHeader.getEmpty());
            needNewFile = false;
            i = 0;
            while (i < sparseHeader.total_chunks) {
                if (this.stopFlag) {
                    this.clearTempFile();
                    return false;
                }
                if (needNewFile) {
                    tmpFile = this.createTempFile(partIndex, file, tempTimes);
                    ++tempTimes;
                    needNewFile = false;
                    outFile = new BufferedRandomAccessFile(tmpFile, "rw");
                    outFile.seek(0L);
                    outFile.write(SparseHeader.getEmpty());
                }
                inFile.seek(readLength);
                chunkHeaderData = new byte[12];
                read = inFile.read(chunkHeaderData);
                if (read < 0) {
                    System.out.println("Read Error");
                }
                readLength += 12L;
                chunkHeader = new SparseChunkHeader();
                chunkHeader.fromBytes(chunkHeaderData);
                chunkLen = 0;
                if (chunkHeader.chunk_type == -13631) {
                    chunkLen = chunkHeader.chunk_sz * sparseHeader.blk_sz;
                    if ((long)chunkLen > ddrUsableSize) {
                        splitChunkDdrUsabelSize = (int)this.getTempFileSize(ddrUsableSize);
                        splitChunkCount = (chunkLen + splitChunkDdrUsabelSize - 1) / splitChunkDdrUsabelSize;
                        splitChunkSpace = chunkLen % splitChunkDdrUsabelSize;
                        if (splitChunkCount == 0) {
                            partBlk += chunkHeader.chunk_sz;
                            partSize += 12 + chunkLen;
                            partNeedSize += (long)chunkLen;
                            ++partChunkNum;
                            outFile.write(chunkHeaderData);
                            readLength = this.handleChunkData(inFile, outFile, readLength, chunkLen);
                        } else {
                            splitChunkIndex = 0;
                            while (splitChunkIndex < splitChunkCount) {
                                if (needNewFile) {
                                    tmpFile = this.createTempFile(partIndex, file, tempTimes);
                                    ++tempTimes;
                                    needNewFile = false;
                                    outFile = new BufferedRandomAccessFile(tmpFile, "rw");
                                    outFile.seek(0L);
                                    outFile.write(SparseHeader.getEmpty());
                                }
                                inFile.seek(readLength);
                                splteChunkLen = splitChunkIndex == splitChunkCount - 1 ? (splitChunkSpace == 0 ? splitChunkDdrUsabelSize : splitChunkSpace) : splitChunkDdrUsabelSize;
                                splitChunkHeader = new SparseChunkHeader();
                                splitChunkHeader.chunk_type = (short)-13631;
                                splitChunkHeader.reserved1 = chunkHeader.reserved1;
                                splitChunkHeader.chunk_sz = splteChunkLen / sparseHeader.blk_sz;
                                splitChunkHeader.total_sz = splteChunkLen + 12;
                                splitChunkHeaderData = splitChunkHeader.toBytes();
                                outFile.write(splitChunkHeaderData);
                                readLength = this.handleChunkData(inFile, outFile, readLength, splteChunkLen);
                                partBlk += splitChunkHeader.chunk_sz;
                                partSize += 12 + splteChunkLen;
                                partNeedSize += (long)splteChunkLen;
                                needNewFile = true;
                                partHeader = new SparseHeader();
                                partHeader.magic = sparseHeader.magic;
                                partHeader.major_version = sparseHeader.major_version;
                                partHeader.minor_version = sparseHeader.minor_version;
                                partHeader.file_hdr_sz = (short)28;
                                partHeader.chunk_hdr_sz = (short)12;
                                partHeader.blk_sz = sparseHeader.blk_sz;
                                partHeader.total_blks = partBlk;
                                partHeader.total_chunks = ++partChunkNum;
                                partHeader.image_checksum = 0;
                                outFile.seek(0L);
                                outFile.write(partHeader.toBytes());
                                outFile.close();
                                zipTempFile = GZipUtils.compress(uiMonitor, tmpFile, false, this.tftpOccupied);
                                if (zipTempFile == null) {
                                    return false;
                                }
                                tempFileInfo = new TempFileInfo();
                                tempFileInfo.setZipTempFile(zipTempFile);
                                tempFileInfo.setTempFileBurnNeedSize(partNeedSize);
                                tempFileInfo.setStartAddressOffset(offset);
                                tempFileInfo.setBurnState(false);
                                partitionTempObj.getTempFileInfoList().add(tempFileInfo);
                                if (!this.partitionTempObjList.contains(partitionTempObj)) {
                                    this.partitionTempObjList.add(partitionTempObj);
                                }
                                offset += partNeedSize;
                                partNeedSize = 0L;
                                partBlk = 0;
                                partSize = 0;
                                partChunkNum = 0;
                                FileUtils.deleteFile(tmpFile);
                                ++splitChunkIndex;
                            }
                        }
                    } else {
                        partBlk += chunkHeader.chunk_sz;
                        partSize += 12 + chunkLen;
                        partNeedSize += (long)chunkLen;
                        ++partChunkNum;
                        outFile.write(chunkHeaderData);
                        readLength = this.handleChunkData(inFile, outFile, readLength, chunkLen);
                    }
                } else if (chunkHeader.chunk_type == -13629) {
                    chunkLen = chunkHeader.chunk_sz * sparseHeader.blk_sz;
                    partBlk += chunkHeader.chunk_sz;
                    partSize += 12;
                    partNeedSize += (long)chunkLen;
                    ++partChunkNum;
                    outFile.write(chunkHeaderData);
                } else {
                    if (chunkHeader.chunk_type != -13630) {
                        System.out.println("sparse: unknow chunk type .\n");
                        inFile.close();
                        outFile.close();
                        isDelete = FileUtils.deleteFile(tmpFile);
                        if (!isDelete) {
                            monitor.println(NLS.bind((String)Messages.FileDeleteFailed, (Object)tmpFile));
                        }
                        result = false;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.ChunkTypeError);
                            }
                        });
                        break;
                    }
                    chunkLen = chunkHeader.chunk_sz * sparseHeader.blk_sz;
                    fill_val = new byte[4];
                    len = inFile.read(fill_val, 0, fill_val.length);
                    if (len < 0) {
                        System.out.println("Read Error.");
                    }
                    partBlk += chunkHeader.chunk_sz;
                    partSize += 12 + chunkLen;
                    partNeedSize += (long)chunkLen;
                    ++partChunkNum;
                    outFile.write(chunkHeaderData);
                    outFile.write(fill_val);
                    readLength += 4L;
                }
                nextChunkHeader = null;
                if (i < sparseHeader.total_chunks - 1) {
                    nextChunkHeaderData = new byte[12];
                    read = inFile.read(nextChunkHeaderData);
                    if (read < 0) {
                        System.out.println("Read Error");
                    }
                    nextChunkHeader = new SparseChunkHeader();
                    nextChunkHeader.fromBytes(nextChunkHeaderData);
                }
                measureValue = 0L;
                if (nextChunkHeader != null) {
                    if (nextChunkHeader.chunk_type == -13631) {
                        measureValue = partSize + 12 + nextChunkHeader.chunk_sz * sparseHeader.blk_sz;
                    } else if (nextChunkHeader.chunk_type == -13629) {
                        measureValue = partSize + 12;
                    } else {
                        if (nextChunkHeader.chunk_type != -13630) {
                            System.out.println("sparse: unknow chunk type .\n");
                            inFile.close();
                            outFile.close();
                            isDelete = FileUtils.deleteFile(tmpFile);
                            if (!isDelete) {
                                monitor.println(NLS.bind((String)Messages.FileDeleteFailed, (Object)tmpFile));
                            }
                            result = false;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.ChunkTypeError);
                                }
                            });
                            break;
                        }
                        measureValue = partSize + 12 + nextChunkHeader.chunk_sz * sparseHeader.blk_sz;
                    }
                }
                v0 = isEnough = measureValue > ddrUsableSize || nextChunkHeader == null;
                if (!isEnough) ** GOTO lbl234
                needNewFile = true;
                partHeader = new SparseHeader();
                partHeader.magic = sparseHeader.magic;
                partHeader.major_version = sparseHeader.major_version;
                partHeader.minor_version = sparseHeader.minor_version;
                partHeader.file_hdr_sz = (short)28;
                partHeader.chunk_hdr_sz = (short)12;
                partHeader.blk_sz = sparseHeader.blk_sz;
                partHeader.total_blks = partBlk;
                partHeader.total_chunks = partChunkNum;
                partHeader.image_checksum = 0;
                outFile.seek(0L);
                outFile.write(partHeader.toBytes());
                outFile.close();
                if (!result) {
                    isDelete = FileUtils.deleteFile(tmpFile);
                    if (!isDelete) {
                        monitor.println(NLS.bind((String)Messages.FileDeleteFailed, (Object)tmpFile));
                    }
                } else {
                    zipTempFile = GZipUtils.compress(uiMonitor, tmpFile, false, this.tftpOccupied);
                    if (zipTempFile == null) {
                        return false;
                    }
                    try {
                        tempFileInfo = new TempFileInfo();
                        tempFileInfo.setZipTempFile(zipTempFile);
                        tempFileInfo.setTempFileBurnNeedSize(partNeedSize);
                        tempFileInfo.setStartAddressOffset(offset);
                        tempFileInfo.setBurnState(false);
                        partitionTempObj.getTempFileInfoList().add(tempFileInfo);
                        if (!this.partitionTempObjList.contains(partitionTempObj)) {
                            this.partitionTempObjList.add(partitionTempObj);
                        }
                        offset += partNeedSize;
                        partNeedSize = 0L;
                        partBlk = 0;
                        partSize = 0;
                        partChunkNum = 0;
                        isDelete = FileUtils.deleteFile(tmpFile);
                        if (!isDelete) {
                            monitor.println(NLS.bind((String)Messages.FileDeleteFailed, (Object)tmpFile));
                        }
lbl234:
                        // 4 sources

                        ++i;
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        monitor.println("runMakeZipThread Compress file Abnormal, error information : " + e.getMessage());
                    }
                }
                break;
            }
        }
        finally {
            partitionTempObj.setTotalTempCount(partitionTempObj.getTempFileInfoList().size());
            if (inFile != null) {
                inFile.close();
            }
            if (outFile != null) {
                outFile.close();
            }
            if (!(isDelete = FileUtils.deleteFile(tmpFile))) {
                monitor.println(NLS.bind((String)Messages.FileDeleteFailed, (Object)tmpFile));
            }
        }
        return result;
    }

    private long handleChunkData(BufferedRandomAccessFile inFile, BufferedRandomAccessFile outFile, long readLength, int chunkLen) throws IOException {
        int chunkDataSpaceCount = (chunkLen + 0x500000 - 1) / 0x500000;
        int chunkDataSpaceSpace = chunkLen % 0x500000;
        byte[] chunkData = new byte[0x500000];
        if (chunkDataSpaceCount == 0) {
            int read = inFile.read(chunkData, 0, chunkLen);
            if (read != chunkLen) {
                return readLength;
            }
            readLength += (long)chunkLen;
            outFile.write(chunkData, 0, chunkLen);
        } else {
            int j = 0;
            while (j < chunkDataSpaceCount) {
                int len = j == chunkDataSpaceCount - 1 ? (chunkDataSpaceSpace == 0 ? 0x500000 : chunkDataSpaceSpace) : 0x500000;
                int read = inFile.read(chunkData, 0, len);
                if (read != len) {
                    return readLength;
                }
                readLength += (long)len;
                outFile.write(chunkData, 0, len);
                ++j;
            }
        }
        return readLength;
    }

    protected File createTempFile(int partIndex, File file, int tempTimes) {
        String hiToolPath = null;
        File tmpFile = this.tftpOccupied ? new File(String.valueOf(file.getAbsolutePath()) + ".tmp" + tempTimes) : ((hiToolPath = HiToolUtils.getInstallPath()).endsWith(File.separator) ? new File(String.valueOf(hiToolPath) + partIndex + file.getName() + ".tmp" + tempTimes) : new File(String.valueOf(hiToolPath) + File.separator + partIndex + file.getName() + ".tmp" + tempTimes));
        return tmpFile;
    }

    public ArrayList<PartitionTempObj> getPartitionTempObjList() {
        return this.partitionTempObjList;
    }

    public void setPartitionTempObjList(ArrayList<PartitionTempObj> partitionTempObjList) {
        this.partitionTempObjList = partitionTempObjList;
    }
}

