/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui;

import java.util.StringTokenizer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MacAddressEditor
extends Composite {
    static final char CHAR_0 = '0';
    static final char CHAR_9 = '9';
    static final String STR_00 = "00";
    static final String STR_0 = "0";
    static final String separator = ":";
    private Color defaultBackground;
    private Text digitalText0;
    private Text digitalText1;
    private Text digitalText2;
    private Text digitalText3;
    private Text digitalText4;
    private Text digitalText5;

    public MacAddressEditor(Composite parent, int style) {
        super(parent, style | 0x800);
        this.createContent(this);
        this.setBackground(this.getColor(1));
        GridLayout layout = new GridLayout();
        layout.numColumns = 13;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        this._setLayout(layout);
        this.setTabList(new Control[]{this.digitalText0, this.digitalText1, this.digitalText2, this.digitalText3, this.digitalText4, this.digitalText5});
    }

    private void _setLayout(GridLayout layout) {
        super.setLayout((Layout)layout);
    }

    public String getDisplayText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.digitalText0.getText()).append(separator).append(this.digitalText1.getText()).append(separator).append(this.digitalText2.getText()).append(separator).append(this.digitalText3.getText()).append(separator).append(this.digitalText4.getText()).append(separator).append(this.digitalText5.getText());
        return sb.toString();
    }

    private void createContent(Composite parent) {
        this.digitalText0 = this.createText(parent, 0);
        this.digitalText0.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.digitalText1 = this.createText(parent, 1);
        this.digitalText1.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.digitalText2 = this.createText(parent, 2);
        this.digitalText2.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.digitalText3 = this.createText(parent, 3);
        this.digitalText3.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.digitalText4 = this.createText(parent, 0);
        this.digitalText4.setLayoutData((Object)this.createLayoutData());
        this.createDotLabel(parent);
        this.digitalText5 = this.createText(parent, 1);
        this.digitalText5.setLayoutData((Object)this.createLayoutData());
    }

    private Label createDotLabel(Composite parent) {
        Label label = new Label(parent, 0);
        if (this.defaultBackground == null) {
            this.defaultBackground = label.getBackground();
        }
        label.setBackground(this.getColor(1));
        label.setText(separator);
        return label;
    }

    private GridData createLayoutData() {
        GridData layoutData = new GridData(768);
        layoutData.minimumWidth = 25;
        return layoutData;
    }

    private Text createText(Composite parent, final int index) {
        final Text text = new Text(parent, 0x1000000);
        text.setData((Object)index);
        text.setTextLimit(2);
        text.addListener(25, (Listener)new VerifyListener());
        text.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                text.selectAll();
            }
        });
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                MacAddressEditor.this.dispatchEvent();
            }
        });
        text.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if ((event.keyCode == 46 || event.keyCode == 16777262) && index < 2) {
                    MacAddressEditor.this.getTabList()[index % 6 + 1].setFocus();
                }
            }
        });
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                System.out.println("e.stateMask " + e.stateMask);
                System.out.println("e.keyCode " + e.keyCode);
                if (e.stateMask == 262144 && (e.keyCode == 67 || e.keyCode == 99)) {
                    System.out.println("Ctrl+C");
                    MacAddressEditor.this.copyKeyPressed();
                }
                if (e.stateMask == 262144 && (e.keyCode == 86 || e.keyCode == 118)) {
                    System.out.println("Ctrl+V");
                    MacAddressEditor.this.pasteKeyPressed();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return text;
    }

    public void pasteKeyPressed() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        TransferData[] transferDatas = clipboard.getAvailableTypes();
        int i = 0;
        while (i < transferDatas.length) {
            if (RTFTransfer.getInstance().isSupportedType(transferDatas[i])) {
                System.out.println("Data is available in RTF format");
                break;
            }
            ++i;
        }
        String plainText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        clipboard.dispose();
        if (plainText == null) {
            return;
        }
        String[] split = plainText.split("\\:");
        int length = split.length;
        if (length != 6) {
            return;
        }
        this.digitalText0.setText(split[0]);
        this.digitalText1.setText(split[1]);
        this.digitalText2.setText(split[2]);
        this.digitalText3.setText(split[3]);
        this.digitalText4.setText(split[4]);
        this.digitalText5.setText(split[5]);
        this.digitalText0.setFocus();
    }

    public void copyKeyPressed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.digitalText0.getText()).append(separator);
        sb.append(this.digitalText1.getText()).append(separator);
        sb.append(this.digitalText2.getText()).append(separator);
        sb.append(this.digitalText3.getText()).append(separator);
        sb.append(this.digitalText4.getText()).append(separator);
        sb.append(this.digitalText5.getText());
        Clipboard clipboard = new Clipboard(Display.getDefault());
        String plainText = sb.toString();
        String rtfText = "{\\rtf1\\b Hello World}";
        TextTransfer textTransfer = TextTransfer.getInstance();
        RTFTransfer rftTransfer = RTFTransfer.getInstance();
        clipboard.setContents((Object[])new String[]{plainText, rtfText}, new Transfer[]{textTransfer, rftTransfer});
        clipboard.dispose();
    }

    private void dispatchEvent() {
        Event event = new Event();
        event.widget = this;
        event.text = this.getDisplayText();
        this.notifyListeners(24, event);
    }

    private Color getColor(int colorID) {
        Display default1 = Display.getDefault();
        if (default1 == null) {
            default1 = new Display();
        }
        return default1.getSystemColor(colorID);
    }

    public void setText(String newMacAddress) {
        if (newMacAddress != null && !"".equals(newMacAddress)) {
            StringTokenizer strToken = new StringTokenizer(newMacAddress, separator);
            String[] strIPAddress = new String[strToken.countTokens()];
            if (strToken.countTokens() != 6) {
                return;
            }
            int k = 0;
            while (strToken.hasMoreTokens()) {
                strIPAddress[k] = strToken.nextToken();
                ++k;
            }
            this.digitalText0.setText(strIPAddress[0]);
            this.digitalText1.setText(strIPAddress[1]);
            this.digitalText2.setText(strIPAddress[2]);
            this.digitalText3.setText(strIPAddress[3]);
            this.digitalText4.setText(strIPAddress[4]);
            this.digitalText5.setText(strIPAddress[5]);
        }
    }

    public static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public void setEnabled(boolean enabled) {
        this.digitalText0.setEnabled(enabled);
        this.digitalText1.setEnabled(enabled);
        this.digitalText2.setEnabled(enabled);
        this.digitalText3.setEnabled(enabled);
        this.digitalText4.setEnabled(enabled);
        this.digitalText5.setEnabled(enabled);
    }

    private static class VerifyListener
    implements Listener {
        private boolean ignore = false;

        private VerifyListener() {
        }

        public void handleEvent(Event e) {
            if (this.ignore) {
                return;
            }
            e.doit = false;
            String insert = e.text;
            char[] newChars = insert.toCharArray();
            int i = Math.min(2, newChars.length - 1);
            while (i >= 0) {
                if (!MacAddressEditor.isHexChar(newChars[i])) {
                    return;
                }
                --i;
            }
            Text widget = (Text)e.widget;
            StringBuilder newText = new StringBuilder(widget.getText());
            if (e.start == e.end) {
                newText.insert(e.start, newChars);
            } else {
                newText.replace(e.start, e.end, insert);
            }
            String value = newText.toString();
            if (value.length() > 2) {
                value = value.substring(0, 2);
            } else if (value.isEmpty()) {
                value = MacAddressEditor.STR_00;
            }
            this.ignore = true;
            widget.selectAll();
            widget.insert(value);
            this.ignore = false;
        }
    }
}

