/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.consoles.FastbootConsoleFactory;
import com.hisilicon.fastboot.model.badcheck.BadBlockComposite;
import com.hisilicon.fastboot.model.badcheck.BadBlockModel;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IChecker;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.burners.BadCheckBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.serial.workers.WorkerUtility;
import com.hisilicon.fastboot.ui.BurnComposite;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class BadCheckComposite
extends BurnComposite {
    private Text informationText;
    private Button checkButton;
    private Button nandScrubButton;
    private BadBlockComposite badBlockComposite;
    BadBlockModel badBlockModel;
    private static long chipSize;
    private String nandScrub = "nandscrub";
    private String checkBad = "checkbad";

    public BadCheckComposite(Composite parent, int style, IBurner burner) {
        super(parent, style, burner);
    }

    @Override
    protected void createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        this.badBlockComposite = new BadBlockComposite(control, 2048);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 30;
        this.badBlockComposite.setLayoutData(layoutData);
        this.badBlockModel = this.badBlockComposite.getBadBlock();
        this.informationText = new Text(control, 2570);
        this.informationText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.informationText.setText(String.valueOf(Messages.BadCheckComposite_BadInfo) + ":\r\n");
        Composite checkComposite = new Composite(control, 0);
        checkComposite.setLayout((Layout)new GridLayout(2, false));
        checkComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.checkButton = new Button(checkComposite, 8);
        GridData buttonGridData = new GridData(0x1000000, 1, true, false, 1, 1);
        buttonGridData.widthHint = 100;
        buttonGridData.heightHint = 30;
        this.checkButton.setLayoutData((Object)buttonGridData);
        this.checkButton.setText(Messages.BadCheckComposite_CheckButton_Text);
        this.checkButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BadCheckComposite.this.disableUI(BadCheckComposite.this.checkBad);
                BadCheckComposite.this.checkBadBlock(BadCheckComposite.this.checkBad);
            }
        });
        this.nandScrubButton = new Button(checkComposite, 8);
        GridData nandScrubGridData = new GridData(0x1000000, 1, true, false, 1, 1);
        nandScrubGridData.widthHint = 100;
        nandScrubGridData.heightHint = 30;
        this.nandScrubButton.setLayoutData((Object)nandScrubGridData);
        this.nandScrubButton.setText(Messages.BadCheckComposite_EraseButton_Text);
        this.nandScrubButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BadCheckComposite.this.disableUI(BadCheckComposite.this.nandScrub);
                BadCheckComposite.this.checkBadBlock(BadCheckComposite.this.nandScrub);
            }
        });
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(2, false);
    }

    protected void checkBadBlock(String buttonName) {
        IFastbootProgressMonitor monitor = this.getProgressMonitor(HiToolUtils.getToolType());
        monitor.begin();
        IChecker checker = (IChecker)this.getBurner();
        if (this.checkStatus(checker.checkBeforeCheck())) {
            monitor.getEvent().setBurner(checker);
            if (buttonName.equals(this.checkBad)) {
                checker.check(monitor);
            } else if (buttonName.equals(this.nandScrub)) {
                checker.eraseBad(monitor);
            }
        } else {
            monitor.finish();
        }
    }

    protected void disableUI(String buttonName) {
        super.disableUI();
        if (buttonName.equals(this.checkBad)) {
            if (this.checkButton != null && !this.checkButton.isDisposed()) {
                this.checkButton.setEnabled(false);
            }
        } else if (buttonName.equals(this.nandScrub) && this.nandScrubButton != null && !this.nandScrubButton.isDisposed()) {
            this.nandScrubButton.setEnabled(false);
        }
    }

    protected void enableUI(String buttonName) {
        super.enableUI();
        if (buttonName.equals(this.checkBad)) {
            if (this.checkButton != null && !this.checkButton.isDisposed()) {
                this.checkButton.setEnabled(true);
            }
        } else if (buttonName.equals(this.nandScrub) && this.nandScrubButton != null && !this.nandScrubButton.isDisposed()) {
            this.nandScrubButton.setEnabled(true);
        }
    }

    @Override
    public void started(FastbootEvent event) {
        if (event.getBurner() instanceof BadCheckBurner) {
            super.started(event);
            if (event.getBurner() == this.getBurner()) {
                this.checkButton.setEnabled(false);
            }
        }
    }

    private String getNandContent(String recieved) {
        StringBuilder sb = new StringBuilder();
        if (recieved != null && recieved.trim().length() != 0) {
            String[] split;
            int indexOf = recieved.indexOf("bad blocks:");
            if (indexOf == -1) {
                return Messages.BadCheckComposite_No_Bad_Blocks_Found;
            }
            String[] stringArray = split = recieved.substring(0, indexOf).split("\n");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.trim().length() != 0 && !string.toLowerCase().contains("in:") && !string.toLowerCase().contains("out:")) {
                    sb.append(string).append("\n");
                }
                ++n2;
            }
            int indexOf2 = recieved.indexOf("[EOT]");
            if (indexOf2 == -1) {
                indexOf2 = recieved.length();
            }
            sb.append(recieved.substring(indexOf, indexOf2));
            return sb.toString();
        }
        return Messages.BadCheckComposite_Nothing_to_display;
    }

    @Override
    public void finished(FastbootEvent event) {
        if (event.getBurner() instanceof BadCheckBurner) {
            String message;
            this.enableUI(this.checkBad);
            this.enableUI(this.nandScrub);
            if (event.getBurner() == this.getBurner()) {
                this.checkButton.setEnabled(true);
                this.nandScrubButton.setEnabled(true);
            }
            if (event.getType() == EventType.CHECK && (message = event.getMessage()) != null && message.trim().length() != 0) {
                this.updateDataModel(message);
            }
        }
    }

    private void updateDataModel(String message) {
        if (this.informationText.isDisposed()) {
            return;
        }
        this.informationText.setText(this.getNandContent(message));
        chipSize = WorkerUtility.ReceiveHelper.getNandChipSize(message);
        if (chipSize == -1L) {
            try {
                FastbootConsoleFactory.getDefaultConsole().getWarningStream().write("Failed to get Chip size\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        long blockSize = WorkerUtility.ReceiveHelper.getNandBlockSize(message);
        if (blockSize == -1L) {
            try {
                FastbootConsoleFactory.getDefaultConsole().getWarningStream().write("Failed to get Block size\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        long[] badblocks = this.getBadBlocks(message);
        this.badBlockModel.setBadAddress(badblocks);
        this.badBlockModel.setChip(chipSize);
        this.badBlockModel.setBlock((int)blockSize);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BadCheckComposite.this.badBlockComposite.isDisposed()) {
                    return;
                }
                BadCheckComposite.this.badBlockComposite.redraw();
            }
        });
        String transfered = BadCheckComposite.getTransfered(badblocks, blockSize);
        this.informationText.append(transfered);
    }

    public long getChipSize() {
        return chipSize;
    }

    private static String getTransfered(long[] badblocks, long blockSize) {
        StringBuilder sb = new StringBuilder("\r\nTransfered:\r\n");
        long[] lArray = badblocks;
        int n = badblocks.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            String hexString = Integer.toHexString((int)l);
            int i = 0;
            while (i < 8 - hexString.length()) {
                sb.append("0");
                ++i;
            }
            sb.append(String.valueOf(hexString) + ":\tindex=" + (l / (long)((int)blockSize) + 1L) + "\r\n");
            ++n2;
        }
        return sb.toString();
    }

    private long[] getBadBlocks(String message) {
        String[] split;
        int indexOf = message.indexOf("bad blocks:");
        if (indexOf == -1) {
            return new long[0];
        }
        int indexOf2 = message.indexOf("[EOT]");
        if (indexOf2 == -1) {
            indexOf2 = message.length();
        }
        String substring = message.substring("bad blocks:".length() + indexOf, indexOf2);
        ArrayList<Long> result = new ArrayList<Long>();
        String[] stringArray = split = substring.split("\r\n");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.trim().length() != 0) {
                try {
                    long parseLong = Long.parseLong(string.trim(), 16);
                    result.add(parseLong);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        long[] relong = new long[result.size()];
        int i = 0;
        while (i < relong.length) {
            relong[i] = (Long)result.get(i);
            ++i;
        }
        return relong;
    }
}

