/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.AlgorithmType;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.ICheckSumBurner;
import com.hisilicon.fastboot.ui.burners.PartitionComposite;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CheckSumComposite
extends PartitionComposite {
    private Button browseButton;
    private Button CheckSumButton;
    private Combo algorithmTypeCombo;
    private Text checkSumResultText;
    private static String[] algorithmTypeItems = new String[]{"CRC-16", "Cumulative Sum"};

    public CheckSumComposite(Composite parent, int style, IBurner emmcBurn) {
        super(parent, style, emmcBurn);
    }

    @Override
    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.creareAlgorithmTypeComposite(parent);
        this.createCheckSumFileComposite(parent);
        this.createResultComposite(parent);
        this.createCheckSumComposite(parent);
    }

    private void createResultComposite(Composite parent) {
        Composite resultComposite = new Composite(parent, 0);
        resultComposite.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(1808);
        resultComposite.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 5;
        Label label = new Label(resultComposite, 0);
        label.setText(Messages.CheckSumComposite_CheckSumResult);
        gridData = new GridData(1, 1, false, false);
        gridData.horizontalIndent = 20;
        label.setLayoutData((Object)gridData);
        this.checkSumResultText = new Text(resultComposite, 2056);
        GridData tableFileTextGD = new GridData(1, 1, false, false);
        tableFileTextGD.horizontalSpan = 1;
        tableFileTextGD.horizontalIndent = 20;
        tableFileTextGD.widthHint = 80;
        this.checkSumResultText.setLayoutData((Object)tableFileTextGD);
        this.checkSumResultText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                CheckSumComposite.this.handleEnterOnTableFileText();
            }
        });
    }

    private void createCheckSumFileComposite(Composite parent) {
        Composite checkSumFileComposite = new Composite(parent, 0);
        checkSumFileComposite.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(1808);
        checkSumFileComposite.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 3;
        Label CheckSumFileLabel = new Label(checkSumFileComposite, 0);
        CheckSumFileLabel.setText(Messages.CheckSumComposite_CheckSumFile);
        gridData = new GridData(1, 1, false, false);
        gridData.horizontalIndent = 20;
        CheckSumFileLabel.setLayoutData((Object)gridData);
        this.tableFileText = new Text(checkSumFileComposite, 2048);
        GridData tableFileTextGD = new GridData(4, 1, true, false);
        tableFileTextGD.horizontalSpan = 2;
        tableFileTextGD.horizontalIndent = 20;
        this.tableFileText.setLayoutData((Object)tableFileTextGD);
        this.tableFileText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                CheckSumComposite.this.handleEnterOnTableFileText();
            }
        });
        this.browseButton = new Button(checkSumFileComposite, 0);
        gridData = new GridData();
        HiToolUtils.setWidthForOS(gridData, 60, 70);
        this.browseButton.setLayoutData((Object)gridData);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String filePath;
                FileDialog dialog = new FileDialog(CheckSumComposite.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.bin", "*.*"});
                String text = CheckSumComposite.this.tableFileText.getText();
                if (!text.equals("")) {
                    dialog.setFileName(text);
                }
                if ((filePath = dialog.open()) != null) {
                    CheckSumComposite.this.tableFileText.setText(filePath);
                }
                CheckSumComposite.this.promptToSave(false);
            }
        });
    }

    private void createCheckSumComposite(Composite parent) {
        Composite CheckSumComposite2 = new Composite(parent, 0);
        CheckSumComposite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 6;
        CheckSumComposite2.setLayoutData((Object)gridData);
        this.CheckSumButton = new Button(CheckSumComposite2, 0);
        GridData buttonLayoutData = new GridData(576);
        buttonLayoutData.widthHint = 120;
        this.CheckSumButton.setLayoutData((Object)buttonLayoutData);
        this.CheckSumButton.setText(Messages.FastbootView_TabCheckSum);
        this.CheckSumButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckSumComposite.this.CheckSum();
            }
        });
    }

    private void creareAlgorithmTypeComposite(Composite parent) {
        Composite typeComposite = new Composite(parent, 0);
        typeComposite.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(4, 1, false, false);
        gridData.horizontalSpan = 5;
        typeComposite.setLayoutData((Object)gridData);
        Label algorithmTypeLabel = new Label(typeComposite, 0);
        GridData layoutData = new GridData(1, 1, false, false);
        layoutData.horizontalIndent = 20;
        algorithmTypeLabel.setLayoutData((Object)layoutData);
        algorithmTypeLabel.setText(Messages.CheckSumComposite_AlgorithmType);
        this.algorithmTypeCombo = new Combo(typeComposite, 8);
        this.algorithmTypeCombo.setItems(algorithmTypeItems);
        this.algorithmTypeCombo.setLayoutData((Object)layoutData);
        this.algorithmTypeCombo.select(0);
    }

    private void CheckSum() {
        String path;
        File file;
        ICheckSumBurner burner = (ICheckSumBurner)((Object)this.getBurner());
        IFastbootProgressMonitor monitor = this.getProgressMonitor(ToolType.Composite);
        AlgorithmType algorithmType = AlgorithmType.CUMULATIVE_SUM;
        if (this.algorithmTypeCombo.getText().equals(algorithmTypeItems[0])) {
            algorithmType = AlgorithmType.CRC_16;
        }
        if ((file = new File(path = this.tableFileText.getText())).exists()) {
            long length = file.length();
            if (length % 4L > 0L) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CheckSumComposite_CheckSumResult, (String)Messages.CheckSumComposite_CheckSumFile_Length_ERROR);
                this.checkSumResultText.setText("");
                return;
            }
            burner.checkSum(monitor, file, this.checkSumResultText, algorithmType);
        }
    }
}

