/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IMergeBurner;
import com.hisilicon.fastboot.model.devices.burners.MergeBurner;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.ui.burners.PartitionComposite;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.File;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MergeComposite
extends PartitionComposite {
    private Button browseButton;
    private Button makeMergeButton;

    public MergeComposite(Composite parent, int style, IBurner emmcBurn) {
        super(parent, style, emmcBurn);
    }

    @Override
    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite com = new Composite(parent, 0);
        com.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(1808);
        com.setLayoutData((Object)gridData);
        this.useXMLPathAsParentButton = new Button(com, 32);
        GridData layoutData = new GridData(1, 1, false, false);
        this.useXMLPathAsParentButton.setLayoutData((Object)layoutData);
        this.useXMLPathAsParentButton.setText(Messages.PartitionComposite_LABEL_Default_Use_XML_Path);
        this.useXMLPathAsParentButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String text = MergeComposite.this.tableFileText.getText().trim();
                File file = new File(text);
                if (file.exists()) {
                    MergeComposite.this.loadPartitionFile(file, MergeComposite.this.useXMLPathAsParentButton.getSelection());
                }
            }
        });
        this.useXMLPathAsParentButton.setSelection(true);
        Label label = new Label(com, 0);
        label.setText(Messages.MergeComposite_LABEL_PartitionFile);
        layoutData = new GridData(1, 1, false, false);
        layoutData.horizontalIndent = 20;
        label.setLayoutData((Object)layoutData);
        this.tableFileText = new Text(com, 2048);
        GridData tableFileTextGD = new GridData(4, 1, true, false);
        tableFileTextGD.horizontalIndent = 5;
        tableFileTextGD.horizontalSpan = 2;
        this.tableFileText.setLayoutData((Object)tableFileTextGD);
        this.tableFileText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                MergeComposite.this.handleEnterOnTableFileText();
            }
        });
        this.browseButton = new Button(com, 0);
        layoutData = new GridData();
        HiToolUtils.setWidthForOS(layoutData, 60, 70);
        this.browseButton.setLayoutData((Object)layoutData);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MergeComposite.this.handleBrowseFile();
            }
        });
        this.saveButton = new Button(com, 0);
        this.saveButton.setLayoutData((Object)layoutData);
        this.saveButton.setText(LABEL_SAVE);
        this.saveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MergeComposite.this.savePartitionTable();
            }
        });
        if (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((UnknownDevice)this.getBurner().getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            Button alignButton = new Button(com, 32);
            layoutData = new GridData(1, 1, false, false);
            alignButton.setLayoutData((Object)layoutData);
            alignButton.setText(Messages.PartitionComposite_LABEL_Default_Use_XML_Path);
            alignButton.setVisible(false);
        }
        this.createButtons(com);
        Control tableControl = this.createItemTable(com);
        this.itemViewer = (CheckboxTableViewer)tableControl.getData();
        this.itemViewer.setInput((Object)this.getBurner());
        GridData layoutData2 = new GridData(4, 4, true, true, 6, 1);
        tableControl.setLayoutData((Object)layoutData2);
        this.initData();
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 6;
        buttonComp.setLayoutData((Object)gd);
        this.makeMergeButton = new Button(buttonComp, 0);
        GridData buttonLayoutData = new GridData(576);
        buttonLayoutData.widthHint = 120;
        this.makeMergeButton.setLayoutData((Object)buttonLayoutData);
        this.makeMergeButton.setText(Messages.MergeComposite_MergeImage_Button);
        this.makeMergeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MergeComposite.this.makeMergeButton.setEnabled(false);
                MergeComposite.this.updateSelection();
                MergeComposite.this.mergeImage();
            }
        });
        buttonComp.setLayout((Layout)new GridLayout(1, true));
    }

    private void mergeImage() {
        IMergeBurner burner = (IMergeBurner)((Object)this.getBurner());
        if (this.checkStatus(burner.checkBeforeBurn())) {
            IFastbootProgressMonitor monitor = this.getProgressMonitor(ToolType.Composite);
            monitor.getEvent().setBurner(this.getBurner());
            List<PartitionItem> children = this.getBurner().getPratitionInfo().getChildren();
            int size = children.size();
            int i = 0;
            while (i < size) {
                PartitionItem partition = children.get(i);
                if (i == size - 1 && partition.isChecked() && !((MergeBurner)this.getBurner()).getBurnerWorker().checkLastPartition(children)) {
                    this.enableUI();
                    return;
                }
                ++i;
            }
            burner.mergeImage(monitor);
        } else {
            this.enableUI();
        }
    }

    @Override
    protected void disableUI() {
        if (this.makeMergeButton != null && !this.makeMergeButton.isDisposed()) {
            this.makeMergeButton.setEnabled(false);
        }
    }

    @Override
    protected void enableUI() {
        if (this.makeMergeButton != null && !this.makeMergeButton.isDisposed()) {
            this.makeMergeButton.setEnabled(true);
        }
    }
}

