/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui;

import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.externaltools.ToolsLoader;
import com.soyatec.hisilicon.platform.core.externaltools.model.ExternalTool;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.PlatformUIActivator;
import com.soyatec.hisilicon.platform.ui.internal.BundleUtils;
import com.soyatec.hisilicon.platform.ui.internal.IniUtils;
import com.soyatec.hisilicon.platform.ui.internal.PerspectiveUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class WelcomeView
extends ViewPart
implements IDeviceChangedListener {
    private static final String TOOL_PROPERTIES = "TOOL.PROPERTIES";
    private static final String TOOL_PROPERTIES_KEY_EN = "DESCRIPTION_EN";
    private static final String TOOL_PROPERTIES_KEY_CN = "DESCRIPTION_CN";
    private static final String TOOL_PROPERTIES_KEY_EN_V620 = "DESCRIPTION_EN_V620";
    private static final String TOOL_PROPERTIES_KEY_CN_V620 = "DESCRIPTION_CN_V620";
    private static WelcomeView INSTANCE = null;
    public static final String ID = "com.soyatec.hisilicon.platform.ui.view.welcome";
    private Composite subPanel;
    private Map<String, Control> map = new HashMap<String, Control>();
    private Map<String, Image> toolImageMap = new HashMap<String, Image>();
    private Map<ExternalTool, Control> externalToolsMap = new HashMap<ExternalTool, Control>();
    private Map<ExternalTool, Image> externalToolImageMap = new HashMap<ExternalTool, Image>();
    private String nl;
    private Cursor wait = new Cursor(null, 1);
    public static final Map<String, Integer> READED_BUNDLES = new HashMap<String, Integer>();

    public WelcomeView() {
        DeviceManager.getInstance().addDeviceChangedListener((IDeviceChangedListener)this);
        this.nl = IniUtils.getIniConfiguration("osgi.nl");
        if (this.nl.length() == 0) {
            this.nl = Locale.getDefault().toString();
            if (!this.nl.equals(Locale.US.toString()) && !this.nl.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
                if (this.nl.startsWith("en_")) {
                    this.nl = Locale.US.toString();
                } else if (this.nl.startsWith("zh_")) {
                    this.nl = Locale.SIMPLIFIED_CHINESE.toString();
                }
            }
        }
        WelcomeView.registerView(this);
    }

    public static WelcomeView getInstance() {
        return INSTANCE;
    }

    public static void registerView(WelcomeView view) {
        INSTANCE = view;
    }

    public static void unregisterView() {
        INSTANCE = null;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite panel = new ScrolledComposite(parent, 768);
        this.subPanel = new Composite((Composite)panel, 0);
        panel.setContent((Control)this.subPanel);
        this.subPanel.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginWidth = 60;
        this.subPanel.setLayout((Layout)gridLayout);
        panel.setExpandHorizontal(true);
        panel.setExpandVertical(true);
        panel.setMinWidth(800);
        panel.setMinHeight(600);
        this.subPanel.setBackgroundImage(PlatformUIActivator.getImageDescriptor("icons/welcome.bmp").createImage());
        this.subPanel.setBackgroundMode(1);
        Label topspace = new Label(this.subPanel, 0);
        topspace.setVisible(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 200;
        topspace.setLayoutData((Object)gd);
        try {
            this.initButton();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initButton() {
        this.refreshPerspectiveButton(READED_BUNDLES);
        this.refreshExternalTools();
    }

    public synchronized void refreshExternalTools() {
        try {
            String chipName;
            String currentDevice = DeviceManager.getInstance().getCurrentDevice();
            currentDevice = "," + currentDevice + ",";
            Set<ExternalTool> keySet = this.externalToolsMap.keySet();
            if (!keySet.isEmpty()) {
                Iterator<ExternalTool> keys = keySet.iterator();
                ArrayList<ExternalTool> removes = new ArrayList<ExternalTool>();
                while (keys != null && keys.hasNext()) {
                    ExternalTool tool = keys.next();
                    chipName = "," + tool.getChipName() + ",";
                    if (chipName.contains(currentDevice)) continue;
                    removes.add(tool);
                }
                if (removes != null && !removes.isEmpty()) {
                    Iterator iterator = removes.iterator();
                    while (iterator != null && iterator.hasNext()) {
                        ExternalTool tool = (ExternalTool)iterator.next();
                        Control remove = this.externalToolsMap.remove(tool);
                        if (remove == null || remove.isDisposed()) continue;
                        remove.dispose();
                    }
                }
            }
            List tools = ToolsLoader.instance.getExternalTools();
            for (ExternalTool tool : tools) {
                ToolModel toolModel;
                if (this.externalToolsMap.get(tool) != null || !(chipName = "," + tool.getChipName() + ",").contains(currentDevice) || (toolModel = this.computeToolModel(tool)) == null) continue;
                this.externalToolsMap.put(tool, this.createImageLink(toolModel));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.subPanel.layout(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void refreshPerspectiveButton(final Map<String, Integer> needUpdatePerspectiveIDS) {
        if (needUpdatePerspectiveIDS != null && needUpdatePerspectiveIDS.size() > 0) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PerspectiveRegistry reg = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
                    Set entrySet = needUpdatePerspectiveIDS.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator != null && iterator.hasNext()) {
                        Map.Entry next = iterator.next();
                        String id = (String)next.getKey();
                        try {
                            PerspectiveDescriptor perspective = (PerspectiveDescriptor)reg.findPerspectiveWithId(id);
                            if (perspective != null && WelcomeView.this.isSuitForTool(perspective)) {
                                if (WelcomeView.this.map.get(id) != null) continue;
                                Bundle bundle = Platform.getBundle((String)perspective.getPluginId());
                                ToolModel toolModel = WelcomeView.this.computeToolModel(bundle);
                                toolModel.setToolPerspective(id);
                                WelcomeView.this.map.put(id, WelcomeView.this.createImageLink(toolModel));
                                continue;
                            }
                            Control remove = (Control)WelcomeView.this.map.remove(id);
                            if (remove == null || remove.isDisposed()) continue;
                            remove.dispose();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    WelcomeView.this.subPanel.layout(true);
                }
            });
        }
    }

    private Control createImageLink(ToolModel toolModel) {
        return new ImageLink(this.subPanel, 0, toolModel);
    }

    private File findFile(Bundle bundle, String path) {
        URL entry = bundle.getEntry(path);
        try {
            URL fileURL = FileLocator.toFileURL((URL)entry);
            return new File(fileURL.getFile());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ToolDescriptor findToolByPerspectivePluginID(String pluginID) {
        IToolManager toolManager = PlatformCoreActivator.getDefault().getToolManager();
        List installTools = toolManager.collectFeatureToolsAndPlatform(toolManager.getInstalledToolAndPlatformIUs());
        if (installTools != null && installTools.size() > 0) {
            int i = 0;
            while (i < installTools.size()) {
                ToolDescriptor toolDescriptor = (ToolDescriptor)installTools.get(i);
                String[] pluginIds = toolDescriptor.getPluginIds();
                List<String> list = Arrays.asList(pluginIds);
                if (list.contains(pluginID)) {
                    return toolDescriptor;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean isSuitForTool(PerspectiveDescriptor perspective) {
        ToolDescriptor tool = this.findToolByPerspectivePluginID(perspective.getPluginId());
        if (tool == null) {
            return false;
        }
        IDeviceManager dm = DeviceManager.getInstance();
        return BundleUtils.suitableForChip(tool, dm.getCurrentDevice());
    }

    public void setFocus() {
    }

    public ToolModel computeToolModel(Bundle bundle) {
        ToolDescriptor tool;
        String desc;
        Image image;
        ToolModel toolModel;
        block50: {
            block48: {
                toolModel = new ToolModel();
                image = null;
                if (this.toolImageMap.get(bundle.getSymbolicName()) == null) {
                    File imageFile = this.findFile(bundle, "TOOL.PNG");
                    if (imageFile != null && imageFile.exists()) {
                        FileInputStream input = null;
                        try {
                            try {
                                input = new FileInputStream(imageFile);
                                image = new Image((Device)this.getViewSite().getShell().getDisplay(), (InputStream)input);
                                this.toolImageMap.put(bundle.getSymbolicName(), image);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block48;
                            }
                        }
                        catch (Throwable throwable) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    image = this.toolImageMap.get(bundle.getSymbolicName());
                }
            }
            if (image == null) {
                image = PlatformUIActivator.getToolDefaultImage();
            }
            desc = "";
            File propertiesFile = this.findFile(bundle, TOOL_PROPERTIES);
            if (propertiesFile != null && propertiesFile.exists()) {
                FileInputStream input = null;
                try {
                    try {
                        input = new FileInputStream(propertiesFile);
                        Properties prop = new Properties();
                        prop.load(input);
                        if (this.nl.equals(Locale.US.toString())) {
                            if (this.isV620()) {
                                if (prop.getProperty(TOOL_PROPERTIES_KEY_EN_V620) != null) {
                                    desc = prop.getProperty(TOOL_PROPERTIES_KEY_EN_V620);
                                } else if (prop.getProperty(TOOL_PROPERTIES_KEY_CN) != null) {
                                    desc = prop.getProperty(TOOL_PROPERTIES_KEY_CN);
                                }
                            } else if (prop.getProperty(TOOL_PROPERTIES_KEY_EN) != null) {
                                desc = prop.getProperty(TOOL_PROPERTIES_KEY_EN);
                            }
                        } else if (this.nl.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
                            if (this.isV620()) {
                                if (prop.getProperty(TOOL_PROPERTIES_KEY_CN_V620) != null) {
                                    desc = prop.getProperty(TOOL_PROPERTIES_KEY_CN_V620);
                                } else if (prop.getProperty(TOOL_PROPERTIES_KEY_CN) != null) {
                                    desc = prop.getProperty(TOOL_PROPERTIES_KEY_CN);
                                }
                            } else if (prop.getProperty(TOOL_PROPERTIES_KEY_CN) != null) {
                                desc = prop.getProperty(TOOL_PROPERTIES_KEY_CN);
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block50;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((tool = this.findToolByPerspectivePluginID(bundle.getSymbolicName())) != null) {
            toolModel.setImage(image);
            toolModel.setToolName(tool.getName());
            toolModel.setDescription(desc);
        }
        return toolModel;
    }

    private boolean isV620() {
        String currentDevice = DeviceManager.getInstance().getCurrentDevice();
        return currentDevice.equalsIgnoreCase("Hi3751V551") || currentDevice.equalsIgnoreCase("Hi3751V553") || currentDevice.equalsIgnoreCase("Hi3751V620");
    }

    public ToolModel computeToolModel(ExternalTool tool) {
        Image image;
        String doc;
        String toolName;
        String desc;
        block23: {
            desc = "";
            toolName = "";
            doc = "";
            try {
                if (this.nl.equals(Locale.US.toString())) {
                    desc = tool.getDescEN();
                    toolName = tool.getNameENAttr();
                    doc = tool.getDocEN();
                } else if (this.nl.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
                    desc = tool.getDescCN();
                    toolName = tool.getNameCNAttr();
                    doc = tool.getDocCN();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            image = null;
            if (this.externalToolImageMap.get(tool) == null) {
                File imageFile = ToolsLoader.instance.findsubfilesInExternalFolder(tool.getIconPath());
                if (imageFile != null && imageFile.exists()) {
                    FileInputStream input = null;
                    try {
                        try {
                            input = new FileInputStream(imageFile);
                            image = new Image((Device)this.getViewSite().getShell().getDisplay(), (InputStream)input);
                            this.externalToolImageMap.put(tool, image);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                image = this.externalToolImageMap.get(tool);
            }
        }
        if (image == null) {
            image = PlatformUIActivator.getToolDefaultImage();
        }
        ToolModel toolModel = new ToolModel();
        toolModel.setExternalTool(true);
        toolModel.setImage(image);
        toolModel.setToolName(toolName);
        toolModel.setDescription(desc);
        File exeFile = ToolsLoader.instance.findsubfilesInExternalFolder(tool.getExePath());
        toolModel.setExeFile(exeFile);
        File helpdoc = ToolsLoader.instance.findsubfilesInExternalFolder(doc);
        toolModel.setDoc(helpdoc);
        return toolModel;
    }

    public void dispose() {
        WelcomeView.unregisterView();
        DeviceManager.getInstance().removeDeviceChangedListener((IDeviceChangedListener)this);
        super.dispose();
    }

    public void deviceChanged(Chip chip) {
        this.refreshPerspectiveButton(READED_BUNDLES);
        this.refreshExternalTools();
    }

    class ImageLink
    extends Composite {
        private ToolModel toolModel;

        public ImageLink(Composite parent, int style, ToolModel toolModel) {
            super(parent, style);
            this.toolModel = toolModel;
            this.setLayout((Layout)new GridLayout(3, false));
            this.setLayoutData(new GridData(768));
            this.createControl_();
        }

        private void createControl_() {
            ImageHyperlink imageLabel = new ImageHyperlink((Composite)this, 0);
            imageLabel.setHoverImage(this.toolModel.getImage());
            imageLabel.setImage(this.toolModel.getImage());
            GridData gd = new GridData();
            gd.verticalSpan = 2;
            imageLabel.setLayoutData((Object)gd);
            Hyperlink lnkColumn1 = new Hyperlink((Composite)this, 0);
            lnkColumn1.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
            lnkColumn1.setForeground(new Color((Device)Display.getDefault(), 0, 65, 107));
            lnkColumn1.setFont(PlatformUIActivator.getToolFont());
            lnkColumn1.setUnderlined(true);
            lnkColumn1.setText(this.toolModel.getToolName());
            if (this.toolModel.isExternalTool()) {
                final File doc = this.toolModel.getDoc();
                if (doc != null && doc.exists() && doc.isFile()) {
                    ImageHyperlink docLabel = new ImageHyperlink((Composite)this, 0);
                    docLabel.setCursor(Display.getDefault().getSystemCursor(4));
                    docLabel.setImage(PlatformUIActivator.getImageDescriptor("icons/linkto_help.gif").createImage());
                    docLabel.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            try {
                                Program.launch((String)doc.getAbsolutePath());
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                }
            } else {
                new Label((Composite)this, 0);
            }
            Label desc = new Label((Composite)this, 0);
            desc.setLayoutData((Object)new GridData(1, 1024, true, false, 2, 1));
            desc.setText(this.toolModel.getDescription());
            desc.setToolTipText(this.toolModel.getDescription());
            MouseAdapter adapter = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    block10: {
                        Cursor oldCursor = null;
                        Control c = null;
                        try {
                            try {
                                c = (Control)e.widget;
                                oldCursor = c.getCursor();
                                c.setCursor(WelcomeView.this.wait);
                                if (ImageLink.this.toolModel.isExternalTool()) {
                                    final File exeFile = ImageLink.this.toolModel.getExeFile();
                                    if (exeFile.exists()) {
                                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(ImageLink.this.getShell());
                                        dialog.run(true, false, new IRunnableWithProgress(){

                                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                                try {
                                                    try {
                                                        monitor.beginTask(String.valueOf(Messages.WelcomeView_4) + ImageLink.this.toolModel.getToolName(), -1);
                                                        Runtime.getRuntime().exec(exeFile.getAbsolutePath());
                                                    }
                                                    catch (Exception e) {
                                                        Display.getDefault().syncExec(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                MessageDialog.openError((Shell)WelcomeView.this.subPanel.getShell(), (String)Messages.WelcomeView_0, (String)(String.valueOf(Messages.WelcomeView_1) + e.getMessage()));
                                                            }
                                                        });
                                                        monitor.done();
                                                    }
                                                }
                                                finally {
                                                    monitor.done();
                                                }
                                            }
                                        });
                                    } else {
                                        MessageDialog.openWarning((Shell)ImageLink.this.getShell(), (String)Messages.WelcomeView_2, (String)(String.valueOf(Messages.WelcomeView_3) + exeFile.getAbsolutePath()));
                                    }
                                    break block10;
                                }
                                PerspectiveUtil.openPerspectiveOnTheRight(ImageLink.this.toolModel.getToolPerspective());
                            }
                            catch (Exception e1) {
                                MessageDialog.openError((Shell)WelcomeView.this.subPanel.getShell(), (String)Messages.WelcomeView_0, (String)(String.valueOf(Messages.WelcomeView_1) + e1.getMessage()));
                                if (oldCursor != null && c != null) {
                                    c.setCursor(oldCursor);
                                }
                            }
                        }
                        finally {
                            if (oldCursor != null && c != null) {
                                c.setCursor(oldCursor);
                            }
                        }
                    }
                }
            };
            imageLabel.addMouseListener((MouseListener)adapter);
            lnkColumn1.addMouseListener((MouseListener)adapter);
        }
    }

    static class ToolModel {
        private Image image;
        private String toolName;
        private String description;
        private String toolPerspective;
        private boolean isExternalTool = false;
        private File doc;
        private File exeFile;

        ToolModel() {
        }

        public Image getImage() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public String getToolName() {
            return this.toolName;
        }

        public void setToolName(String toolName) {
            this.toolName = toolName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getToolPerspective() {
            return this.toolPerspective;
        }

        public void setToolPerspective(String toolPerspective) {
            this.toolPerspective = toolPerspective;
        }

        public boolean isExternalTool() {
            return this.isExternalTool;
        }

        public void setExternalTool(boolean isExternalTool) {
            this.isExternalTool = isExternalTool;
        }

        public File getDoc() {
            return this.doc;
        }

        public void setDoc(File doc) {
            this.doc = doc;
        }

        public void setExeFile(File exeFile) {
            this.exeFile = exeFile;
        }

        public File getExeFile() {
            return this.exeFile;
        }
    }
}

