/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.WorkbenchEncoding;

public class OptionManager {
    File file;
    HashMap<String, HashMap<String, String>> optionList;

    public OptionManager(File file) {
        this.file = file;
        this.optionList = new HashMap();
    }

    public String getOption(String groupName, String key) {
        HashMap<String, String> group = this.optionList.get(groupName);
        if (group == null) {
            return null;
        }
        String value = group.get(key);
        return value;
    }

    public void setOption(String groupName, String key, String value) {
        HashMap<Object, Object> group = null;
        if (this.optionList.containsKey(groupName)) {
            group = this.optionList.get(groupName);
        } else {
            group = new HashMap();
            this.optionList.put(groupName, group);
        }
        group.put(key, value);
    }

    public synchronized void readFile() {
        block22: {
            HashMap<String, String> curGroup = null;
            FileInputStream stream = null;
            BufferedReader reader = null;
            try {
                try {
                    stream = new FileInputStream(this.file);
                    reader = new BufferedReader(new InputStreamReader((InputStream)stream, WorkbenchEncoding.getWorkbenchDefaultEncoding()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim().replace("\t", "")).startsWith("[") && line.endsWith("]")) {
                            String groupName = line.substring(1, line.length() - 1);
                            curGroup = new HashMap<String, String>();
                            this.optionList.put(groupName, curGroup);
                        }
                        if (!line.contains("=") || curGroup == null) continue;
                        int sepIndex = line.indexOf("=");
                        String key = line.substring(0, sepIndex);
                        String value = line.substring(sepIndex + 1);
                        curGroup.put(key, value);
                    }
                }
                catch (IOException iOException) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (stream == null) break block22;
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public synchronized boolean writeFile() {
        BufferedWriter writer = null;
        FileOutputStream stream = null;
        try {
            if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs()) {
                return false;
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return false;
            }
            try {
                stream = new FileOutputStream(this.file);
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, WorkbenchEncoding.getWorkbenchDefaultEncoding()));
                for (Map.Entry<String, HashMap<String, String>> entryGroup : this.optionList.entrySet()) {
                    writer.write("[" + entryGroup.getKey() + "]\r\n");
                    for (Map.Entry<String, String> entryItem : entryGroup.getValue().entrySet()) {
                        writer.write(String.valueOf(entryItem.getKey()) + "=" + entryItem.getValue() + "\r\n");
                    }
                    writer.write("\r\n");
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

