/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.eclipse.ui.WorkbenchEncoding;

public class RC4 {
    private byte[] state = new byte[256];
    private int x;
    private int y;
    private static final Random rand = new Random();

    public RC4(String key) throws NullPointerException, UnsupportedEncodingException {
        this(key.getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
    }

    public RC4(byte[] key) throws NullPointerException {
        int i = 0;
        while (i < 256) {
            this.state[i] = (byte)i;
            ++i;
        }
        this.x = 0;
        this.y = 0;
        int index1 = 0;
        int index2 = 0;
        if (key == null || key.length == 0) {
            throw new NullPointerException();
        }
        int i2 = 0;
        while (i2 < 256) {
            index2 = (key[index1] & 0xFF) + (this.state[i2] & 0xFF) + index2 & 0xFF;
            byte tmp = this.state[i2];
            this.state[i2] = this.state[index2];
            this.state[index2] = tmp;
            index1 = (index1 + 1) % key.length;
            ++i2;
        }
    }

    public byte[] rc4(String data) {
        byte[] tmp;
        if (data == null) {
            return null;
        }
        try {
            tmp = data.getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        tmp = this.rc4(tmp);
        return tmp;
    }

    public byte[] rc4(byte[] buf) {
        if (buf == null) {
            return null;
        }
        byte[] result = new byte[buf.length];
        int i = 0;
        while (i < buf.length) {
            this.x = this.x + 1 & 0xFF;
            this.y = (this.state[this.x] & 0xFF) + this.y & 0xFF;
            byte tmp = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = tmp;
            int xorIndex = (this.state[this.x] & 0xFF) + (this.state[this.y] & 0xFF) & 0xFF;
            result[i] = (byte)(buf[i] ^ this.state[xorIndex]);
            ++i;
        }
        return result;
    }
}

