/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.internal;

import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.internal.BundleUtils;
import com.soyatec.hisilicon.platform.ui.internal.PerspectiveUtil;
import com.soyatec.hisilicon.platform.ui.internal.PlatformStateControlUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ToolMenuBuilder
implements IMenuListener,
IDeviceChangedListener {
    private String subMenuManagerID;
    private IMenuManager menuManager;

    public ToolMenuBuilder(String subMenuManagerID) {
        this.subMenuManagerID = subMenuManagerID;
        DeviceManager.getInstance().addDeviceChangedListener((IDeviceChangedListener)this);
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.menuManager = manager;
        MenuManager allToolsMenu = (MenuManager)manager.find(this.subMenuManagerID);
        allToolsMenu.removeAll();
        IDeviceManager dm = DeviceManager.getInstance();
        String currentDevice = dm.getCurrentDevice();
        Map<String, IExtension> reg = PerspectiveUtil.loadPerspectiveRegistry();
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        List installIUs = m.getInstalledToolIUs();
        List installTools = m.collectFeatureTools(installIUs);
        for (ToolDescriptor t : installTools) {
            List<String> ids;
            if (!BundleUtils.isToolEnabled(t) || !BundleUtils.suitableForChip(t, currentDevice) || (ids = PerspectiveUtil.finPerspectiveDeclareIds(t, reg)).size() == 0) continue;
            final String id = ids.get(0);
            Action action = new Action(t.getName()){

                public void run() {
                    try {
                        PerspectiveUtil.openPerspectiveOnTheRight(id);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ToolMenuBuilder_0, (String)(String.valueOf(Messages.ToolMenuBuilder_1) + id));
                    }
                }
            };
            action.setEnabled(PlatformStateControlUtils.isPlatformEnabled());
            allToolsMenu.add((IAction)action);
        }
    }

    public void deviceChanged(Chip chip) {
        if (this.menuManager != null) {
            this.menuAboutToShow(this.menuManager);
        }
    }
}

