/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.ui.tool;

import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import com.soyatec.hisilicon.platform.core.ToolDescriptor;
import com.soyatec.hisilicon.platform.ui.Messages;
import com.soyatec.hisilicon.platform.ui.internal.ControlFactory;
import com.soyatec.hisilicon.platform.ui.internal.FileUtils;
import com.soyatec.hisilicon.platform.ui.internal.P2Utils;
import com.soyatec.hisilicon.platform.ui.internal.PatchUtils;
import com.soyatec.hisilicon.platform.ui.internal.ToolUpdateUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ApplyPlatformPatchDialog
extends Dialog {
    private static final int LABEL_WIDTH = 100;
    private Text upgradeNameField;
    private Text upgradeVersionField;
    private Text upgradeProviderField;
    private Text upgradeReleaseDateField;
    private Text upgradeZipFile;
    private Button upgradeButton;
    private ToolDescriptor upgradeTool;
    private IToolManager toolManager;
    private final boolean[] updating = new boolean[1];
    private String installZip;
    private IInstallableUnit platformUpdatableUnit;

    public ApplyPlatformPatchDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.toolManager = PlatformCoreActivator.getDefault().getToolManager();
        try {
            this.platformUpdatableUnit = this.toolManager.findInstallIU("com.soyatec.hisilicon.platform.update.feature.feature.group", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Apply_Platform_Patch);
        newShell.setSize(600, 300);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData(4, 0x1000000, true, false);
        parent.setLayoutData((Object)data);
        this.upgradeButton = this.createButton(parent, 0, Messages.ApplyPlatformPatch, true);
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        GridData upgradeGD = (GridData)this.upgradeButton.getLayoutData();
        upgradeGD.horizontalAlignment = 0x1000000;
        upgradeGD.grabExcessHorizontalSpace = true;
        GridData cancelGD = (GridData)cancelButton.getLayoutData();
        cancelGD.horizontalAlignment = 0x1000000;
        cancelGD.grabExcessHorizontalSpace = true;
        this.upgradeButton.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.createUpgradInfoGroup(comp);
        return comp;
    }

    private void createUpgradInfoGroup(Composite comp) {
        Group group = ControlFactory.createGroup(comp, Messages.ApplyPlatformPatchDialog_0, 4);
        Composite c = ControlFactory.createComposite((Composite)group, 3, 0, 768, 4);
        GridLayout layout = (GridLayout)c.getLayout();
        layout.marginWidth = 0;
        this.upgradeZipFile = ControlFactory.createFileFieldWithWidth(c, Messages.ApplyPlatformPatchDialog_1, Messages.UpgradeToolDialog_25, 100, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ApplyPlatformPatchDialog.this.refreshUpgradeInfo(ApplyPlatformPatchDialog.this.upgradeZipFile.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.upgradeZipFile.setEditable(false);
        this.upgradeNameField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.ApplyPlatformPatchDialog_2, 2048, 100, null);
        this.upgradeVersionField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_27, 2048, 100, null);
        this.upgradeProviderField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_28, 2048, 100, null);
        this.upgradeReleaseDateField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_29, 2048, 100, null);
        ControlFactory.setEditable(false, this.upgradeNameField, this.upgradeVersionField, this.upgradeProviderField, this.upgradeReleaseDateField);
    }

    protected void refreshUpgradeInfo(String zipFile) {
        block16: {
            try {
                if (zipFile.length() == 0) {
                    return;
                }
                IPath path = PlatformCoreActivator.getDefault().getStateLocation().append("temp");
                File upFile = new File(path.toOSString());
                if (!upFile.exists() && !upFile.mkdirs()) {
                    return;
                }
                this.installZip = path.append(new File(zipFile).getName()).toOSString();
                File target = new File(this.installZip);
                if (target.exists() && !target.delete()) {
                    return;
                }
                try {
                    FileUtils.copyFile(zipFile, target);
                    IInstallableUnit unit = this.toolManager.findPlatformUpdatableUnit(this.installZip, (IProgressMonitor)new NullProgressMonitor());
                    if (unit == null) {
                        this.installZip = null;
                        this.upgradeTool = null;
                        this.clearInputText();
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.UpgradeToolDialog_14, (String)Messages.ApplyPlatformPatchDialog_3);
                        break block16;
                    }
                    boolean versionOK = true;
                    try {
                        Version oldVersion;
                        Version newVersion;
                        if (this.platformUpdatableUnit != null && (newVersion = unit.getVersion()).compareTo((Object)(oldVersion = this.platformUpdatableUnit.getVersion())) == 0) {
                            versionOK = false;
                            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ApplyPlatformPatchDialog_4, (String)Messages.ApplyPlatformPatchDialog_5);
                        }
                    }
                    catch (Exception newVersion) {
                        // empty catch block
                    }
                    if (versionOK) {
                        this.upgradeTool = new ToolDescriptor(unit);
                        ToolDescriptor.ToolProperties props = this.upgradeTool.props;
                        this.upgradeNameField.setText(this.trim(props.getName()));
                        this.upgradeVersionField.setText(this.trim(props.getVersion()));
                        this.upgradeProviderField.setText(this.trim(props.getProvider()));
                        this.upgradeReleaseDateField.setText(this.trim(props.getReleaseDate()));
                        break block16;
                    }
                    this.installZip = null;
                    this.upgradeTool = null;
                }
                catch (Exception e) {
                    this.installZip = null;
                    this.upgradeTool = null;
                    this.clearInputText();
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.UpgradeToolDialog_16, (String)Messages.ApplyPlatformPatchDialog_6);
                }
            }
            finally {
                this.refreshUpgradeButton();
            }
        }
    }

    private void clearInputText() {
        try {
            this.upgradeNameField.setText("");
            this.upgradeVersionField.setText("");
            this.upgradeProviderField.setText("");
            this.upgradeReleaseDateField.setText("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean doUpgrade() {
        if (!this.updating[0]) {
            this.updating[0] = true;
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            try {
                pmd.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask(Messages.ApplyPlatformPatchDialog_7, -1);
                                final IStatus status = P2Utils.checkForUpdates(ApplyPlatformPatchDialog.this.toolManager.getAgent(), ApplyPlatformPatchDialog.this.toolManager.getSite(ApplyPlatformPatchDialog.this.installZip), (IProgressMonitor)new NullProgressMonitor());
                                ApplyPlatformPatchDialog.this.setReturnCode(0);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ApplyPlatformPatchDialog.this.close();
                                        if (status != null) {
                                            if (status.getCode() == 10000) {
                                                MessageDialog.openWarning((Shell)ApplyPlatformPatchDialog.this.getShell(), (String)Messages.UpgradeToolDialog_16, (String)Messages.ApplyPlatformPatchDialog_8);
                                            } else if (status.getSeverity() != 8) {
                                                if (status.getSeverity() == 4) {
                                                    MessageDialog.openError((Shell)ApplyPlatformPatchDialog.this.getShell(), (String)Messages.UpgradeToolDialog_16, (String)(String.valueOf(Messages.ApplyPlatformPatchDialog_9) + status.getMessage()));
                                                } else {
                                                    PatchUtils.setPlatformPatchedFlag(true);
                                                    ToolUpdateUtils.requestRestart(3);
                                                }
                                            }
                                        } else {
                                            MessageDialog.openError((Shell)ApplyPlatformPatchDialog.this.getShell(), (String)Messages.UpgradeToolDialog_16, (String)Messages.ApplyPlatformPatchDialog_10);
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)ApplyPlatformPatchDialog.this.getShell(), (String)Messages.UpgradeToolDialog_16, (String)e.getMessage());
                                ((ApplyPlatformPatchDialog)ApplyPlatformPatchDialog.this).updating[0] = false;
                            }
                        }
                        finally {
                            ((ApplyPlatformPatchDialog)ApplyPlatformPatchDialog.this).updating[0] = false;
                        }
                    }
                });
            }
            catch (Exception e) {
                this.updating[0] = false;
            }
        }
        return true;
    }

    private void refreshUpgradeButton() {
        boolean state = false;
        if (this.upgradeTool != null && this.upgradeButton != null) {
            state = true;
        }
        if (this.upgradeButton != null) {
            this.upgradeButton.setEnabled(state);
        }
    }

    protected void okPressed() {
        this.doUpgrade();
    }

    public String trim(String str) {
        return str == null ? "N/A" : str.trim();
    }
}

