/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.terminal.actions;

import com.hisilicon.terminal.view.ITerminalViewConnection;
import com.hisilicon.terminal.view.ITerminalViewConnectionManager;
import org.eclipse.jface.action.Action;

public class ShowTerminalConnectionAction
extends Action {
    private final ITerminalViewConnection fConnection;
    private final ITerminalViewConnectionManager fConnectionManager;

    public ShowTerminalConnectionAction(ITerminalViewConnectionManager manager, ITerminalViewConnection connection) {
        super(ShowTerminalConnectionAction.quoteName(ShowTerminalConnectionAction.buildName(manager, connection)), 8);
        this.fConnection = connection;
        this.fConnectionManager = manager;
        this.setImageDescriptor(connection.getImageDescriptor());
    }

    private static String quoteName(String name) {
        return String.valueOf(name) + "\t";
    }

    private static String buildName(ITerminalViewConnectionManager m, ITerminalViewConnection connection) {
        String name = connection.getFullSummary();
        if (!ShowTerminalConnectionAction.checkIfAllPartNamesTheSame(m)) {
            name = String.valueOf(connection.getPartName()) + " - " + name;
        }
        return name;
    }

    private static boolean checkIfAllPartNamesTheSame(ITerminalViewConnectionManager m) {
        ITerminalViewConnection[] connections = m.getConnections();
        if (connections.length > 1) {
            String partName = connections[0].getPartName();
            int i = 1;
            while (i < connections.length) {
                if (!partName.equals(connections[i].getPartName())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void run() {
        this.fConnectionManager.setActiveConnection(this.fConnection);
    }
}

