/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.terminal.actions;

import com.hisilicon.terminal.actions.TerminalAction;
import com.hisilicon.terminal.control.HisiVT100TerminalControl;
import com.hisilicon.terminal.view.ITerminalView;
import com.hisilicon.terminal.view.TerminalViewPlugin;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionClearAll;

public class TerminalControlLogAction
extends TerminalAction {
    private static final String START_LOGGING = "Start logging";
    private static final String STOP_LOGGING = "Stop logging";
    private ITerminalViewControl currentViewControl;
    private Map<ITerminalViewControl, Boolean> map = new HashMap<ITerminalViewControl, Boolean>();

    public TerminalControlLogAction(ITerminalView tv, ITerminalViewControl initViewControl) {
        super(tv, TerminalActionClearAll.class.getName(), 1);
        this.currentViewControl = initViewControl;
        this.map.put(this.currentViewControl, false);
        this.setupAction(START_LOGGING, START_LOGGING, "ImageDlclStart", "ImageDlclStart", "ImageDlclStart", true, TerminalViewPlugin.getDefault().getImageRegistry());
    }

    @Override
    public void run() {
        if (this.currentViewControl != null && this.currentViewControl instanceof HisiVT100TerminalControl) {
            boolean bHas = this.map.get(this.currentViewControl);
            if (!bHas) {
                HisiVT100TerminalControl control = (HisiVT100TerminalControl)this.currentViewControl;
                FileDialog fd = new FileDialog(this.currentViewControl.getControl().getShell(), 8192);
                fd.setFilterExtensions(new String[]{"*.txt", "*.*"});
                String path = fd.open();
                if (path != null) {
                    this.setActionChecked(true);
                    this.fTarget.onTerminalStartLogging(new File(path));
                } else {
                    this.setActionChecked(false);
                }
            } else {
                this.setActionChecked(false);
                this.fTarget.onTerminalStopLogging();
            }
        }
    }

    public void setActionChecked(boolean checked) {
        this.map.put(this.currentViewControl, checked);
        if (checked) {
            this.setupAction(STOP_LOGGING, STOP_LOGGING, "ImageDlclStop", "ImageDlclStop", "ImageDlclStop", true, TerminalViewPlugin.getDefault().getImageRegistry());
        } else {
            this.setupAction(START_LOGGING, START_LOGGING, "ImageDlclStart", "ImageDlclStart", "ImageDlclStart", true, TerminalViewPlugin.getDefault().getImageRegistry());
        }
    }

    public void updateTerminalConnect(ITerminalViewControl fCtlTerminal) {
        if (this.currentViewControl != fCtlTerminal) {
            this.currentViewControl = fCtlTerminal;
            if (this.map.get(fCtlTerminal) == null) {
                this.setActionChecked(false);
            } else {
                boolean logging = this.map.get(fCtlTerminal);
                if (logging) {
                    this.setActionChecked(true);
                } else {
                    this.setActionChecked(false);
                }
            }
        }
    }
}

