/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.terminal.view;

import com.hisilicon.terminal.view.ITerminalViewConnection;
import com.hisilicon.terminal.view.ITerminalViewConnectionManager;
import com.hisilicon.terminal.view.SettingStorePrefixDecorator;
import com.hisilicon.terminal.view.TerminalViewPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class TerminalViewConnectionManager
implements ITerminalViewConnectionManager {
    private static final String STORE_CONNECTION_PREFIX = "connection";
    private static final String STORE_SIZE = "size";
    private static final String STORE_ACTIVE_CONNECTION = "active";
    private final List fConnections = new ArrayList();
    private ITerminalViewConnection fActiveConnection;
    private final List fConnectionHistory = new ArrayList();
    private final List fListeners = new ArrayList();

    @Override
    public ITerminalViewConnection[] getConnections() {
        return this.fConnections.toArray(new ITerminalViewConnection[this.fConnections.size()]);
    }

    @Override
    public int size() {
        return this.fConnections.size();
    }

    @Override
    public ITerminalViewConnection getActiveConnection() {
        return this.fActiveConnection;
    }

    @Override
    public void setActiveConnection(ITerminalViewConnection conn) {
        this.fActiveConnection = conn;
        this.fConnectionHistory.remove(conn);
        this.fConnectionHistory.add(0, conn);
        this.fireListeners();
    }

    @Override
    public void swapConnection() {
        ITerminalViewConnection conn = this.getPreviousConnection();
        if (conn != null) {
            this.setActiveConnection(conn);
        }
    }

    private ITerminalViewConnection getPreviousConnection() {
        for (ITerminalViewConnection conn : this.fConnectionHistory) {
            if (conn == this.fActiveConnection) continue;
            return conn;
        }
        return null;
    }

    @Override
    public void addConnection(ITerminalViewConnection conn) {
        this.fConnections.add(conn);
        this.fireListeners();
    }

    public void removeConnection(ITerminalViewConnection conn) {
        this.fConnections.remove(conn);
        this.fConnectionHistory.remove(conn);
        this.fireListeners();
    }

    @Override
    public void addListener(ITerminalViewConnectionManager.ITerminalViewConnectionListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void removeListener(ITerminalViewConnectionManager.ITerminalViewConnectionListener listener) {
        this.fListeners.remove(listener);
    }

    protected void fireListeners() {
        ITerminalViewConnectionManager.ITerminalViewConnectionListener[] listeners = this.fListeners.toArray(new ITerminalViewConnectionManager.ITerminalViewConnectionListener[this.fListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].connectionsChanged();
            ++i;
        }
    }

    @Override
    public void saveState(ISettingsStore store) {
        store.put(STORE_SIZE, "" + this.fConnections.size());
        int n = 0;
        for (ITerminalViewConnection connection : this.fConnections) {
            String prefix = STORE_CONNECTION_PREFIX + n;
            ++n;
            if (connection.equals(this.fActiveConnection)) {
                store.put(STORE_ACTIVE_CONNECTION, prefix);
            }
            connection.saveState(new SettingStorePrefixDecorator(store, prefix));
        }
    }

    @Override
    public void loadState(ISettingsStore store, ITerminalViewConnectionManager.ITerminalViewConnectionFactory factory) {
        int size = 0;
        try {
            size = Integer.parseInt(store.get(STORE_SIZE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (size > 0) {
            String active = store.get(STORE_ACTIVE_CONNECTION);
            int n = 0;
            int i = 0;
            while (i < size) {
                String prefix = STORE_CONNECTION_PREFIX + n;
                ++n;
                try {
                    ITerminalViewConnection connection = factory.create();
                    this.fConnections.add(connection);
                    this.fConnectionHistory.add(connection);
                    if (prefix.equals(active)) {
                        this.fActiveConnection = connection;
                    }
                    connection.loadState(new SettingStorePrefixDecorator(store, prefix));
                }
                catch (RuntimeException e) {
                    TerminalViewPlugin.getDefault().getLog().log((IStatus)new Status(2, TerminalViewPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getLocalizedMessage(), (Throwable)e));
                }
                ++i;
            }
        }
    }

    @Override
    public void removeActive() {
        if (this.fConnections.size() > 1) {
            this.fActiveConnection.getCtlTerminal().disconnectTerminal();
            this.fConnections.remove(this.fActiveConnection);
            this.fConnectionHistory.remove(this.fActiveConnection);
            this.fActiveConnection = this.getPreviousConnection();
            if (this.fActiveConnection == null) {
                this.fActiveConnection = (ITerminalViewConnection)this.fConnections.get(0);
            }
            this.fireListeners();
        }
    }
}

