/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import com.hisilicon.hiloader.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DialogUtil {
    private DialogUtil() {
    }

    public static void openError(Shell parent, String title, String message, PartInitException exception) {
        CoreException nestedException = null;
        IStatus status = exception.getStatus();
        if (status != null && status.getException() instanceof CoreException) {
            nestedException = (CoreException)status.getException();
        }
        if (nestedException != null) {
            ErrorDialog.openError((Shell)parent, (String)title, (String)message, (IStatus)nestedException.getStatus());
        } else {
            MessageDialog.openError((Shell)parent, (String)title, (String)message);
        }
    }

    public static void displayError(final String errorMsg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.HiLoaderComposite_10, (String)errorMsg);
            }
        });
    }

    public static void displayWarning(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.HiLoaderComposite_15, (String)msg);
            }
        });
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveShell() {
        Display display = DialogUtil.getCurrentDisplay();
        Shell activeShell = display.getActiveShell();
        if (activeShell == null) {
            return DialogUtil.getActiveWorkbenchWindow().getShell();
        }
        return activeShell;
    }

    public static Display getCurrentDisplay() {
        Display display = Display.getCurrent();
        if (display != null) {
            return display;
        }
        return Display.getDefault();
    }
}

