/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import com.hisilicon.hiloader.ImageFactory;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public class FileCellEditor
extends DialogCellEditor {
    public FileCellEditor(Composite parent) {
        super(parent);
    }

    public FileCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 1024);
        result.setImage(ImageFactory.getImage("/icons/selfile.ico"));
        result.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 8 || e.keyCode == 127 || e.keyCode == 16777262) {
                    FileCellEditor.this.setValue(null);
                    FileCellEditor.this.fireApplyEditorValue();
                }
            }
        });
        return result;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        FileDialog dialog = new FileDialog(cellEditorWindow.getShell());
        String path = dialog.open();
        if (path != null) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    protected void updateContents(Object value) {
        if (value != null) {
            String text = value.toString();
            this.getDefaultLabel().setToolTipText(text);
            this.getDefaultLabel().setText(text);
            this.getDefaultLabel().update();
        }
    }
}

