/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util.ssu;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.Builder;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.struct.CableMode;
import com.hisilicon.hiloader.struct.DbFrontEnd;
import com.hisilicon.hiloader.struct.FlashType;
import com.hisilicon.hiloader.struct.HeadTsPacket;
import com.hisilicon.hiloader.struct.PartFile;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.struct.UpgradeInfo;
import com.hisilicon.hiloader.struct.ssu.CompatibilityDescriptor;
import com.hisilicon.hiloader.struct.ssu.DDBSections;
import com.hisilicon.hiloader.struct.ssu.DSMCCMessageHeader;
import com.hisilicon.hiloader.struct.ssu.DSMCCSectionHead;
import com.hisilicon.hiloader.struct.ssu.DSMCC_SectionInfo;
import com.hisilicon.hiloader.struct.ssu.GroupInfoIndication;
import com.hisilicon.hiloader.struct.ssu.ModuleDescription;
import com.hisilicon.hiloader.struct.ssu.SsuUpgradeInfo;
import com.hisilicon.hiloader.struct.ssu.SubCompatibilityDescriptor;
import com.hisilicon.hiloader.util.Crc32;
import com.hisilicon.hiloader.util.FileHelper;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.HiLoaderException;
import com.hisilicon.hiloader.util.RandomFileOutputStream;
import com.hisilicon.hiloader.util.StringUtil;
import com.hisilicon.hiloader.util.ssu.SsuPackageOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.WorkbenchEncoding;

public class SsuTsPackageBuilder
implements Builder {
    public static final String UPGRADE_FILE_NAME = "packer.ts";
    private static final int SIZE_OF_U16 = 2;
    public static final int HI_MAGICNUM_SIZE = 4;
    private static long g_u32DataTotalLen = 0L;
    private static int g_u32DataCrc = 0;
    private static int g_u32GroupId;
    private static long g_softwareVersion;
    private static long g_FactoryIdFlag;
    private static long g_HardwareVersion;
    private static long g_start_sn;
    private static long g_end_sn;
    private static long g_download_date;
    private int count = 0;
    private int countNIT = 0;
    private int countBAT = 0;
    private static DbFrontEnd g_struFrontend;
    private static List<PartFile> g_struPartFile;
    private static short g_ulPartNum;
    private double symbolRate;
    private int validSymbolRate;
    private int transferMode;
    private int sectionNumber;
    private byte[] tempByte = new byte[6144];
    private static boolean is32Bit;
    private static boolean hi3798CV200;
    static byte[] tempSectionData;
    static SubCompatibilityDescriptor subCompatibilityDescriptor;

    static {
        g_softwareVersion = 0x1010101L;
        g_FactoryIdFlag = 3L;
        g_HardwareVersion = 1L;
        g_start_sn = 0L;
        g_end_sn = -1L;
        g_download_date = 537460993L;
        tempSectionData = new byte[4066];
        subCompatibilityDescriptor = new SubCompatibilityDescriptor();
    }

    public static int getG_u32GroupId() {
        return g_u32GroupId;
    }

    public static void setG_u32GroupId(int g_u32GroupId) {
        SsuTsPackageBuilder.g_u32GroupId = g_u32GroupId;
    }

    public static long getG_softwareVersion() {
        return g_softwareVersion;
    }

    public static void setG_softwareVersion(long g_softwareVersion) {
        SsuTsPackageBuilder.g_softwareVersion = g_softwareVersion;
    }

    public static long getG_FactoryIdFlag() {
        return g_FactoryIdFlag;
    }

    public static void setG_FactoryIdFlag(long g_FactoryIdFlag) {
        SsuTsPackageBuilder.g_FactoryIdFlag = g_FactoryIdFlag;
    }

    public static long getG_HardwareVersion() {
        return g_HardwareVersion;
    }

    public static void setG_HardwareVersion(long g_HardwareVersion) {
        SsuTsPackageBuilder.g_HardwareVersion = g_HardwareVersion;
    }

    public static long getG_start_sn() {
        return g_start_sn;
    }

    public static void setG_start_sn(long g_start_sn) {
        SsuTsPackageBuilder.g_start_sn = g_start_sn;
    }

    public static long getG_end_sn() {
        return g_end_sn;
    }

    public static void setG_end_sn(long g_end_sn) {
        SsuTsPackageBuilder.g_end_sn = g_end_sn;
    }

    public static DbFrontEnd getG_struFrontend() {
        return g_struFrontend;
    }

    public static void setG_struFrontend(DbFrontEnd g_struFrontend) {
        SsuTsPackageBuilder.g_struFrontend = g_struFrontend;
    }

    public static List<PartFile> getG_struPartFile() {
        return g_struPartFile;
    }

    public static void setG_struPartFile(List<PartFile> g_struPartFile) {
        SsuTsPackageBuilder.g_struPartFile = g_struPartFile;
    }

    public static short getG_ulPartNum() {
        return g_ulPartNum;
    }

    public static void setG_ulPartNum(int g_ulPartNum) {
        SsuTsPackageBuilder.g_ulPartNum = (short)g_ulPartNum;
    }

    public static boolean isIs32Bit() {
        return is32Bit;
    }

    public static void setIs32Bit(boolean is32Bit) {
        SsuTsPackageBuilder.is32Bit = is32Bit;
    }

    public static boolean isHi3798CV200() {
        return hi3798CV200;
    }

    public static void setHi3798CV200(boolean hi3798cv200) {
        hi3798CV200 = hi3798cv200;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus createPackageOptions(List<UpgradeFileInfo> list, SsuUpgradeInfo info, SsuPackageOptions packageOtions, String strFilePathName, IProgressMonitor monitor) throws IOException, HiLoaderException {
        boolean oneBATNAT = true;
        monitor.setTaskName("Validate upgrade file list..");
        boolean success = FileHelper.validateUpdateFilesList(list, 0xF000000L);
        if (!success) {
            return Status.CANCEL_STATUS;
        }
        monitor.setTaskName("Analysis of the part file");
        List<UpgradeFileInfo> realInfoList = FileHelper.getRealBurnFileList(list, 0xF000000L);
        if (64 < realInfoList.size()) {
            throw new HiLoaderException(String.format(Messages.HiLoaderComposite_MaxPartFile, 64));
        }
        monitor.beginTask("Packaged part files", 100 * realInfoList.size() + 20 + 20);
        SsuTsPackageBuilder.setG_softwareVersion(info.getSoftwareVersion());
        SsuTsPackageBuilder.setG_FactoryIdFlag(info.getManufacturerId());
        SsuTsPackageBuilder.setG_HardwareVersion(info.getHardwareVersion());
        SsuTsPackageBuilder.setG_start_sn(info.getStartSn());
        SsuTsPackageBuilder.setG_end_sn(info.getEndSn());
        SsuTsPackageBuilder.setG_struFrontend(new DbFrontEnd());
        SsuTsPackageBuilder.getG_struFrontend().u32Frequency.set(674000L);
        SsuTsPackageBuilder.getG_struFrontend().u32SymbolRate.set(6875000L);
        SsuTsPackageBuilder.getG_struFrontend().enModulation.set((Enum)CableMode.valueOf(2));
        SsuTsPackageBuilder.getG_struFrontend().u16TsPID.set((long)info.getDownloadPid());
        SsuTsPackageBuilder.getG_struFrontend().u16GroupID.set(info.getDownloadGroupId());
        SsuTsPackageBuilder.setG_u32GroupId((short)SsuTsPackageBuilder.getG_struFrontend().u16GroupID.get());
        monitor.worked(5);
        byte[] tsBuf = new byte[184];
        int lenDatagram = 0;
        int lenPartInfo = 0;
        int lenDownloadCtrl = 0;
        int pTempOffset = 0;
        HeadTsPacket strHeadTsPak = new HeadTsPacket();
        DSMCC_SectionInfo stDSISection = new DSMCC_SectionInfo();
        DSMCC_SectionInfo stDIISection = new DSMCC_SectionInfo();
        DSMCC_SectionInfo stNULLSection = new DSMCC_SectionInfo();
        SsuTsPackageBuilder.construct_NULLSection(stNULLSection);
        DSMCC_SectionInfo stNITSection = new DSMCC_SectionInfo();
        DSMCC_SectionInfo stBATSection = new DSMCC_SectionInfo();
        int dataGramIndex = 0;
        strHeadTsPak.synByte.set(71L);
        strHeadTsPak.transportErrorIndicator.set(0L);
        strHeadTsPak.payloadUnitStartIndicator.set(1L);
        strHeadTsPak.transportPriority.set(0L);
        strHeadTsPak.transportScramblingControl.set(0L);
        strHeadTsPak.adaptationFieldControl.set(1L);
        Arrays.fill(tsBuf, (byte)-1);
        RandomFileOutputStream fp = SsuTsPackageBuilder.newOutputStream(strFilePathName);
        if (fp == null) {
            return Status.CANCEL_STATUS;
        }
        byte[] nit = null;
        int nitLength = 0;
        byte[] bat = null;
        int batLength = 0;
        try {
            monitor.worked(5);
            monitor.setTaskName("Compute all of part file crc");
            SsuTsPackageBuilder.setG_struPartFile(SsuTsPackageBuilder.fillFileDataStruct(realInfoList));
            SsuTsPackageBuilder.setG_ulPartNum(SsuTsPackageBuilder.getG_struPartFile().size());
            monitor.setTaskName("Package Part file..");
            monitor.worked(10);
            int partIndex = 0;
            while (partIndex < SsuTsPackageBuilder.getG_ulPartNum()) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                PartFile partFile = SsuTsPackageBuilder.getG_struPartFile().get(partIndex);
                long[] values = new long[]{partFile.getSectionNum(), partFile.getLastDiagramDataLength(), partFile.datagramNum.get()};
                strHeadTsPak.pid.set(SsuTsPackageBuilder.getG_struFrontend().u16TsPID.get());
                monitor.worked(20);
                long u16DataGramNum = values[0];
                SubProgressMonitor subProgressMonitor = null;
                try {
                    subProgressMonitor = new SubProgressMonitor(monitor, 80, 4);
                    subProgressMonitor.beginTask("", (int)u16DataGramNum);
                    subProgressMonitor.setTaskName("Package all information to ts file...");
                    dataGramIndex = 0;
                    while ((long)dataGramIndex < u16DataGramNum) {
                        byte[] pTmp;
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (dataGramIndex % 100 == 0) {
                            SsuTsPackageBuilder.construct_DSISection(stDSISection);
                            pTmp = stDSISection.pSectionBuff;
                            pTempOffset = 0;
                            lenDownloadCtrl = stDSISection.buffLength.get();
                            int i = 0;
                            while (i < 2) {
                                this.count = SsuTsPackageBuilder.fillTsPackage(fp, strHeadTsPak, pTmp, pTempOffset, lenDownloadCtrl, this.count, tsBuf);
                                ++i;
                            }
                            SsuTsPackageBuilder.construct_DIISection(stDIISection);
                            pTmp = stDIISection.pSectionBuff;
                            lenPartInfo = stDIISection.buffLength.get();
                            i = 0;
                            while (i < 2) {
                                this.count = SsuTsPackageBuilder.fillTsPackage(fp, strHeadTsPak, pTmp, pTempOffset, lenPartInfo, this.count, tsBuf);
                                ++i;
                            }
                        }
                        if (dataGramIndex % this.sectionNumber == 0) {
                            boolean needInsertLinkDesc;
                            boolean bl = needInsertLinkDesc = packageOtions.getInsertLinkedDescriptorBtn() && this.symbolRate > 0.0;
                            if (needInsertLinkDesc) {
                                if (oneBATNAT) {
                                    SsuTsPackageBuilder.construct_NitSection(stNITSection, info, packageOtions);
                                    nit = stNITSection.pSectionBuff;
                                    if (nit == null) {
                                        return null;
                                    }
                                    nitLength = stNITSection.buffLength.get();
                                }
                                int i = 0;
                                while (i < 2) {
                                    this.countNIT = SsuTsPackageBuilder.fillTsPackage(fp, strHeadTsPak, nit, pTempOffset, nitLength, this.countNIT, tsBuf, 16L);
                                    ++i;
                                }
                                if (oneBATNAT) {
                                    this.construct_BatSection(stBATSection, info, packageOtions);
                                    bat = stBATSection.pSectionBuff;
                                    batLength = stBATSection.buffLength.get();
                                }
                                i = 0;
                                while (i < 2) {
                                    this.countBAT = SsuTsPackageBuilder.fillTsPackage(fp, strHeadTsPak, bat, pTempOffset, batLength, this.countBAT, tsBuf, 17L);
                                    ++i;
                                }
                            }
                            if (oneBATNAT) {
                                oneBATNAT = false;
                            }
                        }
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        DDBSections stDDBSections = new DDBSections();
                        SsuTsPackageBuilder.loadingDDBSectionData(stDDBSections, partFile, partIndex, dataGramIndex, values);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        pTmp = stDDBSections.pDDBSection[0].pSectionBuff;
                        pTempOffset = 0;
                        lenDatagram = stDDBSections.pDDBSection[0].buffLength.get();
                        Arrays.fill(this.tempByte, (byte)0);
                        int[] temp = SsuTsPackageBuilder.fillTsPackage(this.tempByte, strHeadTsPak, pTmp, pTempOffset, lenDatagram, this.count, tsBuf);
                        this.count = temp[0];
                        int len = temp[1];
                        try {
                            fp.write(this.tempByte, 0, len);
                        }
                        catch (IOException e) {
                            SsuTsPackageBuilder.closeStream(fp);
                            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
                        }
                        SsuTsPackageBuilder.fflush(fp);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        IStatus result = this.insertEmptyPacket(packageOtions, monitor, tsBuf, pTempOffset, strHeadTsPak, stNULLSection, fp, subProgressMonitor, lenPartInfo, pTmp);
                        if (result != Status.OK_STATUS) {
                            IStatus iStatus = result;
                            return iStatus;
                        }
                        ++dataGramIndex;
                    }
                }
                finally {
                    if (subProgressMonitor != null) {
                        subProgressMonitor.done();
                    }
                }
                ++partIndex;
            }
            if (nit == null) return Status.OK_STATUS;
            if (bat == null) return Status.OK_STATUS;
            if (packageOtions == null) return Status.OK_STATUS;
            boolean needInsertLinkedDesc = packageOtions.getInsertLinkedDescriptorBtn() && nit.length > 0 && bat.length > 0;
            if (!needInsertLinkedDesc) return Status.OK_STATUS;
            this.WriteTextFile(strFilePathName, nit, nitLength, bat, batLength);
            return Status.OK_STATUS;
        }
        finally {
            monitor.worked(20);
            try {
                fp.close();
            }
            catch (IOException e) {
                throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
            }
        }
    }

    private IStatus insertEmptyPacket(SsuPackageOptions packageOtions, IProgressMonitor monitor, byte[] tsBuf, int pTempOffset, HeadTsPacket strHeadTsPak, DSMCC_SectionInfo stNULLSection, RandomFileOutputStream fp, SubProgressMonitor subProgressMonitor, int lenPartInfo, byte[] pTmp) throws HiLoaderException, IOException {
        boolean neenInsertEmptyPacket;
        boolean bl = neenInsertEmptyPacket = packageOtions.getInsertEmptyPacket() && this.symbolRate > (double)this.validSymbolRate && this.validSymbolRate > 0;
        if (neenInsertEmptyPacket) {
            int number = (int)((this.symbolRate - (double)this.validSymbolRate) / 1000.0 * 3060.0 / (double)this.sectionNumber) * 2;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (number < 0) {
                number = 2;
            }
            int tempNumber = number * 184;
            int size = (int)((long)tempNumber / 4066L);
            if ((long)tempNumber % 4066L != 0L) {
                ++size;
            }
            pTmp = stNULLSection.pSectionBuff;
            lenPartInfo = stNULLSection.buffLength.get();
            int i = 0;
            while (i < size) {
                if (i + 1 == size) {
                    lenPartInfo = (int)((long)tempNumber - 4066L * (long)i);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Arrays.fill(this.tempByte, (byte)-1);
                strHeadTsPak.pid.set(8191L);
                int[] tempNullNumber = SsuTsPackageBuilder.fillTsPackage(this.tempByte, strHeadTsPak, pTmp, pTempOffset, lenPartInfo, 0, tsBuf);
                int nullLen = tempNullNumber[1];
                if (nullLen > 0) {
                    try {
                        fp.write(this.tempByte, 0, nullLen);
                    }
                    catch (IOException e) {
                        SsuTsPackageBuilder.closeStream(fp);
                        throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
                    }
                    SsuTsPackageBuilder.fflush(fp);
                }
                ++i;
            }
            strHeadTsPak.pid.set(SsuTsPackageBuilder.getG_struFrontend().u16TsPID.get());
        }
        subProgressMonitor.worked(1);
        return Status.OK_STATUS;
    }

    private void WriteTextFile(String strFilePathName, byte[] nit, int nitLength, byte[] bat, int batLength) {
        if (strFilePathName == null) {
            return;
        }
        String fileName = strFilePathName;
        if (strFilePathName.lastIndexOf(46) > 0) {
            fileName = strFilePathName.substring(0, strFilePathName.lastIndexOf(46));
            fileName = String.valueOf(fileName) + "PSI-SI.txt";
        } else {
            fileName = String.valueOf(fileName) + "PSI-SI.txt";
        }
        if (fileName != null && !fileName.isEmpty()) {
            StringBuffer resultNIT = new StringBuffer();
            resultNIT.append("NIT:\n\tsection:0\n");
            resultNIT.append("\t\ttable_id0x40\n");
            resultNIT.append("\t\tsection_syntax_indicator0x01\n");
            resultNIT.append("\t\tsection_length(byte):0x");
            resultNIT.append(Integer.toHexString(nit[3]));
            resultNIT.append("(");
            resultNIT.append(nit[3]);
            resultNIT.append(")\n");
            resultNIT.append("\t\tnetwork_id:");
            resultNIT.append("0x0001");
            resultNIT.append("\n");
            resultNIT.append("\t\tversion_number:");
            resultNIT.append("0x00");
            resultNIT.append("\n");
            resultNIT.append("\t\tcurrent_next_indicator:");
            resultNIT.append("0x1");
            resultNIT.append("\n");
            resultNIT.append("\t\tsection_number:");
            resultNIT.append("0x00(0)");
            resultNIT.append("\n");
            resultNIT.append("\t\tlast_section_number:");
            resultNIT.append("0x00(0)");
            resultNIT.append("\n");
            resultNIT.append("\t\tnetwork_descriptors_length(byte):");
            resultNIT.append("0x");
            resultNIT.append(Integer.toHexString(nit[10]));
            resultNIT.append("(");
            resultNIT.append(nit[10]);
            resultNIT.append(")");
            resultNIT.append("\n");
            resultNIT.append("\t\tnetwork_descriptors:");
            resultNIT.append("\n");
            resultNIT.append("\t\t\tdescriptor_tag:0x");
            resultNIT.append(Integer.toHexString(nit[11]));
            resultNIT.append("(");
            resultNIT.append(nit[11]);
            resultNIT.append(")");
            resultNIT.append("\n");
            resultNIT.append("\t\t\tdescriptor_length(byte):0x");
            resultNIT.append(Integer.toHexString(nit[12]));
            resultNIT.append("(");
            resultNIT.append(nit[12]);
            resultNIT.append(")");
            resultNIT.append("\n");
            resultNIT.append("\t\t\ttransport_stream_id:");
            resultNIT.append("0x0001");
            resultNIT.append("\n");
            resultNIT.append("\t\t\toriginal_network_id:");
            resultNIT.append("0x0001");
            resultNIT.append("\n");
            resultNIT.append("\t\t\tservice_id:");
            resultNIT.append("0x0001");
            resultNIT.append("\n");
            resultNIT.append("\t\t\tlinkage_type:");
            resultNIT.append("0x");
            resultNIT.append(Integer.toHexString(nit[19]));
            resultNIT.append("\n");
            resultNIT.append("\t\t\toui_data_length(byte):");
            resultNIT.append("0x");
            resultNIT.append(String.valueOf(Integer.toHexString(nit[21])) + "(" + nit[21] + ")" + "\n");
            StringBuffer buf = new StringBuffer();
            int i = 1;
            while (i < nit[21] + 1) {
                buf.append(String.valueOf(StringUtil.toHexStr(nit[21 + i], 2)) + " ");
                ++i;
            }
            resultNIT.append("\t\t\toui_data(hex):" + buf.toString() + "\n");
            resultNIT.append("\t\ttransport_stream_loop_length:0x");
            resultNIT.append(String.valueOf(StringUtil.toHexStr(nit[70], 2)) + "(" + nit[70] + ")");
            resultNIT.append("\n");
            resultNIT.append("\t\tcrc_32:0x");
            resultNIT.append(StringUtil.toHexStr(nit[72], 2));
            resultNIT.append(StringUtil.toHexStr(nit[73], 2));
            resultNIT.append(StringUtil.toHexStr(nit[74], 2));
            resultNIT.append(String.valueOf(StringUtil.toHexStr(nit[75], 2)) + "\n\n");
            StringBuffer resultBAT = new StringBuffer();
            resultBAT.append("BAT:\n\tsection:0\n");
            resultBAT.append("\t\ttable_id0x4a\n");
            resultBAT.append("\t\tsection_syntax_indicator0x01\n");
            resultBAT.append("\t\tsection_length(byte):0x");
            resultBAT.append(Integer.toHexString(bat[3]));
            resultBAT.append("(");
            resultBAT.append(bat[3]);
            resultBAT.append(")\n");
            resultBAT.append("\t\tbouquet_id:");
            resultBAT.append("0x0000");
            resultBAT.append("\n");
            resultBAT.append("\t\tversion_number:");
            resultBAT.append("0x00");
            resultBAT.append("\n");
            resultBAT.append("\t\tcurrent_next_indicator:");
            resultBAT.append("0x0");
            resultBAT.append("\n");
            resultBAT.append("\t\tsection_number:");
            resultBAT.append("0x00(0)");
            resultBAT.append("\n");
            resultBAT.append("\t\tlast_section_number:");
            resultBAT.append("0x00(0)");
            resultBAT.append("\n");
            resultBAT.append("\t\tbouquet_descriptors_length(byte):");
            resultBAT.append("0x");
            resultBAT.append(Integer.toHexString(bat[10]));
            resultBAT.append("(");
            resultBAT.append(bat[10]);
            resultBAT.append(")");
            resultBAT.append("\n");
            resultBAT.append("\t\tbouquet_descriptors:");
            resultBAT.append("\n");
            resultBAT.append("\t\t\tdescriptor_tag:0x");
            resultBAT.append(Integer.toHexString(bat[11]));
            resultBAT.append("(");
            resultBAT.append(bat[11]);
            resultBAT.append(")");
            resultBAT.append("\n");
            resultBAT.append("\t\t\tdescriptor_length(byte):0x");
            resultBAT.append(Integer.toHexString(bat[12]));
            resultBAT.append("(");
            resultBAT.append(bat[12]);
            resultBAT.append(")");
            resultBAT.append("\n");
            resultBAT.append("\t\t\ttransport_stream_id:");
            resultBAT.append("0x0001");
            resultBAT.append("\n");
            resultBAT.append("\t\t\toriginal_network_id:");
            resultBAT.append("0x0001");
            resultBAT.append("\n");
            resultBAT.append("\t\t\tservice_id:");
            resultBAT.append("0x0001");
            resultBAT.append("\n");
            resultBAT.append("\t\t\tlinkage_type:");
            resultBAT.append("0x");
            resultBAT.append(Integer.toHexString(bat[19]));
            resultBAT.append("\n");
            resultBAT.append("\t\t\toui_data_length(byte):");
            resultBAT.append("0x");
            resultBAT.append(String.valueOf(Integer.toHexString(bat[21])) + "(" + bat[21] + ")" + "\n");
            StringBuffer buf1 = new StringBuffer();
            int i2 = 1;
            while (i2 < bat[21] + 1) {
                buf1.append(String.valueOf(StringUtil.toHexStr(bat[21 + i2], 2)) + " ");
                ++i2;
            }
            resultBAT.append("\t\t\toui_data(hex):" + buf1.toString() + "\n");
            resultBAT.append("\t\ttransport_stream_loop_length:0x");
            resultBAT.append(String.valueOf(StringUtil.toHexStr(bat[70], 2)) + "(" + bat[70] + ")");
            resultBAT.append("\n");
            resultBAT.append("\t\tcrc_32:0x");
            resultBAT.append(StringUtil.toHexStr(bat[72], 2));
            resultBAT.append(StringUtil.toHexStr(bat[73], 2));
            resultBAT.append(StringUtil.toHexStr(bat[74], 2));
            resultBAT.append(String.valueOf(StringUtil.toHexStr(bat[75], 2)) + "\n\n");
            FileOutputStream outputStream = null;
            try {
                try {
                    outputStream = new FileOutputStream(new File(fileName));
                    outputStream.write(resultNIT.toString().getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
                    outputStream.write(resultBAT.toString().getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus createPackage(List<UpgradeFileInfo> list, SsuUpgradeInfo info, SsuPackageOptions packageOtions, String strFilePathName, IProgressMonitor monitor) throws IOException, HiLoaderException {
        boolean needInsertEmptyOrDesc;
        SsuTsPackageBuilder.setIs32Bit(GlobleControler.intance.isIs32Bit());
        SsuTsPackageBuilder.setHi3798CV200(GlobleControler.intance.isHi3798CV200());
        boolean bl = needInsertEmptyOrDesc = packageOtions.getInsertEmptyPacket() || packageOtions.getInsertLinkedDescriptorBtn();
        if (needInsertEmptyOrDesc) {
            this.symbolRate = packageOtions.getSymbolRate();
            this.validSymbolRate = packageOtions.getValidSymbolRate();
            this.transferMode = packageOtions.getTransferModeCombo();
            this.sectionNumber = this.getSectionNum(packageOtions);
            return this.createPackageOptions(list, info, packageOtions, strFilePathName, monitor);
        }
        monitor.setTaskName("Validate upgrade file list..");
        boolean success = FileHelper.validateUpdateFilesList(list, 0xF000000L);
        if (!success) {
            return Status.CANCEL_STATUS;
        }
        monitor.setTaskName("Analysis of the part file");
        list = FileHelper.getRealBurnFileList(list, 0xF000000L);
        if (64 < list.size()) {
            throw new HiLoaderException(String.format(Messages.HiLoaderComposite_MaxPartFile, 64));
        }
        monitor.beginTask("Packaged part files", 100 * list.size() + 20 + 20);
        SsuTsPackageBuilder.setG_softwareVersion(info.getSoftwareVersion());
        SsuTsPackageBuilder.setG_FactoryIdFlag(info.getManufacturerId());
        SsuTsPackageBuilder.setG_HardwareVersion(info.getHardwareVersion());
        SsuTsPackageBuilder.setG_start_sn(info.getStartSn());
        SsuTsPackageBuilder.setG_end_sn(info.getEndSn());
        SsuTsPackageBuilder.setG_struFrontend(new DbFrontEnd());
        SsuTsPackageBuilder.getG_struFrontend().u32Frequency.set(674000L);
        SsuTsPackageBuilder.getG_struFrontend().u32SymbolRate.set(6875000L);
        SsuTsPackageBuilder.getG_struFrontend().enModulation.set((Enum)CableMode.valueOf(2));
        SsuTsPackageBuilder.getG_struFrontend().u16TsPID.set((long)info.getDownloadPid());
        SsuTsPackageBuilder.getG_struFrontend().u16GroupID.set(info.getDownloadGroupId());
        SsuTsPackageBuilder.setG_u32GroupId((short)SsuTsPackageBuilder.getG_struFrontend().u16GroupID.get());
        monitor.worked(5);
        byte[] tsBuf = new byte[184];
        int lenDatagram = 0;
        int lenPartInfo = 0;
        int lenDownloadCtrl = 0;
        int pTempOffset = 0;
        HeadTsPacket strHeadTsPak = new HeadTsPacket();
        DSMCC_SectionInfo stDSISection = new DSMCC_SectionInfo();
        DSMCC_SectionInfo stDIISection = new DSMCC_SectionInfo();
        int dataGramIndex = 0;
        strHeadTsPak.synByte.set(71L);
        strHeadTsPak.transportErrorIndicator.set(0L);
        strHeadTsPak.payloadUnitStartIndicator.set(1L);
        strHeadTsPak.transportPriority.set(0L);
        strHeadTsPak.transportScramblingControl.set(0L);
        strHeadTsPak.adaptationFieldControl.set(1L);
        Arrays.fill(tsBuf, (byte)-1);
        RandomFileOutputStream fp = SsuTsPackageBuilder.newOutputStream(strFilePathName);
        if (fp == null) {
            return Status.CANCEL_STATUS;
        }
        try {
            monitor.worked(5);
            monitor.setTaskName("Compute all of part file crc");
            SsuTsPackageBuilder.setG_struPartFile(SsuTsPackageBuilder.fillFileDataStruct(list));
            SsuTsPackageBuilder.setG_ulPartNum(SsuTsPackageBuilder.getG_struPartFile().size());
            monitor.setTaskName("Package Part file..");
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.worked(10);
            int partIndex = 0;
            while (partIndex < SsuTsPackageBuilder.getG_ulPartNum()) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                PartFile partFile = SsuTsPackageBuilder.getG_struPartFile().get(partIndex);
                long[] values = new long[]{partFile.getSectionNum(), partFile.getLastDiagramDataLength(), partFile.datagramNum.get()};
                strHeadTsPak.pid.set(SsuTsPackageBuilder.getG_struFrontend().u16TsPID.get());
                monitor.worked(20);
                long u16DataGramNum = values[0];
                SubProgressMonitor subProgressMonitor = null;
                try {
                    subProgressMonitor = new SubProgressMonitor(monitor, 80, 4);
                    subProgressMonitor.beginTask("", (int)u16DataGramNum);
                    subProgressMonitor.setTaskName("Package all information to ts file...");
                    dataGramIndex = 0;
                    while ((long)dataGramIndex < u16DataGramNum) {
                        byte[] pTmp;
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (dataGramIndex % 100 == 0) {
                            SsuTsPackageBuilder.construct_DSISection(stDSISection);
                            pTmp = stDSISection.pSectionBuff;
                            pTempOffset = 0;
                            lenDownloadCtrl = stDSISection.buffLength.get();
                            int i = 0;
                            while (i < 2) {
                                this.count = SsuTsPackageBuilder.fillTsPackage(fp, strHeadTsPak, pTmp, pTempOffset, lenDownloadCtrl, this.count, tsBuf);
                                ++i;
                            }
                            SsuTsPackageBuilder.construct_DIISection(stDIISection);
                            pTmp = stDIISection.pSectionBuff;
                            lenPartInfo = stDIISection.buffLength.get();
                            i = 0;
                            while (i < 2) {
                                this.count = SsuTsPackageBuilder.fillTsPackage(fp, strHeadTsPak, pTmp, pTempOffset, lenPartInfo, this.count, tsBuf);
                                ++i;
                            }
                        }
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        DDBSections stDDBSections = new DDBSections();
                        SsuTsPackageBuilder.loadingDDBSectionData(stDDBSections, partFile, partIndex, dataGramIndex, values);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        pTmp = stDDBSections.pDDBSection[0].pSectionBuff;
                        pTempOffset = 0;
                        lenDatagram = stDDBSections.pDDBSection[0].buffLength.get();
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        int[] temp = SsuTsPackageBuilder.fillTsPackage(this.tempByte, strHeadTsPak, pTmp, pTempOffset, lenDatagram, this.count, tsBuf);
                        this.count = temp[0];
                        int len = temp[1];
                        try {
                            fp.write(this.tempByte, 0, len);
                        }
                        catch (IOException e) {
                            SsuTsPackageBuilder.closeStream(fp);
                            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
                        }
                        SsuTsPackageBuilder.fflush(fp);
                        subProgressMonitor.worked(1);
                        ++dataGramIndex;
                    }
                }
                finally {
                    if (subProgressMonitor != null) {
                        subProgressMonitor.done();
                    }
                }
                ++partIndex;
            }
            return Status.OK_STATUS;
        }
        finally {
            monitor.worked(20);
            try {
                fp.close();
            }
            catch (IOException e) {
                throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
            }
        }
    }

    private int getSectionNum(SsuPackageOptions packageOtions) {
        boolean needInsertEmptyAndDesc;
        boolean bl = needInsertEmptyAndDesc = packageOtions.getInsertEmptyPacket() && packageOtions.getInsertLinkedDescriptorBtn();
        this.sectionNumber = needInsertEmptyAndDesc ? (this.symbolRate > (double)this.validSymbolRate ? this.validSymbolRate * 257 : 100) : (packageOtions.getInsertLinkedDescriptorBtn() ? (int)(this.symbolRate * 257.0) : (packageOtions.getInsertEmptyPacket() ? this.validSymbolRate * 257 : 100));
        if (this.sectionNumber > 1000) {
            this.sectionNumber /= 1000;
        }
        return this.sectionNumber;
    }

    private static void loadingDDBSectionData(DDBSections stDDBSections, PartFile partFile, int partIndex, int dataGramIndex, long[] values) {
        long u32DataLen = 0L;
        int u32TotleLen = 0;
        short u8LastSectionNum = 0;
        long sectionNum = values[0];
        long lastSectionLength = values[1];
        int u16ModuleId = partFile.moduleId.get();
        short u8ModuleVersion = partFile.moduleVersion.get();
        RandomAccessFile file = null;
        try {
            try {
                file = new RandomAccessFile(new File(partFile.fileName), "r");
                stDDBSections.newDSMCC_SectionInfo(1);
                stDDBSections.u16SectionNum.set((int)sectionNum);
                u8LastSectionNum = sectionNum > 256L ? (short)0 : (short)sectionNum;
                DSMCCSectionHead stDSMCCHeader = new DSMCCSectionHead();
                SsuTsPackageBuilder.construct_DDBSecHead(stDSMCCHeader, (short)60, u16ModuleId, (short)(dataGramIndex % 256), u8LastSectionNum);
                u32DataLen = sectionNum - 1L == (long)dataGramIndex ? lastSectionLength : 4066L;
                int u16MsgLen = (int)(6L + u32DataLen);
                DSMCCMessageHeader stDsmccMsgHeader = new DSMCCMessageHeader();
                u32TotleLen = 9 + stDsmccMsgHeader.size() + u16MsgLen + 4;
                stDDBSections.pDDBSection[0].pSectionBuff = new byte[u32TotleLen];
                SsuTsPackageBuilder.memset(stDDBSections.pDDBSection[0].pSectionBuff, 0, u32TotleLen);
                stDDBSections.pDDBSection[0].buffLength.set(u32TotleLen);
                stDSMCCHeader.section_length.set((long)(u32TotleLen - 1 - 3));
                byte[] ptmp = stDDBSections.pDDBSection[0].pSectionBuff;
                SsuTsPackageBuilder.construct_SecHead(stDSMCCHeader, ptmp);
                int offset = 0;
                SsuTsPackageBuilder.construct_DSMCCMessageHeader(ptmp, 4099, u16ModuleId, u16MsgLen, offset += 9);
                offset += stDsmccMsgHeader.size();
                offset = SsuTsPackageBuilder.alterU16ToU8(ptmp, offset, (short)u16ModuleId);
                ptmp[offset++] = (byte)u8ModuleVersion;
                ++offset;
                offset = SsuTsPackageBuilder.alterU16ToU8(ptmp, offset, (short)dataGramIndex);
                long srcOffset = (long)dataGramIndex * 4066L;
                file.seek(srcOffset);
                int read = file.read(tempSectionData, 0, (int)u32DataLen);
                System.arraycopy(tempSectionData, 0, ptmp, offset, read);
                int crc = Crc32.compute(stDDBSections.pDDBSection[0].pSectionBuff, 1, u32TotleLen - 1 - 4);
                SsuTsPackageBuilder.alterU32ToU8(ptmp, offset += read, crc);
                offset += 4;
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void construct_DIISection(DSMCC_SectionInfo pDIISection) {
        DSMCCSectionHead stDSMCCHeader = new DSMCCSectionHead();
        DSMCCMessageHeader stDsmccMsgHeader = new DSMCCMessageHeader();
        int u32CRClen = 4;
        boolean u32CrcVal = false;
        boolean crcDataLen = false;
        int messageLen = 0;
        int downloadId = 0;
        int totalLen = 0;
        short f = 0;
        ModuleDescription moduleDescription = new ModuleDescription();
        messageLen = SsuTsPackageBuilder.isIs32Bit() ? 20 + SsuTsPackageBuilder.getG_ulPartNum() * (moduleDescription.size() + 8 - 8) + 2 : (SsuTsPackageBuilder.isHi3798CV200() ? 20 + SsuTsPackageBuilder.getG_ulPartNum() * (moduleDescription.size() + 16) + 2 : 20 + SsuTsPackageBuilder.getG_ulPartNum() * (moduleDescription.size() + 16 - 8) + 2);
        if (SsuTsPackageBuilder.isHi3798CV200()) {
            f = 0;
            while (f < SsuTsPackageBuilder.getG_ulPartNum()) {
                PartFile partFile = SsuTsPackageBuilder.getG_struPartFile().get(f);
                String name = partFile.getPartitionName();
                messageLen = name == null || name.isEmpty() ? (messageLen += 4) : (messageLen += 2 + name.length() + 2);
                f = (short)(f + 1);
            }
        }
        totalLen = 9 + stDsmccMsgHeader.size() + messageLen + 4;
        pDIISection.pSectionBuff = new byte[totalLen];
        pDIISection.buffLength.set(totalLen);
        SsuTsPackageBuilder.construct_DSIHead(stDSMCCHeader, 59, 0);
        stDSMCCHeader.section_length.set((long)(totalLen - 1 - 3));
        byte[] pTmp = pDIISection.pSectionBuff;
        SsuTsPackageBuilder.construct_SecHead(stDSMCCHeader, pTmp);
        int offset = 0;
        SsuTsPackageBuilder.construct_DSMCCMessageHeader(pTmp, 4098, SsuTsPackageBuilder.getG_u32GroupId(), messageLen, offset += 9);
        offset += stDsmccMsgHeader.size();
        offset = SsuTsPackageBuilder.alterU32ToU8(pTmp, offset, downloadId);
        offset = SsuTsPackageBuilder.alterU16ToU8(pTmp, offset, (short)4066);
        offset += 12;
        short numberOfModules = SsuTsPackageBuilder.getG_ulPartNum();
        offset = SsuTsPackageBuilder.alterU16ToU8(pTmp, offset, numberOfModules);
        f = 0;
        while (f < SsuTsPackageBuilder.getG_ulPartNum()) {
            PartFile partFile = SsuTsPackageBuilder.getG_struPartFile().get(f);
            ModuleDescription stModule = new ModuleDescription();
            stModule.moduleId.set(partFile.moduleId.get());
            stModule.moduleSize.set(partFile.fileSize.get());
            stModule.moduleVersion.set(partFile.moduleVersion.get());
            int partLength = 0;
            if (SsuTsPackageBuilder.isHi3798CV200()) {
                String name = partFile.getPartitionName();
                stModule.moduleInfo.setPartitionName(name);
                partLength = name == null || name.isEmpty() ? (partLength += 4) : (partLength += 2 + name.length() + 2);
                stModule.moduleInfo.partitionVersion.set(partFile.partitionVersion.get());
                stModule.moduleInfo.partitionVerifyTag.set(partFile.partitionVerifyTag.get());
            }
            if (SsuTsPackageBuilder.isIs32Bit()) {
                stModule.moduleInfoLength.set((short)(stModule.moduleInfo.size() + 8 - 8 + partLength));
            } else if (SsuTsPackageBuilder.isHi3798CV200()) {
                stModule.moduleInfoLength.set((short)(stModule.moduleInfo.size() + 16 + partLength));
            } else {
                stModule.moduleInfoLength.set((short)(stModule.moduleInfo.size() + 16 - 8 + partLength));
            }
            stModule.moduleInfo.setFlashStartAddr(partFile.getBurnAddr());
            stModule.moduleInfo.setFlashEndAddr(partFile.getuPartitionEndAddr());
            stModule.moduleInfo.flashType.set((long)((FlashType)partFile.uFlashType.get()).ordinal());
            stModule.moduleInfo.flashIndex.set(partFile.lFlashIndex.get());
            stModule.moduleInfo.partitionCRC.set(partFile.crcValue.get());
            int offsetlength = SsuTsPackageBuilder.construct_ModuleDescription(stModule, pTmp, offset);
            offset = SsuTsPackageBuilder.isHi3798CV200() ? offsetlength : (SsuTsPackageBuilder.isIs32Bit() ? (offset += stModule.size() + 8 - 8) : (offset += stModule.size() + 16 - 8));
            f = (short)(f + 1);
        }
        boolean privateLength = false;
        offset = SsuTsPackageBuilder.alterU16ToU8(pTmp, offset, (short)(privateLength ? 1 : 0));
        int crc = Crc32.compute(pDIISection.pSectionBuff, 1, totalLen - 1 - 4);
        SsuTsPackageBuilder.alterU32ToU8(pTmp, offset, crc);
        offset += 4;
    }

    private static int construct_ModuleDescription(ModuleDescription pstModule, byte[] pTmp, int offset) {
        int descOffset = offset;
        descOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, descOffset, (short)pstModule.moduleId.get());
        descOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, descOffset, pstModule.moduleSize.get());
        pTmp[descOffset++] = (byte)pstModule.moduleVersion.get();
        pTmp[descOffset++] = (byte)pstModule.moduleInfoLength.get();
        if (SsuTsPackageBuilder.isIs32Bit()) {
            descOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, descOffset, (int)pstModule.moduleInfo.getFlashStartAddr());
            descOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, descOffset, (int)pstModule.moduleInfo.getFlashEndAddr());
        } else {
            descOffset = SsuTsPackageBuilder.alterU64ToU8(pTmp, descOffset, pstModule.moduleInfo.getFlashStartAddr());
            descOffset = SsuTsPackageBuilder.alterU64ToU8(pTmp, descOffset, pstModule.moduleInfo.getFlashEndAddr());
        }
        descOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, descOffset, (int)pstModule.moduleInfo.flashType.get());
        descOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, descOffset, (int)pstModule.moduleInfo.flashIndex.get());
        if (SsuTsPackageBuilder.isHi3798CV200()) {
            descOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, descOffset, (int)pstModule.moduleInfo.partitionVersion.get());
            descOffset = SsuTsPackageBuilder.alterU32LowToU8(pTmp, descOffset, (int)pstModule.moduleInfo.partitionVerifyTag.get());
            String name = pstModule.moduleInfo.getPartitionName();
            if (name == null || name.isEmpty()) {
                descOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, descOffset, (short)0);
                descOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, descOffset, (short)0);
            } else {
                short len = (short)name.length();
                descOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, descOffset, (short)name.length());
                try {
                    SsuTsPackageBuilder.memcpy(pTmp, descOffset, name.getBytes(System.getProperty("file.encoding")), len);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                descOffset += len;
                descOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, descOffset, (short)0);
            }
        }
        descOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, descOffset, (int)pstModule.moduleInfo.partitionCRC.get());
        return descOffset;
    }

    private static RandomFileOutputStream newOutputStream(String strFilePathName) throws FileNotFoundException, HiLoaderException {
        FileUtil.deleteFile(strFilePathName);
        if (!FileUtil.canWriteFile(strFilePathName, Messages.TsPackageBuilder_CreateError)) {
            return null;
        }
        RandomFileOutputStream fp = null;
        try {
            fp = new RandomFileOutputStream(strFilePathName);
        }
        catch (IOException e) {
            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
        }
        return fp;
    }

    public static void writeByte(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    private static void construct_TsHead(byte[] out, HeadTsPacket pstrHeadTsPak, int destPos) throws HiLoaderException {
        byte[] headBuf = new byte[]{(byte)pstrHeadTsPak.synByte.get(), (byte)(0L | pstrHeadTsPak.transportErrorIndicator.get() << 7 | pstrHeadTsPak.payloadUnitStartIndicator.get() << 6 | pstrHeadTsPak.transportPriority.get() << 5 | pstrHeadTsPak.pid.get() >>> 8 & 0x1FL), (byte)(pstrHeadTsPak.pid.get() & 0xFFL), (byte)(0L | pstrHeadTsPak.transportScramblingControl.get() << 6 | pstrHeadTsPak.adaptationFieldControl.get() << 4 | pstrHeadTsPak.continuityCounter.get())};
        SsuTsPackageBuilder.writeByte(headBuf, 0, out, destPos, headBuf.length);
    }

    private static int fillTsPackage(RandomFileOutputStream fp, HeadTsPacket strHeadTsPak, byte[] pTmp, int pTempOffset, int lenDownloadCtrl, int count, byte[] tsBuf, long pid) throws HiLoaderException, IOException {
        strHeadTsPak.pid.set(pid);
        strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
        if (count > 15) {
            count = 0;
        }
        strHeadTsPak.payloadUnitStartIndicator.set(1L);
        try {
            SsuTsPackageBuilder.construct_TsHead(fp, strHeadTsPak);
            strHeadTsPak.pid.set(SsuTsPackageBuilder.getG_struFrontend().u16TsPID.get());
            if (lenDownloadCtrl > 184) {
                while (lenDownloadCtrl > 184) {
                    fp.write(pTmp, pTempOffset, 184);
                    lenDownloadCtrl -= 184;
                    strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
                    if (count > 15) {
                        count = 0;
                    }
                    strHeadTsPak.payloadUnitStartIndicator.set(0L);
                    SsuTsPackageBuilder.construct_TsHead(fp, strHeadTsPak);
                    pTempOffset += 184;
                }
                fp.write(pTmp, pTempOffset, lenDownloadCtrl);
                fp.write(tsBuf, 0, 184 - lenDownloadCtrl);
            } else {
                fp.write(pTmp, pTempOffset, lenDownloadCtrl);
                fp.write(tsBuf, 0, 184 - lenDownloadCtrl);
            }
        }
        catch (IOException e) {
            SsuTsPackageBuilder.closeStream(fp);
            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
        }
        SsuTsPackageBuilder.fflush(fp);
        return count;
    }

    private static int[] fillTsPackage(byte[] fp, HeadTsPacket strHeadTsPak, byte[] pTmp, int pTempOffset, int lenDownloadCtrl, int count, byte[] tsBuf) throws HiLoaderException, IOException {
        int oldLen = 0;
        strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
        if (count > 15) {
            count = 0;
        }
        strHeadTsPak.payloadUnitStartIndicator.set(1L);
        SsuTsPackageBuilder.construct_TsHead(fp, strHeadTsPak, 0);
        pTempOffset += 4;
        if (lenDownloadCtrl > 184) {
            while (lenDownloadCtrl > 184) {
                SsuTsPackageBuilder.writeByte(pTmp, oldLen, fp, pTempOffset, 184);
                lenDownloadCtrl -= 184;
                oldLen += 184;
                strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
                if (count > 15) {
                    count = 0;
                }
                if (strHeadTsPak.pid.get() != 8191L) {
                    strHeadTsPak.payloadUnitStartIndicator.set(0L);
                }
                SsuTsPackageBuilder.construct_TsHead(fp, strHeadTsPak, pTempOffset += 184);
                pTempOffset += 4;
            }
            SsuTsPackageBuilder.writeByte(pTmp, oldLen, fp, pTempOffset, lenDownloadCtrl);
            SsuTsPackageBuilder.writeByte(tsBuf, 0, fp, pTempOffset += lenDownloadCtrl, 184 - lenDownloadCtrl);
            pTempOffset += 184 - lenDownloadCtrl;
        } else {
            SsuTsPackageBuilder.writeByte(pTmp, oldLen, fp, pTempOffset, lenDownloadCtrl);
            SsuTsPackageBuilder.writeByte(tsBuf, 0, fp, pTempOffset += lenDownloadCtrl, 184 - lenDownloadCtrl);
            pTempOffset += 184 - lenDownloadCtrl;
        }
        int[] temp = new int[]{count, pTempOffset};
        return temp;
    }

    private static int fillTsPackage(RandomFileOutputStream fp, HeadTsPacket strHeadTsPak, byte[] pTmp, int pTempOffset, int lenDownloadCtrl, int count, byte[] tsBuf) throws HiLoaderException, IOException {
        strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
        if (count > 15) {
            count = 0;
        }
        strHeadTsPak.payloadUnitStartIndicator.set(1L);
        try {
            SsuTsPackageBuilder.construct_TsHead(fp, strHeadTsPak);
            if (lenDownloadCtrl > 184) {
                while (lenDownloadCtrl > 184) {
                    fp.write(pTmp, pTempOffset, 184);
                    lenDownloadCtrl -= 184;
                    strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
                    if (count > 15) {
                        count = 0;
                    }
                    strHeadTsPak.payloadUnitStartIndicator.set(0L);
                    SsuTsPackageBuilder.construct_TsHead(fp, strHeadTsPak);
                    pTempOffset += 184;
                }
                fp.write(pTmp, pTempOffset, lenDownloadCtrl);
                fp.write(tsBuf, 0, 184 - lenDownloadCtrl);
            } else {
                fp.write(pTmp, pTempOffset, lenDownloadCtrl);
                fp.write(tsBuf, 0, 184 - lenDownloadCtrl);
            }
        }
        catch (IOException e) {
            SsuTsPackageBuilder.closeStream(fp);
            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
        }
        SsuTsPackageBuilder.fflush(fp);
        return count;
    }

    private static void fflush(RandomFileOutputStream fp) throws HiLoaderException {
        try {
            fp.flush();
        }
        catch (IOException e) {
            throw new HiLoaderException(String.valueOf(Messages.TsPackageBuilder_CreateError) + e.getMessage());
        }
    }

    private static void closeStream(RandomFileOutputStream fp) {
        try {
            fp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void construct_DSMCCMessageHeader(byte[] pBuff, int msgId, int transactionId, int msgLen, int offset) {
        int descOffset = offset;
        DSMCCMessageHeader stMsgHeader = new DSMCCMessageHeader();
        stMsgHeader.protocolDiscriminator.set((short)17);
        stMsgHeader.dsmccType.set((short)3);
        stMsgHeader.messageId.set(msgId);
        stMsgHeader.transactionId.set((long)transactionId);
        stMsgHeader.reserved.set((short)0);
        stMsgHeader.adapationLength.set((short)0);
        stMsgHeader.messageLength.set(msgLen);
        pBuff[descOffset++] = (byte)stMsgHeader.protocolDiscriminator.get();
        pBuff[descOffset++] = (byte)stMsgHeader.dsmccType.get();
        descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)stMsgHeader.messageId.get());
        descOffset = SsuTsPackageBuilder.alterU32ToU8(pBuff, descOffset, (int)stMsgHeader.transactionId.get());
        pBuff[descOffset++] = (byte)stMsgHeader.reserved.get();
        pBuff[descOffset++] = (byte)stMsgHeader.adapationLength.get();
        descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)stMsgHeader.messageLength.get());
    }

    private static void memcpy(byte[] pu8Temp, int offset, byte[] downloadDescriptionString, short len) {
        System.arraycopy(downloadDescriptionString, 0, pu8Temp, offset, len);
    }

    private static void memset(byte[] buf, int value, int len) {
        assert (buf.length == len);
        Arrays.fill(buf, (byte)value);
    }

    private static void construct_TsHead(OutputStream out, HeadTsPacket pstrHeadTsPak) throws HiLoaderException {
        byte[] headBuf = new byte[]{(byte)pstrHeadTsPak.synByte.get(), (byte)(0L | pstrHeadTsPak.transportErrorIndicator.get() << 7 | pstrHeadTsPak.payloadUnitStartIndicator.get() << 6 | pstrHeadTsPak.transportPriority.get() << 5 | pstrHeadTsPak.pid.get() >>> 8 & 0x1FL), (byte)(pstrHeadTsPak.pid.get() & 0xFFL), (byte)(0L | pstrHeadTsPak.transportScramblingControl.get() << 6 | pstrHeadTsPak.adaptationFieldControl.get() << 4 | pstrHeadTsPak.continuityCounter.get())};
        try {
            out.write(headBuf);
            out.flush();
        }
        catch (IOException e) {
            throw new HiLoaderException(Messages.TsPackageBuilder_FillError);
        }
    }

    private static void construct_SecHead(DSMCCSectionHead pSecHead, byte[] secBuf) {
        secBuf[0] = 0;
        secBuf[1] = (byte)pSecHead.table_id.get();
        secBuf[2] = (byte)(0L | pSecHead.section_syntax_indicator.get() << 7 | 0x70L | (pSecHead.section_length.get() & 0xF00L) >> 8);
        secBuf[3] = (byte)(pSecHead.section_length.get() & 0xFFL);
        secBuf[4] = (byte)((pSecHead.table_id_extension.get() & 0xFF00L) >> 8);
        secBuf[5] = (byte)(pSecHead.table_id_extension.get() & 0xFFL);
        secBuf[6] = (byte)((pSecHead.version_number.get() & 0x1FL) << 2 | pSecHead.current_next_indicator.get());
        secBuf[7] = (byte)pSecHead.section_number.get();
        secBuf[8] = (byte)pSecHead.last_section_number.get();
    }

    private static int alterU64ToU8(byte[] pu8Data, int offset, long u64Data) {
        pu8Data[offset] = (byte)(u64Data >> 56 & 0xFFL);
        pu8Data[offset + 1] = (byte)(u64Data >> 48 & 0xFFL);
        pu8Data[offset + 2] = (byte)(u64Data >> 40 & 0xFFL);
        pu8Data[offset + 3] = (byte)(u64Data >> 32 & 0xFFL);
        pu8Data[offset + 4] = (byte)(u64Data >> 24 & 0xFFL);
        pu8Data[offset + 5] = (byte)(u64Data >> 16 & 0xFFL);
        pu8Data[offset + 6] = (byte)(u64Data >> 8 & 0xFFL);
        pu8Data[offset + 7] = (byte)(u64Data & 0xFFL);
        return offset += 8;
    }

    private static int alterU32ToU8(byte[] pu8Data, int offset, int u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF000000) >>> 24);
        pu8Data[offset + 1] = (byte)((u32Data & 0xFF0000) >>> 16);
        pu8Data[offset + 2] = (byte)((u32Data & 0xFF00) >>> 8);
        pu8Data[offset + 3] = (byte)(u32Data & 0xFF);
        return offset + 4;
    }

    private static int alterU32ToU8(byte[] pu8Data, int offset, long u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFFFFFFFFFF000000L) >>> 24);
        pu8Data[offset + 1] = (byte)((u32Data & 0xFF0000L) >>> 16);
        pu8Data[offset + 2] = (byte)((u32Data & 0xFF00L) >>> 8);
        pu8Data[offset + 3] = (byte)(u32Data & 0xFFL);
        return offset + 4;
    }

    public static int alterU12ToU8(byte[] pu8Data, int offset, short u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF00) >>> 4 & 0xFF);
        pu8Data[offset + 1] = (byte)(u32Data & 0xFF);
        return offset + 2;
    }

    public static int alterU16ToU8(byte[] pu8Data, int offset, short u4Data, short u12Data) {
        pu8Data[offset] = (byte)(((u4Data & 0xFF) << 4) + (u12Data & 0xFF));
        pu8Data[offset + 1] = 0;
        return offset + 2;
    }

    private static int alterU16BitToU8(byte[] pu8Data, int offset, short u32Data, String data, short cableModulation) {
        int[] result = SsuTsPackageBuilder.getIntData(data);
        pu8Data[offset] = (byte)(((cableModulation & 0xFF) << 4) + result[0]);
        pu8Data[offset + 1] = (byte)(((result[2] & 0xFF) << 4) + result[3]);
        return offset + 2;
    }

    private static int alterU16BitToU8(byte[] pu8Data, int offset, short u32Data, String data) {
        int[] result = SsuTsPackageBuilder.getIntData(data);
        pu8Data[offset] = (byte)(((result[0] & 0xFF) << 4) + result[1]);
        pu8Data[offset + 1] = (byte)(((result[2] & 0xFF) << 4) + result[3]);
        return offset + 2;
    }

    private static int[] getIntData(String data) {
        int[] result = new int[4];
        if (data.length() > 0) {
            if (data.length() == 4) {
                result[0] = Integer.parseInt(data.substring(0, 1));
                result[1] = Integer.parseInt(data.substring(1, 2));
                result[2] = Integer.parseInt(data.substring(2, 3));
                result[3] = Integer.parseInt(data.substring(3, 4));
            } else if (data.length() == 3) {
                result[1] = Integer.parseInt(data.substring(0, 1));
                result[2] = Integer.parseInt(data.substring(1, 2));
                result[3] = Integer.parseInt(data.substring(2, 3));
            } else if (data.length() == 2) {
                result[2] = Integer.parseInt(data.substring(0, 1));
                result[3] = Integer.parseInt(data.substring(1, 2));
            } else if (data.length() == 1) {
                result[3] = Integer.parseInt(data);
            }
        }
        return result;
    }

    private static int alterU16ByModulationToU8(byte[] pu8Data, int offset, short u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF) << 4);
        return offset + 2;
    }

    private static int alterU16ToU8(byte[] pu8Data, int offset, short u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF00) >>> 8);
        pu8Data[offset + 1] = (byte)(u32Data & 0xFF);
        return offset + 2;
    }

    private static int alterU8ToU8(byte[] pu8Data, int offset, short u32Data) {
        pu8Data[offset] = (byte)(u32Data & 0xFF00);
        return offset + 1;
    }

    private static int alterU8ToU8(byte[] pTmp, int offset, int code_rate_LP_stream, int guard_interval, int transmission_mode, int other_frequency_flag) {
        pTmp[offset++] = (byte)((code_rate_LP_stream << 5) + (guard_interval << 3) + (transmission_mode << 1) + other_frequency_flag & 0xFF);
        return offset;
    }

    private static int alterU4ToU8(byte[] pTmp, int offset, int code_rate_LP_stream) {
        pTmp[offset++] = (byte)(code_rate_LP_stream << 4 & 0xFF);
        return offset;
    }

    private static int alterU16ToU8(byte[] pTmp, int offset, int bandwidth, int reserved_future_use, int constellation, int hierarchy_information, int code_rate_HP_stream) {
        pTmp[offset] = (byte)((bandwidth << 5) + (reserved_future_use << 1) + (constellation >>> 2) & 0xFF);
        pTmp[offset + 1] = (byte)(((constellation & 3) << 6) + (hierarchy_information << 3) + code_rate_HP_stream & 0xFF);
        return offset + 2;
    }

    private static int alterU24ToU8(byte[] pu8Data, int offset, int u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF0000) >>> 16);
        pu8Data[offset + 1] = (byte)((u32Data & 0xFF00) >>> 8);
        pu8Data[offset + 2] = (byte)(u32Data & 0xFF);
        return offset + 3;
    }

    private static int alterU28ToU8(byte[] pu8Data, int offset, short u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF0000) >>> 16);
        pu8Data[offset + 1] = (byte)((u32Data & 0xFF00) >>> 8);
        pu8Data[offset + 2] = (byte)(u32Data & 0xFF);
        return offset + 3;
    }

    private static void construct_DDBSecHead(DSMCCSectionHead stDSMCCHeader, short ddbTableId, int u16TableExId, short u8SectionNum, short last_section_number) {
        stDSMCCHeader.table_id.set((long)ddbTableId);
        stDSMCCHeader.section_syntax_indicator.set(1L);
        stDSMCCHeader.table_id_extension.set((long)u16TableExId);
        stDSMCCHeader.current_next_indicator.set(1L);
        stDSMCCHeader.version_number.set(0L);
        stDSMCCHeader.section_number.set((long)u8SectionNum);
        stDSMCCHeader.last_section_number.set((long)last_section_number);
    }

    private static void construct_NULLSection(DSMCC_SectionInfo stNULLSection) {
        stNULLSection.pSectionBuff = new byte[4096];
        stNULLSection.buffLength.set(4066);
        Arrays.fill(stNULLSection.pSectionBuff, (byte)-1);
    }

    private static void construct_NitSection(DSMCC_SectionInfo pDSISection, SsuUpgradeInfo info, SsuPackageOptions packageOtions) {
        int delivery_flag = packageOtions.getTransferModeCombo();
        long centre_frequency = packageOtions.getCentreFrequency();
        int bandwidth = packageOtions.getBandWidth();
        int constellation = packageOtions.getConstellation();
        int upgradeType = packageOtions.getUpgradeTypeCombo();
        double cableFrequency = packageOtions.getCableFrequency();
        int cableModulation = packageOtions.getCableModulation();
        int cableSymbolRate = packageOtions.getSymbolRate();
        if (delivery_flag == 1) {
            delivery_flag = 3;
        } else if (delivery_flag == 0) {
            delivery_flag = 1;
        }
        pDSISection.pSectionBuff = new byte[1024];
        pDSISection.buffLength.set(0);
        DSMCCSectionHead stDSMCCHeader = new DSMCCSectionHead();
        int u32CrcVal = 0;
        int crcDataLen = 0;
        int messageLen = 0;
        int sectionLength = 0;
        pDSISection.pSectionBuff = new byte[1024];
        pDSISection.buffLength.set(0);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 8 + 1);
        byte[] pTmp = pDSISection.pSectionBuff;
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 2);
        int linkageOffset = pDSISection.buffLength.get();
        pTmp[linkageOffset++] = 74;
        pTmp[linkageOffset++] = 57;
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)1);
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)1);
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)1);
        pTmp[linkageOffset++] = 9;
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)48);
        linkageOffset = SsuTsPackageBuilder.alterU24ToU8(pTmp, linkageOffset, info.getManufacturerId() & 0xFFFFFF);
        pTmp[linkageOffset++] = 44;
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)info.getDownloadPid());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getHardwareVersion());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getSoftwareVersion());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getStartSn());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getEndSn());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, 0);
        linkageOffset = SsuTsPackageBuilder.alterU4ToU8(pTmp, linkageOffset, upgradeType);
        linkageOffset = SsuTsPackageBuilder.alterU8ToU8(pTmp, linkageOffset, (short)0);
        linkageOffset = SsuTsPackageBuilder.alterU8ToU8(pTmp, linkageOffset, (short)0);
        linkageOffset = SsuTsPackageBuilder.alterU8ToU8(pTmp, linkageOffset, (short)0);
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, 0);
        pTmp[linkageOffset++] = (byte)delivery_flag;
        if (delivery_flag == 1) {
            linkageOffset = SsuTsPackageBuilder.createCable(cableFrequency, cableModulation, cableSymbolRate, pTmp, linkageOffset);
        } else if (delivery_flag == 3) {
            linkageOffset = SsuTsPackageBuilder.createTerrestrial(centre_frequency, bandwidth, constellation, pTmp, linkageOffset);
        }
        messageLen = linkageOffset - 11;
        int netWork_descriptors_length_index = 9;
        SsuTsPackageBuilder.alterU12ToU8(pTmp, netWork_descriptors_length_index, (short)messageLen);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + messageLen);
        int transport_stram_loop_length_index = pDSISection.buffLength.get();
        boolean transport_stram_loop_length = false;
        SsuTsPackageBuilder.alterU16ToU8(pTmp, transport_stram_loop_length_index, (short)(transport_stram_loop_length ? 1 : 0));
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 2);
        sectionLength = pDSISection.buffLength.get();
        stDSMCCHeader.section_length.set((long)sectionLength);
        SsuTsPackageBuilder.construct_NITHead(stDSMCCHeader, 64, 1);
        SsuTsPackageBuilder.construct_SecHead(stDSMCCHeader, pDSISection.pSectionBuff);
        crcDataLen = pDSISection.buffLength.get();
        u32CrcVal = Crc32.compute(pDSISection.pSectionBuff, 1, crcDataLen - 1);
        SsuTsPackageBuilder.alterU32ToU8(pDSISection.pSectionBuff, crcDataLen, u32CrcVal);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 4);
    }

    private static int createCable(double cableFrequency, int cableModulation, int cableSymbolRate, byte[] pTmp, int linkageOffset) {
        short temp = 0;
        pTmp[linkageOffset++] = 68;
        pTmp[linkageOffset++] = 11;
        String frequency = String.valueOf(cableFrequency);
        if (frequency.indexOf(".") > 0) {
            String[] result = frequency.split("\\.");
            Short frequencyResult = Short.parseShort(result[0]);
            linkageOffset = frequencyResult > 0 ? SsuTsPackageBuilder.alterU16BitToU8(pTmp, linkageOffset, frequencyResult, result[0]) : SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, temp);
            Short frequencyResult1 = Short.parseShort(result[1]);
            linkageOffset = frequencyResult1 > 0 ? SsuTsPackageBuilder.alterU16BitToU8(pTmp, linkageOffset, frequencyResult1, result[1]) : SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, temp);
        } else {
            linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (int)cableFrequency);
        }
        String symbolRate = String.valueOf(cableSymbolRate);
        int length = symbolRate.length();
        if (length > 3) {
            String result1Str = null;
            String result2Str = null;
            if (length == 4) {
                result1Str = symbolRate.substring(1, 4);
                result2Str = symbolRate.substring(0, 1);
            } else if (length == 5) {
                result1Str = symbolRate.substring(2, 5);
                result2Str = symbolRate.substring(0, 2);
            }
            if (result2Str != null) {
                Short result2 = Short.parseShort(result2Str);
                linkageOffset = result2 > 0 ? SsuTsPackageBuilder.alterU16BitToU8(pTmp, linkageOffset, result2, result2Str, (short)cableModulation) : SsuTsPackageBuilder.alterU16ByModulationToU8(pTmp, linkageOffset, (short)cableModulation);
            }
            if (result1Str != null) {
                Short result1 = Short.parseShort(result1Str);
                if (result1 > 0) {
                    result1 = (short)(result1 * 10);
                    result1Str = String.valueOf(result1Str) + "0";
                    linkageOffset = SsuTsPackageBuilder.alterU16BitToU8(pTmp, linkageOffset, result1, result1Str);
                } else {
                    linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, temp);
                }
            }
        } else {
            linkageOffset = SsuTsPackageBuilder.alterU16ByModulationToU8(pTmp, linkageOffset, (short)cableModulation);
            Short result1 = Short.parseShort(symbolRate);
            if (result1 > 0) {
                result1 = (short)(result1 * 10);
                symbolRate = String.valueOf(symbolRate) + "0";
                linkageOffset = SsuTsPackageBuilder.alterU16BitToU8(pTmp, linkageOffset, result1, symbolRate);
            } else {
                linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, temp);
            }
        }
        linkageOffset = SsuTsPackageBuilder.alterU24ToU8(pTmp, linkageOffset, temp);
        return linkageOffset;
    }

    private static int createTerrestrial(long centre_frequency, int bandwidth, int constellation, byte[] pTmp, int linkageOffset) {
        pTmp[linkageOffset++] = 90;
        pTmp[linkageOffset++] = 11;
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, centre_frequency);
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, bandwidth, 0, constellation, 1, 1);
        linkageOffset = SsuTsPackageBuilder.alterU8ToU8(pTmp, linkageOffset, 1, 2, 2, 1);
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, 0);
        return linkageOffset;
    }

    private void construct_BatSection(DSMCC_SectionInfo pDSISection, SsuUpgradeInfo info, SsuPackageOptions packageOtions) {
        int delivery_flag = packageOtions.getTransferModeCombo();
        long centre_frequency = packageOtions.getCentreFrequency();
        int bandwidth = packageOtions.getBandWidth();
        int constellation = packageOtions.getConstellation();
        int upgradeType = packageOtions.getUpgradeTypeCombo();
        double cableFrequency = packageOtions.getCableFrequency();
        int cableModulation = packageOtions.getCableModulation();
        int cableSymbolRate = packageOtions.getSymbolRate();
        if (delivery_flag == 1) {
            delivery_flag = 3;
        } else if (delivery_flag == 0) {
            delivery_flag = 1;
        }
        pDSISection.pSectionBuff = new byte[1024];
        pDSISection.buffLength.set(0);
        DSMCCSectionHead stDSMCCHeader = new DSMCCSectionHead();
        int u32CrcVal = 0;
        int crcDataLen = 0;
        int messageLen = 0;
        pDSISection.pSectionBuff = new byte[1024];
        pDSISection.buffLength.set(0);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 8 + 1);
        byte[] pTmp = pDSISection.pSectionBuff;
        int offset = pDSISection.buffLength.get();
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 2);
        int linkageOffset = pDSISection.buffLength.get();
        pTmp[linkageOffset++] = 74;
        pTmp[linkageOffset++] = 57;
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)1);
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)1);
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)1);
        pTmp[linkageOffset++] = 9;
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)48);
        linkageOffset = SsuTsPackageBuilder.alterU24ToU8(pTmp, linkageOffset, info.getManufacturerId() & 0xFFFFFF);
        pTmp[linkageOffset++] = 44;
        linkageOffset = SsuTsPackageBuilder.alterU16ToU8(pTmp, linkageOffset, (short)info.getDownloadPid());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getHardwareVersion());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getSoftwareVersion());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getStartSn());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, (long)info.getEndSn());
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, 0);
        linkageOffset = SsuTsPackageBuilder.alterU4ToU8(pTmp, linkageOffset, upgradeType);
        linkageOffset = SsuTsPackageBuilder.alterU8ToU8(pTmp, linkageOffset, (short)0);
        linkageOffset = SsuTsPackageBuilder.alterU8ToU8(pTmp, linkageOffset, (short)0);
        linkageOffset = SsuTsPackageBuilder.alterU8ToU8(pTmp, linkageOffset, (short)0);
        linkageOffset = SsuTsPackageBuilder.alterU32ToU8(pTmp, linkageOffset, 0);
        pTmp[linkageOffset++] = (byte)delivery_flag;
        if (delivery_flag == 1) {
            linkageOffset = SsuTsPackageBuilder.createCable(cableFrequency, cableModulation, cableSymbolRate, pTmp, linkageOffset);
        } else if (delivery_flag == 3) {
            linkageOffset = SsuTsPackageBuilder.createTerrestrial(centre_frequency, bandwidth, constellation, pTmp, linkageOffset);
        }
        messageLen = linkageOffset - 11;
        int netWork_descriptors_length_index = 9;
        SsuTsPackageBuilder.alterU12ToU8(pTmp, netWork_descriptors_length_index, (short)messageLen);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + messageLen);
        int transport_stram_loop_length_index = pDSISection.buffLength.get();
        boolean transport_stram_loop_length = false;
        SsuTsPackageBuilder.alterU16ToU8(pTmp, transport_stram_loop_length_index, (short)(transport_stram_loop_length ? 1 : 0));
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 2);
        offset = pDSISection.buffLength.get();
        stDSMCCHeader.section_length.set((long)offset);
        SsuTsPackageBuilder.construct_NITHead(stDSMCCHeader, 74, 0);
        SsuTsPackageBuilder.construct_SecHead(stDSMCCHeader, pDSISection.pSectionBuff);
        crcDataLen = pDSISection.buffLength.get();
        u32CrcVal = Crc32.compute(pDSISection.pSectionBuff, 1, crcDataLen - 1);
        SsuTsPackageBuilder.alterU32ToU8(pDSISection.pSectionBuff, crcDataLen, u32CrcVal);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 4);
    }

    private static void construct_DSISection(DSMCC_SectionInfo pDSISection) {
        DSMCCSectionHead stDSMCCHeader = new DSMCCSectionHead();
        DSMCCMessageHeader stDsmccMsgHeader = new DSMCCMessageHeader();
        int u32CrcVal = 0;
        int crcDataLen = 0;
        byte[] serviceId = new byte[20];
        int privateLength = 0;
        pDSISection.pSectionBuff = new byte[1024];
        pDSISection.buffLength.set(0);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 8 + 1);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + stDsmccMsgHeader.size());
        SsuTsPackageBuilder.memset(serviceId, 255, serviceId.length);
        SsuTsPackageBuilder.memcpy(pDSISection.pSectionBuff, pDSISection.buffLength.get(), serviceId, (short)serviceId.length);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + serviceId.length);
        byte[] pTmp = pDSISection.pSectionBuff;
        int offset = pDSISection.buffLength.get();
        boolean outCompatibility = false;
        SsuTsPackageBuilder.alterU16ToU8(pTmp, offset, (short)(outCompatibility ? 1 : 0));
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 2);
        offset = pDSISection.buffLength.get() + 2;
        privateLength = SsuTsPackageBuilder.construct_GroupInfoIndication(pTmp, offset, privateLength);
        offset = pDSISection.buffLength.get();
        SsuTsPackageBuilder.alterU16ToU8(pTmp, offset, (short)privateLength);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + privateLength + 2);
        int messageLen = privateLength + serviceId.length + 2 + 2;
        offset = 9;
        SsuTsPackageBuilder.construct_DSMCCMessageHeader(pTmp, 4102, 0, messageLen, offset);
        stDSMCCHeader.section_length.set((long)(5 + stDsmccMsgHeader.size() + messageLen + 4));
        SsuTsPackageBuilder.construct_DSIHead(stDSMCCHeader, 59, 0);
        SsuTsPackageBuilder.construct_SecHead(stDSMCCHeader, pDSISection.pSectionBuff);
        crcDataLen = (int)(stDSMCCHeader.section_length.get() + 3L - 4L);
        u32CrcVal = Crc32.compute(pDSISection.pSectionBuff, 1, crcDataLen);
        SsuTsPackageBuilder.alterU32ToU8(pDSISection.pSectionBuff, 1 + crcDataLen, u32CrcVal);
        pDSISection.buffLength.set(pDSISection.buffLength.get() + 4);
    }

    private static void construct_BATTHead(DSMCCSectionHead pSectionHead, int tableID, int tableIdExt) {
        pSectionHead.table_id.set((long)tableID);
        pSectionHead.section_syntax_indicator.set(1L);
        pSectionHead.private_indicator.set(0L);
        pSectionHead.reserved.set(0L);
        pSectionHead.table_id_extension.set((long)tableIdExt);
        pSectionHead.reserved_2.set(0L);
        pSectionHead.version_number.set(0L);
        pSectionHead.current_next_indicator.set(0L);
        pSectionHead.section_number.set(0L);
        pSectionHead.last_section_number.set(0L);
    }

    private static void construct_NITHead(DSMCCSectionHead pSectionHead, int tableID, int tableIdExt) {
        pSectionHead.table_id.set((long)tableID);
        pSectionHead.section_syntax_indicator.set(1L);
        pSectionHead.private_indicator.set(0L);
        pSectionHead.reserved.set(0L);
        pSectionHead.table_id_extension.set((long)tableIdExt);
        pSectionHead.reserved_2.set(0L);
        pSectionHead.version_number.set(0L);
        pSectionHead.current_next_indicator.set(1L);
        pSectionHead.section_number.set(0L);
        pSectionHead.last_section_number.set(0L);
    }

    private static void construct_DSIHead(DSMCCSectionHead pSectionHead, int tableID, int tableIdExt) {
        pSectionHead.table_id.set((long)tableID);
        pSectionHead.section_syntax_indicator.set(1L);
        pSectionHead.table_id_extension.set((long)tableIdExt);
        pSectionHead.version_number.set(0L);
        pSectionHead.current_next_indicator.set(1L);
        pSectionHead.version_number.set(0L);
        pSectionHead.section_number.set(0L);
        pSectionHead.last_section_number.set(1L);
    }

    private static int construct_GroupInfoIndication(byte[] pBuff, int offset, int pLen) {
        int f = 0;
        int descOffset = offset;
        GroupInfoIndication stGII = new GroupInfoIndication();
        int descpLen = pLen;
        descpLen = 0;
        stGII.numberOfGroup.set(1);
        descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)stGII.numberOfGroup.get());
        descpLen += 2;
        f = 0;
        while (f < stGII.numberOfGroup.get()) {
            stGII.groupDescription[f].groupId.set((long)SsuTsPackageBuilder.getG_u32GroupId());
            stGII.groupDescription[f].setGroupSize(g_u32DataTotalLen);
            descOffset = SsuTsPackageBuilder.alterU32ToU8(pBuff, descOffset, (int)stGII.groupDescription[f].groupId.get());
            if (SsuTsPackageBuilder.isHi3798CV200()) {
                descOffset = SsuTsPackageBuilder.alterU32ToU8(pBuff, descOffset, (int)stGII.groupDescription[f].getGroupSize());
                descpLen += 8;
            } else if (SsuTsPackageBuilder.isIs32Bit()) {
                descOffset = SsuTsPackageBuilder.alterU32ToU8(pBuff, descOffset, (int)stGII.groupDescription[f].getGroupSize());
                descpLen += 8;
            } else {
                descOffset = SsuTsPackageBuilder.alterU64ToU8(pBuff, descOffset, stGII.groupDescription[f].getGroupSize());
                descpLen += 12;
            }
            CompatibilityDescriptor pstCompDes = stGII.groupDescription[f].groupCompatibility;
            pstCompDes.descriptorCount.set(4);
            pstCompDes.compatibilityDescriptorLength.set((subCompatibilityDescriptor.size() - 4) * pstCompDes.descriptorCount.get() + 2);
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.compatibilityDescriptorLength.get());
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptorCount.get());
            descpLen += 4;
            pstCompDes.descriptor[0].descriptorType.set((short)1);
            pstCompDes.descriptor[0].descriptorLength.set((short)9);
            pstCompDes.descriptor[0].specifierType.set(1L);
            pstCompDes.descriptor[0].specifierData.set(SsuTsPackageBuilder.getG_FactoryIdFlag() & 0xFFFFFFL);
            pstCompDes.descriptor[0].model.set((int)((SsuTsPackageBuilder.getG_HardwareVersion() & 0xFFFFFFFFFFFF0000L) >>> 16));
            pstCompDes.descriptor[0].version.set((int)(SsuTsPackageBuilder.getG_HardwareVersion() & 0xFFFFL));
            pstCompDes.descriptor[0].subDescriptorCount.set((short)0);
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[0].descriptorType.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[0].descriptorLength.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[0].specifierType.get();
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[0].specifierData.get() & 0xFF0000L) >>> 16);
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[0].specifierData.get() & 0xFF00L) >>> 8);
            pBuff[descOffset++] = (byte)(pstCompDes.descriptor[0].specifierData.get() & 0xFFL);
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[0].model.get());
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[0].version.get());
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[0].subDescriptorCount.get();
            descpLen += subCompatibilityDescriptor.size() - 4;
            pstCompDes.descriptor[1].descriptorType.set((short)2);
            pstCompDes.descriptor[1].descriptorLength.set((short)9);
            pstCompDes.descriptor[1].specifierType.set(1L);
            pstCompDes.descriptor[1].specifierData.set(SsuTsPackageBuilder.getG_FactoryIdFlag() & 0xFFFFFFL);
            pstCompDes.descriptor[1].model.set((int)((SsuTsPackageBuilder.getG_softwareVersion() & 0xFFFFFFFFFFFF0000L) >>> 16));
            pstCompDes.descriptor[1].version.set((int)(SsuTsPackageBuilder.getG_softwareVersion() & 0xFFFFL));
            pstCompDes.descriptor[1].subDescriptorCount.set((short)0);
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[1].descriptorType.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[1].descriptorLength.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[1].specifierType.get();
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[1].specifierData.get() & 0xFF0000L) >>> 16);
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[1].specifierData.get() & 0xFF00L) >>> 8);
            pBuff[descOffset++] = (byte)(pstCompDes.descriptor[1].specifierData.get() & 0xFFL);
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[1].model.get());
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[1].version.get());
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[1].subDescriptorCount.get();
            descpLen += subCompatibilityDescriptor.size() - 4;
            pstCompDes.descriptor[2].descriptorType.set((short)64);
            pstCompDes.descriptor[2].descriptorLength.set((short)9);
            pstCompDes.descriptor[2].specifierType.set(1L);
            pstCompDes.descriptor[2].specifierData.set(SsuTsPackageBuilder.getG_FactoryIdFlag() & 0xFFFFFFL);
            pstCompDes.descriptor[2].model.set((int)((SsuTsPackageBuilder.getG_start_sn() & 0xFFFFFFFFFFFF0000L) >>> 16));
            pstCompDes.descriptor[2].version.set((int)(SsuTsPackageBuilder.getG_start_sn() & 0xFFFFL));
            pstCompDes.descriptor[2].subDescriptorCount.set((short)0);
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[2].descriptorType.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[2].descriptorLength.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[2].specifierType.get();
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[2].specifierData.get() & 0xFF0000L) >>> 16);
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[2].specifierData.get() & 0xFF00L) >>> 8);
            pBuff[descOffset++] = (byte)(pstCompDes.descriptor[2].specifierData.get() & 0xFFL);
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[2].model.get());
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[2].version.get());
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[2].subDescriptorCount.get();
            descpLen += subCompatibilityDescriptor.size() - 4;
            pstCompDes.descriptor[3].descriptorType.set((short)65);
            pstCompDes.descriptor[3].descriptorLength.set((short)9);
            pstCompDes.descriptor[3].specifierType.set(1L);
            pstCompDes.descriptor[3].specifierData.set(SsuTsPackageBuilder.getG_FactoryIdFlag() & 0xFFFFFFL);
            pstCompDes.descriptor[3].model.set((int)((SsuTsPackageBuilder.getG_end_sn() & 0xFFFFFFFFFFFF0000L) >>> 16));
            pstCompDes.descriptor[3].version.set((int)(SsuTsPackageBuilder.getG_end_sn() & 0xFFFFL));
            pstCompDes.descriptor[3].subDescriptorCount.set((short)0);
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[3].descriptorType.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[3].descriptorLength.get();
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[3].specifierType.get();
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[3].specifierData.get() & 0xFF0000L) >>> 16);
            pBuff[descOffset++] = (byte)((pstCompDes.descriptor[3].specifierData.get() & 0xFF00L) >>> 8);
            pBuff[descOffset++] = (byte)(pstCompDes.descriptor[3].specifierData.get() & 0xFFL);
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[3].model.get());
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)pstCompDes.descriptor[3].version.get());
            pBuff[descOffset++] = (byte)pstCompDes.descriptor[3].subDescriptorCount.get();
            descpLen += subCompatibilityDescriptor.size() - 4;
            stGII.groupDescription[f].goupInfoLength.set(0);
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)stGII.groupDescription[f].goupInfoLength.get());
            descpLen += 2;
            stGII.groupDescription[f].privateLength.set(0);
            descOffset = SsuTsPackageBuilder.alterU16ToU8(pBuff, descOffset, (short)stGII.groupDescription[f].privateLength.get());
            descpLen += 2;
            f = (short)(f + 1);
        }
        return descpLen;
    }

    private static int alterU32LowToU8(byte[] pu8Data, int offset, int u32Data) {
        pu8Data[offset] = 0;
        pu8Data[offset + 1] = 0;
        pu8Data[offset + 2] = 0;
        pu8Data[offset + 3] = (byte)(u32Data & 0xFF);
        return offset + 4;
    }

    public static void memcpy(byte[] pTmp, int offset, String string, long len) {
        if (len > (long)string.length()) {
            len = string.length();
        }
        int i = 0;
        while ((long)i < len) {
            pTmp[offset++] = (byte)string.charAt(i);
            ++i;
        }
    }

    private static List<PartFile> fillFileDataStruct(List<UpgradeFileInfo> files) {
        long u32DatagramNum = 0L;
        g_u32DataTotalLen = 0L;
        g_u32DataCrc = -1;
        ArrayList<PartFile> headers = new ArrayList<PartFile>(files.size());
        int i = 0;
        while (i < files.size()) {
            PartFile partFile = new PartFile();
            headers.add(partFile);
            partFile.init(files.get(i), SsuTsPackageBuilder.getG_u32GroupId(), i);
            long fileLength = new File(partFile.fileName).length();
            g_u32DataTotalLen += new File(partFile.fileName).length();
            long lastSectionLength = 4066L;
            u32DatagramNum = fileLength / 4066L;
            if (0L != fileLength % 4066L) {
                lastSectionLength = fileLength % 4066L;
                ++u32DatagramNum;
            }
            partFile.datagramNum.set(u32DatagramNum);
            partFile.setLastDiagramDataLength(lastSectionLength);
            partFile.setSectionNum(u32DatagramNum);
            try {
                int[] crc = Crc32.compute(partFile.fileName, g_u32DataCrc);
                partFile.crcValue.set((long)crc[0]);
                g_u32DataCrc = crc[1];
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return headers;
    }

    @Override
    public IStatus createPackage(List<UpgradeFileInfo> fileInfoList, UpgradeInfo info, String tsFileName, IProgressMonitor monitor) throws IOException, HiLoaderException {
        return null;
    }
}

