/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager.ui;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.api.IConnectionManager;
import org.soyatec.connector.api.IModifiedListener;
import org.soyatec.connector.api.ISettings;
import org.soyatec.connector.api.i2c.I2cConnection;
import org.soyatec.connector.api.i2c.II2cSettings;
import org.soyatec.connector.api.serial.ISerialSettings;
import org.soyatec.connector.api.serial.SerialConnection;
import org.soyatec.connector.api.serial.exceptions.PortBusyException;
import org.soyatec.connector.api.serial.exceptions.PortNotFoundException;
import org.soyatec.connector.api.telnet.ITelnetSettings;
import org.soyatec.connector.api.telnet.TelnetConnection;
import org.soyatec.connector.api.ui.config.i2c.I2cSetting;
import org.soyatec.connector.api.ui.config.serial.SerialSettings;
import org.soyatec.connector.api.ui.config.telnet.TelnetSetting;
import org.soyatec.connector.manager.ConnectionManager;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.ISettingsPage;
import org.soyatec.connector.manager.Messages;
import org.soyatec.connector.manager.PageBook;
import org.soyatec.connector.manager.i2c.I2cConnectorSetting;
import org.soyatec.connector.manager.preferences.Preferences;
import org.soyatec.connector.manager.serial.SerialConnectorSetting;
import org.soyatec.connector.manager.telnet.TelnetConnectorSetting;
import org.soyatec.exceptions.TelnetLoginException;
import org.soyatec.exceptions.TimeoutException;

public class ConnectionManagerDialog
extends Dialog
implements IModifiedListener {
    private static final int ADD_ID = 1025;
    private static final int SAVE_AND_CONNECT_ID = 1026;
    private static final int DELETE_ID = 1027;
    private static final int CLOSE_ID = 1028;
    private static final int CONNECT_ID = 1029;
    final Pattern namePattern = Pattern.compile("[0-9a-z-A-Z|/[^u4E00-u9FA5]/g]{0,30}");
    private ConnectionManager connectionManager = ConnectionManager.INSTANCE;
    private String title = Messages.ConnectionManagerDialog_Title;
    private IConnectorSetting[] fConnectors;
    private Combo connectorTypeCombo;
    private PageBook fPageBook;
    private int fSelectedConnector = -1;
    private ISettingsPage[] fPages;
    private int[] fPageIndex;
    private int fNPages;
    private Button close;
    private Button connectBtn;
    private boolean isClickCloseBtn;

    public ConnectionManagerDialog(Shell shell, IConnectorSetting[] connectors, IConnectorSetting connector) {
        super(shell);
        this.fConnectors = (IConnectorSetting[])connectors.clone();
        this.fPages = new ISettingsPage[this.fConnectors.length];
        this.fPageIndex = new int[this.fConnectors.length];
        this.fSelectedConnector = -1;
        int i = 0;
        while (i < this.fConnectors.length) {
            if (connector.getName().equals(this.fConnectors[i].getName())) {
                this.fSelectedConnector = i;
                this.fConnectors[i] = connector;
                break;
            }
            ++i;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (1029 == buttonId) {
            this.addPressed();
            this.connectCurrent();
            this.close();
            this.isClickCloseBtn = false;
        }
        if (1028 == buttonId) {
            this.close();
            this.isClickCloseBtn = true;
        }
        super.buttonPressed(buttonId);
    }

    private void connectCurrent() {
        ConnectionManager m = ConnectionManager.INSTANCE;
        String name = this.connectorTypeCombo.getText();
        m.setCurrentSettings(name);
        String currentSettings = m.getCurrentSettingKey();
        IConnectorSetting connectionSettings = m.getConnectionSettingsByKey(currentSettings);
        String currentSettingName = this.connectionManager.getCurrentSettingName();
        System.out.println(currentSettingName);
        if (connectionSettings instanceof SerialConnectorSetting) {
            try {
                SerialConnection connection = SerialConnection.createConnection((ISerialSettings)((SerialConnectorSetting)connectionSettings).getSerialSettings());
                if (connection != null) {
                    m.addConnection(connectionSettings, (IConnection<?>)connection);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.ConnectingAction_SerialPort_Connecting_failed, (Object)((SerialConnectorSetting)connectionSettings).getSerialSettings().getSerialPort()));
            }
            catch (PortNotFoundException e) {
                e.printStackTrace();
            }
            catch (PortBusyException e) {
                e.printStackTrace();
            }
            catch (UnsupportedCommOperationException e) {
                e.printStackTrace();
            }
        } else if (connectionSettings instanceof TelnetConnectorSetting) {
            this.connect(m, (TelnetConnectorSetting)connectionSettings);
        } else if (connectionSettings instanceof I2cConnectorSetting) {
            try {
                I2cConnection connection = I2cConnection.createConnection((II2cSettings)((I2cConnectorSetting)connectionSettings).getI2cSettings());
                if (connection != null) {
                    m.addConnection(connectionSettings, (IConnection<?>)connection);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void connect(final ConnectionManager m, final TelnetConnectorSetting connector) {
        Job job = new Job("Connecting"){

            protected IStatus run(IProgressMonitor monitor) {
                String[] err;
                block9: {
                    err = new String[1];
                    TelnetSetting telnetSetting = connector.getTelnetSetting();
                    TelnetConnection connection = null;
                    try {
                        connection = TelnetConnection.createConnection((ITelnetSettings)telnetSetting);
                        if (connection != null) {
                            boolean login = connection.login();
                            if (login) {
                                m.addConnection(connector, (IConnection<?>)connection);
                            }
                            connection.setConnectionManager((IConnectionManager)m);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        err[0] = NLS.bind((String)Messages.ConnectingAction_Failed_to_Connect_Telnet, (Object)(String.valueOf(telnetSetting.getHost()) + ":" + telnetSetting.getNetworkPort()));
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (TimeoutException e) {
                        e.printStackTrace();
                        err[0] = NLS.bind((String)Messages.ConnectingAction_Telnet_Timeout, (Object)(String.valueOf(telnetSetting.getHost()) + ":" + telnetSetting.getNetworkPort()));
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (TelnetLoginException e) {
                        e.printStackTrace();
                        err[0] = Messages.ConnectingAction_Telnet_Login_Error;
                        if (connection == null) break block9;
                        connection.close();
                    }
                }
                if (err[0] != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)err[0]);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void addPressed() {
        ISettingsPage page = this.getPage(this.fSelectedConnector);
        page.save();
        IConnectorSetting connectionSetting = this.getConnectorSetting();
        if (connectionSetting == null) {
            return;
        }
        String name = this.connectorTypeCombo.getText();
        if (connectionSetting instanceof SerialConnectorSetting) {
            SerialSettings serialSettings = ((SerialConnectorSetting)connectionSetting).getSerialSettings();
            SerialConnectorSetting newSetting = new SerialConnectorSetting(serialSettings);
            newSetting.setName(name);
            this.connectionManager.clearAllConnectionSettings();
            this.connectionManager.addConnectionSettings(newSetting);
        } else if (connectionSetting instanceof TelnetConnectorSetting) {
            TelnetSetting telnetSetting = ((TelnetConnectorSetting)connectionSetting).getTelnetSetting();
            TelnetConnectorSetting newSetting = new TelnetConnectorSetting(telnetSetting);
            newSetting.setName(name);
            this.connectionManager.clearAllConnectionSettings();
            this.connectionManager.addConnectionSettings(newSetting);
        } else if (connectionSetting instanceof I2cConnectorSetting) {
            I2cSetting i2cSetting = ((I2cConnectorSetting)connectionSetting).getI2cSettings();
            I2cConnectorSetting newSetting = new I2cConnectorSetting(i2cSetting);
            newSetting.setName(name);
            this.connectionManager.clearAllConnectionSettings();
            this.connectionManager.addConnectionSettings(newSetting);
        }
        Preferences.saveConnectorSettings();
    }

    public IConnectorSetting getConnectorSetting() {
        if (this.fSelectedConnector >= 0) {
            return this.fConnectors[this.fSelectedConnector];
        }
        return null;
    }

    private void refreshDataAndEnableButtons() {
        String key = String.valueOf(this.connectorTypeCombo.getText()) + "ID";
        IConnectorSetting connectionSetting = this.connectionManager.getConnectionSettingsByKey(key);
        this.updateFields(connectionSetting);
    }

    public void create() {
        super.create();
        this.getShell().pack();
    }

    protected void setShellSize(Point size) {
        Rectangle bounds = this.getShell().getMonitor().getClientArea();
        this.getShell().setSize(Math.min(size.x, bounds.width), Math.min(size.y, bounds.height));
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        this.setUpPanels(control);
        this.installListeners();
        this.intFields();
        return control;
    }

    private void updateSelection(Combo c, String text) {
        if (c == null || text == null) {
            return;
        }
        int indexOf = c.indexOf(text);
        if (indexOf == -1) {
            return;
        }
        c.select(indexOf);
    }

    private void installListeners() {
        if (this.connectorTypeCombo == null) {
            return;
        }
        this.connectorTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectionManagerDialog.this.selectPage(ConnectionManagerDialog.this.connectorTypeCombo.getSelectionIndex());
                ConnectionManagerDialog.this.refreshDataAndEnableButtons();
            }
        });
        this.checkConnectBtn();
    }

    private void checkConnectBtn() {
        IConnection<?> activeConnection = ConnectionManager.INSTANCE.getActiveConnection();
        if (activeConnection != null && activeConnection.isConnected()) {
            this.connectBtn.setEnabled(false);
        } else {
            this.connectBtn.setEnabled(true);
        }
    }

    protected void updateFields(IConnectorSetting connectionSetting) {
        if (connectionSetting == null) {
            return;
        }
        if (connectionSetting instanceof SerialConnectorSetting) {
            IConnectorSetting[] iConnectorSettingArray = this.fConnectors;
            int n = this.fConnectors.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorSetting settings = iConnectorSettingArray[n2];
                if (settings instanceof SerialConnectorSetting) {
                    this.updateSelection(this.connectorTypeCombo, settings.getType());
                    ((SerialConnectorSetting)settings).getSerialSettings().update(((SerialConnectorSetting)connectionSetting).getSerialSettings());
                    break;
                }
                ++n2;
            }
        } else if (connectionSetting instanceof TelnetConnectorSetting) {
            IConnectorSetting[] iConnectorSettingArray = this.fConnectors;
            int n = this.fConnectors.length;
            int n3 = 0;
            while (n3 < n) {
                IConnectorSetting connectorSetting = iConnectorSettingArray[n3];
                if (connectorSetting instanceof TelnetConnectorSetting) {
                    this.updateSelection(this.connectorTypeCombo, connectorSetting.getType());
                    TelnetConnectorSetting tconnectorSetting = (TelnetConnectorSetting)connectorSetting;
                    TelnetSetting telnetSetting = tconnectorSetting.getTelnetSetting();
                    telnetSetting.update((ITelnetSettings)((TelnetConnectorSetting)connectionSetting).getTelnetSetting());
                    break;
                }
                ++n3;
            }
        } else if (connectionSetting instanceof I2cConnectorSetting) {
            IConnectorSetting[] iConnectorSettingArray = this.fConnectors;
            int n = this.fConnectors.length;
            int n4 = 0;
            while (n4 < n) {
                IConnectorSetting settings = iConnectorSettingArray[n4];
                if (settings instanceof I2cConnectorSetting) {
                    this.updateSelection(this.connectorTypeCombo, settings.getType());
                    ((I2cConnectorSetting)settings).getI2cSettings().update(((I2cConnectorSetting)connectionSetting).getI2cSettings());
                    break;
                }
                ++n4;
            }
        }
        this.selectPage(this.connectorTypeCombo.getSelectionIndex());
    }

    private void setUpPanels(Composite parent) {
        this.setUpConnectorPanel(parent);
    }

    private void setUpConnectorPanel(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        Group wndGroup = new Group(control, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        GridData gridData = new GridData(768);
        wndGroup.setLayout((Layout)gridLayout);
        wndGroup.setLayoutData((Object)gridData);
        wndGroup.setText(Messages.ConnectionManagerDialog_ConnectionType);
        this.connectorTypeCombo = new Combo((Composite)wndGroup, 8);
        GridData comboGD = new GridData(768);
        this.connectorTypeCombo.setLayoutData((Object)comboGD);
        this.setUpSettingPage(control);
        Composite actionBarControl = new Composite(control, 0);
        actionBarControl.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        actionBarControl.setLayoutData((Object)layoutData);
        this.buttonBar = this.createButtonBar(actionBarControl);
    }

    private void setUpSettingPage(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ConnectionManagerDialog_Settings);
        group.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        this.fPageBook = new PageBook((Composite)group, 0);
        this.fPageBook.setLayoutData(new GridData(768));
    }

    private void intFields() {
        int i = 0;
        while (i < this.fConnectors.length) {
            this.connectorTypeCombo.add(this.fConnectors[i].getType());
            ++i;
        }
        int selectedConnector = this.getInitialConnector();
        if (selectedConnector >= 0) {
            this.connectorTypeCombo.select(selectedConnector);
            this.selectPage(selectedConnector);
        }
    }

    private int getInitialConnector() {
        if (this.fSelectedConnector >= 0) {
            return this.fSelectedConnector;
        }
        int i = 0;
        while (i < this.fConnectors.length) {
            if (this.fConnectors[i] instanceof TelnetConnectorSetting) {
                return i;
            }
            ++i;
        }
        if (this.fConnectors.length > 0) {
            return 0;
        }
        return -1;
    }

    private void selectPage(int index) {
        this.fSelectedConnector = index;
        ISettingsPage page = this.getPage(index);
        Control[] pages = this.fPageBook.getChildren();
        this.fPageBook.showPage(pages[this.fPageIndex[this.fSelectedConnector]]);
        page.load();
    }

    ISettingsPage getPage(int i) {
        if (this.fPages[i] == null) {
            if (this.fConnectors[i].getInitializationErrorMessage() != null) {
                final IConnectorSetting conn = this.fConnectors[i];
                this.fPages[i] = new ISettingsPage(){

                    @Override
                    public void createControl(PageBook fPageBook) {
                        Label l = new Label((Composite)fPageBook, 64);
                        String error = String.valueOf(conn.getType()) + " Connector not available.";
                        l.setText(error);
                        l.setForeground(l.getDisplay().getSystemColor(3));
                        String msg = "Can't initalize Connector " + conn.getType() + "\t" + conn.getInitializationErrorMessage();
                        MessageBox mb = new MessageBox(ConnectionManagerDialog.this.getShell(), 33);
                        mb.setText(error);
                        mb.setMessage(msg);
                        mb.open();
                    }

                    @Override
                    public void setModifiedListener(IModifiedListener l) {
                    }

                    @Override
                    public void save() {
                    }

                    @Override
                    public void load() {
                    }
                };
            } else {
                this.fPages[i] = this.fConnectors[i].makeSettingsPage();
                this.fPages[i].setModifiedListener(this);
            }
            this.fPages[i].createControl(this.fPageBook);
            ++this.fNPages;
            this.resize();
        }
        return this.fPages[i];
    }

    private void resize() {
        Point size = this.getShell().getSize();
        Point newSize = this.getShell().computeSize(-1, -1, true);
        newSize.x = Math.max(newSize.x, size.x);
        newSize.y = Math.max(newSize.y, size.y);
        if (newSize.x != size.x || newSize.y != size.y) {
            this.setShellSize(newSize);
        } else {
            this.fPageBook.getParent().layout();
        }
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        return super.open();
    }

    protected Point getInitialSize() {
        Point point = new Point(285, 400);
        this.setShellSize(point);
        return point;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ConnectionManagerDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData());
        this.connectBtn = this.createButton(parent, 1029, Messages.ConnectionManagerDialog_Connect, false);
        this.close = this.createButton(parent, 1028, Messages.ConnectionManagerDialog_Close, false);
        this.close.setVisible(true);
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(75);
        Point minSize = button.computeSize(-1, -1, true);
        gridData.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)gridData);
    }

    public static void main(String[] args) {
        IConnectorSetting[] connectors = new IConnectorSetting[]{new SerialConnectorSetting(), new TelnetConnectorSetting(), new I2cConnectorSetting()};
        ConnectionManagerDialog serialSettingDialog = new ConnectionManagerDialog(new Shell(), connectors, connectors[0]);
        int open = serialSettingDialog.open();
        if (open == 1) {
            return;
        }
    }

    public void modified(ISettings settings) {
    }

    public boolean isClickCloseBtn() {
        return this.isClickCloseBtn;
    }

    public void setClickCloseBtn(boolean isClickCloseBtn) {
        this.isClickCloseBtn = isClickCloseBtn;
    }
}

