/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.hi.HI_UNF_MCE;
import com.hisilicon.fastplay.model.Setting;
import com.hisilicon.fastplay.model.ts.StartupImage;
import com.hisilicon.fastplay.model.ts.TSParam;
import com.hisilicon.fastplay.processor.PrepareSetting;
import com.hisilicon.fastplay.processor.TSParamProcess;
import com.hisilicon.fastplay.ui.SettingComposite;
import com.hisilicon.fastplay.utility.FileUtil;
import com.hisilicon.fastplay.utility.HiToolUtils;
import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ANIComposite
extends SettingComposite {
    public static final String tsType = "ts";
    public static final String jpegType = "jpeg";
    private static final String fileType = "fileType";
    private static final String[] COLUMN_PROPS = new String[]{Messages.ANIComposite_32, Messages.ANIComposite_0, Messages.ANIComposite_5};
    private Composite control;
    private Group grp;
    private Button jpeg;
    private Button ts;
    private Text videoTxt;
    private Text audioTxt;
    private Combo videoCombo;
    private Combo audioCombo;
    protected TSParam jpegParam;
    private TSParam tsParam;
    private TSParam aniParam;
    private String[] jpgForamt = new String[]{".jpg", ".JPG", ".jpeg"};

    public ANIComposite(Composite parent, Setting setting) {
        super(parent, setting);
    }

    @Override
    public PrepareSetting getSetting() {
        return (PrepareSetting)super.getSetting();
    }

    private TSParam getAniParam(String type) {
        if (jpegType.equals(type)) {
            return this.jpegParam;
        }
        return this.tsParam;
    }

    private void initParam() {
        this.jpegParam = new TSParam(jpegType);
        this.tsParam = new TSParam(tsType);
    }

    @Override
    protected Control createControl(Composite parent) {
        this.initParam();
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        this.control.setLayout((Layout)layout);
        this.createFileType(this.control);
        this.createTsComposite(this.control);
        return this.control;
    }

    private Control createTsComposite(Composite control) {
        Composite tsComposite = new Composite(control, 2048);
        tsComposite.setData((Object)tsType);
        GridLayout tsLayout = new GridLayout();
        tsLayout.verticalSpacing = 8;
        tsComposite.setLayout((Layout)tsLayout);
        tsComposite.setLayoutData((Object)new GridData(1808));
        Control tableControl = this.createImagesTable(tsComposite);
        tableControl.setLayoutData((Object)new GridData(1808));
        Control screenControl = this.createScreenControl(tsComposite);
        screenControl.setLayoutData((Object)new GridData(768));
        return tsComposite;
    }

    private Control createJpegComposite(Composite control) {
        Composite tsComposite = new Composite(control, 2048);
        tsComposite.setData((Object)jpegType);
        GridLayout tsLayout = new GridLayout();
        tsLayout.verticalSpacing = 8;
        tsComposite.setLayout((Layout)tsLayout);
        tsComposite.setLayoutData((Object)new GridData(1808));
        Control tableControl = this.createImagesTable(tsComposite);
        tableControl.setLayoutData((Object)new GridData(1808));
        return tsComposite;
    }

    private Control createFileType(Composite parent) {
        Composite composite = new Composite(parent, 128);
        composite.setData((Object)fileType);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 20;
        composite.setLayout((Layout)gridLayout);
        Label fileType = new Label(composite, 128);
        fileType.setText(Messages.ANIComposite_24);
        this.jpeg = new Button(composite, 16);
        this.jpeg.setData((Object)jpegType);
        this.jpeg.setText(Messages.ANIComposite_25);
        this.jpeg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ANIComposite.this.disposeControl();
                ANIComposite.this.createJpegComposite(ANIComposite.this.control);
                ANIComposite.this.control.layout();
            }
        });
        this.ts = new Button(composite, 16);
        this.ts.setData((Object)tsType);
        this.ts.setText(Messages.ANIComposite_26);
        this.ts.setSelection(true);
        this.ts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ANIComposite.this.disposeControl();
                ANIComposite.this.createTsComposite(ANIComposite.this.control);
                ANIComposite.this.control.layout();
            }
        });
        return composite;
    }

    private void disposeControl() {
        Control[] children = this.control.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!(children[i] == null || children[i].getData() != null && children[i].getData().equals(fileType))) {
                children[i].dispose();
                children[i] = null;
            }
            ++i;
        }
    }

    private Control createScreenControl(Composite parent) {
        this.grp = new Group(parent, 0);
        this.grp.setText(Messages.ANIComposite_27);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 20;
        this.grp.setLayout((Layout)gridLayout);
        Label videoPid = new Label((Composite)this.grp, 0);
        videoPid.setText(Messages.ANIComposite_30);
        this.videoTxt = new Text((Composite)this.grp, 2048);
        this.videoTxt.setText("512");
        this.videoTxt.setTextLimit(4);
        this.fillHorizontal((Control)this.videoTxt);
        ANIComposite.addModifyListene(this.videoTxt);
        Label videoType = new Label((Composite)this.grp, 0);
        videoType.setText(Messages.ANIComposite_28);
        this.videoCombo = new Combo((Composite)this.grp, 8);
        this.videoCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.VDEC_TYPE.values()));
        this.videoCombo.select(0);
        this.fillHorizontal((Control)this.videoCombo);
        Label audioPid = new Label((Composite)this.grp, 0);
        audioPid.setText(Messages.ANIComposite_31);
        this.audioTxt = new Text((Composite)this.grp, 2048);
        this.audioTxt.setText("650");
        this.audioTxt.setTextLimit(4);
        ANIComposite.addModifyListene(this.audioTxt);
        this.fillHorizontal((Control)this.audioTxt);
        Label audioType = new Label((Composite)this.grp, 0);
        audioType.setText(Messages.ANIComposite_29);
        this.audioCombo = new Combo((Composite)this.grp, 8);
        this.audioCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.ADEC_TYPE.values()));
        this.audioCombo.select(0);
        this.fillHorizontal((Control)this.audioCombo);
        return this.grp;
    }

    private Control createImagesTable(Composite parent) {
        Composite tabComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabComposite.setLayout((Layout)layout);
        Composite tableParent = new Composite(tabComposite, 0);
        TableColumnLayout tcl = new TableColumnLayout();
        tableParent.setLayout((Layout)tcl);
        tableParent.setLayoutData((Object)new GridData(1808));
        this.createTable(tabComposite, tableParent, tcl);
        return tabComposite;
    }

    private void createTable(Composite control, Composite tableParent, TableColumnLayout tcl) {
        TableViewer viewer = new TableViewer(tableParent, 67586);
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        viewer.setColumnProperties(COLUMN_PROPS);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        if (this.aniParam != null) {
            this.aniParam.clear();
        }
        if (this.jpeg.getSelection()) {
            table.setData((Object)jpegType);
            int i = 0;
            while (i < COLUMN_PROPS.length) {
                TableColumn column = new TableColumn(table, 16384, i);
                column.setText(COLUMN_PROPS[i]);
                tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(i == 1 ? 12 : 1));
                ++i;
            }
            this.aniParam = this.getAniParam(jpegType);
        } else {
            table.setData((Object)tsType);
            TableColumn column = new TableColumn(table, 16384, 0);
            column.setText(COLUMN_PROPS[1]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
            this.aniParam = this.getAniParam(tsType);
        }
        viewer.setInput((Object)this.aniParam);
        Composite buttonComp = new Composite(control, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.pack = false;
        buttonComp.setLayout((Layout)rowLayout);
        Button addBtn = new Button(buttonComp, 0);
        addBtn.setText(Messages.ANIComposite_21);
        addBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dlg = new FileDialog(ANIComposite.this.getShell(), 4098);
                String open = dlg.open();
                if (open != null) {
                    String path = dlg.getFilterPath();
                    String[] names = dlg.getFileNames();
                    if (names == null || names.length < 0) {
                        return;
                    }
                    if (!ANIComposite.this.checkImageUpper(names.length)) {
                        return;
                    }
                    String sep = System.getProperty("file.separator");
                    String[] stringArray = names;
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        String fullPath = String.valueOf(path) + sep + fileName;
                        StartupImage newImage = new StartupImage();
                        newImage.setFilePath(fullPath);
                        if (ANIComposite.this.jpeg.getSelection()) {
                            if (!ANIComposite.this.checkJpegFormat(fullPath)) {
                                viewer.refresh();
                                if (ANIComposite.this.jpeg.getSelection()) {
                                    ANIComposite.this.resetImageNumber(viewer);
                                }
                                return;
                            }
                            newImage.setOpertionType(1);
                            ANIComposite.this.aniParam.getStartupImages().add(newImage);
                        } else {
                            if (!ANIComposite.this.checkTsFormat(fullPath)) {
                                viewer.refresh();
                                return;
                            }
                            ANIComposite.this.aniParam.getStartupImages().clear();
                            newImage.setOpertionType(0);
                            ANIComposite.this.aniParam.getStartupImages().add(newImage);
                        }
                        ++n2;
                    }
                    viewer.refresh();
                    if (ANIComposite.this.jpeg.getSelection()) {
                        ANIComposite.this.resetImageNumber(viewer);
                    }
                }
            }
        });
        Button delBtn = new Button(buttonComp, 0);
        delBtn.setText(Messages.ANIComposite_23);
        delBtn.setEnabled(false);
        delBtn.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selectionItems;
                StructuredSelection selection = (StructuredSelection)viewer.getSelection();
                selection.getFirstElement();
                TableItem[] tableItemArray = selectionItems = viewer.getTable().getSelection();
                int n = selectionItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    StartupImage theImage = (StartupImage)item.getData();
                    if (theImage != null) {
                        ANIComposite.this.aniParam.getStartupImages().remove(theImage);
                    }
                    ++n2;
                }
                viewer.refresh();
                ANIComposite.this.resetImageNumber(viewer);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                delBtn.setEnabled(firstElement != null);
            }
        });
        if (this.jpeg.getSelection()) {
            CellEditor[] cellEditorArray = new CellEditor[3];
            cellEditorArray[2] = new IntegerCellEditor((Composite)table);
            CellEditor[] editors = cellEditorArray;
            this.addCellEditor(viewer, editors);
        }
    }

    private void resetImageNumber(TableViewer viewer) {
        TableItem[] items = viewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            StartupImage theImage = (StartupImage)items[i].getData();
            theImage.setImgNum(i + 1);
            ++i;
        }
        viewer.refresh();
    }

    private void addCellEditor(TableViewer viewer, CellEditor[] editors) {
        viewer.setCellEditors(editors);
        viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                StartupImage img = null;
                if (value == null) {
                    return;
                }
                if (element instanceof StartupImage) {
                    img = (StartupImage)element;
                } else if (element instanceof TableItem) {
                    img = (StartupImage)((TableItem)element).getData();
                }
                int intValue = Integer.parseInt((String)value);
                if (intValue < 0) {
                    intValue = Math.abs(intValue);
                }
                if (intValue > 99999999) {
                    intValue = Integer.valueOf(String.valueOf(intValue).substring(0, 8));
                }
                if (img == null) {
                    return;
                }
                if (property.equals(COLUMN_PROPS[2])) {
                    img.setDelay(intValue);
                }
                viewer.refresh();
            }

            public Object getValue(Object element, String property) {
                if (!(element instanceof StartupImage)) {
                    return null;
                }
                if (property == null) {
                    return null;
                }
                StartupImage img = (StartupImage)element;
                if (property.equals(COLUMN_PROPS[2])) {
                    return Integer.toString(img.getDelay());
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                if (property == null) {
                    return true;
                }
                return !property.equals(COLUMN_PROPS[0]);
            }
        });
    }

    @Override
    protected Object getParam() {
        if (this.jpeg.getSelection()) {
            this.paramServer = new TSParamProcess();
            List<StartupImage> startupImages = this.jpegParam.getStartupImages();
            int len = startupImages.size();
            int[] msArray = new int[len];
            String[] srcFileName = new String[len];
            if (srcFileName.length < 1) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.TS_0);
                return null;
            }
            StartupImage image = null;
            int i = 0;
            while (i < len) {
                image = startupImages.get(i);
                msArray[i] = image.getDelay();
                srcFileName[i] = image.getFilePath();
                ++i;
            }
            this.jpegParam.setMsArray(msArray);
            this.jpegParam.setSrcFiles(srcFileName);
            this.jpegParam.setTsSrcPath(HiToolUtils.getInstallPath());
            this.getSetting().setParamObj(this.jpegParam);
        } else {
            this.tsParam.setVideoPid(Integer.parseInt(this.videoTxt.getText()));
            this.tsParam.setAudioPid(Integer.parseInt(this.audioTxt.getText()));
            this.tsParam.setVideoType(this.videoCombo.getSelectionIndex());
            this.tsParam.setAudioType(this.audioCombo.getSelectionIndex());
            List<StartupImage> startupImages = this.tsParam.getStartupImages();
            String[] srcFileName = new String[startupImages.size()];
            int i = 0;
            while (i < srcFileName.length) {
                srcFileName[i] = startupImages.get(i).getFilePath();
                ++i;
            }
            if (srcFileName.length < 1) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.TS_0);
                return null;
            }
            this.tsParam.setTsSrcPath(srcFileName[0]);
            this.getSetting().setParamObj(this.tsParam);
        }
        return this.getSetting().getParamObj();
    }

    @Override
    protected boolean checkInfo(Object objParam) {
        TSParam param = (TSParam)objParam;
        if (param.getActiontype() == null) {
            return true;
        }
        if (tsType.equals(param.getActiontype()) && !FileUtil.checkFileSize(param.getTsSrcPath())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SettingComposite_14, (String)Messages.TS_file_size_execed);
            return false;
        }
        return true;
    }

    private boolean checkJpegFormat(String fileName) {
        if (!new File(fileName).exists()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.ANIComposite_File_Not_Exists);
            return false;
        }
        int lastIndexOf = fileName.lastIndexOf(".");
        if (lastIndexOf == -1) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(fileName) + "\n" + Messages.ANIComposite_Image_Not_Valid));
            return false;
        }
        String tempStr = fileName.substring(fileName.lastIndexOf("."));
        if (!this.isJpgFormat(tempStr)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(fileName) + "\n" + Messages.ANIComposite_Image_Not_Valid));
            return false;
        }
        return true;
    }

    private boolean checkTsFormat(String fileName) {
        if (!new File(fileName).exists()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.ANIComposite_File_Not_Exists);
            return false;
        }
        return true;
    }

    private boolean checkImageUpper(int currentImgNum) {
        if (this.jpegParam != null && this.jpegParam.getStartupImages().size() + currentImgNum > 30) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.ANIComposite_image_upper);
            return false;
        }
        return true;
    }

    private boolean isJpgFormat(String postfix) {
        if (postfix == null) {
            return false;
        }
        String[] stringArray = this.jpgForamt;
        int n = this.jpgForamt.length;
        int n2 = 0;
        while (n2 < n) {
            String jpg = stringArray[n2];
            if (jpg.equals(postfix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected boolean checkAllTextValue() {
        if (!this.videoTxt.isDisposed() && !this.checkTextValue(this.videoTxt, 0, 8192)) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_VideoPID) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(8192))));
            return false;
        }
        if (!this.audioTxt.isDisposed() && !this.checkTextValue(this.audioTxt, 0, 8192)) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_AudioPID) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(8192))));
            return false;
        }
        return true;
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TSParam) {
                return ((TSParam)inputElement).getStartupImages().toArray();
            }
            return null;
        }
    }

    public static class IntegerCellEditor
    extends TextCellEditor {
        public IntegerCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(){

                public String isValid(Object object) {
                    if (!(object instanceof Integer)) {
                        String string;
                        block4: {
                            string = (String)object;
                            try {
                                if (string != null) break block4;
                                return null;
                            }
                            catch (NumberFormatException exception) {
                                return exception.getMessage();
                            }
                        }
                        Integer.parseInt(string);
                    }
                    return null;
                }
            });
        }

        public Object doGetValue() {
            if (super.doGetValue() == null || ((String)super.doGetValue()).length() <= 0) {
                return null;
            }
            String str = (String)super.doGetValue();
            if (str.length() > 8) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.commom_msg_warning, (String)Messages.ANIComposite_EnterIntNumbers);
                str = str.substring(0, 8);
            }
            try {
                Integer.valueOf(str);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)Messages.ValidInputDelay);
                return 0;
            }
            return str;
        }

        public void doSetValue(Object value) {
            if (value == null) {
                return;
            }
            ANIComposite.addModifyListene(this.text);
            super.doSetValue(value);
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof StartupImage) {
                StartupImage img = (StartupImage)element;
                switch (columnIndex) {
                    case 0: {
                        return img.getOpertionType() == 0 ? img.getFilePath() : String.valueOf(img.getImgNum());
                    }
                    case 1: {
                        return img.getFilePath();
                    }
                    case 2: {
                        return Integer.toString(img.getDelay());
                    }
                }
            }
            return null;
        }
    }
}

