/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.hi.HI_UNF_MCE;
import com.hisilicon.fastplay.hi.baseparam.HI_UNF_DISP;
import com.hisilicon.fastplay.hi.baseparam.HI_UNF_ENC_FMT_E;
import com.hisilicon.fastplay.model.Setting;
import com.hisilicon.fastplay.model.baseparam.AbstractBaseParam;
import com.hisilicon.fastplay.model.baseparam.Arc;
import com.hisilicon.fastplay.model.baseparam.BaseParam;
import com.hisilicon.fastplay.model.baseparam.Bt1120;
import com.hisilicon.fastplay.model.baseparam.Bt656;
import com.hisilicon.fastplay.model.baseparam.Cvbs;
import com.hisilicon.fastplay.model.baseparam.Dac;
import com.hisilicon.fastplay.model.baseparam.DispParamObj;
import com.hisilicon.fastplay.model.baseparam.Hdmi;
import com.hisilicon.fastplay.model.baseparam.I2SModeObj;
import com.hisilicon.fastplay.model.baseparam.I2s;
import com.hisilicon.fastplay.model.baseparam.Lcd;
import com.hisilicon.fastplay.model.baseparam.Mipi;
import com.hisilicon.fastplay.model.baseparam.MipiModeObj;
import com.hisilicon.fastplay.model.baseparam.MipiPanelCmdObj;
import com.hisilicon.fastplay.model.baseparam.Rgb;
import com.hisilicon.fastplay.model.baseparam.SoundHdmi;
import com.hisilicon.fastplay.model.baseparam.SoundParamObj;
import com.hisilicon.fastplay.model.baseparam.Spdif;
import com.hisilicon.fastplay.model.baseparam.SubParam;
import com.hisilicon.fastplay.model.baseparam.Svideo;
import com.hisilicon.fastplay.model.baseparam.Vga;
import com.hisilicon.fastplay.model.baseparam.WidgetParam;
import com.hisilicon.fastplay.model.baseparam.Ypbpr;
import com.hisilicon.fastplay.processor.PrepareSetting;
import com.hisilicon.fastplay.ui.DispMipiDialog;
import com.hisilicon.fastplay.ui.DispTimingDialog;
import com.hisilicon.fastplay.ui.InterFaceDialog;
import com.hisilicon.fastplay.ui.SettingComposite;
import com.hisilicon.fastplay.views.FastplayView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class BaseparamComposite
extends SettingComposite {
    public static final String[] mipiArray = new String[]{"MIPI_ID_0", "MIPI_ID_1"};
    public static final String hdmiArray0 = "HDMI_ID_0";
    public static final String hdmiArray1 = "HDMI_ID_1";
    private static String[] disp;
    private static String[] sound;
    private static String[] i2s;
    private static String[] mipi;
    public static final int COMMON_SIMBOL_INDEX0 = 0;
    public static final int COMMON_SIMBOL_INDEX1 = 1;
    private static final int COMMON_SIMBOL_INDEX2 = 2;
    private static final int COMMON_SIMBOL_INDEX3 = 3;
    private static int disPlay0Cvbs;
    private static int display0_u8DacY;
    private static int display0_u8DacPb;
    private static int display0_u8DacPr;
    private static int display0_r;
    private static int display0_g;
    private static int display0_b;
    private static int display0_svideoU8DacY;
    private static int display0_svideoU8DacC;
    private static int display0_vga_v;
    private static int display0_vga_g;
    private static int display0_vga_a;
    private static int display1_u8DacY;
    private static int display1_u8DacPb;
    private static int display1_u8DacPr;
    private static int display1_r;
    private static int display1_g;
    private static int display1_b;
    private static int display1_svideoU8DacY;
    private static int display1_svideoU8DacC;
    private static int display1_cvbs;
    private static int display1_vga_v;
    private static int display1_vga_g;
    private static int display1_vga_a;
    private static final int BGCOLOR_MIN_VALUE = 0;
    private static final int BGCOLOR_MAX_VALUE = 0xFFFFFF;
    private static final int VIRTUAL_SCREEN_MIN_VALUE = 480;
    private static final int VIRTUAL_SCREEN_MAX_VALUE = 3840;
    private static final int VIRTUAL_SCREEN_W_MAX_VALUE_HI3796CV300_INDEX1 = 1920;
    private static final int VIRTUAL_SCREEN_W_MAX_VALUE_HI3796CV300_INDEX0 = 3840;
    private static final int VIRTUAL_SCREEN_H_MAX_VALUE_HI3796CV300_INDEX1 = 1080;
    private static final int VIRTUAL_SCREEN_H_MAX_VALUE_HI3796CV300_INDEX0 = 2160;
    private static final int BIT_WIDTH_8BIT = 0;
    private static final int BIT_WIDTH_10BIT = 1;
    private static final int BIT_WIDTH_12BIT = 2;
    private static final int BIT_WIDTH_16BIT = 3;
    private static final int SPINNER_INC_VALUE = 1;
    private static final int SPINNER_PAGEINC_VALUE = 1;
    private static final int SPINNER_DIGITS_VALUE = 0;
    private static final int MIM_VOLUME = 0;
    private static final int MAX_VOLUME = 100;
    private static final int INIT_VOLUME = 30;
    private static final int FORMAT_PARAM_INIT_VALUE = 0;
    private static final int MAX_TEXT_LEN_3 = 3;
    private static final int MAX_VALUE_U8 = 255;
    private static final int BPP_INIT_VOLUME = 128;
    private static final int BRI_PERCENT_INIT_VOLUME = 0;
    private static boolean isBindSource;
    private String[] piexlFormatArray;
    private String[] bt656Array;
    private String[] bt1120Array;
    private String[] lcdArray;
    private InterFaceDialog interFaceDialog;
    private DispTimingDialog dispTimingDialog;
    private final Pattern patten = Pattern.compile("^[0-9]*$");
    private Pattern pattenHex = Pattern.compile("^[0-f]*$");
    private static ArrayList<Text> bgColorTextList;
    private static ArrayList<Text> bgColorTextListR;
    private static ArrayList<Text> bgColorTextListG;
    private static ArrayList<Text> bgColorTextListB;
    private static ArrayList<Text> hueplusTextList;
    private static ArrayList<Text> colorTemperatureTextList;
    private static ArrayList<Text> saturationTextList;
    private static ArrayList<Text> brightnessTextList;
    private static ArrayList<Text> contrastTextList;
    private static ArrayList<Text> offsetLeftTextList;
    private static ArrayList<Text> offsetTopTextList;
    private static ArrayList<Text> offsetRightTextList;
    private static ArrayList<Text> offsetBottomTextList;
    private static ArrayList<Text> virtualScreenWidthTextList;
    private static ArrayList<Text> virtualScreenHeightTextList;
    private static ArrayList<Combo> deepColorModeComboList;
    private Combo vidOutModeCombo;
    private Combo hdrCombo;
    private Combo colorSpaceTypeCombo;
    private Combo comboCvbsOutputStandard;
    private static ArrayList<Text> textVicList;
    private Combo comHdrMatchContent;
    private Combo comDispmngSceneMode;
    private FormToolkit ft;
    private ScrolledForm form;
    private Composite body;
    private Composite i2sCom;
    private WidgetParam wgetParam;

    static {
        disPlay0Cvbs = 3;
        display0_u8DacY = 1;
        display0_u8DacPb = 2;
        display0_u8DacPr = 0;
        display0_r = 0;
        display0_g = 0;
        display0_b = 0;
        display0_svideoU8DacY = 0;
        display0_svideoU8DacC = 0;
        display0_vga_v = 0;
        display0_vga_g = 0;
        display0_vga_a = 0;
        display1_u8DacY = 1;
        display1_u8DacPb = 2;
        display1_u8DacPr = 0;
        display1_r = 0;
        display1_g = 0;
        display1_b = 0;
        display1_svideoU8DacY = 0;
        display1_svideoU8DacC = 0;
        display1_cvbs = 3;
        display1_vga_v = 0;
        display1_vga_g = 0;
        display1_vga_a = 0;
        isBindSource = true;
        bgColorTextList = new ArrayList();
        bgColorTextListR = new ArrayList();
        bgColorTextListG = new ArrayList();
        bgColorTextListB = new ArrayList();
        hueplusTextList = new ArrayList();
        colorTemperatureTextList = new ArrayList();
        saturationTextList = new ArrayList();
        brightnessTextList = new ArrayList();
        contrastTextList = new ArrayList();
        offsetLeftTextList = new ArrayList();
        offsetTopTextList = new ArrayList();
        offsetRightTextList = new ArrayList();
        offsetBottomTextList = new ArrayList();
        virtualScreenWidthTextList = new ArrayList();
        virtualScreenHeightTextList = new ArrayList();
        deepColorModeComboList = new ArrayList();
        textVicList = new ArrayList();
    }

    public void setDisPlay0Cvbs(int disPlay0Cvbs) {
        BaseparamComposite.disPlay0Cvbs = disPlay0Cvbs;
    }

    public BaseparamComposite(Composite parent, Setting setting) {
        super(parent, setting);
    }

    private String getHdmiArray(int index) {
        if (FastplayView.isHi3796CV300Series()) {
            if (index == 0) {
                return hdmiArray0;
            }
            if (index == 1) {
                return hdmiArray1;
            }
        }
        return hdmiArray0;
    }

    private String[] getBt656Array() {
        if (this.bt656Array == null) {
            this.bt656Array = new String[]{"BT656_0"};
        }
        return this.bt656Array;
    }

    private String[] getBt1120Array() {
        if (this.bt1120Array == null) {
            this.bt1120Array = new String[]{"BT1120_0"};
        }
        return this.bt1120Array;
    }

    private String[] getLcdArray() {
        if (this.lcdArray == null) {
            this.lcdArray = new String[]{"LCD_0"};
        }
        return this.lcdArray;
    }

    private String[] getPiexlFormatArray() {
        if (this.piexlFormatArray == null) {
            this.piexlFormatArray = new String[]{"PF_8888", "PF_1555"};
        }
        return this.piexlFormatArray;
    }

    private String[] getAspectArray() {
        return new String[]{"AUTO", "4T03", "16T09", "221T01", "USER CONFIG"};
    }

    public static String getDisplayName(int index) {
        disp = disp == null && !FastplayView.isHi3796CV300Series() ? new String[]{"Display0", "Display1"} : new String[]{"Display0", "Display1", "Display2"};
        return disp[index];
    }

    public static String getSoundNames(int index) {
        if (sound == null) {
            sound = new String[]{"Sound0", "Sound1", "Sound2"};
        }
        return sound[index];
    }

    public static String getMIPIModelNames(int index) {
        if (mipi == null) {
            mipi = new String[]{"MIPI0", "MIPI1"};
        }
        return mipi[index];
    }

    public static String getI2sModelNames(int index) {
        i2s = FastplayView.isHi3796CV300Series() ? new String[]{"I2S0", "I2S1", "I2S2", "I2S3", "I2S4"} : new String[]{"I2S0", "I2S1"};
        return i2s[index];
    }

    public void setInterfaceCntrol(Composite cs, String[] interfaceNames, String type, Composite body, FormToolkit ft, ScrolledForm form, Section section, String dispName) {
        Control[] children = cs.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getData() != null) {
                children[i].dispose();
                children[i] = null;
            }
            ++i;
        }
        if ("disp".equals(type)) {
            int j = 0;
            while (j < interfaceNames.length) {
                this.createDispInterface(cs, interfaceNames[j], dispName);
                ++j;
            }
        } else {
            int i2sSelect = 0;
            int arcSelect = 0;
            int j = 0;
            while (j < interfaceNames.length) {
                String interName = interfaceNames[j];
                this.createSoundInterface(cs, interName, body, ft, form, section, dispName, i2sSelect, arcSelect);
                if ("I2S".equalsIgnoreCase(interName)) {
                    ++i2sSelect;
                } else if ("ARC".equalsIgnoreCase(interName)) {
                    ++arcSelect;
                }
                ++j;
            }
        }
    }

    public void setReadInterface(Composite cs, String[] interfaceNames, String type, Composite body, FormToolkit ft, ScrolledForm form, Section section, String dispName, AbstractBaseParam param, int index) {
        Control[] children = cs.getChildren();
        int i = 0;
        while (i < children.length) {
            System.out.println(children[i].getData());
            if (children[i].getData() != null && children[i].getData() != "basekeyenable") {
                children[i].dispose();
                children[i] = null;
            }
            ++i;
        }
        if ("disp".equals(type)) {
            int j = 0;
            while (j < interfaceNames.length) {
                this.readDispAndCreate(cs, interfaceNames[j], dispName, param);
                ++j;
            }
        } else {
            int arcNumber = 0;
            int j = 0;
            while (j < interfaceNames.length) {
                this.readSoundAndCreate(cs, interfaceNames[j], body, ft, form, section, param, index, arcNumber);
                if ("ARC".equalsIgnoreCase(interfaceNames[j])) {
                    ++arcNumber;
                }
                ++j;
            }
            this.hideOrShowI2sArea(body, ft, form);
        }
        cs.layout(true);
        form.reflow(true);
    }

    public void readParamToInterface(Composite cs, Composite body, FormToolkit ft, ScrolledForm form, AbstractBaseParam param, int index) {
        if (param instanceof DispParamObj) {
            DispParamObj dispParamObj = (DispParamObj)param;
            if (dispParamObj.getFormat() == HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.CUSTOM_TIMING.ordinal() || dispParamObj.getFormat() == HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E_HI3796CV300.CUSTOM_TIMING.ordinal()) {
                if (this.dispTimingDialog == null) {
                    this.dispTimingDialog = new DispTimingDialog(this.getShell(), this.wgetParam, index);
                    this.dispTimingDialog.setLastDispParamObj(dispParamObj);
                    this.wgetParam.addDispTimingDispParamObj(index, dispParamObj);
                } else {
                    this.dispTimingDialog.setLastDispParamObj(dispParamObj);
                    this.wgetParam.addDispTimingDispParamObj(index, dispParamObj);
                }
            }
            String[] displayNames = this.readExitNames("disp", index);
            this.setReadInterface(cs, displayNames, "disp", body, ft, form, null, "Display" + index, param, index);
        } else if (param instanceof SoundParamObj) {
            String[] soundNames = this.readExitNames("SOUND", index);
            this.setReadInterface(cs, soundNames, "SOUND", body, ft, form, null, "Sound" + index, param, index);
        } else if (param instanceof I2SModeObj) {
            I2SModeObj i2sModeObj = (I2SModeObj)param;
            this.readI2sAndCreate(body, ft, form, i2sModeObj);
        }
    }

    private String[] readExitNames(String type, int index) {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        BaseParam readParamObj = (BaseParam)((PrepareSetting)this.getSetting()).getReadParamObj();
        if ("disp".equals(type)) {
            this.createDisp(index, interfaceNames, readParamObj);
        } else {
            this.crateSound(index, interfaceNames, readParamObj);
        }
        String[] temp = new String[interfaceNames.size()];
        int i = 0;
        while (i < interfaceNames.size()) {
            temp[i] = ((String)interfaceNames.get(i)).toString();
            ++i;
        }
        return temp;
    }

    private void crateSound(int index, List<String> interfaceNames, BaseParam readParamObj) {
        List<Arc> arcList;
        List<SoundHdmi> soundHdmiList;
        List<Dac> dacList;
        SoundParamObj[] soundParayArray = readParamObj.getSoundParayArray();
        SoundParamObj soundParamObj = soundParayArray[index];
        List<Spdif> spdifList = soundParamObj.getSpdif();
        if (spdifList != null && spdifList.size() > 0) {
            Spdif spdif = spdifList.get(0);
            if (spdif.getSpdif() == 1) {
                soundParamObj.getSpdif().remove(spdif);
            } else {
                int i = 0;
                while (i < spdifList.size()) {
                    if (spdifList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.AUDIOINTERFACE.SPDIF.name());
                    }
                    ++i;
                }
            }
        }
        if ((dacList = soundParamObj.getDac()) != null && dacList.size() > 0) {
            Dac dac = dacList.get(0);
            if (dac.getDac() == 1) {
                soundParamObj.getDac().remove(dac);
            } else {
                int i = 0;
                while (i < dacList.size()) {
                    if (dacList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.AUDIOINTERFACE.DAC.name());
                    }
                    ++i;
                }
            }
        }
        if ((soundHdmiList = soundParamObj.getSound_hdmi()) != null && soundHdmiList.size() > 0) {
            SoundHdmi soundHdmi = soundHdmiList.get(0);
            int hdmi = 1;
            if (FastplayView.isHi3796CV300Series()) {
                hdmi = -1;
            }
            if (soundHdmi.getHdmi() == hdmi) {
                soundParamObj.getSound_hdmi().remove(soundHdmi);
            } else {
                int i = 0;
                while (i < soundHdmiList.size()) {
                    if (soundHdmiList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.AUDIOINTERFACE.HDMI.name());
                    }
                    ++i;
                }
            }
        }
        if ((arcList = soundParamObj.getArc()) != null && arcList.size() > 0) {
            Arc arcObj = arcList.get(0);
            int initValue = 1;
            if (FastplayView.isHi3796CV300Series()) {
                initValue = -1;
            }
            if (arcObj.getArc() == initValue) {
                soundParamObj.getArc().remove(arcObj);
            } else {
                int i = 0;
                while (i < arcList.size()) {
                    if (arcList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.AUDIOINTERFACE.ARC.name());
                    }
                    ++i;
                }
            }
        }
        int size = soundParamObj.getI2SModel().size();
        I2s[] tempI2s = new I2s[size];
        List<I2s> i2sList = soundParamObj.getI2SModel();
        if (i2sList != null && i2sList.size() > 0) {
            int i = 0;
            while (i < i2sList.size()) {
                tempI2s[i] = i2sList.get(i);
                interfaceNames.add(String.valueOf(HI_UNF_MCE.AUDIOINTERFACE.I2S.name()) + i);
                ++i;
            }
        }
        readParamObj.setSoundParamArray(soundParayArray);
    }

    private void createDisp(int index, List<String> interfaceNames, BaseParam readParamObj) {
        List<SubParam> vgaList;
        List<SubParam> lcdList;
        List<SubParam> bt1120List;
        List<SubParam> bt656List;
        List<SubParam> mipiList;
        List<SubParam> hdmiList;
        List<SubParam> cvbsList;
        List<SubParam> svideoList;
        List<SubParam> rgbList;
        DispParamObj[] dispParamArray = readParamObj.getDispParamArray();
        DispParamObj dispParamObj = dispParamArray[index];
        List<SubParam> ypbprList = dispParamObj.getYpbpr();
        if (ypbprList != null && ypbprList.size() > 0) {
            Ypbpr ypbpr = (Ypbpr)ypbprList.get(0);
            if (ypbpr.getU8DacPb().equals("-1") && ypbpr.getU8DacPr().equals("-1") && ypbpr.getU8DacY().equals("-1")) {
                dispParamObj.getYpbpr().remove(ypbpr);
            } else {
                int i = 0;
                while (i < ypbprList.size()) {
                    if (ypbprList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.YPBPR.name());
                    }
                    ++i;
                }
            }
        }
        if ((rgbList = dispParamObj.getRgb()) != null && rgbList.size() > 0) {
            Rgb rgb = (Rgb)rgbList.get(0);
            if (rgb.getR() == -1 && rgb.getG() == -1 && rgb.getB() == -1) {
                dispParamObj.getRgb().remove(rgb);
            } else {
                int i = 0;
                while (i < rgbList.size()) {
                    if (rgbList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.RGB.name());
                    }
                    ++i;
                }
            }
        }
        if ((svideoList = dispParamObj.getSvideo()) != null && svideoList.size() > 0) {
            Svideo svideo = (Svideo)svideoList.get(0);
            if (svideo.getU8DacC() == -1 && svideo.getU8DacY() == -1) {
                dispParamObj.getSvideo().remove(svideo);
            } else {
                int i = 0;
                while (i < svideoList.size()) {
                    if (svideoList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.SVIDEO.name());
                    }
                    ++i;
                }
            }
        }
        if ((cvbsList = dispParamObj.getCvbs()) != null && cvbsList.size() > 0) {
            Cvbs cvbs = (Cvbs)cvbsList.get(0);
            if (cvbs.getCvbs().equalsIgnoreCase("-1")) {
                dispParamObj.getCvbs().remove(cvbs);
            } else {
                int i = 0;
                while (i < cvbsList.size()) {
                    if (cvbsList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.CVBS.name());
                    }
                    ++i;
                }
            }
        }
        if ((hdmiList = dispParamObj.getHdmi()) != null && hdmiList.size() > 0) {
            Hdmi hdmi = (Hdmi)hdmiList.get(0);
            if (hdmi.getHdmi() == -1) {
                dispParamObj.getHdmi().remove(hdmi);
            } else {
                int i = 0;
                while (i < hdmiList.size()) {
                    if (hdmiList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.HDMI.name());
                    }
                    ++i;
                }
            }
        }
        if ((mipiList = dispParamObj.getMipi()) != null && mipiList.size() > 0) {
            Mipi mipi = (Mipi)mipiList.get(0);
            if (mipi.getMipi() == -1) {
                dispParamObj.getMipi().clear();
            } else {
                int i = 0;
                while (i < mipiList.size()) {
                    if (mipiList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACEHI3796CV300.MIPI.name());
                    }
                    ++i;
                }
            }
        }
        if ((bt656List = dispParamObj.getBt656()) != null && bt656List.size() > 0) {
            Bt656 bt656 = (Bt656)bt656List.get(0);
            if (bt656.getBt656() == -1) {
                dispParamObj.getHdmi().remove(bt656);
            } else {
                int i = 0;
                while (i < bt656List.size()) {
                    if (bt656List.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.BT656.name());
                    }
                    ++i;
                }
            }
        }
        if ((bt1120List = dispParamObj.getBt1120()) != null && bt1120List.size() > 0) {
            Bt1120 bt1120 = (Bt1120)bt1120List.get(0);
            if (bt1120.getBt1120() == -1) {
                dispParamObj.getBt1120().remove(bt1120);
            } else {
                int i = 0;
                while (i < bt1120List.size()) {
                    if (bt1120List.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.BT1120.name());
                    }
                    ++i;
                }
            }
        }
        if ((lcdList = dispParamObj.getLcd()) != null && lcdList.size() > 0) {
            Lcd lcd = (Lcd)lcdList.get(0);
            if (lcd.getLcd() == -1) {
                dispParamObj.getLcd().remove(lcd);
            } else {
                int i = 0;
                while (i < lcdList.size()) {
                    if (lcdList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.LCD.name());
                    }
                    ++i;
                }
            }
        }
        if ((vgaList = dispParamObj.getVga()) != null && vgaList.size() > 0) {
            Vga vga = (Vga)vgaList.get(0);
            if (vga.getR() == -1 && vga.getG() == -1 && vga.getB() == -1) {
                dispParamObj.getVga().remove(vga);
            } else {
                int i = 0;
                while (i < vgaList.size()) {
                    if (vgaList.get(i) != null) {
                        interfaceNames.add(HI_UNF_MCE.DISPINTERFACE.VGA.name());
                    }
                    ++i;
                }
            }
        }
        readParamObj.setDispParamArray(dispParamArray);
    }

    private void readSoundAndCreate(Composite cs, String name, Composite body, FormToolkit ft, ScrolledForm form, Section section, AbstractBaseParam param, int index, int arcNumber) {
        name = InterFaceDialog.removeTipMultiChoice(name);
        SoundParamObj soundParamObj = null;
        if (param instanceof SoundParamObj) {
            soundParamObj = (SoundParamObj)param;
        }
        if (soundParamObj != null) {
            if (HI_UNF_MCE.AUDIOINTERFACE.SPDIF.name().equals(name)) {
                Spdif spdifObj = soundParamObj.getSpdif().get(0);
                int spdif = spdifObj.getSpdif();
                int spdifVolume = spdifObj.getSpdifVolume();
                Composite spdifCom = new Composite(cs, 0);
                RowLayout row = this.rowLayout();
                spdifCom.setLayout((Layout)row);
                spdifCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name());
                Label spdiLbl = new Label(spdifCom, 0);
                spdiLbl.setText("SPDIF:");
                spdiLbl.setAlignment(0x1000000);
                Combo spdicb = new Combo(spdifCom, 8);
                spdicb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_SPDIF_OUTPUTPORT_E.values()));
                spdicb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 1));
                spdicb.select(spdif);
                Label volLabel = new Label(spdifCom, 0);
                volLabel.setText("VOL:");
                Spinner spdifSpinner = this.createSpinner(spdifCom, 2048, 0, 30, 100, 1, 1, 0);
                spdifSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 2));
                spdifSpinner.setToolTipText("Spdif Volume");
                spdifSpinner.setSelection(spdifVolume);
            } else if (HI_UNF_MCE.AUDIOINTERFACE.DAC.name().equals(name)) {
                Dac dacObj = soundParamObj.getDac().get(index);
                int dac = dacObj.getDac();
                int dacVolume = dacObj.getDacVolume();
                Composite dacCom = new Composite(cs, 0);
                dacCom.setLayout((Layout)this.rowLayout());
                dacCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.dac.name());
                Label dacLbl = new Label(dacCom, 0);
                dacLbl.setText("DAC:");
                Combo daccb = new Combo(dacCom, 8);
                daccb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_DAC_OUTPUTPORT_E.values()));
                daccb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 1));
                daccb.select(dac);
                Label volLabel = new Label(dacCom, 0);
                volLabel.setText("VOL:");
                Spinner dacSpinner = this.createSpinner(dacCom, 2048, 0, 30, 100, 1, 1, 0);
                dacSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 2));
                dacSpinner.setToolTipText("Dac Volume");
                dacSpinner.setSelection(dacVolume);
            } else if (HI_UNF_MCE.AUDIOINTERFACE.HDMI.name().equals(name)) {
                SoundHdmi soundHdmiObj = soundParamObj.getSound_hdmi().get(0);
                int hdmi = soundHdmiObj.getHdmi();
                int soundHdmiVolume = soundHdmiObj.getSoundHdmiVolume();
                Composite hdmiCom = new Composite(cs, 0);
                hdmiCom.setLayout((Layout)this.rowLayout());
                hdmiCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name());
                Label hdmiLbl = new Label(hdmiCom, 0);
                hdmiLbl.setText("HDMI:");
                if (FastplayView.isHi3796CV300Series()) {
                    hdmi = 0;
                }
                Combo hdmicb = new Combo(hdmiCom, 8);
                hdmicb.setItems(new String[]{this.getHdmiArray(index)});
                hdmicb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 1));
                hdmicb.select(hdmi);
                Label volLabel = new Label(hdmiCom, 0);
                volLabel.setText("VOL:");
                Spinner soundHdmiSpinner = this.createSpinner(hdmiCom, 2048, 0, 30, 100, 1, 1, 0);
                soundHdmiSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 2));
                soundHdmiSpinner.setToolTipText("Sound Hdmi Volume");
                soundHdmiSpinner.setSelection(soundHdmiVolume);
            } else if (HI_UNF_MCE.AUDIOINTERFACE.ARC.name().equals(name)) {
                Arc arcObj = soundParamObj.getArc().get(arcNumber);
                int arc = arcObj.getArc();
                int arcVolume = arcObj.getArcVolume();
                Composite arcCom = new Composite(cs, 0);
                arcCom.setLayout((Layout)this.rowLayout());
                arcCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.arc.name());
                Label arcLbl = new Label(arcCom, 0);
                arcLbl.setText("ARC:");
                Enum[] objs = null;
                objs = FastplayView.isHi3796CV300Series() ? HI_UNF_MCE.HIUNF_ARC_OUTPUTPORT_E_HI3796CV300.values() : HI_UNF_MCE.HIUNF_ARC_OUTPUTPORT_E.values();
                Combo arccb = new Combo(arcCom, 8);
                arccb.setItems(HI_UNF_MCE.getEnumNames(objs));
                arccb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 1));
                arccb.select(arc);
                Label volLabel = new Label(arcCom, 0);
                volLabel.setText("VOL:");
                Spinner arcSpinner = this.createSpinner(arcCom, 2048, 0, 30, 100, 1, 1, 0);
                arcSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 2));
                arcSpinner.setToolTipText("Arc Volume");
                arcSpinner.setSelection(arcVolume);
            } else {
                int i = 0;
                while (i < soundParamObj.getI2SModel().size()) {
                    if ((String.valueOf(HI_UNF_MCE.AUDIOINTERFACE.I2S.name()) + i).equals(name)) {
                        I2s i2sObj = soundParamObj.getI2SModel().get(i);
                        if (i2sObj == null) break;
                        int i2s = i2sObj.getI2s();
                        int i2sVolume = i2sObj.getI2sVolume();
                        if (i2s == -1) break;
                        Composite i2sCom = new Composite(cs, 0);
                        i2sCom.setLayout((Layout)this.rowLayout());
                        i2sCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name());
                        Label i2sLbl = new Label(i2sCom, 0);
                        i2sLbl.setText("I2S:");
                        Combo i2scb = new Combo(i2sCom, 8);
                        i2scb.setItems(HI_UNF_MCE.getEnumNames(this.getI2sItems()));
                        i2scb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 1));
                        i2scb.select(i2s);
                        this.addSelectionListener(i2scb, body, ft, form);
                        Label volLabel = new Label(i2sCom, 0);
                        volLabel.setText("VOL:");
                        Spinner i2sSpinner = this.createSpinner(i2sCom, 2048, 0, 30, 100, 1, 1, 0);
                        i2sSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 2));
                        i2sSpinner.setToolTipText("I2s Volume");
                        i2sSpinner.setSelection(i2sVolume);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private Object[] getI2sItems() {
        Enum[] objs = HI_UNF_MCE.HIUNF_I2S_OUTPUTPORT_E.values();
        if (FastplayView.isHi3796CV300Series()) {
            objs = HI_UNF_MCE.HIUNF_I2S_OUTPUTPORT_E_HI3796CV300.values();
        }
        return objs;
    }

    private void createSoundInterface(Composite cs, String name, Composite body, FormToolkit ft, ScrolledForm form, Section section, String soundName, int i2sSelect, int arcSelect) {
        Label volLabel;
        Label volLabel2;
        name = InterFaceDialog.removeTipMultiChoice(name);
        if (HI_UNF_MCE.AUDIOINTERFACE.SPDIF.name().equals(name)) {
            Composite spdifCom = new Composite(cs, 0);
            RowLayout row = this.rowLayout();
            spdifCom.setLayout((Layout)row);
            spdifCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name());
            Label spdiLbl = new Label(spdifCom, 0);
            spdiLbl.setText("SPDIF:");
            spdiLbl.setAlignment(0x1000000);
            Combo spdicb = new Combo(spdifCom, 8);
            spdicb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_SPDIF_OUTPUTPORT_E.values()));
            spdicb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 1));
            spdicb.select(0);
            volLabel2 = new Label(spdifCom, 0);
            volLabel2.setText("VOL:");
            Spinner spdifSpinner = this.createSpinner(spdifCom, 2048, 0, 30, 100, 1, 1, 0);
            spdifSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 2));
            spdifSpinner.setToolTipText("Spdif Volume");
        }
        if (HI_UNF_MCE.AUDIOINTERFACE.DAC.name().equals(name)) {
            Composite dacCom = new Composite(cs, 0);
            dacCom.setLayout((Layout)this.rowLayout());
            dacCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.dac.name());
            Label dacLbl = new Label(dacCom, 0);
            dacLbl.setText("DAC:");
            Combo daccb = new Combo(dacCom, 8);
            daccb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_DAC_OUTPUTPORT_E.values()));
            daccb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 1));
            daccb.select(0);
            volLabel = new Label(dacCom, 0);
            volLabel.setText("VOL:");
            Spinner dacSpinner = this.createSpinner(dacCom, 2048, 0, 30, 100, 1, 1, 0);
            dacSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 2));
            dacSpinner.setToolTipText("Dac Volume");
        }
        if (HI_UNF_MCE.AUDIOINTERFACE.HDMI.name().equals(name)) {
            Composite hdmiCom = new Composite(cs, 0);
            hdmiCom.setLayout((Layout)this.rowLayout());
            hdmiCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name());
            Label hdmiLbl = new Label(hdmiCom, 0);
            hdmiLbl.setText("HDMI:");
            int hdmiIndex = 0;
            if (FastplayView.isHi3796CV300Series()) {
                hdmiIndex = soundName.contains("0") ? 0 : 1;
            }
            Combo hdmicb = new Combo(hdmiCom, 8);
            hdmicb.setItems(new String[]{this.getHdmiArray(hdmiIndex)});
            hdmicb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 1));
            hdmicb.select(0);
            volLabel2 = new Label(hdmiCom, 0);
            volLabel2.setText("VOL:");
            Spinner soundHdmiSpinner = this.createSpinner(hdmiCom, 2048, 0, 30, 100, 1, 1, 0);
            soundHdmiSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 2));
            soundHdmiSpinner.setToolTipText("Sound Hdmi Volume");
        }
        if (HI_UNF_MCE.AUDIOINTERFACE.I2S.name().equals(name)) {
            Composite i2sCom = new Composite(cs, 0);
            i2sCom.setLayout((Layout)this.rowLayout());
            i2sCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name());
            Label i2sLbl = new Label(i2sCom, 0);
            i2sLbl.setText("I2S:");
            Combo i2scb = new Combo(i2sCom, 8);
            i2scb.setItems(HI_UNF_MCE.getEnumNames(this.getI2sItems()));
            i2scb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 1));
            i2scb.select(i2sSelect);
            this.addSelectionListener(i2scb, body, ft, form);
            volLabel = new Label(i2sCom, 0);
            volLabel.setText("VOL:");
            Spinner i2sSpinner = this.createSpinner(i2sCom, 2048, 0, 30, 100, 1, 1, 0);
            i2sSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 2));
            i2sSpinner.setToolTipText("I2s Volume");
        }
        if (HI_UNF_MCE.AUDIOINTERFACE.ARC.name().equals(name)) {
            Composite arcCom = new Composite(cs, 0);
            arcCom.setLayout((Layout)this.rowLayout());
            arcCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.arc.name());
            Label arcLbl = new Label(arcCom, 0);
            arcLbl.setText("ARC:");
            int select = 0;
            Combo arccb = new Combo(arcCom, 8);
            Enum[] objs = null;
            if (FastplayView.isHi3796CV300Series()) {
                select = arcSelect;
                objs = HI_UNF_MCE.HIUNF_ARC_OUTPUTPORT_E_HI3796CV300.values();
            } else {
                objs = HI_UNF_MCE.HIUNF_ARC_OUTPUTPORT_E.values();
            }
            arccb.setItems(HI_UNF_MCE.getEnumNames(objs));
            arccb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 1));
            arccb.select(select);
            Label volLabel3 = new Label(arcCom, 0);
            volLabel3.setText("VOL:");
            Spinner arcSpinner = this.createSpinner(arcCom, 2048, 0, 30, 100, 1, 1, 0);
            arcSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 2));
            arcSpinner.setToolTipText("Arc Volume");
        }
    }

    public void createDispInterface(Composite cs, String name, String dispName) {
        if ("Display0".equals(dispName)) {
            this.createDisp0Interface(cs, name);
        } else if ("Display1".equals(dispName) || "Display2".equals(dispName)) {
            this.createOtherDispInterface(cs, name);
        }
    }

    private void createOtherDispInterface(Composite cs, String name) {
        Text text_10;
        Text text_9;
        Text text_8;
        Label label_2;
        boolean index = true;
        if (HI_UNF_MCE.DISPINTERFACE.YPBPR.name().equals(name)) {
            Ypbpr ypbpr = new Ypbpr(String.valueOf(display1_u8DacY), String.valueOf(display1_u8DacPb), String.valueOf(display1_u8DacPr));
            Composite ypbprCom = new Composite(cs, 0);
            ypbprCom.setLayout((Layout)this.rowLayout());
            ypbprCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name());
            Label label_1 = new Label(ypbprCom, 0);
            label_1.setText(Messages.BaseparamComposite_35);
            Text text_5 = new Text(ypbprCom, 2048);
            text_5.setText(ypbpr.getU8DacY());
            text_5.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1));
            this.textRowData(text_5);
            text_5.setTextLimit(3);
            text_5.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_5.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_5.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_5.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_5.setText("0");
                        return;
                    }
                    display1_u8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_6 = new Text(ypbprCom, 2048);
            text_6.setText(ypbpr.getU8DacPb());
            text_6.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 2));
            this.textRowData(text_6);
            text_6.setTextLimit(3);
            text_6.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_6.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_6.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_6.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_6.setText("0");
                        return;
                    }
                    display1_u8DacPb = Integer.parseInt(textStr);
                }
            });
            Text text_7 = new Text(ypbprCom, 2048);
            text_7.setText(ypbpr.getU8DacPr());
            text_7.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 3));
            this.textRowData(text_7);
            text_7.setTextLimit(3);
            text_7.setText(String.valueOf(display1_u8DacPr));
            text_7.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_7.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_7.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_7.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_7.setText("0");
                        return;
                    }
                    display1_u8DacPr = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.RGB.name().equals(name)) {
            Rgb rgb = new Rgb(display1_r, display1_g, display1_b);
            Composite rgbCom = new Composite(cs, 0);
            rgbCom.setLayout((Layout)this.rowLayout());
            rgbCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.rgb.name());
            label_2 = new Label(rgbCom, 0);
            label_2.setText(Messages.BaseparamComposite_36);
            text_8 = new Text(rgbCom, 2048);
            text_8.setText(String.valueOf(rgb.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display1_r = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(rgbCom, 2048);
            text_9.setText(String.valueOf(rgb.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display1_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(rgbCom, 2048);
            text_10.setText(String.valueOf(rgb.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display1_b = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.SVIDEO.name().equals(name)) {
            Svideo svideo = new Svideo(display1_svideoU8DacY, display1_svideoU8DacC);
            Composite svideoCom = new Composite(cs, 0);
            svideoCom.setLayout((Layout)this.rowLayout());
            svideoCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.svideo.name());
            Label label_4 = new Label(svideoCom, 0);
            label_4.setText(Messages.BaseparamComposite_37);
            Text text_12 = new Text(svideoCom, 2048);
            text_12.setText(String.valueOf(svideo.getU8DacY()));
            text_12.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1));
            this.textRowData(text_12);
            text_12.setTextLimit(3);
            text_12.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_12.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_12.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_12.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_12.setText("0");
                        return;
                    }
                    display1_svideoU8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_13 = new Text(svideoCom, 2048);
            text_13.setText(String.valueOf(svideo.getU8DacC()));
            text_13.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 2));
            this.textRowData(text_13);
            text_13.setTextLimit(3);
            text_13.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_13.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_13.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_13.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_13.setText("0");
                        return;
                    }
                    display1_svideoU8DacC = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.CVBS.name().equals(name)) {
            Cvbs cvbsOjb = new Cvbs(String.valueOf(display1_cvbs));
            Composite cvbsCom = new Composite(cs, 0);
            cvbsCom.setLayout((Layout)this.rowLayout());
            cvbsCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.cvbs.name());
            Label label_3 = new Label(cvbsCom, 0);
            label_3.setText(Messages.BaseparamComposite_38);
            Text text_11 = new Text(cvbsCom, 2048);
            text_11.setText(cvbsOjb.getCvbs());
            text_11.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1));
            this.textRowData(text_11);
            text_11.setTextLimit(3);
            text_11.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_11.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_11.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_11.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("CVBS" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_11.setText("0");
                        return;
                    }
                    display1_cvbs = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.HDMI.name().equals(name)) {
            Composite hdmiCom = new Composite(cs, 0);
            hdmiCom.setLayout((Layout)this.rowLayout());
            hdmiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hdmi.name());
            Label label_5 = new Label(hdmiCom, 0);
            label_5.setText(Messages.BaseparamComposite_39);
            Combo combo_1 = new Combo(hdmiCom, 8);
            combo_1.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1));
            combo_1.setItems(new String[]{this.getHdmiArray(1)});
            combo_1.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT656.name().equals(name)) {
            Composite bt656Com = new Composite(cs, 0);
            bt656Com.setLayout((Layout)this.rowLayout());
            bt656Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt656.name());
            Label label_6 = new Label(bt656Com, 0);
            label_6.setText(Messages.BaseparamComposite_40);
            Combo combo_2 = new Combo(bt656Com, 8);
            combo_2.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt656.name()) + 1));
            combo_2.setItems(this.getBt656Array());
            combo_2.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT1120.name().equals(name)) {
            Composite bt1120Com = new Composite(cs, 0);
            bt1120Com.setLayout((Layout)this.rowLayout());
            bt1120Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt1120.name());
            Label Label_7 = new Label(bt1120Com, 0);
            Label_7.setText(Messages.BaseparamComposite_41);
            Combo combo_3 = new Combo(bt1120Com, 8);
            combo_3.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1));
            combo_3.setItems(this.getBt1120Array());
            combo_3.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.LCD.name().equals(name)) {
            Composite lcdCom = new Composite(cs, 0);
            lcdCom.setLayout((Layout)this.rowLayout());
            lcdCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.lcd.name());
            Label label_8 = new Label(lcdCom, 0);
            label_8.setText(Messages.BaseparamComposite_42);
            Combo combo_4 = new Combo(lcdCom, 8);
            combo_4.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1));
            combo_4.setItems(this.getLcdArray());
            combo_4.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.VGA.name().equals(name)) {
            Vga vga = new Vga(display1_vga_v, display1_vga_g, display1_vga_a);
            Composite vgaCom = new Composite(cs, 0);
            vgaCom.setLayout((Layout)this.rowLayout());
            vgaCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vga.name());
            label_2 = new Label(vgaCom, 0);
            label_2.setText(Messages.BaseparamComposite_46);
            text_8 = new Text(vgaCom, 2048);
            text_8.setText(String.valueOf(vga.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display1_vga_v = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(vgaCom, 2048);
            text_9.setText(String.valueOf(vga.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display1_vga_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(vgaCom, 2048);
            text_10.setText(String.valueOf(vga.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display1_vga_a = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACEHI3796CV300.MIPI.name().equalsIgnoreCase(name)) {
            Composite mipiCom = new Composite(cs, 0);
            mipiCom.setLayout((Layout)this.rowLayout());
            mipiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.mipi.name());
            Label mipiLabel = new Label(mipiCom, 0);
            mipiLabel.setText(Messages.BaseparamComposite_mipi);
            mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)this.getMipiModeObj());
            Combo mipiCombo = new Combo(mipiCom, 8);
            mipiCombo.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.mipi.name()) + 1));
            mipiCombo.setItems(mipiArray);
            mipiCombo.select(1);
            mipiCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MipiModeObj mipiModeObj = (MipiModeObj)mipiCom.getData(DispParamObj.BASE_DISP_ATTRNAME.key.name());
                    DispMipiDialog dispMipiDialog = new DispMipiDialog(BaseparamComposite.this.getShell(), mipiModeObj);
                    dispMipiDialog.open();
                    mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)mipiModeObj);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void createDisp0Interface(Composite cs, String name) {
        Text text_10;
        Text text_9;
        Text text_8;
        Label label_2;
        boolean index = false;
        if (HI_UNF_MCE.DISPINTERFACE.YPBPR.name().equals(name)) {
            Ypbpr ypbpr = new Ypbpr(String.valueOf(display0_u8DacY), String.valueOf(display0_u8DacPb), String.valueOf(display0_u8DacPr));
            Composite ypbprCom = new Composite(cs, 0);
            ypbprCom.setLayout((Layout)this.rowLayout());
            ypbprCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name());
            Label label_1 = new Label(ypbprCom, 0);
            label_1.setText(Messages.BaseparamComposite_35);
            Text text_5 = new Text(ypbprCom, 2048);
            text_5.setText(ypbpr.getU8DacY());
            text_5.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1));
            text_5.setTextLimit(3);
            this.textRowData(text_5);
            text_5.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_5.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_5.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_5.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_5.setText("0");
                        return;
                    }
                    display0_u8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_6 = new Text(ypbprCom, 2048);
            text_6.setText(ypbpr.getU8DacPb());
            text_6.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 2));
            text_6.setTextLimit(3);
            this.textRowData(text_6);
            text_6.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_6.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_6.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_6.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_6.setText("0");
                        return;
                    }
                    display0_u8DacPb = Integer.parseInt(textStr);
                }
            });
            Text text_7 = new Text(ypbprCom, 2048);
            text_7.setText(ypbpr.getU8DacPr());
            text_7.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 3));
            this.textRowData(text_7);
            text_7.setTextLimit(3);
            text_7.setText(String.valueOf(display0_u8DacPr));
            text_7.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_7.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_7.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_7.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_7.setText("0");
                        return;
                    }
                    display0_u8DacPr = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.RGB.name().equals(name)) {
            Rgb rgb = new Rgb(display0_r, display0_g, display0_b);
            Composite rgbCom = new Composite(cs, 0);
            rgbCom.setLayout((Layout)this.rowLayout());
            rgbCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.rgb.name());
            label_2 = new Label(rgbCom, 0);
            label_2.setText(Messages.BaseparamComposite_36);
            text_8 = new Text(rgbCom, 2048);
            text_8.setText(String.valueOf(rgb.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display0_r = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(rgbCom, 2048);
            text_9.setText(String.valueOf(rgb.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display0_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(rgbCom, 2048);
            text_10.setText(String.valueOf(rgb.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display0_b = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.SVIDEO.name().equals(name)) {
            Svideo svideo = new Svideo(display0_svideoU8DacY, display0_svideoU8DacC);
            Composite svideoCom = new Composite(cs, 0);
            svideoCom.setLayout((Layout)this.rowLayout());
            svideoCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.svideo.name());
            Label label_4 = new Label(svideoCom, 0);
            label_4.setText(Messages.BaseparamComposite_37);
            Text text_12 = new Text(svideoCom, 2048);
            text_12.setText(String.valueOf(svideo.getU8DacY()));
            text_12.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1));
            this.textRowData(text_12);
            text_12.setTextLimit(3);
            text_12.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_12.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_12.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_12.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_12.setText("0");
                        return;
                    }
                    display0_svideoU8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_13 = new Text(svideoCom, 2048);
            text_13.setText(String.valueOf(svideo.getU8DacC()));
            text_13.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 2));
            this.textRowData(text_13);
            text_13.setTextLimit(3);
            text_13.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_13.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_13.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_13.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_13.setText("0");
                        return;
                    }
                    display0_svideoU8DacC = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.CVBS.name().equals(name)) {
            Cvbs cvbsOjb = new Cvbs(String.valueOf(disPlay0Cvbs));
            Composite cvbsCom = new Composite(cs, 0);
            cvbsCom.setLayout((Layout)this.rowLayout());
            cvbsCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.cvbs.name());
            Label label_3 = new Label(cvbsCom, 0);
            label_3.setText(Messages.BaseparamComposite_38);
            Text text_11 = new Text(cvbsCom, 2048);
            text_11.setText(cvbsOjb.getCvbs());
            text_11.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1));
            this.textRowData(text_11);
            text_11.setTextLimit(3);
            text_11.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_11.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_11.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_11.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_11.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("CVBS" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_11.setText("0");
                        return;
                    }
                    BaseparamComposite.this.setDisPlay0Cvbs(Integer.parseInt(textStr));
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.HDMI.name().equals(name)) {
            Composite hdmiCom = new Composite(cs, 0);
            hdmiCom.setLayout((Layout)this.rowLayout());
            hdmiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hdmi.name());
            Label label_5 = new Label(hdmiCom, 0);
            label_5.setText(Messages.BaseparamComposite_39);
            Combo combo_1 = new Combo(hdmiCom, 8);
            combo_1.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1));
            combo_1.setItems(new String[]{this.getHdmiArray(0)});
            combo_1.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT656.name().equals(name)) {
            Composite bt656Com = new Composite(cs, 0);
            bt656Com.setLayout((Layout)this.rowLayout());
            bt656Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt656.name());
            Label label_6 = new Label(bt656Com, 0);
            label_6.setText(Messages.BaseparamComposite_40);
            Combo combo_2 = new Combo(bt656Com, 8);
            combo_2.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt656.name()) + 1));
            combo_2.setItems(this.getBt656Array());
            combo_2.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT1120.name().equals(name)) {
            Composite bt1120Com = new Composite(cs, 0);
            bt1120Com.setLayout((Layout)this.rowLayout());
            bt1120Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt1120.name());
            Label Label_7 = new Label(bt1120Com, 0);
            Label_7.setText(Messages.BaseparamComposite_41);
            Combo combo_3 = new Combo(bt1120Com, 8);
            combo_3.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1));
            combo_3.setItems(this.getBt1120Array());
            combo_3.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.LCD.name().equals(name)) {
            Composite lcdCom = new Composite(cs, 0);
            lcdCom.setLayout((Layout)this.rowLayout());
            lcdCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.lcd.name());
            Label label_8 = new Label(lcdCom, 0);
            label_8.setText(Messages.BaseparamComposite_42);
            Combo combo_4 = new Combo(lcdCom, 8);
            combo_4.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1));
            combo_4.setItems(this.getLcdArray());
            combo_4.select(0);
        }
        if (HI_UNF_MCE.DISPINTERFACE.VGA.name().equals(name)) {
            Vga vga = new Vga(display0_vga_v, display0_vga_g, display0_vga_a);
            Composite vgaCom = new Composite(cs, 0);
            vgaCom.setLayout((Layout)this.rowLayout());
            vgaCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vga.name());
            label_2 = new Label(vgaCom, 0);
            label_2.setText(Messages.BaseparamComposite_46);
            text_8 = new Text(vgaCom, 2048);
            text_8.setText(String.valueOf(vga.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display0_vga_v = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(vgaCom, 2048);
            text_9.setText(String.valueOf(vga.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display0_vga_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(vgaCom, 2048);
            text_10.setText(String.valueOf(vga.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display0_vga_a = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACEHI3796CV300.MIPI.name().equalsIgnoreCase(name)) {
            Composite mipiCom = new Composite(cs, 0);
            mipiCom.setLayout((Layout)this.rowLayout());
            mipiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.mipi.name());
            Label mipiLabel = new Label(mipiCom, 0);
            mipiLabel.setText(Messages.BaseparamComposite_mipi);
            mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)this.getMipiModeObj());
            Combo mipiCombo = new Combo(mipiCom, 8);
            mipiCombo.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.mipi.name()) + 1));
            mipiCombo.setItems(mipiArray);
            mipiCombo.select(0);
            mipiCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MipiModeObj mipiModeObj = (MipiModeObj)mipiCom.getData(DispParamObj.BASE_DISP_ATTRNAME.key.name());
                    DispMipiDialog dispMipiDialog = new DispMipiDialog(BaseparamComposite.this.getShell(), mipiModeObj);
                    dispMipiDialog.open();
                    mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)mipiModeObj);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public void readDispAndCreate(Composite cs, String name, String dispName, Object obj) {
        DispParamObj dispParamObj = null;
        if (obj instanceof DispParamObj) {
            dispParamObj = (DispParamObj)obj;
        }
        if (dispParamObj != null) {
            if ("Display0".equals(dispName)) {
                this.readAndCreatDisplay0(cs, name, dispParamObj);
            }
            if ("Display1".equals(dispName) || "Display2".equals(dispName)) {
                this.readAndCreatDisplay1(cs, name, dispParamObj);
            }
        }
    }

    private void readAndCreatDisplay1(Composite cs, String name, DispParamObj dispParamObj) {
        Text text_10;
        Text text_9;
        Text text_8;
        Label label_2;
        int index = 1;
        if (HI_UNF_MCE.DISPINTERFACE.YPBPR.name().equals(name)) {
            Ypbpr ypbpr = (Ypbpr)dispParamObj.getYpbpr().get(0);
            Composite ypbprCom = new Composite(cs, 0);
            ypbprCom.setLayout((Layout)this.rowLayout());
            ypbprCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name());
            Label label_1 = new Label(ypbprCom, 0);
            label_1.setText(Messages.BaseparamComposite_35);
            Text text_5 = new Text(ypbprCom, 2048);
            text_5.setText(ypbpr.getU8DacY());
            text_5.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1));
            this.textRowData(text_5);
            text_5.setTextLimit(3);
            text_5.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_5.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_5.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_5.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_5.setText("0");
                        return;
                    }
                    display1_u8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_6 = new Text(ypbprCom, 2048);
            text_6.setText(ypbpr.getU8DacPb());
            text_6.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 2));
            this.textRowData(text_6);
            text_6.setTextLimit(3);
            text_6.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_6.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_6.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_6.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_6.setText("0");
                        return;
                    }
                    display1_u8DacPb = Integer.parseInt(textStr);
                }
            });
            Text text_7 = new Text(ypbprCom, 2048);
            text_7.setText(ypbpr.getU8DacPr());
            text_7.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 3));
            this.textRowData(text_7);
            text_7.setText(String.valueOf(display1_u8DacPr));
            text_7.setTextLimit(3);
            text_7.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_7.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_7.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_7.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_7.setText("0");
                        return;
                    }
                    display1_u8DacPr = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.RGB.name().equals(name)) {
            Rgb rgb = (Rgb)dispParamObj.getRgb().get(0);
            Composite rgbCom = new Composite(cs, 0);
            rgbCom.setLayout((Layout)this.rowLayout());
            rgbCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.rgb.name());
            label_2 = new Label(rgbCom, 0);
            label_2.setText(Messages.BaseparamComposite_36);
            text_8 = new Text(rgbCom, 2048);
            text_8.setText(String.valueOf(rgb.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display1_r = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(rgbCom, 2048);
            text_9.setText(String.valueOf(rgb.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display1_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(rgbCom, 2048);
            text_10.setText(String.valueOf(rgb.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display1_b = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.SVIDEO.name().equals(name)) {
            Svideo svideo = (Svideo)dispParamObj.getSvideo().get(0);
            Composite svideoCom = new Composite(cs, 0);
            svideoCom.setLayout((Layout)this.rowLayout());
            svideoCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.svideo.name());
            Label label_4 = new Label(svideoCom, 0);
            label_4.setText(Messages.BaseparamComposite_37);
            Text text_12 = new Text(svideoCom, 2048);
            text_12.setText(String.valueOf(svideo.getU8DacY()));
            text_12.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1));
            this.textRowData(text_12);
            text_12.setTextLimit(3);
            text_12.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_12.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_12.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_12.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_12.setText("0");
                        return;
                    }
                    display1_svideoU8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_13 = new Text(svideoCom, 2048);
            text_13.setText(String.valueOf(svideo.getU8DacC()));
            text_13.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 2));
            this.textRowData(text_13);
            text_13.setTextLimit(3);
            text_13.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_13.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_13.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_13.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_13.setText("0");
                        return;
                    }
                    display1_svideoU8DacC = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.CVBS.name().equals(name)) {
            Cvbs cvbsOjb = (Cvbs)dispParamObj.getCvbs().get(0);
            Composite cvbsCom = new Composite(cs, 0);
            cvbsCom.setLayout((Layout)this.rowLayout());
            cvbsCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.cvbs.name());
            Label label_3 = new Label(cvbsCom, 0);
            label_3.setText(Messages.BaseparamComposite_38);
            Text text_11 = new Text(cvbsCom, 2048);
            text_11.setText(cvbsOjb.getCvbs());
            text_11.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1));
            this.textRowData(text_11);
            text_11.setTextLimit(3);
            text_11.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_11.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_11.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_11.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("CVBS" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_11.setText("0");
                        return;
                    }
                    display1_cvbs = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.HDMI.name().equals(name)) {
            Hdmi hdmiObj = (Hdmi)dispParamObj.getHdmi().get(0);
            int hdmi = hdmiObj.getHdmi();
            Composite hdmiCom = new Composite(cs, 0);
            hdmiCom.setLayout((Layout)this.rowLayout());
            hdmiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hdmi.name());
            Label label_5 = new Label(hdmiCom, 0);
            label_5.setText(Messages.BaseparamComposite_39);
            Combo combo_1 = new Combo(hdmiCom, 8);
            combo_1.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1));
            combo_1.setItems(new String[]{this.getHdmiArray(index)});
            combo_1.select(hdmi);
        }
        if (HI_UNF_MCE.DISPINTERFACEHI3796CV300.MIPI.name().equalsIgnoreCase(name)) {
            SubParam subParam;
            Composite mipiCom = new Composite(cs, 0);
            mipiCom.setLayout((Layout)this.rowLayout());
            mipiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.mipi.name());
            Label mipiLabel = new Label(mipiCom, 0);
            mipiLabel.setText(Messages.BaseparamComposite_mipi);
            mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)this.getMipiModeObj());
            Combo mipiCombo = new Combo(mipiCom, 8);
            mipiCombo.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.mipi.name()) + 1));
            mipiCombo.setItems(mipiArray);
            List<SubParam> SubParamMipi = dispParamObj.getMipi();
            if (SubParamMipi != null && SubParamMipi.size() > 0 && (subParam = SubParamMipi.get(0)) instanceof Mipi) {
                Mipi mipiData = (Mipi)subParam;
                mipiCombo.select(mipiData.getMipi());
            }
            mipiCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MipiModeObj mipiModeObj = (MipiModeObj)mipiCom.getData(DispParamObj.BASE_DISP_ATTRNAME.key.name());
                    DispMipiDialog dispMipiDialog = new DispMipiDialog(BaseparamComposite.this.getShell(), mipiModeObj);
                    dispMipiDialog.open();
                    mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)mipiModeObj);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT656.name().equals(name)) {
            Bt656 bt656Obj = (Bt656)dispParamObj.getBt656().get(0);
            int bt656 = bt656Obj.getBt656();
            Composite bt656Com = new Composite(cs, 0);
            bt656Com.setLayout((Layout)this.rowLayout());
            bt656Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt656.name());
            Label label_6 = new Label(bt656Com, 0);
            label_6.setText(Messages.BaseparamComposite_40);
            Combo combo_2 = new Combo(bt656Com, 8);
            combo_2.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt656.name()) + 1));
            combo_2.setItems(this.getBt656Array());
            combo_2.select(bt656);
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT1120.name().equals(name)) {
            Bt1120 Bt1120Obj = (Bt1120)dispParamObj.getBt1120().get(0);
            int bt1120 = Bt1120Obj.getBt1120();
            Composite bt1120Com = new Composite(cs, 0);
            bt1120Com.setLayout((Layout)this.rowLayout());
            bt1120Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt1120.name());
            Label Label_7 = new Label(bt1120Com, 0);
            Label_7.setText(Messages.BaseparamComposite_41);
            Combo combo_3 = new Combo(bt1120Com, 8);
            combo_3.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1));
            combo_3.setItems(this.getBt1120Array());
            combo_3.select(bt1120);
        }
        if (HI_UNF_MCE.DISPINTERFACE.LCD.name().equals(name)) {
            Lcd lcdObj = (Lcd)dispParamObj.getLcd().get(0);
            int lcd = lcdObj.getLcd();
            Composite lcdCom = new Composite(cs, 0);
            lcdCom.setLayout((Layout)this.rowLayout());
            lcdCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.lcd.name());
            Label label_8 = new Label(lcdCom, 0);
            label_8.setText(Messages.BaseparamComposite_42);
            Combo combo_4 = new Combo(lcdCom, 8);
            combo_4.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1));
            combo_4.setItems(this.getLcdArray());
            combo_4.select(lcd);
        }
        if (HI_UNF_MCE.DISPINTERFACE.VGA.name().equals(name)) {
            Vga vga = (Vga)dispParamObj.getVga().get(0);
            Composite vgaCom = new Composite(cs, 0);
            vgaCom.setLayout((Layout)this.rowLayout());
            vgaCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vga.name());
            label_2 = new Label(vgaCom, 0);
            label_2.setText(Messages.BaseparamComposite_46);
            text_8 = new Text(vgaCom, 2048);
            text_8.setText(String.valueOf(vga.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display1_vga_v = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(vgaCom, 2048);
            text_9.setText(String.valueOf(vga.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display1_vga_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(vgaCom, 2048);
            text_10.setText(String.valueOf(vga.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display1_vga_a = Integer.parseInt(textStr);
                }
            });
        }
    }

    private void readAndCreatDisplay0(Composite cs, String name, DispParamObj dispParamObj) {
        SubParam bt656Obj;
        Text text_10;
        Text text_9;
        Text text_8;
        Label label_2;
        int index = 0;
        if (HI_UNF_MCE.DISPINTERFACE.YPBPR.name().equals(name)) {
            Ypbpr ypbpr = (Ypbpr)dispParamObj.getYpbpr().get(0);
            Composite ypbprCom = new Composite(cs, 0);
            ypbprCom.setLayout((Layout)this.rowLayout());
            ypbprCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name());
            Label label_1 = new Label(ypbprCom, 0);
            label_1.setText(Messages.BaseparamComposite_35);
            Text text_5 = new Text(ypbprCom, 2048);
            text_5.setText(ypbpr.getU8DacY());
            text_5.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1));
            this.textRowData(text_5);
            text_5.setTextLimit(3);
            text_5.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_5.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_5.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_5.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_5.setText("0");
                        return;
                    }
                    display0_u8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_6 = new Text(ypbprCom, 2048);
            text_6.setText(ypbpr.getU8DacPb());
            text_6.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 2));
            this.textRowData(text_6);
            text_6.setTextLimit(3);
            text_6.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_6.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_6.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_6.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_6.setText("0");
                        return;
                    }
                    display0_u8DacPb = Integer.parseInt(textStr);
                }
            });
            Text text_7 = new Text(ypbprCom, 2048);
            text_7.setText(ypbpr.getU8DacPr());
            text_7.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 3));
            this.textRowData(text_7);
            text_7.setTextLimit(3);
            text_7.setText(String.valueOf(display0_u8DacPr));
            text_7.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_7.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_7.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_7.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_7.setText("0");
                        return;
                    }
                    display0_u8DacPr = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.RGB.name().equals(name)) {
            Rgb rgb = (Rgb)dispParamObj.getRgb().get(0);
            Composite rgbCom = new Composite(cs, 0);
            rgbCom.setLayout((Layout)this.rowLayout());
            rgbCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.rgb.name());
            label_2 = new Label(rgbCom, 0);
            label_2.setText(Messages.BaseparamComposite_36);
            text_8 = new Text(rgbCom, 2048);
            text_8.setText(String.valueOf(rgb.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display0_r = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(rgbCom, 2048);
            text_9.setText(String.valueOf(rgb.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display0_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(rgbCom, 2048);
            text_10.setText(String.valueOf(rgb.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("RGB" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display0_b = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.SVIDEO.name().equals(name)) {
            Svideo svideo = (Svideo)dispParamObj.getSvideo().get(0);
            Composite svideoCom = new Composite(cs, 0);
            svideoCom.setLayout((Layout)this.rowLayout());
            svideoCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.svideo.name());
            Label label_4 = new Label(svideoCom, 0);
            label_4.setText(Messages.BaseparamComposite_37);
            Text text_12 = new Text(svideoCom, 2048);
            text_12.setText(String.valueOf(svideo.getU8DacY()));
            text_12.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1));
            this.textRowData(text_12);
            text_12.setTextLimit(3);
            text_12.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_12.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_12.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_12.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_12.setText("0");
                        return;
                    }
                    display0_svideoU8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_13 = new Text(svideoCom, 2048);
            text_13.setText(String.valueOf(svideo.getU8DacC()));
            text_13.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 2));
            this.textRowData(text_13);
            text_13.setTextLimit(3);
            text_13.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_13.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_13.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_13.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("SVIDEO" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_13.setText("0");
                        return;
                    }
                    display0_svideoU8DacC = Integer.parseInt(textStr);
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.CVBS.name().equals(name)) {
            Cvbs cvbsOjb = (Cvbs)dispParamObj.getCvbs().get(0);
            Composite cvbsCom = new Composite(cs, 0);
            cvbsCom.setLayout((Layout)this.rowLayout());
            cvbsCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.cvbs.name());
            Label label_3 = new Label(cvbsCom, 0);
            label_3.setText(Messages.BaseparamComposite_38);
            Text text_11 = new Text(cvbsCom, 2048);
            text_11.setText(cvbsOjb.getCvbs());
            text_11.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1));
            this.textRowData(text_11);
            text_11.setTextLimit(3);
            text_11.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_11.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_11.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_11.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("CVBS" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_11.setText("0");
                        return;
                    }
                    BaseparamComposite.this.setDisPlay0Cvbs(Integer.parseInt(textStr));
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.HDMI.name().equals(name)) {
            Hdmi hdmiObj = (Hdmi)dispParamObj.getHdmi().get(0);
            int hdmi = hdmiObj.getHdmi();
            Composite hdmiCom = new Composite(cs, 0);
            hdmiCom.setLayout((Layout)this.rowLayout());
            hdmiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hdmi.name());
            Label label_5 = new Label(hdmiCom, 0);
            label_5.setText(Messages.BaseparamComposite_39);
            Combo combo_1 = new Combo(hdmiCom, 8);
            combo_1.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1));
            combo_1.setItems(new String[]{this.getHdmiArray(index)});
            combo_1.select(hdmi);
        }
        if (HI_UNF_MCE.DISPINTERFACEHI3796CV300.MIPI.name().equalsIgnoreCase(name)) {
            SubParam subParam;
            Composite mipiCom = new Composite(cs, 0);
            mipiCom.setLayout((Layout)this.rowLayout());
            mipiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.mipi.name());
            Label mipiLabel = new Label(mipiCom, 0);
            mipiLabel.setText(Messages.BaseparamComposite_mipi);
            mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)this.getMipiModeObj());
            Combo mipiCombo = new Combo(mipiCom, 8);
            mipiCombo.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.mipi.name()) + 1));
            mipiCombo.setItems(mipiArray);
            List<SubParam> SubParamMipi = dispParamObj.getMipi();
            if (SubParamMipi != null && SubParamMipi.size() > 0 && (subParam = SubParamMipi.get(0)) instanceof Mipi) {
                Mipi mipiData = (Mipi)subParam;
                mipiCombo.select(mipiData.getMipi());
            }
            mipiCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MipiModeObj mipiModeObj = (MipiModeObj)mipiCom.getData(DispParamObj.BASE_DISP_ATTRNAME.key.name());
                    DispMipiDialog dispMipiDialog = new DispMipiDialog(BaseparamComposite.this.getShell(), mipiModeObj);
                    dispMipiDialog.open();
                    mipiCom.setData(DispParamObj.BASE_DISP_ATTRNAME.key.name(), (Object)mipiModeObj);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT656.name().equals(name)) {
            bt656Obj = (Bt656)dispParamObj.getBt656().get(0);
            int bt656 = ((Bt656)bt656Obj).getBt656();
            Composite bt656Com = new Composite(cs, 0);
            bt656Com.setLayout((Layout)this.rowLayout());
            bt656Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt656.name());
            Label label_6 = new Label(bt656Com, 0);
            label_6.setText(Messages.BaseparamComposite_40);
            Combo combo_2 = new Combo(bt656Com, 8);
            combo_2.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt656.name()) + 1));
            combo_2.setItems(this.getBt656Array());
            combo_2.select(bt656);
        }
        if (HI_UNF_MCE.DISPINTERFACE.BT1120.name().equals(name)) {
            bt656Obj = (Bt1120)dispParamObj.getBt1120().get(0);
            int bt1120 = ((Bt1120)bt656Obj).getBt1120();
            Composite bt1120Com = new Composite(cs, 0);
            bt1120Com.setLayout((Layout)this.rowLayout());
            bt1120Com.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bt1120.name());
            Label Label_7 = new Label(bt1120Com, 0);
            Label_7.setText(Messages.BaseparamComposite_41);
            Combo combo_3 = new Combo(bt1120Com, 8);
            combo_3.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1));
            combo_3.setItems(this.getBt1120Array());
            combo_3.select(bt1120);
        }
        if (HI_UNF_MCE.DISPINTERFACE.LCD.name().equals(name)) {
            Lcd lcdObj = (Lcd)dispParamObj.getLcd().get(0);
            int lcd = lcdObj.getLcd();
            Composite lcdCom = new Composite(cs, 0);
            lcdCom.setLayout((Layout)this.rowLayout());
            lcdCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.lcd.name());
            Label label_8 = new Label(lcdCom, 0);
            label_8.setText(Messages.BaseparamComposite_42);
            Combo combo_4 = new Combo(lcdCom, 8);
            combo_4.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1));
            combo_4.setItems(this.getLcdArray());
            combo_4.select(lcd);
        }
        if (HI_UNF_MCE.DISPINTERFACE.VGA.name().equals(name)) {
            Vga vga = (Vga)dispParamObj.getVga().get(0);
            Composite vgaCom = new Composite(cs, 0);
            vgaCom.setLayout((Layout)this.rowLayout());
            vgaCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vga.name());
            label_2 = new Label(vgaCom, 0);
            label_2.setText(Messages.BaseparamComposite_46);
            text_8 = new Text(vgaCom, 2048);
            text_8.setText(String.valueOf(vga.getR()));
            text_8.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1));
            this.textRowData(text_8);
            text_8.setTextLimit(3);
            text_8.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_8.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_8.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_8.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_8.setText("0");
                        return;
                    }
                    display0_vga_v = Integer.parseInt(textStr);
                }
            });
            text_9 = new Text(vgaCom, 2048);
            text_9.setText(String.valueOf(vga.getG()));
            text_9.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 2));
            this.textRowData(text_9);
            text_9.setTextLimit(3);
            text_9.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_9.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_9.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_9.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_9.setText("0");
                        return;
                    }
                    display0_vga_g = Integer.parseInt(textStr);
                }
            });
            text_10 = new Text(vgaCom, 2048);
            text_10.setText(String.valueOf(vga.getB()));
            text_10.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 3));
            this.textRowData(text_10);
            text_10.setTextLimit(3);
            text_10.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_10.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_10.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_10.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("VGA" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_10.setText("0");
                        return;
                    }
                    display0_vga_a = Integer.parseInt(textStr);
                }
            });
        }
    }

    private String[] getInterfaceNames(Group cs) {
        Control[] children = cs.getChildren();
        int len = children.length;
        if (len < 1) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Control con = controlArray[n2];
            if (con != null && con.getData() != null && !"BASEKEYENABLE".equalsIgnoreCase(name = con.getData().toString())) {
                nameList.add(con.getData().toString().toUpperCase());
            }
            ++n2;
        }
        String[] names = new String[nameList.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = ((String)nameList.get(i)).toString();
            ++i;
        }
        return names;
    }

    public static GridData fillGridFill(Control control) {
        GridData layoutData = new GridData(4, 1, true, false);
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    public static GridData fillGridBeginning(Control control) {
        GridData layoutData = new GridData(1, 1, false, false);
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    public static GridData fillDefaultSpinner(Control control) {
        GridData spinnerGD = new GridData(1, 1, false, false);
        spinnerGD.widthHint = 35;
        control.setLayoutData((Object)spinnerGD);
        return spinnerGD;
    }

    private void hideOrShowI2sArea(Composite body, FormToolkit ft, ScrolledForm form) {
        Collection<Composite> soundComposite = this.wgetParam.getSoundComposite().values();
        ArrayList<Object> findComtrol = new ArrayList<Object>();
        boolean exsitI2sControl = false;
        for (Composite com : soundComposite) {
            this.findWidgetByData((Control)com, SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name(), findComtrol);
            if (findComtrol.size() <= 0) continue;
            exsitI2sControl = true;
            break;
        }
        int i2sNum = this.wgetParam.getI2sComposite().values().size();
        if (exsitI2sControl) {
            this.checkCreateI2sArea(body, ft, form);
        } else if (i2sNum > 0) {
            this.removeI2sPanle(body);
        }
    }

    private void removeI2sPanle(Composite body) {
        Control[] children = body.getChildren();
        int i = 0;
        while (i < children.length) {
            if (SectionType.I2S.name().equals(children[i].getData())) {
                children[i].dispose();
                children[i] = null;
            }
            ++i;
        }
        this.wgetParam.getI2sComposite().clear();
    }

    private void createSoundArea(Composite body, FormToolkit ft, ScrolledForm form, Section section, int soundIndex) {
        String soundName = BaseparamComposite.getSoundNames(soundIndex);
        section.setText(soundName);
        Composite soundCom = ft.createComposite((Composite)section);
        soundCom.setLayout((Layout)new GridLayout());
        Group cs = new Group(soundCom, 64);
        cs.setText(Messages.BaseparamComposite_16);
        GridLayout gridLayout = new GridLayout(10, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Button interButton = ft.createButton((Composite)cs, Messages.BaseparamComposite_9, 0);
        interButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] oldNames = BaseparamComposite.this.getInterfaceNames(cs);
                BaseparamComposite.this.interFaceDialog = new InterFaceDialog(BaseparamComposite.this.getShell(), oldNames, "SOUND");
                BaseparamComposite.this.interFaceDialog.open();
                Object[] typeObj = BaseparamComposite.this.interFaceDialog.getTypeObj();
                if ((Integer)typeObj[0] == 0) {
                    return;
                }
                BaseparamComposite.this.setInterfaceCntrol((Composite)cs, (String[])typeObj[1], "SOUND", body, ft, form, section, soundName);
                BaseparamComposite.this.hideOrShowI2sArea(body, ft, form);
                cs.layout(true);
                form.reflow(true);
            }
        });
        if (soundIndex == 0) {
            GridData interBData = new GridData();
            interBData.horizontalSpan = 10;
            interButton.setLayoutData((Object)interBData);
            this.createSpdif(cs);
            this.createDac(cs);
            this.createHdmi(cs, soundIndex);
        }
        section.setClient((Control)soundCom);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        this.wgetParam.addSoundComposite(soundIndex, soundCom);
    }

    private void createSpdif(Group cs) {
        Composite spdifCom = new Composite((Composite)cs, 0);
        spdifCom.setLayout((Layout)this.rowLayout());
        spdifCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name());
        Label spdiLbl = new Label(spdifCom, 0);
        spdiLbl.setText("SPDIF:");
        Combo spdicb = new Combo(spdifCom, 8);
        spdicb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 1));
        spdicb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_SPDIF_OUTPUTPORT_E.values()));
        spdicb.select(0);
        Label spdofVolLabel = new Label(spdifCom, 0);
        spdofVolLabel.setText("VOL:");
        Spinner spdifSpinner = this.createSpinner(spdifCom, 2048, 0, 30, 100, 1, 1, 0);
        spdifSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 2));
        spdifSpinner.setToolTipText("Spdif Volume");
    }

    private void createDac(Group cs) {
        Composite dacCom = new Composite((Composite)cs, 0);
        dacCom.setLayout((Layout)this.rowLayout());
        dacCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.dac.name());
        Label dacLbl = new Label(dacCom, 0);
        dacLbl.setText("DAC:");
        Combo daccb = new Combo(dacCom, 8);
        daccb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 1));
        daccb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HIUNF_DAC_OUTPUTPORT_E.values()));
        daccb.select(0);
        Label dacVolLabel = new Label(dacCom, 0);
        dacVolLabel.setText("VOL:");
        Spinner dacSpinner = this.createSpinner(dacCom, 2048, 0, 30, 100, 1, 1, 0);
        dacSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 2));
        dacSpinner.setToolTipText("Dac Volume");
    }

    private void createHdmi(Group cs, int soundIndex) {
        Composite hdmiCom = new Composite((Composite)cs, 0);
        hdmiCom.setLayout((Layout)this.rowLayout());
        hdmiCom.setData((Object)SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name());
        Label hdmiLbl = new Label(hdmiCom, 0);
        hdmiLbl.setText("HDMI:");
        Combo hdmicb = new Combo(hdmiCom, 8);
        hdmicb.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 1));
        hdmicb.setItems(new String[]{this.getHdmiArray(soundIndex)});
        hdmicb.select(0);
        Label soundHdmiVolLabel = new Label(hdmiCom, 0);
        soundHdmiVolLabel.setText("VOL:");
        Spinner soundHdmiSpinner = this.createSpinner(hdmiCom, 2048, 0, 30, 100, 1, 1, 0);
        soundHdmiSpinner.setData((Object)(String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 2));
        soundHdmiSpinner.setToolTipText("Sound Hdmi Volume");
    }

    private void createInterfcAreaHi3796CV300(FormToolkit ft, ScrolledForm form, Composite dispCom, Section section, String dispName) {
        Group cs = new Group(dispCom, 64);
        cs.setText(Messages.BaseparamComposite_16);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Button interButton = ft.createButton((Composite)cs, Messages.BaseparamComposite_9, 0);
        interButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] oldNames = BaseparamComposite.this.getInterfaceNames(cs);
                BaseparamComposite.this.interFaceDialog = new InterFaceDialog(BaseparamComposite.this.getShell(), oldNames, "disp");
                BaseparamComposite.this.interFaceDialog.open();
                Object[] typeObj = BaseparamComposite.this.interFaceDialog.getTypeObj();
                if ((Integer)typeObj[0] == 0) {
                    return;
                }
                BaseparamComposite.this.setInterfaceCntrol((Composite)cs, (String[])typeObj[1], "disp", null, null, null, null, dispName);
                cs.layout(true);
                form.reflow(true);
            }
        });
        GridData interBData = new GridData();
        interBData.horizontalSpan = 7;
        interButton.setLayoutData((Object)interBData);
        if ("Display0".equals(dispName)) {
            Cvbs cvbs = new Cvbs(String.valueOf(disPlay0Cvbs));
            Composite cvbsCom = new Composite((Composite)cs, 0);
            cvbsCom.setLayout((Layout)this.rowLayout());
            cvbsCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.cvbs.name());
            Label cvbsLabel = new Label(cvbsCom, 0);
            cvbsLabel.setText(Messages.BaseparamComposite_38);
            Text cvbsText = ft.createText(cvbsCom, cvbs.getCvbs());
            cvbsText.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1));
            this.textRowData(cvbsText);
            cvbsText.setTextLimit(3);
            cvbsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = cvbsText.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        cvbsText.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        cvbsText.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) < 0 || Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("CVBS" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        cvbsText.setText("0");
                        return;
                    }
                    BaseparamComposite.this.setDisPlay0Cvbs(Integer.parseInt(textStr));
                }
            });
        }
        if ("Display1".equals(dispName) || "Display2".equals(dispName)) {
            Composite hdmiCom = new Composite((Composite)cs, 0);
            hdmiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hdmi.name());
            hdmiCom.setLayout((Layout)this.rowLayout());
            Label hdmiLabel = new Label(hdmiCom, 0);
            hdmiLabel.setText(Messages.BaseparamComposite_39);
            Combo hdmiCombo = new Combo(hdmiCom, 8);
            hdmiCombo.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1));
            hdmiCombo.setItems(new String[]{this.getHdmiArray(1)});
            hdmiCombo.select(0);
        }
    }

    private void createInterfcArea(FormToolkit ft, ScrolledForm form, Composite section, String dispName) {
        Group cs = new Group(section, 64);
        cs.setText(Messages.BaseparamComposite_16);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Button interButton = ft.createButton((Composite)cs, Messages.BaseparamComposite_9, 0);
        interButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] oldNames = BaseparamComposite.this.getInterfaceNames(cs);
                BaseparamComposite.this.interFaceDialog = new InterFaceDialog(BaseparamComposite.this.getShell(), oldNames, "disp");
                BaseparamComposite.this.interFaceDialog.open();
                Object[] typeObj = BaseparamComposite.this.interFaceDialog.getTypeObj();
                if ((Integer)typeObj[0] == 0) {
                    return;
                }
                BaseparamComposite.this.setInterfaceCntrol((Composite)cs, (String[])typeObj[1], "disp", null, null, null, null, dispName);
                cs.layout(true);
                form.reflow(true);
            }
        });
        GridData interBData = new GridData();
        interBData.horizontalSpan = 7;
        interButton.setLayoutData((Object)interBData);
        if ("Display0".equals(dispName)) {
            Cvbs cvbs = new Cvbs(String.valueOf(disPlay0Cvbs));
            Composite cvbsCom = new Composite((Composite)cs, 0);
            cvbsCom.setLayout((Layout)this.rowLayout());
            cvbsCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.cvbs.name());
            Label label_1 = new Label(cvbsCom, 0);
            label_1.setText(Messages.BaseparamComposite_38);
            Text text_11 = ft.createText(cvbsCom, cvbs.getCvbs());
            text_11.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1));
            this.textRowData(text_11);
            text_11.setTextLimit(3);
            text_11.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_11.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_11.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_11.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("CVBS" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_11.setText("0");
                        return;
                    }
                    BaseparamComposite.this.setDisPlay0Cvbs(Integer.parseInt(textStr));
                }
            });
        }
        if ("Display1".equals(dispName)) {
            Ypbpr ypbpr = new Ypbpr(String.valueOf(display1_u8DacY), String.valueOf(display1_u8DacPb), String.valueOf(display1_u8DacPr));
            Composite ypbprCom = new Composite((Composite)cs, 0);
            ypbprCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name());
            ypbprCom.setLayout((Layout)this.rowLayout());
            Label label_2 = new Label(ypbprCom, 0);
            label_2.setText(Messages.BaseparamComposite_35);
            Text text_5 = new Text(ypbprCom, 2048);
            text_5.setText(ypbpr.getU8DacY());
            text_5.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1));
            this.textRowData(text_5);
            text_5.setTextLimit(3);
            text_5.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_5.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_5.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_5.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_5.setText("0");
                        return;
                    }
                    display1_u8DacY = Integer.parseInt(textStr);
                }
            });
            Text text_6 = new Text(ypbprCom, 2048);
            text_6.setText(ypbpr.getU8DacPb());
            text_6.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 2));
            this.textRowData(text_6);
            text_6.setTextLimit(3);
            text_6.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_6.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_6.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_6.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_6.setText("0");
                        return;
                    }
                    display1_u8DacPb = Integer.parseInt(textStr);
                }
            });
            Text text_7 = new Text(ypbprCom, 2048);
            text_7.setText(ypbpr.getU8DacPr());
            text_7.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 3));
            this.textRowData(text_7);
            text_7.setTextLimit(3);
            text_7.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = text_7.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                        text_7.setText("0");
                        return;
                    }
                    if (textStr.length() <= 0) {
                        text_7.setText("0");
                        return;
                    }
                    if (Integer.parseInt(textStr) > 255) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)("Ypbpr" + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(255))));
                        text_7.setText("0");
                        return;
                    }
                    display1_u8DacPr = Integer.parseInt(textStr);
                }
            });
            Composite hdmiCom = new Composite((Composite)cs, 0);
            hdmiCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hdmi.name());
            hdmiCom.setLayout((Layout)this.rowLayout());
            Label label_3 = new Label(hdmiCom, 0);
            label_3.setText(Messages.BaseparamComposite_39);
            Combo combo_1 = new Combo(hdmiCom, 8);
            combo_1.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1));
            combo_1.setItems(new String[]{this.getHdmiArray(1)});
            combo_1.select(0);
        }
    }

    private void textRowData(Text text) {
        text.setLayoutData((Object)new RowData(50, 15));
    }

    private void enabledControl(boolean isSelect, Composite group, int dispIndex) {
        Composite dispGroup;
        String[] tempStr = new String[]{DispParamObj.BASE_DISP_ATTRNAME.bgColor.name(), DispParamObj.BASE_DISP_ATTRNAME.hueplus.name(), DispParamObj.BASE_DISP_ATTRNAME.saturation.name(), DispParamObj.BASE_DISP_ATTRNAME.brightness.name(), DispParamObj.BASE_DISP_ATTRNAME.constrast.name(), DispParamObj.BASE_DISP_ATTRNAME.virtualWidth.name(), DispParamObj.BASE_DISP_ATTRNAME.virtualHeight.name(), DispParamObj.BASE_DISP_ATTRNAME.pixelFormat.name(), DispParamObj.BASE_DISP_ATTRNAME.gammaEnable.name()};
        if (FastplayView.isHi3796CV300Series()) {
            tempStr = new String[]{DispParamObj.BASE_DISP_ATTRNAME.bgColorR.name(), DispParamObj.BASE_DISP_ATTRNAME.bgColorG.name(), DispParamObj.BASE_DISP_ATTRNAME.bgColorB.name(), DispParamObj.BASE_DISP_ATTRNAME.hueplus.name(), DispParamObj.BASE_DISP_ATTRNAME.colortemperature.name(), DispParamObj.BASE_DISP_ATTRNAME.saturation.name(), DispParamObj.BASE_DISP_ATTRNAME.brightness.name(), DispParamObj.BASE_DISP_ATTRNAME.constrast.name(), DispParamObj.BASE_DISP_ATTRNAME.virtualWidth.name(), DispParamObj.BASE_DISP_ATTRNAME.virtualHeight.name(), DispParamObj.BASE_DISP_ATTRNAME.pixelFormat.name(), DispParamObj.BASE_DISP_ATTRNAME.gammaEnable.name(), DispParamObj.BASE_DISP_ATTRNAME.logoIndex.name(), DispParamObj.BASE_DISP_ATTRNAME.panelIndex.name()};
        }
        if ((dispGroup = this.getCurrentGroup(0, Messages.BaseparamComposite_20)) == null) {
            return;
        }
        if (isSelect) {
            String[] stringArray = tempStr;
            int n = tempStr.length;
            int n2 = 0;
            while (n2 < n) {
                String data = stringArray[n2];
                if (this.findActiveCon(dispGroup, data) == null) {
                    return;
                }
                this.findActiveCon(dispGroup, data).setEnabled(false);
                ++n2;
            }
        } else {
            String[] stringArray = tempStr;
            int n = tempStr.length;
            int n3 = 0;
            while (n3 < n) {
                String data = stringArray[n3];
                if (this.findActiveCon(dispGroup, data) == null) {
                    return;
                }
                this.findActiveCon(dispGroup, data).setEnabled(true);
                ++n3;
            }
        }
    }

    private void createBindSourceArea(FormToolkit ft, ScrolledForm form, Composite section, String[] dispNameArray, int dispIndex) {
        Group cs = new Group(section, 64);
        cs.setText(Messages.BaseparamComposite_17);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Composite buindCom = new Composite((Composite)cs, 0);
        buindCom.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name());
        buindCom.setLayout((Layout)new GridLayout(2, false));
        Button isBind = new Button(buindCom, 32);
        isBind.setText(Messages.BaseparamComposite_18);
        isBind.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name());
        GridData data = new GridData();
        data.horizontalSpan = 4;
        isBind.setLayoutData((Object)data);
        if (FastplayView.isHi3796CV300Series()) {
            isBind.setSelection(false);
            this.enabledControl(false, (Composite)cs, dispIndex);
            BaseparamComposite.setBindSource(false);
        } else {
            isBind.setSelection(true);
            this.enabledControl(true, (Composite)cs, dispIndex);
            BaseparamComposite.setBindSource(true);
        }
        Button bindDisp = null;
        isBind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkBtn = (Button)e.getSource();
                Control findActiveCon = BaseparamComposite.this.findActiveCon(buindCom, DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name());
                if (checkBtn.getSelection()) {
                    BaseparamComposite.this.enabledControl(true, (Composite)cs, dispIndex);
                    ((Button)findActiveCon).setSelection(true);
                    BaseparamComposite.setBindSource(true);
                } else {
                    BaseparamComposite.this.enabledControl(false, (Composite)cs, dispIndex);
                    ((Button)findActiveCon).setSelection(false);
                    BaseparamComposite.setBindSource(false);
                }
            }
        });
        Label sourceLbl = new Label(buindCom, 0);
        sourceLbl.setText(Messages.BaseparamComposite_19);
        if (dispIndex == 0) {
            bindDisp = new Button(buindCom, 16);
            bindDisp.setText(dispNameArray[1]);
            bindDisp.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name()) + 1));
            bindDisp.setSelection(true);
        } else if (FastplayView.isHi3796CV300Series()) {
            bindDisp = new Button(buindCom, 16);
            bindDisp.setText(dispNameArray[0]);
            bindDisp.setData((Object)(String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name()) + 1));
            bindDisp.setSelection(true);
        }
    }

    private void createDisplayArea(FormToolkit ft, ScrolledForm form, Composite section, int dispIndex) {
        Group cs = new Group(section, 64);
        cs.setText(Messages.BaseparamComposite_20);
        GridLayout gridLayout = new GridLayout(12, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Label label = new Label((Composite)cs, 0);
        label.setText(Messages.BaseparamComposite_21);
        Combo combo = new Combo((Composite)cs, 8);
        combo.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.format.name());
        if (FastplayView.isHi3796CV300Series()) {
            combo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E_HI3796CV300.values()));
            int select = HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E_HI3796CV300.FMT_3840X2160_60.ordinal();
            if (dispIndex == 1 || dispIndex == 2) {
                select = HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E_HI3796CV300.FMT_1080P_60.ordinal();
            }
            combo.select(select);
        } else {
            combo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.values()));
            combo.select(HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080i_50.ordinal());
        }
        this.initFormatValue(dispIndex);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ((Combo)e.getSource()).getSelectionIndex();
                if (index == HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.CUSTOM_TIMING.ordinal() || index == HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E_HI3796CV300.CUSTOM_TIMING.ordinal()) {
                    BaseparamComposite.this.dispTimingDialog = new DispTimingDialog(BaseparamComposite.this.getShell(), BaseparamComposite.this.wgetParam, dispIndex);
                    BaseparamComposite.this.dispTimingDialog.open();
                    DispParamObj dispParamObj = BaseparamComposite.this.dispTimingDialog.getDispParamObj();
                    if (dispParamObj == null) {
                        return;
                    }
                    BaseparamComposite.this.wgetParam.addDispTimingDispParamObj(dispIndex, dispParamObj);
                    cs.layout(true);
                    form.reflow(true);
                }
            }
        });
        this.fillHorizontal((Control)combo);
        if (FastplayView.isHi3796CV300Series()) {
            Label label_2R = new Label((Composite)cs, 0);
            label_2R.setText(Messages.BaseparamComposite_bgColorR);
            Text bgColorTextR = new Text((Composite)cs, 2048);
            bgColorTextR.setText("0");
            bgColorTextR.setTextLimit(5);
            bgColorTextR.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bgColorR.name());
            this.fillHorizontal((Control)bgColorTextR);
            this.automaticParameter((Control)bgColorTextR, dispIndex);
            bgColorTextListR.add(bgColorTextR);
            Label label_2G = new Label((Composite)cs, 0);
            label_2G.setText(Messages.BaseparamComposite_bgColorG);
            Text bgColorTextG = new Text((Composite)cs, 2048);
            bgColorTextG.setText("0");
            bgColorTextG.setTextLimit(5);
            bgColorTextG.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bgColorG.name());
            this.fillHorizontal((Control)bgColorTextG);
            this.automaticParameter((Control)bgColorTextG, dispIndex);
            bgColorTextListG.add(bgColorTextG);
            Label label_2B = new Label((Composite)cs, 0);
            label_2B.setText(Messages.BaseparamComposite_bgColorB);
            Text bgColorTextB = new Text((Composite)cs, 2048);
            bgColorTextB.setText("0");
            bgColorTextB.setTextLimit(5);
            bgColorTextB.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bgColorB.name());
            this.fillHorizontal((Control)bgColorTextB);
            this.automaticParameter((Control)bgColorTextB, dispIndex);
            bgColorTextListB.add(bgColorTextB);
        } else {
            Label label_2 = new Label((Composite)cs, 0);
            label_2.setText(Messages.BaseparamComposite_23);
            Text bgColorText = new Text((Composite)cs, 2048);
            bgColorText.setText("0x000000");
            bgColorText.setTextLimit(8);
            bgColorText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bgColor.name());
            this.fillHorizontal((Control)bgColorText);
            this.automaticParameter((Control)bgColorText, dispIndex);
            bgColorText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String textStr = bgColorText.getText();
                    if (textStr == null) {
                        return;
                    }
                    if (textStr.equalsIgnoreCase("")) {
                        bgColorText.setText("0x0");
                        return;
                    }
                }
            });
            bgColorTextList.add(bgColorText);
        }
        Label label_1 = new Label((Composite)cs, 0);
        label_1.setText(Messages.BaseparamComposite_22);
        Text hueplusText = new Text((Composite)cs, 2048);
        hueplusText.setText("50");
        hueplusText.setTextLimit(3);
        hueplusText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hueplus.name());
        this.fillHorizontal((Control)hueplusText);
        BaseparamComposite.addModifyListene(hueplusText);
        this.automaticParameter((Control)hueplusText, dispIndex);
        hueplusTextList.add(hueplusText);
        if (FastplayView.isHi3796CV300Series()) {
            Label labelColorTemperature = new Label((Composite)cs, 0);
            labelColorTemperature.setText(Messages.BaseparamComposite_ColorTemperature);
            Text textColorTemperature = new Text((Composite)cs, 2048);
            textColorTemperature.setText("50");
            textColorTemperature.setTextLimit(4);
            textColorTemperature.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.colortemperature.name());
            this.fillHorizontal((Control)textColorTemperature);
            BaseparamComposite.addModifyListene(textColorTemperature);
            this.automaticParameter((Control)textColorTemperature, dispIndex);
            colorTemperatureTextList.add(textColorTemperature);
        }
        Label label_3 = new Label((Composite)cs, 0);
        label_3.setText(Messages.BaseparamComposite_24);
        Text saturationText = new Text((Composite)cs, 2048);
        saturationText.setText("50");
        saturationText.setTextLimit(3);
        saturationText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.saturation.name());
        this.fillHorizontal((Control)saturationText);
        BaseparamComposite.addModifyListene(saturationText);
        this.automaticParameter((Control)saturationText, dispIndex);
        saturationTextList.add(saturationText);
        Label label_4 = new Label((Composite)cs, 0);
        label_4.setText(Messages.BaseparamComposite_25);
        Text brightnessText = new Text((Composite)cs, 2048);
        brightnessText.setText("50");
        brightnessText.setTextLimit(3);
        brightnessText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.brightness.name());
        brightnessText.setTextLimit(8);
        this.fillHorizontal((Control)brightnessText);
        BaseparamComposite.addModifyListene(brightnessText);
        this.automaticParameter((Control)brightnessText, dispIndex);
        brightnessTextList.add(brightnessText);
        Label label_5 = new Label((Composite)cs, 0);
        label_5.setText(Messages.BaseparamComposite_26);
        Text contrastText = new Text((Composite)cs, 2048);
        contrastText.setText("50");
        contrastText.setTextLimit(3);
        contrastText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.constrast.name());
        contrastText.setTextLimit(8);
        BaseparamComposite.addModifyListene(contrastText);
        this.fillHorizontal((Control)contrastText);
        this.automaticParameter((Control)contrastText, dispIndex);
        contrastTextList.add(contrastText);
        if (FastplayView.isHi3796CV300Series()) {
            hueplusText.setTextLimit(4);
            saturationText.setTextLimit(4);
            brightnessText.setTextLimit(4);
            contrastText.setTextLimit(4);
        }
        Label label_12 = new Label((Composite)cs, 0);
        label_12.setText(Messages.BaseparamComposite_31);
        String widthStr = "1280";
        if (FastplayView.isHi3796CV300Series()) {
            widthStr = "1920";
            if (dispIndex == 0) {
                widthStr = "3840";
            }
        }
        Text virtualScreenWidthText = new Text((Composite)cs, 2048);
        virtualScreenWidthText.setText(widthStr);
        virtualScreenWidthText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.virtualWidth.name());
        virtualScreenWidthText.setTextLimit(4);
        this.fillHorizontal((Control)virtualScreenWidthText);
        BaseparamComposite.addModifyListene(virtualScreenWidthText);
        this.automaticParameter((Control)virtualScreenWidthText, dispIndex);
        virtualScreenWidthTextList.add(virtualScreenWidthText);
        Label label_13 = new Label((Composite)cs, 0);
        label_13.setText(Messages.BaseparamComposite_32);
        String heightStr = "720";
        if (FastplayView.isHi3796CV300Series()) {
            heightStr = "1080";
            if (dispIndex == 0) {
                heightStr = "2160";
            }
        }
        Text virtualScreenHeightText = new Text((Composite)cs, 2048);
        virtualScreenHeightText.setText(heightStr);
        virtualScreenHeightText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.virtualHeight.name());
        virtualScreenHeightText.setTextLimit(4);
        this.fillHorizontal((Control)virtualScreenHeightText);
        BaseparamComposite.addModifyListene(virtualScreenHeightText);
        this.automaticParameter((Control)virtualScreenHeightText, dispIndex);
        virtualScreenHeightTextList.add(virtualScreenHeightText);
        Label label_9 = new Label((Composite)cs, 0);
        label_9.setText(Messages.BaseparamComposite_28);
        Text offsetTopText = new Text((Composite)cs, 2048);
        offsetTopText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.top.name());
        offsetTopText.setText("0");
        offsetTopText.setTextLimit(3);
        this.fillHorizontal((Control)offsetTopText);
        BaseparamComposite.addModifyListene(offsetTopText);
        offsetTopTextList.add(offsetTopText);
        Label label_11 = new Label((Composite)cs, 0);
        label_11.setText(Messages.BaseparamComposite_30);
        Text offsetBottomText = new Text((Composite)cs, 2048);
        offsetBottomText.setText("0");
        offsetBottomText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bottom.name());
        offsetBottomText.setTextLimit(3);
        this.fillHorizontal((Control)offsetBottomText);
        BaseparamComposite.addModifyListene(offsetBottomText);
        offsetBottomTextList.add(offsetBottomText);
        Label label_8 = new Label((Composite)cs, 0);
        label_8.setText(Messages.BaseparamComposite_27);
        Text offsetLeftText = new Text((Composite)cs, 2048);
        offsetLeftText.setText("0");
        offsetLeftText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.left.name());
        offsetLeftText.setTextLimit(3);
        BaseparamComposite.addModifyListene(offsetLeftText);
        this.fillHorizontal((Control)offsetLeftText);
        offsetLeftTextList.add(offsetLeftText);
        Label label_10 = new Label((Composite)cs, 0);
        label_10.setText(Messages.BaseparamComposite_29);
        Text offsetRightText = new Text((Composite)cs, 2048);
        offsetRightText.setText("0");
        offsetRightText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.right.name());
        offsetRightText.setTextLimit(3);
        this.fillHorizontal((Control)offsetRightText);
        BaseparamComposite.addModifyListene(offsetRightText);
        offsetRightTextList.add(offsetRightText);
        Label label_7 = new Label((Composite)cs, 0);
        label_7.setText(Messages.BaseparamComposite_33);
        Combo combo_1 = new Combo((Composite)cs, 8);
        combo_1.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.pixelFormat.name());
        combo_1.setItems(this.getPiexlFormatArray());
        combo_1.select(0);
        this.fillHorizontal((Control)combo_1);
        this.automaticParameter((Control)combo_1, dispIndex);
        Label label_14 = new Label((Composite)cs, 0);
        label_14.setText(Messages.BaseparamComposite_43);
        Combo combo_2 = new Combo((Composite)cs, 8);
        combo_2.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.aspectRatio.name());
        combo_2.setItems(this.getAspectArray());
        combo_2.select(2);
        this.fillHorizontal((Control)combo_2);
        combo_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                Text userAspectW = (Text)BaseparamComposite.this.findActiveCon((Composite)cs, DispParamObj.BASE_DISP_ATTRNAME.userAspectW.name());
                Text userAspectH = (Text)BaseparamComposite.this.findActiveCon((Composite)cs, DispParamObj.BASE_DISP_ATTRNAME.userAspectH.name());
                if (combo.getSelectionIndex() != HI_UNF_DISP.HI_UNF_DISP_ASPECT_RATIO_E.ASPECT_RATIO_USER.ordinal()) {
                    userAspectW.setText("0");
                    userAspectH.setText("0");
                    userAspectW.setEnabled(false);
                    userAspectH.setEnabled(false);
                } else {
                    userAspectW.setEnabled(true);
                    userAspectH.setEnabled(true);
                }
            }
        });
        Label label_15 = new Label((Composite)cs, 0);
        label_15.setText(Messages.BaseparamComposite_44);
        Text Text_24 = new Text((Composite)cs, 2048);
        Text_24.setText("0");
        Text_24.setEnabled(false);
        Text_24.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.userAspectW.name());
        Text_24.setTextLimit(8);
        BaseparamComposite.addModifyListene(Text_24);
        this.fillHorizontal((Control)Text_24);
        Label label_16 = new Label((Composite)cs, 0);
        label_16.setText(":");
        label_16.setLayoutData((Object)new GridData(66));
        Text text_25 = new Text((Composite)cs, 2048);
        text_25.setText("0");
        text_25.setEnabled(false);
        text_25.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.userAspectH.name());
        text_25.setTextLimit(8);
        BaseparamComposite.addModifyListene(text_25);
        this.fillHorizontal((Control)text_25);
        Button button = new Button((Composite)cs, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.BaseparamComposite_34);
        button.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.gammaEnable.name());
        this.automaticParameter((Control)button, dispIndex);
        if (dispIndex == 1 || FastplayView.isHi3796CV300Series()) {
            Label vidOutModeLabel = new Label((Composite)cs, 0);
            vidOutModeLabel.setText(String.valueOf(Messages.BaseParamComposite_VidOutMode) + ":");
            this.vidOutModeCombo = new Combo((Composite)cs, 8);
            this.vidOutModeCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_HDMI_VIDEO_MODE_E.values()));
            this.fillHorizontal((Control)this.vidOutModeCombo);
            this.vidOutModeCombo.select(HI_UNF_DISP.HI_UNF_HDMI_VIDEO_MODE_E.RGB444.ordinal());
            this.vidOutModeCombo.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vidOutMode.name());
            Label deepColorModeComboLabel = new Label((Composite)cs, 0);
            deepColorModeComboLabel.setText(String.valueOf(Messages.BaseParamComposite_DeepColorModeCombo) + ":");
            if (FastplayView.isHi3796CV300Series()) {
                deepColorModeComboLabel.setText(String.valueOf(Messages.BaseParamComposite_HDMIColorBitWidth) + ":");
            }
            Combo deepColorModeCombo = new Combo((Composite)cs, 8);
            if (FastplayView.isHi3796CV300Series()) {
                deepColorModeCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_HDMI_DEEP_COLOR_E_HI3796CV300.values()));
                deepColorModeCombo.select(HI_UNF_DISP.HI_UNF_HDMI_DEEP_COLOR_E_HI3796CV300.BIT_WIDTH_8BIT.ordinal());
            } else {
                deepColorModeCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_HDMI_DEEP_COLOR_E.values()));
                deepColorModeCombo.select(HI_UNF_DISP.HI_UNF_HDMI_DEEP_COLOR_E.DEEP_COLOR_24BIT.ordinal());
            }
            this.fillHorizontal((Control)deepColorModeCombo);
            deepColorModeCombo.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.deepColorMode.name());
            deepColorModeComboList.add(deepColorModeCombo);
            if (FastplayView.isHi3798MV200Series()) {
                Label hdrTypeComboLabel = new Label((Composite)cs, 0);
                hdrTypeComboLabel.setText(String.valueOf(Messages.BaseParamComposite_HdrTypeCombo) + ":");
                this.hdrCombo = new Combo((Composite)cs, 8);
                this.fillHorizontal((Control)this.hdrCombo);
                if (FastplayView.isHi3796CV300Series()) {
                    this.hdrCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_HDR_TYPE_HI3796CV300.values()));
                    this.hdrCombo.select(HI_UNF_DISP.HI_UNF_HDR_TYPE_HI3796CV300.SDR.ordinal());
                } else {
                    this.hdrCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_HDR_TYPE.values()));
                    this.hdrCombo.select(HI_UNF_DISP.HI_UNF_HDR_TYPE.AUTO_FellowTVAndVideo.ordinal());
                }
                this.hdrCombo.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hdrType.name());
                Label colorSpaceComboLabel = new Label((Composite)cs, 0);
                colorSpaceComboLabel.setText(String.valueOf(Messages.BaseParamComposite_ColorSpaceTypeCombo) + ":");
                this.colorSpaceTypeCombo = new Combo((Composite)cs, 8);
                this.colorSpaceTypeCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_COLOR_SPACE_TYPE_TYPE.values()));
                this.fillHorizontal((Control)this.colorSpaceTypeCombo);
                this.colorSpaceTypeCombo.select(HI_UNF_DISP.HI_UNF_COLOR_SPACE_TYPE_TYPE.BT709.ordinal());
                if (FastplayView.isHi3796CV300Series()) {
                    this.colorSpaceTypeCombo.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_COLOR_SPACE_TYPE_TYPE_HI3796CV300.values()));
                    this.colorSpaceTypeCombo.select(HI_UNF_DISP.HI_UNF_COLOR_SPACE_TYPE_TYPE_HI3796CV300.BT709.ordinal());
                }
                this.colorSpaceTypeCombo.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.colorSpaceType.name());
                Label labelCvbsOutputStandard = new Label((Composite)cs, 0);
                labelCvbsOutputStandard.setText(Messages.BaseParamComposite_CvbsOutputStandard);
                this.comboCvbsOutputStandard = new Combo((Composite)cs, 8);
                this.comboCvbsOutputStandard.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_CVBS_OUTPUT_STANDARD_TYPE.values()));
                this.fillHorizontal((Control)this.comboCvbsOutputStandard);
                this.comboCvbsOutputStandard.select(HI_UNF_DISP.HI_UNF_CVBS_OUTPUT_STANDARD_TYPE.FOLLOW_HD.ordinal());
                this.comboCvbsOutputStandard.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.cvbsoutputstandardtype.name());
                if (FastplayView.isHi3796CV300Series()) {
                    Label labelVic = new Label((Composite)cs, 0);
                    labelVic.setText(String.valueOf(Messages.BaseParamComposite_Vic) + "(HEX)");
                    Text textVic = new Text((Composite)cs, 2048);
                    this.fillHorizontal((Control)textVic);
                    textVic.setText("0");
                    this.addModifyListene(textVic, true);
                    textVic.setTextLimit(4);
                    textVic.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vic.name());
                    textVicList.add(textVic);
                    Label labelHdrMatchContent = new Label((Composite)cs, 0);
                    labelHdrMatchContent.setText(Messages.BaseParamComposite_HdrMatchContent);
                    this.comHdrMatchContent = new Combo((Composite)cs, 8);
                    this.comHdrMatchContent.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_HDR_MATCH_CONTENT_TYPE.values()));
                    this.fillHorizontal((Control)this.comHdrMatchContent);
                    this.comHdrMatchContent.select(HI_UNF_DISP.HI_HDR_MATCH_CONTENT_TYPE.DISABLE.ordinal());
                    this.comHdrMatchContent.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.matchcontenttype.name());
                    Label labelDispmngSceneMode = new Label((Composite)cs, 0);
                    labelDispmngSceneMode.setText(Messages.BaseParamComposite_ScenarioMode);
                    this.comDispmngSceneMode = new Combo((Composite)cs, 8);
                    this.comDispmngSceneMode.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_DISP.HI_DISPMNG_SCENE_MODE_TYPE.values()));
                    this.fillHorizontal((Control)this.comboCvbsOutputStandard);
                    this.comDispmngSceneMode.select(HI_UNF_DISP.HI_DISPMNG_SCENE_MODE_TYPE.NORMAL.ordinal());
                    this.comDispmngSceneMode.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.scenemode.name());
                    Label labelLogoIndex = new Label((Composite)cs, 0);
                    labelLogoIndex.setText(Messages.BaseParamComposite_LogoIndex);
                    Text logoIndexText = new Text((Composite)cs, 2048);
                    logoIndexText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.logoIndex.name());
                    logoIndexText.setTextLimit(9);
                    logoIndexText.setText("0");
                    this.fillHorizontal((Control)logoIndexText);
                    BaseparamComposite.addModifyListene(logoIndexText);
                }
            }
        }
    }

    private void createPanelSettingsArea(FormToolkit ft, ScrolledForm form, Composite section, int dispIndex) {
        Group cs = new Group(section, 64);
        cs.setText(Messages.BaseparamComposite_PanelSetting);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Label label_2R = new Label((Composite)cs, 0);
        label_2R.setText(Messages.BaseparamComposite_PanelIndex);
        Text panelIndexText = new Text((Composite)cs, 2048);
        panelIndexText.setTextLimit(9);
        panelIndexText.setText("0");
        panelIndexText.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.panelIndex.name());
        GridData layoutData = new GridData(512);
        layoutData.widthHint = 80;
        panelIndexText.setLayoutData((Object)layoutData);
        this.automaticParameter((Control)panelIndexText, dispIndex);
    }

    protected void addModifyListene(Text text, boolean isHex) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textStr = text.getText();
                if (textStr == null) {
                    return;
                }
                if (textStr.isEmpty()) {
                    text.setText("0");
                    return;
                }
                if (isHex) {
                    if (!BaseparamComposite.this.pattenHex.matcher(textStr.toLowerCase()).matches()) {
                        text.setText("0");
                        return;
                    }
                } else if (!BaseparamComposite.this.patten.matcher(textStr).matches()) {
                    text.setText("0");
                    return;
                }
            }
        });
    }

    private void addSelectionListener(Combo combo, Composite body, FormToolkit ft, ScrolledForm form) {
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseparamComposite.this.checkCreateI2sArea(body, ft, form);
            }
        });
    }

    private void checkCreateI2sArea(Composite body, FormToolkit ft, ScrolledForm form) {
        List<Object> createI2S = this.getCreateI2S(body);
        this.removeI2SPanel(body);
        this.wgetParam.getI2sComposite().clear();
        Combo combo = null;
        ArrayList<Integer> selectList = new ArrayList<Integer>();
        int i = 0;
        while (i < createI2S.size()) {
            combo = (Combo)createI2S.get(i);
            selectList.add(combo.getSelectionIndex());
            ++i;
        }
        if (selectList.size() > 0) {
            i = 0;
            while (i < selectList.size()) {
                this.createI2sModeArea(body, ft, form, (Integer)selectList.get(i));
                ++i;
            }
            form.layout();
            form.reflow(true);
        }
    }

    private void removeI2SPanel(Composite body) {
        Control[] children = body.getChildren();
        Section sctn = null;
        int i = 0;
        while (i < children.length) {
            sctn = (Section)children[i];
            if (sctn.getData() != null && SectionType.I2S.name().equals(sctn.getData())) {
                sctn.dispose();
                children[i] = null;
            }
            ++i;
        }
    }

    private List<Object> getCreateI2S(Composite body) {
        Control[] children = body.getChildren();
        Section sctn = null;
        ArrayList<Object> findComtrol = new ArrayList<Object>();
        ArrayList<Object> conrolList = new ArrayList<Object>(0);
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            sctn = (Section)con;
            if (sctn.getData() != null && SectionType.SOUND.name().equals(sctn.getData())) {
                this.findWidgetByData((Control)sctn, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 1, findComtrol);
                if (findComtrol != null) {
                    conrolList.addAll(findComtrol);
                    findComtrol.clear();
                }
            }
            ++n2;
        }
        return conrolList;
    }

    public void findWidgetByData(Control parent, String data, ArrayList<Object> findComtrol) {
        if (!(parent instanceof Composite)) {
            return;
        }
        Composite parentComposite = (Composite)parent;
        Control[] children = parentComposite.getChildren();
        if (children == null || children.length < 1) {
            return;
        }
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            if (con instanceof Composite && ((Composite)con).getChildren() != null) {
                this.findWidgetByData(con, data, findComtrol);
                if (con.getData() != null && con.getData().equals(data)) {
                    findComtrol.add(con);
                }
            } else if (con.getData() != null && con.getData().equals(data)) {
                findComtrol.add(con);
            }
            ++n2;
        }
    }

    private void readI2sAndCreate(Composite body, FormToolkit ft, ScrolledForm form, I2SModeObj i2SModeObj) {
        if (i2SModeObj == null) {
            return;
        }
        int i2sIndex = i2SModeObj.getI2smodel();
        int bclk = i2SModeObj.getBclk();
        int bitdepth = i2SModeObj.getBitdepth();
        int chnum = i2SModeObj.getChnum();
        int master = i2SModeObj.getMaster();
        int mclk = i2SModeObj.getMclk();
        int pcmdelay = i2SModeObj.getPcmdelay();
        int pcmSampleRiseEdge = i2SModeObj.getPcmSampleRiseEdge();
        boolean boolMaster = this.IntToBoolean(master);
        boolean boolPcmSampleRiseEdge = this.IntToBoolean(pcmSampleRiseEdge);
        Section section = ft.createSection(body, 258);
        section.setExpanded(true);
        section.setLayoutData((Object)new ColumnLayoutData(768));
        section.setData((Object)SectionType.I2S.name());
        section.setText(BaseparamComposite.getI2sModelNames(i2sIndex));
        Composite i2sCom = ft.createComposite((Composite)section);
        i2sCom.setData((Object)(String.valueOf(SectionType.I2S.name()) + i2sIndex));
        i2sCom.setLayout((Layout)new GridLayout());
        Group cs = new Group(i2sCom, 64);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Composite spdifCom = new Composite((Composite)cs, 0);
        spdifCom.setLayout((Layout)this.rowLayout());
        spdifCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name());
        Label spdiLbl = new Label(spdifCom, 0);
        spdiLbl.setText(Messages.BaseparamComposite_i2s_model);
        Combo spdifcb = new Combo(spdifCom, 8);
        spdifcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_MODE_E.values()));
        spdifcb.select(i2sIndex);
        spdifcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name()) + 1));
        Composite mclkCom = new Composite((Composite)cs, 0);
        mclkCom.setLayout((Layout)this.rowLayout());
        mclkCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.mclk.name());
        Label dacLbl = new Label(mclkCom, 0);
        dacLbl.setText(Messages.BaseparamComposite_i2s_mclk);
        Combo mclkcb = new Combo(mclkCom, 8);
        mclkcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_MCLK_SEL_E.values()));
        mclkcb.select(mclk);
        mclkcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.mclk.name()) + 1));
        Composite bclkCom = new Composite((Composite)cs, 0);
        bclkCom.setLayout((Layout)this.rowLayout());
        bclkCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.bclk.name());
        Label bclkLbl = new Label(bclkCom, 0);
        bclkLbl.setText(Messages.BaseparamComposite_i2s_bclk);
        Combo bclkcb = new Combo(bclkCom, 8);
        bclkcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_BCLK_SEL_E.values()));
        bclkcb.select(bclk);
        bclkcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bclk.name()) + 1));
        Composite chnumCom = new Composite((Composite)cs, 0);
        chnumCom.setLayout((Layout)this.rowLayout());
        chnumCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.chnum.name());
        Label chnumLbl = new Label(chnumCom, 0);
        chnumLbl.setText(Messages.BaseparamComposite_i2s_chnum);
        Combo chnumcb = new Combo(chnumCom, 8);
        chnumcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_CHNUM_E.values()));
        chnumcb.select(chnum);
        chnumcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.chnum.name()) + 1));
        Composite bitdepthCom = new Composite((Composite)cs, 0);
        bitdepthCom.setLayout((Layout)this.rowLayout());
        bitdepthCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name());
        Label bitdepthLbl = new Label(bitdepthCom, 0);
        bitdepthLbl.setText(Messages.BaseparamComposite_i2s_ditdepth);
        Combo bitdepthkcb = new Combo(bitdepthCom, 8);
        bitdepthkcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_BITDEPTH_E.values()));
        bitdepthkcb.select(bitdepth);
        bitdepthkcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name()) + 1));
        Composite pcmdelayCom = new Composite((Composite)cs, 0);
        pcmdelayCom.setLayout((Layout)this.rowLayout());
        pcmdelayCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name());
        Label pcmdelayLbl = new Label(pcmdelayCom, 0);
        pcmdelayLbl.setText(Messages.BaseparamComposite_i2s_pcmodelay);
        Combo pcmdelaykcb = new Combo(pcmdelayCom, 8);
        pcmdelaykcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_PCMDELAY_E.values()));
        pcmdelaykcb.select(pcmdelay);
        pcmdelaykcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name()) + 1));
        Composite masterCom = new Composite((Composite)cs, 0);
        masterCom.setLayout((Layout)this.rowLayout());
        masterCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.master.name());
        Label masterLbl = new Label(masterCom, 0);
        masterLbl.setText(Messages.BaseparamComposite_i2s_master);
        Button masterBtn = new Button(masterCom, 32);
        masterBtn.setSelection(boolMaster);
        masterBtn.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.master.name()) + 1));
        Composite pcmeEdgeCom = new Composite((Composite)cs, 0);
        pcmeEdgeCom.setLayout((Layout)this.rowLayout());
        pcmeEdgeCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name());
        Label pcmeEdgeLbl = new Label(pcmeEdgeCom, 0);
        pcmeEdgeLbl.setText(Messages.BaseparamComposite_i2s_pcmriseedge);
        Button pcmeEdgekcb = new Button(pcmeEdgeCom, 32);
        pcmeEdgekcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name()) + 1));
        pcmeEdgekcb.setSelection(boolPcmSampleRiseEdge);
        section.setClient((Control)i2sCom);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        this.wgetParam.addI2SComposite(i2sIndex, i2sCom);
    }

    private void createI2sModeArea(Composite body, FormToolkit ft, ScrolledForm form, int i2sIndex) {
        Section section = ft.createSection(body, 258);
        section.setExpanded(true);
        section.setLayoutData((Object)new ColumnLayoutData(768));
        section.setData((Object)SectionType.I2S.name());
        section.setText(BaseparamComposite.getI2sModelNames(i2sIndex));
        this.i2sCom = ft.createComposite((Composite)section);
        this.i2sCom.setData((Object)(String.valueOf(SectionType.I2S.name()) + i2sIndex));
        this.i2sCom.setLayout((Layout)new GridLayout());
        Group cs = new Group(this.i2sCom, 64);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.horizontalSpacing = 15;
        cs.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)cs);
        Composite spdifCom = new Composite((Composite)cs, 0);
        spdifCom.setLayout((Layout)this.rowLayout());
        spdifCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name());
        Label spdiLbl = new Label(spdifCom, 0);
        spdiLbl.setText(Messages.BaseparamComposite_i2s_model);
        Combo spdifcb = new Combo(spdifCom, 8);
        spdifcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_MODE_E.values()));
        spdifcb.select(0);
        spdifcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name()) + 1));
        Composite mclkCom = new Composite((Composite)cs, 0);
        mclkCom.setLayout((Layout)this.rowLayout());
        mclkCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.mclk.name());
        Label dacLbl = new Label(mclkCom, 0);
        dacLbl.setText(Messages.BaseparamComposite_i2s_mclk);
        Combo mclkcb = new Combo(mclkCom, 8);
        mclkcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_MCLK_SEL_E.values()));
        mclkcb.select(1);
        mclkcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.mclk.name()) + 1));
        Composite bclkCom = new Composite((Composite)cs, 0);
        bclkCom.setLayout((Layout)this.rowLayout());
        bclkCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.bclk.name());
        Label bclkLbl = new Label(bclkCom, 0);
        bclkLbl.setText(Messages.BaseparamComposite_i2s_bclk);
        Combo bclkcb = new Combo(bclkCom, 8);
        bclkcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_BCLK_SEL_E.values()));
        bclkcb.select(3);
        bclkcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bclk.name()) + 1));
        Composite chnumCom = new Composite((Composite)cs, 0);
        chnumCom.setLayout((Layout)this.rowLayout());
        chnumCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.chnum.name());
        Label chnumLbl = new Label(chnumCom, 0);
        chnumLbl.setText(Messages.BaseparamComposite_i2s_chnum);
        Combo chnumcb = new Combo(chnumCom, 8);
        chnumcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_CHNUM_E.values()));
        chnumcb.select(1);
        chnumcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.chnum.name()) + 1));
        Composite bitdepthCom = new Composite((Composite)cs, 0);
        bitdepthCom.setLayout((Layout)this.rowLayout());
        bitdepthCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name());
        Label bitdepthLbl = new Label(bitdepthCom, 0);
        bitdepthLbl.setText(Messages.BaseparamComposite_i2s_ditdepth);
        Combo bitdepthkcb = new Combo(bitdepthCom, 8);
        bitdepthkcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_BITDEPTH_E.values()));
        bitdepthkcb.select(0);
        bitdepthkcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name()) + 1));
        Composite pcmdelayCom = new Composite((Composite)cs, 0);
        pcmdelayCom.setLayout((Layout)this.rowLayout());
        pcmdelayCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name());
        Label pcmdelayLbl = new Label(pcmdelayCom, 0);
        pcmdelayLbl.setText(Messages.BaseparamComposite_i2s_pcmodelay);
        Combo pcmdelaykcb = new Combo(pcmdelayCom, 8);
        pcmdelaykcb.setItems(HI_UNF_MCE.getEnumNames((Object[])HI_UNF_MCE.HI_UNF_I2S_PCMDELAY_E.values()));
        pcmdelaykcb.select(0);
        pcmdelaykcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name()) + 1));
        Composite masterCom = new Composite((Composite)cs, 0);
        masterCom.setLayout((Layout)this.rowLayout());
        masterCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.master.name());
        Label masterLbl = new Label(masterCom, 0);
        masterLbl.setText(Messages.BaseparamComposite_i2s_master);
        Button masterBtn = new Button(masterCom, 32);
        masterBtn.setSelection(true);
        masterBtn.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.master.name()) + 1));
        Composite pcmeEdgeCom = new Composite((Composite)cs, 0);
        pcmeEdgeCom.setLayout((Layout)this.rowLayout());
        pcmeEdgeCom.setData((Object)I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name());
        Label pcmeEdgeLbl = new Label(pcmeEdgeCom, 0);
        pcmeEdgeLbl.setText(Messages.BaseparamComposite_i2s_pcmriseedge);
        Button pcmeEdgekcb = new Button(pcmeEdgeCom, 32);
        pcmeEdgekcb.setData((Object)(String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name()) + 1));
        pcmeEdgekcb.setSelection(true);
        section.setClient((Control)this.i2sCom);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        this.wgetParam.addI2SComposite(i2sIndex, this.i2sCom);
    }

    private void automaticParameter(Control control, int dispIndex) {
        if (FastplayView.isHi3796CV300Series()) {
            this.addLosesfocus(control);
            return;
        }
        if (dispIndex == 1) {
            this.addLosesfocus(control);
        } else {
            control.setEnabled(false);
        }
    }

    protected void addLosesfocus(Control contorl) {
        contorl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (BaseparamComposite.isBindSource()) {
                    BaseparamComposite.this.setCurrentParam((Control)e.getSource());
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private Composite getCurrentGroup(int dispIndex, String text) {
        Composite tempWidg = null;
        Group dispComp = null;
        Map<Integer, Composite> dispCompositeMap = this.wgetParam.getDispComposite();
        Set<Map.Entry<Integer, Composite>> entrySet = dispCompositeMap.entrySet();
        if (!dispCompositeMap.isEmpty()) {
            for (Map.Entry<Integer, Composite> entry : entrySet) {
                if (entry.getKey() != dispIndex) continue;
                tempWidg = entry.getValue();
                break;
            }
            if (tempWidg != null) {
                Control[] children;
                Control[] controlArray = children = tempWidg.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control con = controlArray[n2];
                    if (((Group)con).getText().equals(text)) {
                        dispComp = (Group)con;
                    }
                    ++n2;
                }
            }
        }
        return dispComp;
    }

    private void setCurrentParam(Control control) {
        Composite dispComp = this.getCurrentGroup(0, Messages.BaseparamComposite_20);
        if (dispComp == null) {
            return;
        }
        Control findActiveCon = this.findActiveCon(dispComp, control.getData().toString());
        if (findActiveCon == null) {
            return;
        }
        if (findActiveCon instanceof Text) {
            ((Text)findActiveCon).setText("");
            ((Text)findActiveCon).setText(((Text)control).getText());
        }
        if (findActiveCon instanceof Combo) {
            ((Combo)findActiveCon).select(((Combo)control).getSelectionIndex());
        }
        if (findActiveCon instanceof Button) {
            ((Button)findActiveCon).setSelection(((Button)control).getSelection());
        }
    }

    private Control findActiveCon(Composite com, String data) {
        Control[] children = com.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getData() != null && children[i].getData().equals(data)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    private void createDisplay(FormToolkit ft, ScrolledForm form, Section section, int dispIndex) {
        section.setText(BaseparamComposite.getDisplayName(dispIndex));
        Composite dispCom = ft.createComposite((Composite)section);
        dispCom.setData((Object)BaseparamComposite.getDisplayName(dispIndex));
        dispCom.setLayout((Layout)new GridLayout());
        this.wgetParam.addDispComposite(dispIndex, dispCom);
        if (FastplayView.isHi3796CV300Series()) {
            this.createBaseKeyEnableAreaHi3796CV300(dispCom, dispIndex);
            this.createInterfcAreaHi3796CV300(ft, form, dispCom, section, BaseparamComposite.getDisplayName(dispIndex));
        } else {
            this.createInterfcArea(ft, form, dispCom, BaseparamComposite.getDisplayName(dispIndex));
        }
        if (FastplayView.isHi3796CV300Series()) {
            if (dispIndex == 1 || dispIndex == 2) {
                this.createBindSourceArea(ft, form, dispCom, disp, dispIndex);
            }
        } else if (dispIndex == 0) {
            this.createBindSourceArea(ft, form, dispCom, disp, dispIndex);
        }
        this.createDisplayArea(ft, form, dispCom, dispIndex);
        if (FastplayView.isHi3796CV300Series()) {
            this.createPanelSettingsArea(ft, form, dispCom, dispIndex);
        }
        section.setClient((Control)dispCom);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
    }

    private void createBaseKeyEnableAreaHi3796CV300(Composite dispCom, int dispIndex) {
        Group group = new Group(dispCom, 64);
        group.setText(Messages.BaseparamComposite_BaseKeyEnable);
        GridLayout gridLayout = new GridLayout(6, false);
        group.setLayout((Layout)gridLayout);
        this.fillHorizontal((Control)group);
        Button baseKeyEnable = new Button((Composite)group, 32);
        GridData baseKeyEnableGrid = new GridData();
        baseKeyEnableGrid.horizontalSpan = 2;
        baseKeyEnable.setLayoutData((Object)baseKeyEnableGrid);
        baseKeyEnable.setText(Messages.BaseparamComposite_BaseKeyEnable);
        baseKeyEnable.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.basekeyenable.name());
        if (dispIndex == 0) {
            baseKeyEnable.setSelection(true);
        } else {
            baseKeyEnable.setSelection(false);
        }
    }

    @Override
    protected Control createControl(Composite parent) {
        Section st;
        Composite control = new Composite(parent, 2048);
        control.setLayout((Layout)new FillLayout());
        this.ft = new FormToolkit(control.getDisplay());
        this.form = this.ft.createScrolledForm(control);
        this.body = this.form.getBody();
        this.body.setLayout((Layout)new ColumnLayout());
        this.wgetParam = new WidgetParam();
        bgColorTextList.clear();
        bgColorTextListR.clear();
        bgColorTextListG.clear();
        bgColorTextListB.clear();
        deepColorModeComboList.clear();
        hueplusTextList.clear();
        colorTemperatureTextList.clear();
        saturationTextList.clear();
        brightnessTextList.clear();
        contrastTextList.clear();
        offsetLeftTextList.clear();
        offsetTopTextList.clear();
        offsetRightTextList.clear();
        offsetBottomTextList.clear();
        virtualScreenWidthTextList.clear();
        virtualScreenHeightTextList.clear();
        textVicList.clear();
        int displayCount = 2;
        if (FastplayView.isHi3796CV300Series()) {
            displayCount = 3;
        }
        int i = 0;
        while (i < displayCount) {
            st = this.ft.createSection(this.body, 258);
            st.setExpanded(true);
            st.setLayoutData((Object)new ColumnLayoutData(768));
            this.createDisplay(this.ft, this.form, st, i);
            ++i;
        }
        i = 0;
        while (i < 3) {
            st = this.ft.createSection(this.body, 258);
            if (i == 0) {
                st.setExpanded(true);
            }
            st.setLayoutData((Object)new ColumnLayoutData(768));
            st.setData((Object)SectionType.SOUND.name());
            this.createSoundArea(this.body, this.ft, this.form, st, i);
            ++i;
        }
        return control;
    }

    @Override
    protected Object getParam() {
        BaseParam baseParam = new BaseParam();
        Set<Map.Entry<Integer, Composite>> dispEntrySet = this.wgetParam.getDispComposite().entrySet();
        int len = dispEntrySet.size();
        if (len == 0) {
            return null;
        }
        ArrayList<DispParamObj> baseParamArray = new ArrayList<DispParamObj>();
        for (Map.Entry<Integer, Composite> entry : dispEntrySet) {
            DispParamObj dispParamObj = new DispParamObj();
            dispParamObj.setCurrentDisp(entry.getKey());
            this.wgetParam.getBaseParam(entry.getKey(), entry.getValue(), dispParamObj);
            dispParamObj.listParamToArray();
            DispParamObj timingDispParamObj = this.wgetParam.getDispTimingDispParamObj().get(dispParamObj.getCurrentDisp());
            if (timingDispParamObj == null) {
                this.setDispTimingToDisplayInit(dispParamObj);
            }
            this.setDispTimingToDisplay(dispParamObj);
            baseParamArray.add(dispParamObj);
        }
        ArrayList<DispParamObj> orderBaseParamlist = new ArrayList<DispParamObj>();
        if (len == 1) {
            baseParam.setDispParam(baseParamArray);
            ((PrepareSetting)this.getSetting()).setParamObj(baseParam);
        } else {
            int j = 0;
            while (j < len) {
                orderBaseParamlist.add(this.getOrderParamObj(baseParamArray, j));
                ++j;
            }
            baseParam.setDispParam(orderBaseParamlist);
        }
        Set<Map.Entry<Integer, Composite>> soundEntrySet = this.wgetParam.getSoundComposite().entrySet();
        for (Map.Entry<Integer, Composite> entry : soundEntrySet) {
            SoundParamObj soundParamObj = (SoundParamObj)this.wgetParam.getBaseParam(entry.getKey(), entry.getValue(), new SoundParamObj());
            if (!this.checkSameI2S(soundParamObj)) {
                return null;
            }
            soundParamObj.listParamToArray();
            baseParam.addSountParamToList(this.checkNullParam(soundParamObj));
        }
        Set<Map.Entry<Integer, Composite>> i2sEntrySet = this.wgetParam.getI2sComposite().entrySet();
        for (Map.Entry<Integer, Composite> entry : i2sEntrySet) {
            baseParam.addI2sParamToList((I2SModeObj)this.wgetParam.getBaseParam(entry.getKey(), entry.getValue(), new I2SModeObj()));
        }
        ((PrepareSetting)this.getSetting()).setParamObj(baseParam);
        return baseParam;
    }

    private boolean checkSameI2S(SoundParamObj soundParamObj) {
        List<I2s> i2sModel = soundParamObj.getI2SModel();
        boolean haveSameI2c = false;
        if (i2sModel != null && i2sModel.size() == 2) {
            I2s i2s0 = i2sModel.get(0);
            I2s i2s1 = i2sModel.get(1);
            if (i2s0.getI2s() == i2s1.getI2s() && i2s1.getI2s() != -1) {
                haveSameI2c = true;
            }
        }
        if (haveSameI2c) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)Messages.BaseParamComposite_have_same_i2c);
            return false;
        }
        return true;
    }

    public SoundParamObj checkNullParam(SoundParamObj soundParamObj) {
        String[] interfaceValueArray;
        String[] stringArray = interfaceValueArray = soundParamObj.getInterfaceValueArray();
        int n = interfaceValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramStr = stringArray[n2];
            if (paramStr != null && paramStr.length() > 0) {
                return soundParamObj;
            }
            ++n2;
        }
        return null;
    }

    private void setDispTimingToDisplay(DispParamObj dispParamObj) {
        DispParamObj timingDispParamObj = this.wgetParam.getDispTimingDispParamObj().get(dispParamObj.getCurrentDisp());
        if (timingDispParamObj == null) {
            return;
        }
        dispParamObj.setVfb(timingDispParamObj.getVfb());
        dispParamObj.setVbb(timingDispParamObj.getVbb());
        dispParamObj.setVact(timingDispParamObj.getVact());
        dispParamObj.setHfb(timingDispParamObj.getHfb());
        dispParamObj.setHbb(timingDispParamObj.getHbb());
        dispParamObj.setHact(timingDispParamObj.getHact());
        dispParamObj.setVpw(timingDispParamObj.getVpw());
        dispParamObj.setClkPara0(timingDispParamObj.getClkPara0());
        dispParamObj.setClkPara1(timingDispParamObj.getClkPara1());
        dispParamObj.setPixFreq(timingDispParamObj.getPixFreq());
        dispParamObj.setHpw(timingDispParamObj.getHpw());
        dispParamObj.setVertFreq(timingDispParamObj.getVertFreq());
        dispParamObj.setAspectRatioW(timingDispParamObj.getAspectRatioW());
        dispParamObj.setAspectRatioH(timingDispParamObj.getAspectRatioH());
        dispParamObj.setDataWidth(timingDispParamObj.getDataWidth());
        dispParamObj.setItfFormat(timingDispParamObj.getItfFormat());
        dispParamObj.setIdv(timingDispParamObj.getIdv());
        dispParamObj.setIhs(timingDispParamObj.getIhs());
        dispParamObj.setIvs(timingDispParamObj.getIvs());
        dispParamObj.setClockReversal(timingDispParamObj.getClockReversal());
        dispParamObj.setDitherEnable(timingDispParamObj.getDitherEnable());
        dispParamObj.setbInterlace(timingDispParamObj.getbInterlace());
    }

    private void setDispTimingToDisplayInit(DispParamObj dispParamObj) {
        DispParamObj timingDispParamObjInit = this.wgetParam.getDispTimingDispParamObjInit().get(dispParamObj.getCurrentDisp());
        if (timingDispParamObjInit == null) {
            return;
        }
        dispParamObj.setVfb(timingDispParamObjInit.getVfb());
        dispParamObj.setVbb(timingDispParamObjInit.getVbb());
        dispParamObj.setVact(timingDispParamObjInit.getVact());
        dispParamObj.setHfb(timingDispParamObjInit.getHfb());
        dispParamObj.setHbb(timingDispParamObjInit.getHbb());
        dispParamObj.setHact(timingDispParamObjInit.getHact());
        dispParamObj.setVpw(timingDispParamObjInit.getVpw());
        dispParamObj.setClkPara0(timingDispParamObjInit.getClkPara0());
        dispParamObj.setClkPara1(timingDispParamObjInit.getClkPara1());
        dispParamObj.setPixFreq(timingDispParamObjInit.getPixFreq());
        dispParamObj.setHpw(timingDispParamObjInit.getHpw());
        dispParamObj.setVertFreq(timingDispParamObjInit.getVertFreq());
        dispParamObj.setAspectRatioW(timingDispParamObjInit.getAspectRatioW());
        dispParamObj.setAspectRatioH(timingDispParamObjInit.getAspectRatioH());
        dispParamObj.setDataWidth(timingDispParamObjInit.getDataWidth());
        dispParamObj.setItfFormat(timingDispParamObjInit.getItfFormat());
        dispParamObj.setIdv(timingDispParamObjInit.getIdv());
        dispParamObj.setIhs(timingDispParamObjInit.getIhs());
        dispParamObj.setIvs(timingDispParamObjInit.getIvs());
        dispParamObj.setClockReversal(timingDispParamObjInit.getClockReversal());
        dispParamObj.setDitherEnable(timingDispParamObjInit.getDitherEnable());
        dispParamObj.setbInterlace(timingDispParamObjInit.getbInterlace());
    }

    private DispParamObj getOrderParamObj(List<DispParamObj> baseParamList, int index) {
        int i = 0;
        while (i < baseParamList.size()) {
            if (index == baseParamList.get(i).getCurrentDisp()) {
                return baseParamList.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    protected boolean checkInfo(Object objParam) {
        ArrayList<DispParamObj> dispParam = ((BaseParam)objParam).getDispParam();
        for (DispParamObj param : dispParam) {
            if (param == null || this.checkBaseInfo(param)) continue;
            return false;
        }
        return true;
    }

    public int[] getMaxScreentSize(HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E fmt) {
        int[] WH = new int[2];
        switch (fmt) {
            case FMT_1080P_60: 
            case FMT_1080P_50: 
            case FMT_1080i_60: 
            case FMT_1080i_50: {
                WH[0] = 1920;
                WH[1] = 1080;
                break;
            }
            case FMT_720P_60: 
            case FMT_720P_50: {
                WH[0] = 1280;
                WH[1] = 720;
                break;
            }
            case FMT_576P_50: 
            case FMT_PAL: {
                WH[0] = 720;
                WH[1] = 576;
                break;
            }
            case FMT_480P_60: 
            case FMT_NTSC: {
                WH[0] = 720;
                WH[1] = 480;
                break;
            }
            case FMT_861D_640X480_60: {
                WH[0] = 640;
                WH[1] = 480;
                break;
            }
            case FMT_VESA_800X600_60: {
                WH[0] = 800;
                WH[1] = 600;
                break;
            }
            case FMT_VESA_1024X768_60: {
                WH[0] = 1024;
                WH[1] = 768;
                break;
            }
            case FMT_VESA_1280X720_60: {
                WH[0] = 1280;
                WH[1] = 720;
                break;
            }
            case FMT_VESA_1280X800_60: {
                WH[0] = 1280;
                WH[1] = 800;
                break;
            }
            case FMT_VESA_1280X1024_60: {
                WH[0] = 1280;
                WH[1] = 1024;
                break;
            }
            case FMT_VESA_1360X768_60: {
                WH[0] = 1360;
                WH[1] = 768;
                break;
            }
            case FMT_VESA_1366X768_60: {
                WH[0] = 1366;
                WH[1] = 768;
                break;
            }
            case FMT_VESA_1400X1050_60: {
                WH[0] = 1400;
                WH[1] = 1050;
                break;
            }
            case FMT_VESA_1440X900_60: {
                WH[0] = 1440;
                WH[1] = 900;
                break;
            }
            case FMT_VESA_1440X900_60_RB: {
                WH[0] = 1440;
                WH[1] = 900;
                break;
            }
            case FMT_VESA_1600X900_60_RB: {
                WH[0] = 1600;
                WH[1] = 900;
                break;
            }
            case FMT_VESA_1600X1200_60: {
                WH[0] = 1600;
                WH[1] = 1200;
                break;
            }
            case FMT_VESA_1680X1050_60: {
                WH[0] = 1680;
                WH[1] = 1050;
                break;
            }
            case FMT_VESA_1920X1080_60: {
                WH[0] = 1920;
                WH[1] = 1080;
                break;
            }
            case FMT_VESA_1920X1200_60: {
                WH[0] = 1920;
                WH[1] = 1200;
                break;
            }
            case FMT_VESA_2048X1152_60: {
                WH[0] = 2048;
                WH[1] = 1152;
                break;
            }
            default: {
                WH[0] = 1920;
                WH[1] = 1080;
            }
        }
        return WH;
    }

    private HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E transIDToFormat(int u32SelectID) {
        switch (u32SelectID) {
            case 0: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080P_60;
            }
            case 1: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080P_50;
            }
            case 2: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080P_30;
            }
            case 3: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080P_25;
            }
            case 4: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080P_24;
            }
            case 5: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080i_60;
            }
            case 6: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080i_50;
            }
            case 7: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_720P_60;
            }
            case 8: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_720P_50;
            }
            case 9: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_576P_50;
            }
            case 10: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_480P_60;
            }
            case 11: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_PAL;
            }
            case 12: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_PAL_N;
            }
            case 13: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_PAL_Nc;
            }
            case 14: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_NTSC;
            }
            case 15: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_NTSC_J;
            }
            case 16: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_NTSC_PAL_M;
            }
            case 17: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_SECAM_SIN;
            }
            case 18: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_SECAM_COS;
            }
            case 19: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_861D_640X480_60;
            }
            case 20: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_800X600_60;
            }
            case 21: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1024X768_60;
            }
            case 22: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1280X720_60;
            }
            case 23: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1280X800_60;
            }
            case 24: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1280X1024_60;
            }
            case 25: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1360X768_60;
            }
            case 26: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1366X768_60;
            }
            case 27: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1400X1050_60;
            }
            case 28: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1440X900_60;
            }
            case 29: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1440X900_60_RB;
            }
            case 30: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1600X900_60_RB;
            }
            case 31: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1600X1200_60;
            }
            case 32: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1680X1050_60;
            }
            case 33: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1920X1080_60;
            }
            case 34: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_1920X1200_60;
            }
            case 35: {
                return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_VESA_2048X1152_60;
            }
        }
        return HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E.FMT_1080i_50;
    }

    private boolean checkBaseInfo(DispParamObj param) {
        HI_UNF_ENC_FMT_E.HIUNF_ENC_FMT_E fmt = this.transIDToFormat(param.getFormat());
        int[] WH = this.getMaxScreentSize(fmt);
        if (param.getLeft() + param.getRight() > WH[0] || param.getTop() + param.getBottom() > WH[1]) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)String.format(Messages.BaseparamComposite_16, WH[0], WH[1]));
            return false;
        }
        if (param.getAspectRatio() == HI_UNF_DISP.HI_UNF_DISP_ASPECT_RATIO_E.ASPECT_RATIO_USER.ordinal() && (param.getUserAspectW() == 0 || param.getUserAspectH() == 0)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.Baseparam_11);
            return false;
        }
        return true;
    }

    private void initFormatValue(int dispIndex) {
        DispParamObj dispParamObj = new DispParamObj();
        dispParamObj.setVfb(0);
        dispParamObj.setVbb(0);
        dispParamObj.setVact(0);
        dispParamObj.setHfb(0);
        dispParamObj.setHbb(0);
        dispParamObj.setHact(0);
        dispParamObj.setVpw(0);
        dispParamObj.setClkPara0(0);
        dispParamObj.setClkPara1(0);
        dispParamObj.setPixFreq(0);
        dispParamObj.setHpw(0);
        dispParamObj.setVertFreq(0);
        dispParamObj.setAspectRatioW(0);
        dispParamObj.setAspectRatioH(0);
        dispParamObj.setDataWidth(0);
        dispParamObj.setItfFormat(0);
        dispParamObj.setIdv(0);
        dispParamObj.setIhs(0);
        dispParamObj.setIvs(0);
        dispParamObj.setClockReversal(0);
        dispParamObj.setDitherEnable(0);
        dispParamObj.setbInterlace(0);
        this.wgetParam.addDispTimingDispParamObjInit(dispIndex, dispParamObj);
    }

    @Override
    protected boolean checkAllTextValue() {
        if (!this.checkBgcolorValue()) {
            return false;
        }
        if (FastplayView.isHi3796CV300Series()) {
            if (!this.checkBgcolorValue(bgColorTextListR)) {
                return false;
            }
            if (!this.checkBgcolorValue(bgColorTextListG)) {
                return false;
            }
            if (!this.checkBgcolorValue(bgColorTextListB)) {
                return false;
            }
        }
        if (!this.checkHueplusValue()) {
            return false;
        }
        if (!this.checkColorTemperatureValue()) {
            return false;
        }
        if (!this.chekSaturationValue()) {
            return false;
        }
        if (!this.checkBrightnessValue()) {
            return false;
        }
        if (!this.checkContrastValue()) {
            return false;
        }
        if (!this.checkOffsetLeftValue()) {
            return false;
        }
        if (!this.checkOffsetText()) {
            return false;
        }
        if (!this.checkOffsetRightValue()) {
            return false;
        }
        if (!this.checkOffsetBottomValue()) {
            return false;
        }
        if (!this.checkVirtualScreenWidthValue()) {
            return false;
        }
        return this.checkVirtualScreenHeightValue();
    }

    private boolean checkVirtualScreenHeightValue() {
        int virtualMaxValue = 3840;
        int i = 0;
        while (i < virtualScreenHeightTextList.size()) {
            Text virtualScreenHeightText = virtualScreenHeightTextList.get(i);
            if (FastplayView.isHi3796CV300Series()) {
                virtualMaxValue = i == 0 ? 2160 : 1080;
            }
            if (!virtualScreenHeightText.isDisposed() && !this.checkTextValue(virtualScreenHeightText, 480, virtualMaxValue)) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Virtual_Screen_Height) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(480), (Object)String.valueOf(virtualMaxValue))));
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkVirtualScreenWidthValue() {
        int virtualMaxValue = 3840;
        int i = 0;
        while (i < virtualScreenWidthTextList.size()) {
            Text virtualScreenWidthText;
            if (FastplayView.isHi3796CV300Series()) {
                virtualMaxValue = i == 0 ? 3840 : 1920;
            }
            if (!(virtualScreenWidthText = virtualScreenWidthTextList.get(i)).isDisposed() && !this.checkTextValue(virtualScreenWidthText, 480, virtualMaxValue)) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Virtual_Screen_Width) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(480), (Object)String.valueOf(virtualMaxValue))));
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkOffsetBottomValue() {
        for (Text offsetBottomText : offsetBottomTextList) {
            if (offsetBottomText.isDisposed() || this.checkTextOffsetValue(offsetBottomText, 0, 200, 4)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Offset_Bottom) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers_OffsetParam, (Object[])new Object[]{String.valueOf(0), String.valueOf(200), String.valueOf(4)})));
            return false;
        }
        return true;
    }

    private boolean checkOffsetRightValue() {
        for (Text offsetRightText : offsetRightTextList) {
            if (offsetRightText.isDisposed() || this.checkTextOffsetValue(offsetRightText, 0, 200, 2)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Offset_Right) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers_OffsetParam, (Object[])new Object[]{String.valueOf(0), String.valueOf(200), String.valueOf(2)})));
            return false;
        }
        return true;
    }

    private boolean checkOffsetText() {
        for (Text offsetTopText : offsetTopTextList) {
            if (offsetTopText.isDisposed() || this.checkTextOffsetValue(offsetTopText, 0, 200, 4)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Offset_Top) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers_OffsetParam, (Object[])new Object[]{String.valueOf(0), String.valueOf(200), String.valueOf(4)})));
            return false;
        }
        return true;
    }

    private boolean checkOffsetLeftValue() {
        for (Text offsetLeftText : offsetLeftTextList) {
            if (offsetLeftText.isDisposed() || this.checkTextOffsetValue(offsetLeftText, 0, 200, 2)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Offset_Left) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers_OffsetParam, (Object[])new Object[]{String.valueOf(0), String.valueOf(200), String.valueOf(2)})));
            return false;
        }
        return true;
    }

    private boolean checkContrastValue() {
        for (Text contrastText : contrastTextList) {
            if (contrastText.isDisposed()) continue;
            int maxInput = 100;
            if (FastplayView.isHi3796CV300Series()) {
                maxInput = 1023;
            }
            if (this.checkTextValue(contrastText, 0, maxInput)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Contrast) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(maxInput))));
            return false;
        }
        return true;
    }

    private boolean checkBrightnessValue() {
        for (Text brightnessText : brightnessTextList) {
            if (brightnessText.isDisposed()) continue;
            int maxInput = 100;
            if (FastplayView.isHi3796CV300Series()) {
                maxInput = 1023;
            }
            if (this.checkTextValue(brightnessText, 0, maxInput)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Brightness) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(maxInput))));
            return false;
        }
        return true;
    }

    private boolean chekSaturationValue() {
        for (Text saturationText : saturationTextList) {
            if (saturationText.isDisposed()) continue;
            int maxInput = 100;
            if (FastplayView.isHi3796CV300Series()) {
                maxInput = 1023;
            }
            if (this.checkTextValue(saturationText, 0, maxInput)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Saturation) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(maxInput))));
            return false;
        }
        return true;
    }

    private boolean checkHueplusValue() {
        for (Text hueplusText : hueplusTextList) {
            if (hueplusText.isDisposed()) continue;
            int maxInput = 100;
            if (FastplayView.isHi3796CV300Series()) {
                maxInput = 1023;
            }
            if (this.checkTextValue(hueplusText, 0, maxInput)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_Hueplus) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(maxInput))));
            return false;
        }
        return true;
    }

    private boolean checkColorTemperatureValue() {
        for (Text colorTemperatureText : colorTemperatureTextList) {
            if (colorTemperatureText.isDisposed()) continue;
            int maxInput = 100;
            if (FastplayView.isHi3796CV300Series()) {
                maxInput = 1023;
            }
            if (this.checkTextValue(colorTemperatureText, 0, maxInput)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_ColorTemperature) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(maxInput))));
            return false;
        }
        return true;
    }

    private boolean checkBgcolorValue() {
        for (Text bgColorText : bgColorTextList) {
            if (bgColorText.isDisposed()) continue;
            if (!BaseparamComposite.isValidHexString(bgColorText.getText())) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_BackgroundColor) + Messages.ValidityCheck_Must_Hex_Number));
                return false;
            }
            if (this.checkTextValue(bgColorText, 0, 0xFFFFFF)) continue;
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_BackgroundColor) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(0xFFFFFF))));
            return false;
        }
        return true;
    }

    private int getBGColorMaxValue(int index) {
        if (index == 0) {
            return 255;
        }
        if (index == 1) {
            return 1023;
        }
        if (index == 2) {
            return 4095;
        }
        if (index == 3) {
            return 65535;
        }
        return 0;
    }

    private boolean checkBgcolorValue(ArrayList<Text> bgColorTxtList) {
        int index = 0;
        int bgColor_max_value = 0;
        for (Text bgColorText : bgColorTxtList) {
            if (!bgColorText.isDisposed()) {
                if (!BaseparamComposite.isValidHexString(bgColorText.getText())) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_BackgroundColor) + Messages.ValidityCheck_Must_Hex_Number));
                    return false;
                }
                int deepColorIndex = deepColorModeComboList.get(index).getSelectionIndex();
                bgColor_max_value = this.getBGColorMaxValue(deepColorIndex);
                if (!this.checkTextValue(bgColorText, 0, bgColor_max_value)) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.Label_BackgroundColor) + NLS.bind((String)Messages.BaseComposite_EnterIntNumbers, (Object)String.valueOf(0), (Object)String.valueOf(bgColor_max_value))));
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    private MipiModeObj getMipiModeObj() {
        MipiModeObj mipiModeObj = new MipiModeObj();
        mipiModeObj.setLaneIdList(DispMipiDialog.CHANNEL_LIST_INIT);
        mipiModeObj.setBpp(128);
        mipiModeObj.setBriPercent(0);
        mipiModeObj.setCmdNumber(3);
        MipiPanelCmdObj[] cmdObjList = new MipiPanelCmdObj[mipiModeObj.getCmdNumber()];
        int index = 0;
        while (index < cmdObjList.length) {
            cmdObjList[index] = new MipiPanelCmdObj();
            ++index;
        }
        mipiModeObj.setMipiPanelCmdObj(cmdObjList);
        return mipiModeObj;
    }

    @Override
    protected Spinner createSpinner(Composite parent, int style, int min, int current, int max, int inc, int pageinc, int digits) {
        Spinner spinner = new Spinner(parent, style);
        if (min >= 0) {
            spinner.setMinimum(min);
        }
        if (max >= 0) {
            spinner.setMaximum(max);
        }
        if (current >= 0) {
            spinner.setSelection(current);
        }
        if (inc >= 1) {
            spinner.setIncrement(inc);
        }
        if (pageinc >= 1) {
            spinner.setPageIncrement(pageinc);
        }
        if (digits >= 0) {
            spinner.setDigits(digits);
        }
        return spinner;
    }

    public WidgetParam getWgetParam() {
        return this.wgetParam;
    }

    public FormToolkit getFt() {
        return this.ft;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public Composite getBody() {
        return this.body;
    }

    private boolean IntToBoolean(int i) {
        return i == 1;
    }

    public Composite getI2sCom() {
        return this.i2sCom;
    }

    public static boolean isBindSource() {
        return isBindSource;
    }

    public static void setBindSource(boolean isBindSource) {
        BaseparamComposite.isBindSource = isBindSource;
    }

    protected static enum SectionType {
        DISP,
        SOUND,
        I2S;

    }
}

