/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.views;

import com.hisilicon.fastplay.Activator;
import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.editor.IDeviceListener;
import com.hisilicon.fastplay.editor.IDeviceSetting;
import com.hisilicon.fastplay.editor.UDProperties;
import com.hisilicon.fastplay.perspectives.FastplayPerspective;
import com.hisilicon.fastplay.processor.PrepareSetting;
import com.hisilicon.fastplay.ui.ANIComposite;
import com.hisilicon.fastplay.ui.BaseparamComposite;
import com.hisilicon.fastplay.ui.DVBComposite;
import com.hisilicon.fastplay.ui.LogoComposite;
import com.hisilicon.fastplay.ui.MusicComposite;
import com.hisilicon.fastplay.utility.AESUtils;
import com.hisilicon.fastplay.utility.FileUtils;
import com.soyatec.hisilicon.platform.api.IDeviceChangedListener;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.api.chips.Tool;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FastplayView
extends ViewPart
implements IDeviceChangedListener,
IPerspectiveListener4,
IDeviceListener {
    public static final String ID = FastplayView.class.getName();
    static final String DEVICE_SETTING_FOLDER = "Resources/Common/ChipProperties/";
    static final String AES_KEY = "HiReg-5D765B15-8F5B-46DC-9B7C-80322B8F74E4";
    private FormToolkit toolkit;
    private TabFolder tabFolder;
    private IDeviceManager deviceManager;
    private IDeviceSetting deviceSetting = null;
    private UDProperties properties;
    private static String currentChip;
    private BaseparamComposite baseparamComposite;
    private LogoComposite logoComposite;
    private DVBComposite dvbComposite;
    private ANIComposite aniComposite;
    private MusicComposite musicComposite;
    private Composite parent;
    private static final String Hi3798MV200SERIESCHIPNAME = "Hi3798MV200";
    private static final String Hi3798MV200HSERIESCHIPNAME = "Hi3798MV200H";
    private static final String Hi3798MV300SERIESCHIPNAME = "Hi3798MV300";
    private static final String Hi3798MV300HSERIESCHIPNAME = "Hi3798MV300H";
    private static final String Hi3798MV310SERIESCHIPNAME = "Hi3798MV310";
    private static final String Hi3798MV300ESERIESCHIPNAME = "Hi3798MV300E";
    private static final String Hi3796CV300SERIESCHIPNAME = "Hi3796CV300";
    private static final String Hi3751V350_Hi3751V351SERIESCHIPNAME = "Hi3751V350 Hi3751V351";
    private static final String Hi3751V560SERIESCHIPNAME = "Hi3751V560";
    private static final String Hi3751V811SERIESCHIPNAME = "Hi3751V811";
    private static boolean isHi3798MV200Series;
    private static boolean isHi3796CV300Series;

    static {
        isHi3798MV200Series = false;
        isHi3796CV300Series = false;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.createPartControl();
    }

    public static boolean isHi3798MV200Series() {
        return isHi3798MV200Series;
    }

    public static void setHi3798MV200Series(boolean isHi3798MV200Series) {
        FastplayView.isHi3798MV200Series = isHi3798MV200Series;
    }

    public static void setCurrentChip(String currentChip) {
        FastplayView.currentChip = currentChip;
    }

    public static boolean isHi3796CV300Series() {
        return isHi3796CV300Series;
    }

    public static void setHi3796CV300Series(boolean isHi3796CV300Series) {
        FastplayView.isHi3796CV300Series = isHi3796CV300Series;
    }

    public void createPartControl() {
        boolean isSupport;
        this.toolkit = new FormToolkit(this.parent.getDisplay());
        this.tabFolder = new TabFolder(this.parent, 1024);
        TabItem item = null;
        boolean bl = isSupport = !currentChip.equalsIgnoreCase(Hi3751V350_Hi3751V351SERIESCHIPNAME) && !currentChip.equalsIgnoreCase(Hi3751V811SERIESCHIPNAME) && !currentChip.equalsIgnoreCase("Hi3751V810") && !currentChip.equalsIgnoreCase("Hi3751V551") && !currentChip.equalsIgnoreCase("Hi3751V553") && !currentChip.equalsIgnoreCase("Hi3751V620") && !currentChip.equalsIgnoreCase(Hi3751V560SERIESCHIPNAME);
        if (isSupport) {
            item = new TabItem(this.tabFolder, 0);
            item.setControl(this.createBaseparamControl(this.tabFolder));
            item.setText(Messages.BaseparamPage_1);
        }
        item = new TabItem(this.tabFolder, 0);
        item.setControl(this.createLogoControl(this.tabFolder));
        item.setText(Messages.LogoPage_1);
        if (this.properties != null) {
            String boardType = this.properties.queryForString("TYPE");
            if (boardType == null) {
                item = new TabItem(this.tabFolder, 0);
                item.setControl(this.createANIControl(this.tabFolder));
                item.setText(Messages.ANIPage_1);
                item = new TabItem(this.tabFolder, 0);
                item.setControl(this.createDVBControl(this.tabFolder));
                item.setText(Messages.DVBPage_1);
                return;
            }
            if (boardType.equalsIgnoreCase("STB")) {
                item = new TabItem(this.tabFolder, 0);
                item.setControl(this.createANIControl(this.tabFolder));
                item.setText(Messages.ANIPage_1);
                item = new TabItem(this.tabFolder, 0);
                item.setControl(this.createDVBControl(this.tabFolder));
                item.setText(Messages.DVBPage_1);
            } else {
                item = new TabItem(this.tabFolder, 0);
                item.setControl(this.createMusicControl(this.tabFolder));
                item.setText(Messages.MusicComposite_Page);
            }
        } else {
            item = new TabItem(this.tabFolder, 0);
            item.setControl(this.createANIControl(this.tabFolder));
            item.setText(Messages.ANIPage_1);
            item = new TabItem(this.tabFolder, 0);
            item.setControl(this.createDVBControl(this.tabFolder));
            item.setText(Messages.DVBPage_1);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference sreference = bundleContext.getServiceReference(IDeviceManager.class);
        if (sreference == null) {
            this.loadChipProperties("Hi3798CV100");
            return;
        }
        this.deviceManager = (IDeviceManager)bundleContext.getService(sreference);
        this.deviceManager.addDeviceChangedListener((IDeviceChangedListener)this);
        String currentDevice = this.deviceManager.getCurrentDevice();
        if (currentDevice == null || currentDevice.trim().length() == 0) {
            return;
        }
        this.loadChipProperties(currentDevice);
        this.deviceChanged(this.deviceManager.findChipByName(currentDevice));
        this.getViewSite().getPage().getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    private Control createBaseparamControl(TabFolder tabFolder) {
        this.baseparamComposite = new BaseparamComposite((Composite)tabFolder, new PrepareSetting(null));
        this.adapt((Control)this.baseparamComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.baseparamComposite, "com.hisilicon.fastplay.fastplay_context_baseparam");
        return this.baseparamComposite;
    }

    private Control createLogoControl(TabFolder tabFolder) {
        this.logoComposite = new LogoComposite((Composite)tabFolder, new PrepareSetting(null));
        this.adapt((Control)this.logoComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.logoComposite, "com.hisilicon.fastplay.fastplay_context_logo");
        return this.logoComposite;
    }

    private Control createDVBControl(TabFolder tabFolder) {
        this.dvbComposite = new DVBComposite((Composite)tabFolder, new PrepareSetting(null));
        this.adapt((Control)this.dvbComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.dvbComposite, "com.hisilicon.fastplay.fastplay_context_dvb");
        return this.dvbComposite;
    }

    private Control createANIControl(TabFolder tabFolder) {
        this.aniComposite = new ANIComposite((Composite)tabFolder, new PrepareSetting(null));
        this.adapt((Control)this.aniComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.aniComposite, "com.hisilicon.fastplay.fastplay_context_ani");
        return this.aniComposite;
    }

    private Control createMusicControl(TabFolder tabFolder) {
        this.musicComposite = new MusicComposite((Composite)tabFolder, new PrepareSetting(null));
        this.adapt((Control)this.musicComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.musicComposite, "com.hisilicon.fastplay.fastplay_context_music");
        return this.musicComposite;
    }

    private void adapt(Control control) {
        this.toolkit.adapt(control, false, false);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.adapt(child);
                ++n2;
            }
        }
    }

    public void setFocus() {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        this.tabFolder.getTabList()[this.tabFolder.getSelectionIndex()].setFocus();
    }

    public void loadChipProperties(String chipName) {
        String name = "";
        name = Hi3751V350_Hi3751V351SERIESCHIPNAME.equalsIgnoreCase(chipName) || Hi3751V560SERIESCHIPNAME.equalsIgnoreCase(chipName) ? Hi3751V811SERIESCHIPNAME : chipName;
        String propertiesFile = DEVICE_SETTING_FOLDER + name + ".chip";
        if (FileUtils.toAbsolutePath(propertiesFile) == null) {
            return;
        }
        if (!FileUtils.isExists(FileUtils.toAbsolutePath(propertiesFile))) {
            return;
        }
        this.properties = new UDProperties();
        byte[] definitionData = AESUtils.decrypt(FileUtils.readAllBytes(FileUtils.toAbsolutePath(propertiesFile)), AES_KEY);
        try {
            String[] definitionLines;
            String[] stringArray = definitionLines = new String(definitionData, System.getProperty("file.encoding")).split("\r\n");
            int n = definitionLines.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ppt;
                String s = stringArray[n2];
                String line = s.trim().replace("\t", "");
                if (!line.startsWith("[") && line.contains("=") && (ppt = line.split("=")).length > 1) {
                    this.properties.set(ppt[0], ppt[1]);
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void deviceChanged(Chip chip) {
        if (chip == null) {
            return;
        }
        this.setChip();
        if (currentChip != null && currentChip.equals(chip.getName())) {
            return;
        }
        FastplayView.setCurrentChip(chip.getName());
        if (Platform.inDevelopmentMode()) {
            this.deviceChanged(chip.getName());
        } else {
            ArrayList toolList = chip.getToolList();
            for (Tool tool : toolList) {
                List containingPlugin = tool.getContainingPlugin();
                if (containingPlugin == null) continue;
                for (String string : containingPlugin) {
                    String[] split;
                    if (!string.equals(Activator.getDefault().getBundle().getSymbolicName())) continue;
                    String param = tool.getParam();
                    if (param == null) {
                        this.deviceChanged(chip.getName());
                        return;
                    }
                    String[] stringArray = split = param.split(",");
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        String[] keyvalue = p.split("=");
                        if (keyvalue.length == 2 && "type".equalsIgnoreCase(keyvalue[0].trim())) {
                            this.deviceChanged(keyvalue[1]);
                            return;
                        }
                        ++n2;
                    }
                    this.deviceChanged(chip.getName());
                    return;
                }
            }
        }
    }

    private void setChip() {
        String currentDevice = this.deviceManager.getCurrentDevice();
        if (currentDevice.equalsIgnoreCase(Hi3798MV200SERIESCHIPNAME) || currentDevice.equalsIgnoreCase(Hi3798MV200HSERIESCHIPNAME) || currentDevice.equalsIgnoreCase(Hi3798MV300SERIESCHIPNAME) || currentDevice.equalsIgnoreCase(Hi3798MV300HSERIESCHIPNAME) || currentDevice.equalsIgnoreCase(Hi3798MV310SERIESCHIPNAME) || currentDevice.equalsIgnoreCase(Hi3796CV300SERIESCHIPNAME) || currentDevice.equalsIgnoreCase(Hi3798MV300ESERIESCHIPNAME)) {
            FastplayView.setHi3798MV200Series(true);
        } else {
            FastplayView.setHi3798MV200Series(false);
        }
        if (currentDevice.equalsIgnoreCase(Hi3796CV300SERIESCHIPNAME)) {
            FastplayView.setHi3796CV300Series(true);
        } else {
            FastplayView.setHi3796CV300Series(false);
        }
    }

    public void deviceChanged(String deviceName) {
        if (deviceName == null || deviceName.trim().length() == 0) {
            return;
        }
        this.loadChipProperties(deviceName);
        Chip chip = new Chip();
        chip.setName(deviceName);
        this.deviceChanged(chip);
        this.deviceChanged();
    }

    public void deviceChanged() {
        if (this.parent != null) {
            if (this.toolkit != null) {
                this.toolkit.dispose();
            }
            if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
                this.tabFolder.dispose();
                this.createPartControl();
                this.parent.layout();
            }
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (FastplayPerspective.class.getName().equals(perspective.getId())) {
            if (this.deviceManager == null) {
                return;
            }
            String currentDevice = this.deviceManager.getCurrentDevice();
            if (currentChip.equals(currentDevice)) {
                return;
            }
            FastplayView.setCurrentChip(currentDevice);
            this.deviceChanged(this.deviceManager.findChipByName(currentChip));
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    @Override
    public void deviceChanged(IDeviceSetting device) {
        if (device == this.deviceSetting) {
            return;
        }
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            Control[] tabList = this.tabFolder.getTabList();
            int i = 0;
            while (i < tabList.length) {
                tabList[i].dispose();
                ++i;
            }
            this.tabFolder.dispose();
        }
        this.deviceSetting = device;
        if (device == null) {
            return;
        }
    }

    public BaseparamComposite getBaseparamComposite() {
        return this.baseparamComposite;
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public static String getCurrentChip() {
        return currentChip;
    }

    public static String getHi3798mv300hserieschipname() {
        return Hi3798MV300HSERIESCHIPNAME;
    }
}

