/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;
import org.eclipse.tm.internal.terminal.serial.ISerialSettings;
import org.eclipse.tm.internal.terminal.serial.SerialConnectWorker;
import org.eclipse.tm.internal.terminal.serial.SerialMessages;
import org.eclipse.tm.internal.terminal.serial.SerialPortHandler;
import org.eclipse.tm.internal.terminal.serial.SerialSettings;
import org.eclipse.tm.internal.terminal.serial.SerialSettingsPage;

public class SerialConnector
extends TerminalConnectorImpl {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private SerialPort fSerialPort;
    private CommPortIdentifier fSerialPortIdentifier;
    private SerialPortHandler fTerminalSerialPortHandler;
    private SerialSettings fSettings;
    private SerialConnectWorker fConnectWorker = null;
    private volatile boolean fDisconnectGoingOn = false;

    public SerialConnector() {
    }

    public SerialConnector(SerialSettings settings) {
        this.fSettings = settings;
    }

    public void initialize() throws Exception {
        try {
            this.fSettings = new SerialSettings();
        }
        catch (NoClassDefFoundError e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.tm.terminal.serial", 0, SerialMessages.ERROR_LIBRARY_NOT_INSTALLED, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ITerminalControl control) {
        super.connect(control);
        SerialConnector serialConnector = this;
        synchronized (serialConnector) {
            if (this.fConnectWorker != null || this.fDisconnectGoingOn) {
                return;
            }
            this.fConnectWorker = new SerialConnectWorker(this, control);
        }
        this.fControl.setState(TerminalState.CONNECTING);
        this.fConnectWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doneConnect() {
        SerialConnector serialConnector = this;
        synchronized (serialConnector) {
            this.fConnectWorker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDisconnect() {
        SerialConnector serialConnector = this;
        synchronized (serialConnector) {
            if (this.fConnectWorker != null) {
                this.fConnectWorker.interrupt();
                return;
            }
            if (this.fDisconnectGoingOn) {
                return;
            }
            this.fDisconnectGoingOn = true;
        }
        new Thread("Terminal View Serial Port Disconnect Worker"){

            @Override
            public void run() {
                try {
                    try {
                        if (SerialConnector.this.getSerialPortIdentifier() != null) {
                            try {
                                SerialConnector.this.getSerialPortIdentifier().removePortOwnershipListener((CommPortOwnershipListener)SerialConnector.this.getSerialPortHandler());
                            }
                            catch (Exception e) {
                                Logger.logException((Exception)e);
                            }
                        }
                        if (SerialConnector.this.getSerialPort() != null) {
                            try {
                                SerialConnector.this.getSerialPort().removeEventListener();
                                Thread.sleep(50L);
                            }
                            catch (Exception e) {
                                Logger.logException((Exception)e);
                            }
                            Logger.log((String)"Calling close() on serial port ...");
                            SerialConnector.this.getSerialPort().close();
                        }
                        if (SerialConnector.this.getInputStream() != null) {
                            try {
                                SerialConnector.this.getInputStream().close();
                            }
                            catch (Exception exception) {
                                Logger.logException((Exception)exception);
                            }
                        }
                        if (SerialConnector.this.getTerminalToRemoteStream() != null) {
                            try {
                                SerialConnector.this.getTerminalToRemoteStream().close();
                            }
                            catch (Exception exception) {
                                Logger.logException((Exception)exception);
                            }
                        }
                        SerialConnector.this.setSerialPortIdentifier(null);
                        SerialConnector.this.cleanSerialPort();
                        SerialConnector.this.setSerialPortHandler(null);
                    }
                    catch (Exception e) {
                        Logger.logException((Exception)e);
                        SerialConnector.this.fDisconnectGoingOn = false;
                    }
                }
                finally {
                    SerialConnector.this.fDisconnectGoingOn = false;
                }
            }
        }.start();
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }

    protected SerialPort getSerialPort() {
        return this.fSerialPort;
    }

    void cleanSerialPort() {
        this.fSerialPort = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    protected void setSerialPort(SerialPort serialPort) throws IOException {
        this.cleanSerialPort();
        if (serialPort != null) {
            this.fSerialPort = serialPort;
            this.setOutputStream(serialPort.getOutputStream());
            this.setInputStream(serialPort.getInputStream());
        }
    }

    protected CommPortIdentifier getSerialPortIdentifier() {
        return this.fSerialPortIdentifier;
    }

    protected void setSerialPortIdentifier(CommPortIdentifier serialPortIdentifier) {
        this.fSerialPortIdentifier = serialPortIdentifier;
    }

    void setSerialPortHandler(SerialPortHandler serialPortHandler) {
        this.fTerminalSerialPortHandler = serialPortHandler;
    }

    SerialPortHandler getSerialPortHandler() {
        return this.fTerminalSerialPortHandler;
    }

    public ISerialSettings getSerialSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new SerialSettingsPage(this.fSettings);
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }
}

