/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.io.Serializable;
import java.util.Map;
import javax.swing.JCheckBox;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.policyeditor.PermissionActions;
import net.sourceforge.jnlp.security.policyeditor.PermissionTarget;
import net.sourceforge.jnlp.security.policyeditor.PermissionType;
import sun.security.provider.PolicyParser;

public enum PolicyEditorPermissions implements Serializable
{
    READ_LOCAL_FILES(Translator.R("PEReadFiles"), Translator.R("PEReadFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.USER_HOME, PermissionActions.READ),
    WRITE_LOCAL_FILES(Translator.R("PEWriteFiles"), Translator.R("PEWriteFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.USER_HOME, PermissionActions.WRITE),
    DELETE_LOCAL_FILES(Translator.R("PEDeleteFiles"), Translator.R("PEDeleteFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.USER_HOME, PermissionActions.DELETE),
    READ_PROPERTIES(Translator.R("PEReadProps"), Translator.R("PEReadPropsDetail"), PermissionType.PROPERTY_PERMISSION, PermissionTarget.ALL, PermissionActions.READ),
    WRITE_PROPERTIES(Translator.R("PEWriteProps"), Translator.R("PEWritePropsDetail"), PermissionType.PROPERTY_PERMISSION, PermissionTarget.ALL, PermissionActions.WRITE),
    READ_SYSTEM_FILES(Translator.R("PEReadSystemFiles"), Translator.R("PEReadSystemFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.ALL_FILES, PermissionActions.READ),
    WRITE_SYSTEM_FILES(Translator.R("PEWriteSystemFiles"), Translator.R("PEWriteSystemFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.ALL_FILES, PermissionActions.WRITE),
    READ_TMP_FILES(Translator.R("PEReadTempFiles"), Translator.R("PEReadTempFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.TMPDIR, PermissionActions.READ),
    WRITE_TMP_FILES(Translator.R("PEWriteTempFiles"), Translator.R("PEWriteTempFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.TMPDIR, PermissionActions.WRITE),
    DELETE_TMP_FILES(Translator.R("PEDeleteTempFiles"), Translator.R("PEDeleteTempFilesDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.TMPDIR, PermissionActions.DELETE),
    JAVA_REFLECTION(Translator.R("PEReflection"), Translator.R("PEReflectionDetail"), PermissionType.REFLECT_PERMISSION, PermissionTarget.REFLECT, PermissionActions.NONE),
    GET_CLASSLOADER(Translator.R("PEClassLoader"), Translator.R("PEClassLoaderDetail"), PermissionType.RUNTIME_PERMISSION, PermissionTarget.CLASSLOADER, PermissionActions.NONE),
    ACCESS_CLASS_IN_PACKAGE(Translator.R("PEClassInPackage"), Translator.R("PEClassInPackageDetail"), PermissionType.RUNTIME_PERMISSION, PermissionTarget.ACCESS_CLASS_IN_PACKAGE, PermissionActions.NONE),
    ACCESS_DECLARED_MEMBERS(Translator.R("PEDeclaredMembers"), Translator.R("PEDeclaredMembersDetail"), PermissionType.RUNTIME_PERMISSION, PermissionTarget.DECLARED_MEMBERS, PermissionActions.NONE),
    ACCESS_THREADS(Translator.R("PEAccessThreads"), Translator.R("PEAccessThreadsDetail"), PermissionType.RUNTIME_PERMISSION, PermissionTarget.ACCESS_THREADS, PermissionActions.NONE),
    ACCESS_THREAD_GROUPS(Translator.R("PEAccessThreadGroups"), Translator.R("PEAccessThreadGroupsDetail"), PermissionType.RUNTIME_PERMISSION, PermissionTarget.ACCESS_THREAD_GROUPS, PermissionActions.NONE),
    NETWORK(Translator.R("PENetwork"), Translator.R("PENetworkDetail"), PermissionType.SOCKET_PERMISSION, PermissionTarget.ALL, PermissionActions.NETALL),
    EXEC_COMMANDS(Translator.R("PEExec"), Translator.R("PEExecDetail"), PermissionType.FILE_PERMISSION, PermissionTarget.ALL_FILES, PermissionActions.EXECUTE),
    GET_ENV(Translator.R("PEGetEnv"), Translator.R("PEGetEnvDetail"), PermissionType.RUNTIME_PERMISSION, PermissionTarget.GETENV, PermissionActions.NONE),
    ALL_AWT(Translator.R("PEAWTPermission"), Translator.R("PEAWTPermissionDetail"), PermissionType.AWT_PERMISSION, PermissionTarget.ALL, PermissionActions.NONE),
    CLIPBOARD(Translator.R("PEClipboard"), Translator.R("PEClipboardDetail"), PermissionType.AWT_PERMISSION, PermissionTarget.CLIPBOARD, PermissionActions.NONE),
    PLAY_AUDIO(Translator.R("PEPlayAudio"), Translator.R("PEPlayAudioDetail"), PermissionType.AUDIO_PERMISSION, PermissionTarget.PLAY, PermissionActions.NONE),
    RECORD_AUDIO(Translator.R("PERecordAudio"), Translator.R("PERecordAudioDetail"), PermissionType.AUDIO_PERMISSION, PermissionTarget.RECORD, PermissionActions.NONE),
    PRINT(Translator.R("PEPrint"), Translator.R("PEPrintDetail"), PermissionType.RUNTIME_PERMISSION, PermissionTarget.PRINT, PermissionActions.NONE);

    private final String name;
    private final String description;
    private final PermissionType type;
    private final PermissionTarget target;
    private final PermissionActions actions;

    private PolicyEditorPermissions(String name, String description, PermissionType type, PermissionTarget target, PermissionActions actions) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.target = target;
        this.actions = actions;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public PermissionType getType() {
        return this.type;
    }

    public PermissionTarget getTarget() {
        return this.target;
    }

    public PermissionActions getActions() {
        return this.actions;
    }

    public String toPermissionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("permission ");
        sb.append(this.type.type);
        sb.append(" \"");
        sb.append(this.target.target);
        sb.append("\"");
        if (!this.actions.equals((Object)PermissionActions.NONE)) {
            sb.append(", \"");
            sb.append(PolicyEditorPermissions.setToActionList(this.actions.getActions().toString()));
            sb.append("\"");
        }
        sb.append(";");
        return sb.toString();
    }

    private static String setToActionList(String string) {
        return string.replaceAll("[\\[\\]\\s]", "");
    }

    public static PolicyEditorPermissions fromPermissionEntry(PolicyParser.PermissionEntry permissionEntry) {
        for (PolicyEditorPermissions permission : PolicyEditorPermissions.values()) {
            String actionsString = permission.getActions().equals((Object)PermissionActions.NONE) ? null : permission.getActions().rawString();
            PolicyParser.PermissionEntry editorEntry = new PolicyParser.PermissionEntry(permission.getType().type, permission.getTarget().target, actionsString);
            if (!editorEntry.equals(permissionEntry)) continue;
            return permission;
        }
        return null;
    }

    public static enum Group {
        ReadFileSystem(Translator.R("PEGReadFileSystem"), READ_LOCAL_FILES, READ_PROPERTIES, READ_SYSTEM_FILES, READ_TMP_FILES, GET_ENV),
        WriteFileSystem(Translator.R("PEGWriteFileSystem"), WRITE_LOCAL_FILES, DELETE_LOCAL_FILES, WRITE_PROPERTIES, WRITE_SYSTEM_FILES, WRITE_TMP_FILES, DELETE_TMP_FILES, EXEC_COMMANDS),
        AccessUnownedCode(Translator.R("PEGAccessUnownedCode"), JAVA_REFLECTION, GET_CLASSLOADER, ACCESS_CLASS_IN_PACKAGE, ACCESS_DECLARED_MEMBERS, ACCESS_THREADS, ACCESS_THREAD_GROUPS),
        MediaAccess(Translator.R("PEGMediaAccess"), PLAY_AUDIO, RECORD_AUDIO, PRINT, CLIPBOARD);

        private final PolicyEditorPermissions[] permissions;
        private final String title;

        private Group(String title, PolicyEditorPermissions ... permissions) {
            this.title = title;
            this.permissions = permissions;
        }

        public static boolean anyContains(PolicyEditorPermissions permission) {
            for (Group g : Group.values()) {
                if (!g.contains(permission)) continue;
                return true;
            }
            return false;
        }

        public static boolean anyContains(JCheckBox view, Map<PolicyEditorPermissions, JCheckBox> checkboxMap) {
            for (Map.Entry<PolicyEditorPermissions, JCheckBox> pairs : checkboxMap.entrySet()) {
                if (pairs.getValue() != view) continue;
                for (Group g : Group.values()) {
                    if (!g.contains(pairs.getKey())) continue;
                    return true;
                }
            }
            return false;
        }

        public int getState(Map<PolicyEditorPermissions, Boolean> map) {
            boolean allTrue = true;
            boolean allFalse = true;
            for (PolicyEditorPermissions pp : this.getPermissions()) {
                Boolean b = map.get(pp);
                if (b == null) {
                    return 0;
                }
                if (b.booleanValue()) {
                    allFalse = false;
                    continue;
                }
                allTrue = false;
            }
            if (allFalse) {
                return -1;
            }
            if (allTrue) {
                return 1;
            }
            return 0;
        }

        public boolean contains(PolicyEditorPermissions permission) {
            for (PolicyEditorPermissions policyEditorPermissions : this.permissions) {
                if (policyEditorPermissions != permission) continue;
                return true;
            }
            return false;
        }

        public String getTitle() {
            return this.title + " \u02c7";
        }

        public PolicyEditorPermissions[] getPermissions() {
            return this.permissions;
        }
    }
}

