/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg;

import com.hisilicon.hiregbin.model.reg.BaseRegisterInfo;
import com.hisilicon.hiregbin.model.reg.DemoBaseParam;
import com.hisilicon.hiregbin.model.reg.GpioData;
import com.hisilicon.hiregbin.model.reg.NetworkConfig;
import com.hisilicon.hiregbin.views.RegbinView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ParsedMainData {
    private String customDemoName;
    private String regFormatVersion;
    private String xlsVersion;
    private LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap = new LinkedHashMap();
    private ArrayList<String> startupList = new ArrayList();
    private ArrayList<String> ddrTypeList = new ArrayList();
    private ArrayList<NetworkConfig> netWorkConfigList = new ArrayList();
    private ArrayList<DemoBaseParam> demoList = new ArrayList();
    private ArrayList<GpioData> gpioList = new ArrayList();
    private ArrayList<String> ddrPhyList = new ArrayList();

    public boolean isValueValid(int address, int value) {
        return this.checkHasOption(address, value, this.comboParamRegInfoMap);
    }

    public ArrayList<String> getStartupList() {
        return this.startupList;
    }

    public void setStartupList(ArrayList<String> startupList) {
        this.startupList = startupList;
    }

    public ArrayList<NetworkConfig> getNetWorkConfigList() {
        return this.netWorkConfigList;
    }

    public void setNetWorkConfigList(ArrayList<NetworkConfig> netWorkConfigList) {
        this.netWorkConfigList = netWorkConfigList;
    }

    public ArrayList<DemoBaseParam> getDemoList() {
        return this.demoList;
    }

    public void setDemoList(ArrayList<DemoBaseParam> demoList) {
        this.demoList = demoList;
    }

    public ArrayList<GpioData> getGpioList() {
        return this.gpioList;
    }

    public void setGpioList(ArrayList<GpioData> gpioList) {
        this.gpioList = gpioList;
    }

    public static String[] getFunctionFromList(ArrayList<BaseRegisterInfo> baseRegisterInfoList, String ddrType) {
        ArrayList<String> resFunctionList = new ArrayList<String>();
        int i = 0;
        while (i < baseRegisterInfoList.size()) {
            block8: {
                String regFunction;
                block7: {
                    BaseRegisterInfo baseRegisterInfo = baseRegisterInfoList.get(i);
                    regFunction = baseRegisterInfo.getRegFunction();
                    String workbookName = baseRegisterInfo.getWorkbookName();
                    if (!RegbinView.isHi3716V550Series() && !RegbinView.isHi3716MV430Series() || !workbookName.contains("mddrc")) break block7;
                    String matcheBookName = "mddrc_" + ddrType;
                    if (!baseRegisterInfo.getWorkbookName().equals(matcheBookName)) break block8;
                }
                boolean isExistSameFunction = false;
                for (String resFunction : resFunctionList) {
                    if (!resFunction.equalsIgnoreCase(regFunction)) continue;
                    isExistSameFunction = true;
                }
                if (!isExistSameFunction) {
                    resFunctionList.add(regFunction);
                }
            }
            ++i;
        }
        String[] resFunctionStr = new String[resFunctionList.size()];
        int i2 = 0;
        while (i2 < resFunctionStr.length) {
            resFunctionStr[i2] = (String)resFunctionList.get(i2);
            ++i2;
        }
        return resFunctionStr;
    }

    public boolean checkHasOption(int absoluteAddr, int value, Map<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap) {
        boolean isAddressContained = false;
        boolean isValueOk = false;
        Iterator<Map.Entry<String, ArrayList<BaseRegisterInfo>>> iterator = comboParamRegInfoMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, ArrayList<BaseRegisterInfo>> entry = iterator.next();
            ArrayList<BaseRegisterInfo> paramRegList = entry.getValue();
            for (BaseRegisterInfo baseRegisterInfo : paramRegList) {
                int regAbsoluteAddress = baseRegisterInfo.getRegAbsoluteAddress();
                int regValue = baseRegisterInfo.getRegValue();
                if (absoluteAddr != regAbsoluteAddress) continue;
                isAddressContained = true;
                if (value != regValue) continue;
                isValueOk = true;
                break;
            }
            return !isAddressContained || isValueOk;
        }
        return false;
    }

    public String getCustomDemoName() {
        return this.customDemoName;
    }

    public void setCustomDemoName(String customDemoName) {
        this.customDemoName = customDemoName;
    }

    public String getRegFormatVersion() {
        return this.regFormatVersion;
    }

    public void setRegFormatVersion(String regFormatVersion) {
        this.regFormatVersion = regFormatVersion;
    }

    public String getXlsVersion() {
        return this.xlsVersion;
    }

    public void setXlsVersion(String xlsVersion) {
        this.xlsVersion = xlsVersion;
    }

    public LinkedHashMap<String, ArrayList<BaseRegisterInfo>> getComboParamRegInfoMap() {
        return this.comboParamRegInfoMap;
    }

    public void setComboParamRegInfoMap(LinkedHashMap<String, ArrayList<BaseRegisterInfo>> comboParamRegInfoMap) {
        this.comboParamRegInfoMap = comboParamRegInfoMap;
    }

    public ArrayList<String> getDdrTypeList() {
        return this.ddrTypeList;
    }

    public void setDdrTypeList(ArrayList<String> ddrTypeList) {
        this.ddrTypeList = ddrTypeList;
    }

    public ArrayList<String> getDdrPhyList() {
        return this.ddrPhyList;
    }

    public void setDdrPhyList(ArrayList<String> ddrPhyList) {
        this.ddrPhyList = ddrPhyList;
    }
}

