/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.bin;

import com.hisilicon.hiregbin.model.reg.bin.RegBinAction;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import java.nio.ByteOrder;

public class RegBinItem {
    protected static final int MASK_ENABLE_READ = 65536;
    protected static final int MASK_ENABLE_WRITE = 1;
    protected static final int MASK_STANDBYWAKEUPEXECUTION_READ = 131072;
    protected static final int MASK_STANDBYWAKEUPEXECUTION_WRITE = 2;
    protected static final int MASK_NORMALBOOTEXECUTION_READ = 262144;
    protected static final int MASK_NORMALBOOTEXECUTION_WRITE = 4;
    protected static final int MASK_BITS_READ = 0xF80000;
    protected static final int MASK_BITS_WRITE = 248;
    protected static final int MASK_STARTBIT_READ = -134217728;
    protected static final int MASK_STARTBIT_WRITE = 63488;
    protected static final int MASK_0_TO_31 = 31;
    protected static final int SHIFT_BITS_READ = 19;
    protected static final int SHIFT_BITS_WRITE = 3;
    protected static final int SHIFT_STARTBIT_READ = 27;
    protected static final int SHIFT_STARTBIT_WRITE = 11;
    public static final int REGBIN_ITEM_ELMT_SIZE = 4;
    protected int mGroupIndex = 1;
    protected int mAddress;
    protected int mValue;
    protected int mDelay;
    protected int mAttribute;
    protected boolean hasExport = false;

    public int getGroupIndex() {
        return this.mGroupIndex;
    }

    public void setContentCatrgory(int groupIndex) {
        this.mGroupIndex = groupIndex;
    }

    public int getAddress() {
        return this.mAddress;
    }

    public void setAddress(int address) {
        this.mAddress = address;
    }

    public int getValue() {
        return this.mValue;
    }

    public void setValue(int value) {
        this.mValue = value;
    }

    public int getDelay() {
        return this.mDelay;
    }

    public void setDelay(int delay) {
        this.mDelay = delay;
    }

    public int getAttributes() {
        return this.mAttribute;
    }

    public void setAttribute(int attribute) {
        this.mAttribute = attribute;
    }

    public boolean isHasExport() {
        return this.hasExport;
    }

    public void setHasExport(boolean hasExport) {
        this.hasExport = hasExport;
    }

    public boolean isActionEnabled(RegBinAction action) {
        if (RegBinAction.READ == action) {
            return (this.mAttribute & 0x10000) != 0;
        }
        return (this.mAttribute & 1) != 0;
    }

    public void setActionEnabled(RegBinAction action, boolean enable) {
        this.mAttribute = RegBinAction.READ == action ? (enable ? (this.mAttribute |= 0x10000) : (this.mAttribute &= 0xFFFEFFFF)) : (enable ? (this.mAttribute |= 1) : (this.mAttribute &= 0xFFFFFFFE));
    }

    public boolean isExecutionRequiredForStandbyWakeup(RegBinAction action) {
        if (RegBinAction.READ == action) {
            return (this.mAttribute & 0x20000) != 0;
        }
        return (this.mAttribute & 2) != 0;
    }

    public void setExecutionRequiredForStandbyWakeup(RegBinAction action, boolean require) {
        this.mAttribute = RegBinAction.READ == action ? (require ? (this.mAttribute |= 0x20000) : (this.mAttribute &= 0xFFFDFFFF)) : (require ? (this.mAttribute |= 2) : (this.mAttribute &= 0xFFFFFFFD));
    }

    public boolean isExecutionRequiredForNormalBoot(RegBinAction action) {
        if (RegBinAction.READ == action) {
            return (this.mAttribute & 0x40000) != 0;
        }
        return (this.mAttribute & 4) != 0;
    }

    public void setExecutionRequiredForNormalBoot(RegBinAction action, boolean require) {
        this.mAttribute = RegBinAction.READ == action ? (require ? (this.mAttribute |= 0x40000) : (this.mAttribute &= 0xFFFBFFFF)) : (require ? (this.mAttribute |= 4) : (this.mAttribute &= 0xFFFFFFFB));
    }

    public int getBits(RegBinAction action) {
        int bits = 0;
        bits = RegBinAction.READ == action ? (this.mAttribute & 0xF80000) >> 19 : (this.mAttribute & 0xF8) >> 3;
        return bits;
    }

    public void setBits(RegBinAction action, int bits) {
        int valueTarget = 0;
        int valueOther = 0;
        if (RegBinAction.READ == action) {
            valueTarget = (bits & 0x1F) << 19;
            valueOther = this.mAttribute & 0xFF07FFFF;
        } else {
            valueTarget = (bits & 0x1F) << 3;
            valueOther = this.mAttribute & 0xFFFFFF07;
        }
        this.mAttribute = valueTarget | valueOther;
    }

    public int getStartBit(RegBinAction action) {
        int startBit = 0;
        startBit = RegBinAction.READ == action ? (this.mAttribute & 0xF8000000) >> 27 : (this.mAttribute & 0xF800) >> 11;
        return startBit;
    }

    public void setStartBit(RegBinAction action, int startBit) {
        int valueTarget = 0;
        int valueOther = 0;
        if (RegBinAction.READ == action) {
            valueTarget = (startBit & 0x1F) << 27;
            valueOther = this.mAttribute & 0x7FFFFFF;
        } else {
            valueTarget = (startBit & 0x1F) << 11;
            valueOther = this.mAttribute & 0xFFFF07FF;
        }
        this.mAttribute = valueTarget | valueOther;
    }

    public boolean fromBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        this.mAddress = BytesArrayUtils.getInt(buffer, pointer, ByteOrder.LITTLE_ENDIAN);
        this.mValue = BytesArrayUtils.getInt(buffer, pointer += 4, ByteOrder.LITTLE_ENDIAN);
        this.mDelay = BytesArrayUtils.getInt(buffer, pointer += 4, ByteOrder.LITTLE_ENDIAN);
        this.mAttribute = BytesArrayUtils.getInt(buffer, pointer += 4, ByteOrder.LITTLE_ENDIAN);
        pointer += 4;
        return true;
    }

    public void toBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
    }
}

