/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.cfg;

import com.hisilicon.hiregbin.model.reg.cfg.CfgBinItem;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinModule;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import com.hisilicon.hiregbin.utility.FileUtils;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CfgBinData {
    protected static final String TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    protected static final int SHORT_SIZE = 2;
    protected static final int INT_SIZE = 4;
    protected static final int DATAEND_SIZE = 8;
    protected static final int DATAEND_98CV200_SIZE = 4;
    protected static final int NAME_OFFSET_SIZE = 4;
    protected static final int REG_FORMAT_VERSION_NUMBER_LEN = 4;
    protected static final int XML_VERSION_NUMBER_LEN = 6;
    protected static final int FIRST_MODULE_OFFSET_LEN = 2;
    protected static final int DATA_TIME_LEN = 20;
    protected String mName;
    protected String mTime;
    protected ArrayList<CfgBinModule> mListModules = new ArrayList();

    public void addModule(CfgBinModule module) {
        this.mListModules.add(module);
    }

    public int getModuleCount() {
        return this.mListModules.size();
    }

    public CfgBinModule getModule(int index) {
        return this.mListModules.get(index);
    }

    public String getmName() {
        return this.mName;
    }

    public void setmName(String mName) {
        this.mName = mName;
    }

    public String getmTime() {
        return this.mTime;
    }

    public void setmTime(String mTime) {
        this.mTime = mTime;
    }

    public ArrayList<CfgBinModule> seekForModule(int baseAddr) {
        ArrayList<CfgBinModule> list = new ArrayList<CfgBinModule>();
        int i = 0;
        while (i < this.mListModules.size()) {
            CfgBinModule module = this.mListModules.get(i);
            if (module.getBaseAddr() == baseAddr) {
                list.add(module);
            }
            ++i;
        }
        return list;
    }

    public CfgBinItem seekForItem(int baseAddr, int offsetAddr, int startBit) {
        for (CfgBinModule module : this.mListModules) {
            if (module.getBaseAddr() != baseAddr) continue;
            int i = 0;
            while (i < module.getItemCount()) {
                CfgBinItem item = module.getItem(i);
                int regStartBit = BitUtils.getStartBit(item.getValueMask());
                if (item.getAddress() == offsetAddr && regStartBit == startBit && !item.isHasExport()) {
                    item.setHasExport(true);
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    public CfgBinItem seekForItemForBase(int baseAddr, int offsetAddr, int startBit) {
        for (CfgBinModule module : this.mListModules) {
            if (module.getBaseAddr() != baseAddr) continue;
            int i = 0;
            while (i < module.getItemCount()) {
                CfgBinItem item = module.getItem(i);
                int regStartBit = BitUtils.getStartBit(item.getValueMask());
                if (item.getAddress() == offsetAddr && regStartBit == startBit) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fromFile(String filePath) throws IndexOutOfBoundsException {
        try {
            byte[] binData = FileUtils.readAllBytes(filePath);
            if (binData == null) {
                return false;
            }
            int pointer = 0;
            boolean isContinue = !BytesArrayUtils.isAllSame((byte)-1, binData, pointer, 8);
            while (isContinue) {
                CfgBinModule module = new CfgBinModule();
                int readSize = module.fromBytes(binData, pointer);
                if (readSize < 0) {
                    return false;
                }
                this.mListModules.add(module);
                boolean bl = isContinue = !BytesArrayUtils.isAllSame((byte)-1, binData, pointer += readSize, 8);
            }
            StringBuilder sbTime = new StringBuilder();
            byte ch = binData[pointer += 8];
            ++pointer;
            while (ch != -1) {
                sbTime.append((char)ch);
                ch = binData[pointer];
                ++pointer;
            }
            this.mTime = sbTime.toString();
            StringBuilder sbName = new StringBuilder();
            ch = binData[pointer];
            ++pointer;
            while (ch != -1) {
                sbName.append((char)ch);
                ch = binData[pointer];
                ++pointer;
            }
            this.mName = sbName.toString();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean toFile(String filePath) {
        if (this.mName == null) {
            return false;
        }
        Date timeNow = new Date();
        SimpleDateFormat df = new SimpleDateFormat(TIME_FORMAT);
        this.mTime = df.format(timeNow);
        int size = 0;
        int i = 0;
        while (i < this.mListModules.size()) {
            CfgBinModule module = this.mListModules.get(i);
            module.recalcByteUse();
            size += module.getBytesSize();
            ++i;
        }
        size += 8;
        try {
            size += this.mName.getBytes(System.getProperty("file.encoding")).length + 1;
            size += this.mTime.getBytes(System.getProperty("file.encoding")).length + 1;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] binData = new byte[size];
        int i2 = 0;
        while (i2 < size) {
            binData[i2] = 0;
            ++i2;
        }
        int pointer = 0;
        int i3 = 0;
        while (i3 < this.mListModules.size()) {
            CfgBinModule module = this.mListModules.get(i3);
            module.toBytes(binData, pointer);
            pointer += module.getBytesSize();
            ++i3;
        }
        i3 = 0;
        while (i3 < 8) {
            binData[pointer] = -1;
            ++pointer;
            ++i3;
        }
        BytesArrayUtils.setString(binData, pointer, this.mTime.length(), this.mTime);
        binData[pointer += this.mTime.length()] = -1;
        BytesArrayUtils.setString(binData, ++pointer, this.mName.length(), this.mName);
        binData[pointer += this.mName.length()] = -1;
        ++pointer;
        return FileUtils.writeAllBytes(binData, filePath);
    }
}

