/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.reg.cfg;

import com.hisilicon.hiregbin.model.reg.cfg.CfgBinBits;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinCommand;
import com.hisilicon.hiregbin.model.reg.cfg.CfgBinModule;
import com.hisilicon.hiregbin.utility.BitUtils;
import com.hisilicon.hiregbin.utility.BytesArrayUtils;
import java.nio.ByteOrder;

public class CfgBinItem {
    protected static final int SHORT_SIZE = 2;
    protected static final int INT_SIZE = 4;
    protected static final byte CMD_END = 15;
    protected static final byte CMD_REG = 0;
    protected static final byte CMD_DELAY = 1;
    protected static final byte CMD_WAIT = 2;
    protected static final byte CMD_REG_MSK = 3;
    protected static final byte CMD_WAIT_MSK = 4;
    protected static final int BIT_8 = 0;
    protected static final int BIT_16 = 1;
    protected static final int BIT_32 = 2;
    protected static final byte FLAGMASK_CMD = 15;
    protected static final byte FLAGMASK_VALUE = 48;
    protected static final byte FLAGMASK_ADDR = -64;
    protected static final int MAX_DELAY = 2500;
    protected CfgBinModule mModuleRef;
    protected CfgBinCommand mCmd;
    protected CfgBinBits mAddrBits;
    protected CfgBinBits mValueBits;
    protected int mAddress;
    protected int mValue;
    protected int mValueMask;
    protected int mDelay;
    protected boolean hasExport = false;

    public CfgBinItem(CfgBinModule parent) {
        this.mModuleRef = parent;
        this.mValueMask = -1;
    }

    public CfgBinModule getModuleRef() {
        return this.mModuleRef;
    }

    public CfgBinCommand getCmd() {
        return this.mCmd;
    }

    public void setCmd(CfgBinCommand mCmd) {
        this.mCmd = mCmd;
    }

    public CfgBinBits getAddrBits() {
        return this.mAddrBits;
    }

    public void setAddrBits(CfgBinBits mAddrBits) {
        this.mAddrBits = mAddrBits;
    }

    public CfgBinBits getValueBits() {
        return this.mValueBits;
    }

    public void setValueBits(CfgBinBits mValueBits) {
        this.mValueBits = mValueBits;
    }

    public int getAddress() {
        return this.mAddress;
    }

    public void setAddress(int mAddress) {
        this.mAddress = mAddress;
    }

    public int getValue() {
        return this.mValue;
    }

    public void setValue(int mValue) {
        this.mValue = mValue;
    }

    public int getValueMask() {
        return this.mValueMask;
    }

    public void setValueMask(int mValueMask) {
        this.mValueMask = mValueMask;
    }

    public int getDelay() {
        return this.mDelay;
    }

    public void setDelay(int delay) {
        if (delay > 2500) {
            delay = 2500;
        }
        this.mDelay = delay;
    }

    public boolean isHasExport() {
        return this.hasExport;
    }

    public void setHasExport(boolean hasExport) {
        this.hasExport = hasExport;
    }

    protected CfgBinBits getBits(int value) {
        if (value >= 0 && value <= 255) {
            return CfgBinBits._8BITS;
        }
        if (value >= 255 && value <= 65535) {
            return CfgBinBits._16BITS;
        }
        return CfgBinBits._32BITS;
    }

    public void recalcBytesUse() {
        this.mAddrBits = this.getBits(this.mAddress);
        if (this.mCmd == CfgBinCommand.REG_MSK || this.mCmd == CfgBinCommand.WAIT_MSK) {
            int startBit = BitUtils.getStartBit(this.mValueMask);
            this.mValueBits = this.getBits(this.mValue << startBit);
            CfgBinBits maskBits = this.getBits(this.mValueMask);
            if (this.mValueBits.getBytesNumber() < maskBits.getBytesNumber()) {
                this.mValueBits = maskBits;
            }
        } else {
            this.mValueBits = this.getBits(this.mValue);
        }
    }

    public int getBytesSize() {
        int size = 0;
        ++size;
        size += this.mAddrBits.getBytesNumber();
        size += this.mValueBits.getBytesNumber();
        if (this.mCmd == CfgBinCommand.REG_MSK || this.mCmd == CfgBinCommand.WAIT_MSK) {
            size += this.mValueBits.getBytesNumber();
        }
        if (this.mDelay != 0) {
            this.toString();
        }
        size = this.mDelay % 255 == 0 ? (size += 2 * (this.mDelay / 255)) : (size += 2 * (this.mDelay / 255 + 1));
        return size;
    }

    public int fromBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        int flag = buffer[pointer] & 0xFF;
        ++pointer;
        int cmd = flag & 0xF;
        int valueBits = (flag & 0x30) >> 4;
        int addrBits = (flag & 0xFFFFFFC0) >> 6;
        if (cmd == 0) {
            this.mCmd = CfgBinCommand.REG;
        } else if (cmd == 2) {
            this.mCmd = CfgBinCommand.WAIT;
        } else if (cmd == 3) {
            this.mCmd = CfgBinCommand.REG_MSK;
        } else if (cmd == 4) {
            this.mCmd = CfgBinCommand.WAIT_MSK;
        } else {
            return -1;
        }
        if (valueBits == 0) {
            this.mValueBits = CfgBinBits._8BITS;
        } else if (valueBits == 1) {
            this.mValueBits = CfgBinBits._16BITS;
        } else if (valueBits == 2) {
            this.mValueBits = CfgBinBits._32BITS;
        } else {
            return -1;
        }
        if (addrBits == 0) {
            this.mAddrBits = CfgBinBits._8BITS;
        } else if (addrBits == 1) {
            this.mAddrBits = CfgBinBits._16BITS;
        } else if (addrBits == 2) {
            this.mAddrBits = CfgBinBits._32BITS;
        } else {
            return -1;
        }
        if (addrBits == 0) {
            this.mAddress = buffer[pointer] & 0xFF;
            ++pointer;
        } else if (addrBits == 1) {
            this.mAddress = BytesArrayUtils.getShort(buffer, pointer, ByteOrder.BIG_ENDIAN) & 0xFFFF;
            pointer += 2;
        } else if (addrBits == 2) {
            this.mAddress = BytesArrayUtils.getInt(buffer, pointer, ByteOrder.BIG_ENDIAN) - this.mModuleRef.getBaseAddr();
            pointer += 4;
        }
        if (valueBits == 0) {
            this.mValue = buffer[pointer] & 0xFF;
            ++pointer;
        } else if (valueBits == 1) {
            this.mValue = BytesArrayUtils.getShort(buffer, pointer, ByteOrder.BIG_ENDIAN) & 0xFFFF;
            pointer += 2;
        } else if (valueBits == 2) {
            this.mValue = BytesArrayUtils.getInt(buffer, pointer, ByteOrder.BIG_ENDIAN);
            pointer += 4;
        }
        if (cmd == 3 || cmd == 4) {
            if (valueBits == 0) {
                this.mValueMask = buffer[pointer] & 0xFF;
                ++pointer;
            } else if (valueBits == 1) {
                this.mValueMask = BytesArrayUtils.getShort(buffer, pointer, ByteOrder.BIG_ENDIAN) & 0xFFFF;
                pointer += 2;
            } else {
                this.mValueMask = BytesArrayUtils.getInt(buffer, pointer, ByteOrder.BIG_ENDIAN);
                pointer += 4;
            }
            int startBit = BitUtils.getStartBit(this.mValueMask);
            this.mValue >>>= startBit;
        }
        return pointer - offset;
    }

    public int delayFromBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int pointer = offset;
        byte chNext = buffer[pointer];
        while (chNext == 1) {
            int delay = buffer[pointer + 1] & 0xFF;
            this.mDelay += delay;
            chNext = buffer[pointer += 2];
        }
        return pointer - offset;
    }

    public int toBytes(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        byte flag;
        int pointer = offset;
        int fcmd = this.mCmd.getValue();
        int fvalue = this.mValueBits.getValue();
        int faddr = this.mAddrBits.getValue();
        buffer[pointer] = flag = (byte)(fcmd | fvalue << 4 | faddr << 6);
        ++pointer;
        if (this.mAddrBits == CfgBinBits._8BITS) {
            buffer[pointer] = (byte)(this.mAddress & 0xFF);
            ++pointer;
        } else if (this.mAddrBits == CfgBinBits._16BITS) {
            BytesArrayUtils.setShort(buffer, pointer, (short)(this.mAddress & 0xFFFF), ByteOrder.BIG_ENDIAN);
            pointer += 2;
        } else {
            BytesArrayUtils.setInt(buffer, pointer, this.mAddress + this.mModuleRef.getBaseAddr(), ByteOrder.BIG_ENDIAN);
            pointer += 4;
        }
        int startBit = BitUtils.getStartBit(this.mValueMask);
        int value = this.mValue << startBit;
        if (this.mValueBits == CfgBinBits._8BITS) {
            buffer[pointer] = (byte)(value & 0xFF);
            ++pointer;
        } else if (this.mValueBits == CfgBinBits._16BITS) {
            BytesArrayUtils.setShort(buffer, pointer, (short)(value & 0xFFFF), ByteOrder.BIG_ENDIAN);
            pointer += 2;
        } else {
            BytesArrayUtils.setInt(buffer, pointer, value, ByteOrder.BIG_ENDIAN);
            pointer += 4;
        }
        if (this.mCmd == CfgBinCommand.REG_MSK || this.mCmd == CfgBinCommand.WAIT_MSK) {
            if (this.mValueBits == CfgBinBits._8BITS) {
                buffer[pointer] = (byte)(this.mValueMask & 0xFF);
                ++pointer;
            } else if (this.mValueBits == CfgBinBits._16BITS) {
                BytesArrayUtils.setShort(buffer, pointer, (short)(this.mValueMask & 0xFFFF), ByteOrder.BIG_ENDIAN);
                pointer += 2;
            } else {
                BytesArrayUtils.setInt(buffer, pointer, this.mValueMask, ByteOrder.BIG_ENDIAN);
                pointer += 4;
            }
        }
        int delay = this.mDelay;
        while (delay > 0) {
            int writeVal = Math.min(delay, 250);
            buffer[pointer] = 1;
            buffer[pointer + 1] = (byte)(writeVal & 0xFF);
            pointer += 2;
            delay -= writeVal;
        }
        return pointer - offset;
    }
}

