/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.ui;

import com.hisilicon.hiregbin.Activator;
import com.hisilicon.hiregbin.Messages;
import com.hisilicon.hiregbin.model.BaseParam;
import com.hisilicon.hiregbin.model.GlobleInfo;
import com.hisilicon.hiregbin.model.reg.ParsedMainData;
import com.hisilicon.hiregbin.model.reg.PinDemuxType;
import com.hisilicon.hiregbin.model.reg.excel.ExcelData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.BinData;
import com.hisilicon.hiregbin.model.reg.hi98cv200bin.MultiperTable;
import com.hisilicon.hiregbin.processor.PrepareSetting;
import com.hisilicon.hiregbin.ui.PanelComposite;
import com.hisilicon.hiregbin.utility.ExcelDataHelper;
import com.hisilicon.hiregbin.utility.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class MultiperTableComposite
extends Composite {
    private static final int COL_NUMBER = 0;
    private static final int COL_VOLTAGE = 1;
    private static final int COL_TABLENAME = 2;
    private static final int COL_TABLE_FILE_PATH = 3;
    private static final int COL_LOAD = 4;
    private static final int COL_DELETE = 5;
    private static final String[] COLUMNS = new String[]{Messages.MultiperTableComposite_TABLE_COLOMN_NUMBER, Messages.MultiperTableComposite_TABLE_COLOMN_VOLTAGE, Messages.MultiperTableComposite_TABLE_COLOMN_TABLENAME, Messages.MultiperTableComposite_TABLE_COLOMN_TABLE_FILE_PATH, Messages.MultiperTableComposite_TABLE_COLOMN_LOAD, Messages.MultiperTableComposite_TABLE_COLOMN_DELETE};
    private TableViewer viewer;
    private boolean vBarVisibility;
    private int labelWidth;
    private TableViewer itemViewer;
    protected List<MultiperTable> multiperTableList;
    private PanelComposite panelComposite;
    private IStructuredSelection lastSelection;

    public MultiperTableComposite(Composite parent, int style, List<MultiperTable> multiperTableList, PanelComposite panelComposite) {
        super(parent, style);
        this.multiperTableList = multiperTableList;
        this.panelComposite = panelComposite;
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        Composite tableControl = this.createItemTable(parent);
        this.itemViewer = (TableViewer)tableControl.getData();
        this.itemViewer.setInput(this.getMultiperTableList());
        this.updateBackground(this.itemViewer, this.multiperTableList);
        this.itemViewer.refresh();
        GridData layoutData2 = new GridData(4, 4, true, false, 1, 1);
        layoutData2.minimumHeight = 230;
        tableControl.setLayoutData((Object)layoutData2);
    }

    protected Composite createItemTable(Composite parent) {
        Composite control = new Composite(parent, 2048);
        TableColumnLayout tcl = new TableColumnLayout();
        control.setLayout((Layout)tcl);
        this.viewer = new TableViewer(control, 66064);
        this.viewer.setContentProvider(this.createContentProvider());
        this.viewer.setLabelProvider(this.createLabelProvider());
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                MultiperTableComposite.this.handlePaintTableItem(event);
            }
        });
        int minWeidth = 20;
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(COLUMNS[0]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(2, 20, false));
        column = new TableColumn(table, 0x1000000, 1);
        column.setResizable(false);
        column.setMoveable(false);
        column.setText(COLUMNS[1]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 20, false));
        column = new TableColumn(table, 0x1000000, 2);
        column.setResizable(true);
        column.setMoveable(false);
        column.setText(COLUMNS[2]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(7, 20, false));
        column = new TableColumn(table, 0x1000000, 3);
        column.setResizable(true);
        column.setMoveable(false);
        column.setText(COLUMNS[3]);
        column.setAlignment(0x1000000);
        tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(7, 20, false));
        TableColumn loadCol = new TableColumn(table, 0x1000000, 4);
        loadCol.setAlignment(0x1000000);
        loadCol.setResizable(false);
        loadCol.setMoveable(false);
        loadCol.setText(COLUMNS[4]);
        tcl.setColumnData((Widget)loadCol, (ColumnLayoutData)new ColumnPixelData(50, false));
        TableViewerColumn loadColumn = new TableViewerColumn(this.viewer, loadCol);
        loadColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        });
        TableEditor loadEditor = new TableEditor(table);
        loadEditor.horizontalAlignment = 16384;
        loadEditor.grabHorizontal = true;
        loadEditor.minimumWidth = 50;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] selection;
                Control oldEditor = loadEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((selection = MultiperTableComposite.this.viewer.getTable().getSelection()).length == 0) {
                    return;
                }
                final TableItem item = selection[0];
                if (item == null) {
                    return;
                }
                MultiperTable multiperTable = (MultiperTable)item.getData();
                if (multiperTable.isSupport()) {
                    Button loadEditorBtn = new Button((Composite)table, 0);
                    loadEditorBtn.setImage(Activator.getImage("icons/add.gif"));
                    loadEditorBtn.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            String open;
                            MultiperTable data = (MultiperTable)item.getData();
                            IStructuredSelection selection = (IStructuredSelection)MultiperTableComposite.this.itemViewer.getSelection();
                            if (selection.isEmpty()) {
                                return;
                            }
                            data = (MultiperTable)selection.getFirstElement();
                            FileDialog dialog = new FileDialog(MultiperTableComposite.this.getShell(), 4096);
                            dialog.setFilterExtensions(new String[]{"*.reg", "*.bin", "*.*"});
                            if (data.getTableFile() != null) {
                                dialog.setFileName(data.getTableFile().getAbsolutePath());
                            }
                            if ((open = dialog.open()) == null || open.isEmpty()) {
                                return;
                            }
                            File file = new File(open);
                            if (file == null || !file.exists()) {
                                MessageDialog.openError((Shell)MultiperTableComposite.this.getShell(), (String)Messages.Message_Error, (String)Messages.MultiperTableComposite_import_reg_file_is_not_exist);
                                return;
                            }
                            data.setTableFile(file);
                            data.setTableName(file.getName());
                            BinData binData = new BinData();
                            boolean result = true;
                            try {
                                byte[] readAllBytes = FileUtils.readAllBytes(file.getAbsolutePath());
                                int pointer = 0;
                                result = binData.fromFile(readAllBytes, pointer);
                            }
                            catch (Exception e2) {
                                result = false;
                            }
                            if (!result) {
                                MessageDialog.openError((Shell)MultiperTableComposite.this.getShell(), (String)Messages.Message_Error, (String)Messages.ImportDateFileFormatError);
                                return;
                            }
                            data.setBinData(binData);
                            MultiperTableComposite.this.itemViewer.refresh(true);
                            control.layout();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    loadEditor.setEditor((Control)loadEditorBtn, item, 4);
                }
            }
        });
        TableColumn deleteCol = new TableColumn(table, 0x1000000, 5);
        deleteCol.setAlignment(0x1000000);
        deleteCol.setResizable(false);
        deleteCol.setMoveable(false);
        deleteCol.setText(COLUMNS[5]);
        tcl.setColumnData((Widget)deleteCol, (ColumnLayoutData)new ColumnPixelData(50, false));
        TableViewerColumn deleteColumn = new TableViewerColumn(this.viewer, deleteCol);
        deleteColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        });
        TableEditor deleteEditor = new TableEditor(table);
        deleteEditor.horizontalAlignment = 16384;
        deleteEditor.grabHorizontal = true;
        deleteEditor.minimumWidth = 50;
        this.lastSelection = (IStructuredSelection)this.viewer.getSelection();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem[] tableItems;
                Control oldEditor = deleteEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((tableItems = MultiperTableComposite.this.viewer.getTable().getSelection()).length == 0) {
                    return;
                }
                TableItem item = tableItems[0];
                if (item == null) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)MultiperTableComposite.this.viewer.getSelection();
                MultiperTable multiperTable = (MultiperTable)item.getData();
                if (multiperTable != null) {
                    String tableName = multiperTable.getTableName();
                    BinData binData = multiperTable.getBinData();
                    if (binData != null) {
                        BaseParam baseParam = new BaseParam();
                        Object paramObj = MultiperTableComposite.this.panelComposite.getParam(baseParam, ".reg");
                        boolean saveDate = MultiperTableComposite.this.tipNeedSaveData(paramObj, (MultiperTable)MultiperTableComposite.this.lastSelection.getFirstElement());
                        if (!saveDate) {
                            boolean openConfirm = MessageDialog.openConfirm((Shell)MultiperTableComposite.this.getShell(), (String)Messages.Message_HiRegBin, (String)NLS.bind((String)Messages.MultiperTableComposite_Confirm_Import_reg_file_to_composite, (Object)tableName));
                            if (openConfirm) {
                                ExcelData excelData = ExcelDataHelper.getExcelDataforImport();
                                if (excelData == null) {
                                    MessageDialog.openError((Shell)MultiperTableComposite.this.getShell(), (String)"Error", (String)"Please open an Excel data file first.");
                                    return;
                                }
                                ParsedMainData pmd = ExcelDataHelper.toParsedMainDataNew(excelData);
                                excelData.importBinData(excelData, binData, pmd, true);
                                ExcelDataHelper.setParsedMainData(pmd);
                                MultiperTableComposite.this.panelComposite.getBaseSettingComposite().refreshDemoInfoToUI(MultiperTableComposite.this.panelComposite.getBaseComposite(), pmd, ExcelDataHelper.extractDeviceName(binData.getHeadData().getBinName()), PinDemuxType.ImportBin, true);
                                MultiperTableComposite.this.panelComposite.getPinDemuxComposite().refreshDemoInfoToUI(ExcelDataHelper.extractDeviceName(binData.getHeadData().getBinName()), binData, binData.getHeadData().getBinName(), PinDemuxType.ImportBin, null);
                                MultiperTableComposite.this.lastSelection = selection;
                            } else {
                                MultiperTableComposite.this.viewer.setSelection((ISelection)MultiperTableComposite.this.lastSelection);
                                MultiperTableComposite.this.viewer.refresh();
                            }
                        }
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] selection;
                Control oldEditor = deleteEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((selection = MultiperTableComposite.this.viewer.getTable().getSelection()).length == 0) {
                    return;
                }
                final TableItem item = selection[0];
                if (item == null) {
                    return;
                }
                MultiperTable multiperTable = (MultiperTable)item.getData();
                if (multiperTable.isSupport()) {
                    Button btnDeleteEditor = new Button((Composite)table, 0);
                    btnDeleteEditor.setImage(Activator.getImage("icons/remove.png"));
                    btnDeleteEditor.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            MultiperTable data = (MultiperTable)item.getData();
                            IStructuredSelection selection = (IStructuredSelection)MultiperTableComposite.this.itemViewer.getSelection();
                            if (selection.isEmpty()) {
                                return;
                            }
                            data = (MultiperTable)selection.getFirstElement();
                            if (data.getBinData() == null) {
                                return;
                            }
                            MessageDialog dialog = new MessageDialog(MultiperTableComposite.this.getShell(), Messages.Message_HiRegBin, null, Messages.MultiperTableComposite_Confirm_Delete_Form, 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                            int open = dialog.open();
                            if (open == 1) {
                                return;
                            }
                            data.setTableFile(null);
                            data.setTableName("");
                            data.setBinData(null);
                            MultiperTableComposite.this.itemViewer.refresh(true);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    deleteEditor.setEditor((Control)btnDeleteEditor, item, 5);
                }
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ScrollBar verticalBar = table.getVerticalBar();
        if (verticalBar != null) {
            this.vBarVisibility = verticalBar.isVisible();
        }
        this.viewer.setColumnProperties(COLUMNS);
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (COLUMNS[0].equals(property)) {
                    return false;
                }
                if (COLUMNS[1].equals(property)) {
                    return false;
                }
                if (COLUMNS[2].equals(property)) {
                    return false;
                }
                if (COLUMNS[3].equals(property)) {
                    return false;
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                MultiperTable value = null;
                if (element instanceof MultiperTable) {
                    value = (MultiperTable)element;
                } else if (element instanceof TableItem) {
                    value = (MultiperTable)((TableItem)element).getData();
                }
                if (value != null) {
                    if (property.equals(COLUMNS[0])) {
                        String name = value.getTableId();
                        return name == null ? "" : name;
                    }
                    if (property.equals(COLUMNS[1])) {
                        String voltage = value.getTableVoltage();
                        return voltage == null ? "" : voltage;
                    }
                    if (property.equals(COLUMNS[2])) {
                        String tabletableName = value.getTableName();
                        return tabletableName == null ? "" : tabletableName;
                    }
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
            }
        });
        TextCellEditor filePathEditor = new TextCellEditor((Composite)table);
        CellEditor[] cellEditorArray = new CellEditor[6];
        cellEditorArray[3] = filePathEditor;
        this.viewer.setCellEditors(cellEditorArray);
        control.setData((Object)this.viewer);
        return control;
    }

    public boolean tipNeedSaveData(Object paramObj, MultiperTable multiperTable) {
        if (GlobleInfo.isNeedSave()) {
            if (paramObj == null) {
                GlobleInfo.setNeedSave(false);
                return false;
            }
            if (multiperTable != null) {
                String regNumber = multiperTable.getTableId();
                String regName = multiperTable.getTableName();
                boolean openConfirm = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.Message_Information, (String)NLS.bind((String)Messages.AbstractBaseComposite_TipNeedSave_Current_RegData_To_Boot, (Object)regNumber));
                if (openConfirm) {
                    PrepareSetting prepareSetting = (PrepareSetting)this.panelComposite.setting;
                    try {
                        BinData binData;
                        if (ExcelDataHelper.isV120RegFomatVersion(ExcelDataHelper.getExcelData()) && (binData = prepareSetting.saveBinDataByCurExcelData(regName)) != null) {
                            multiperTable.setBinData(binData);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    GlobleInfo.setNeedSave(false);
                    return true;
                }
                GlobleInfo.setNeedSave(false);
                return false;
            }
            GlobleInfo.setNeedSave(false);
            return false;
        }
        return false;
    }

    protected void handlePaintTableItem(Event event) {
        event.detail &= 0xFFFFFFDF;
        if ((event.detail & 2) == 0) {
            return;
        }
        Table table = (Table)event.widget;
        int clientWidth = table.getClientArea().width;
        GC gc = event.gc;
        Color oldForeground = gc.getForeground();
        Color oldBackground = gc.getBackground();
        Color forecolor = new Color(null, new RGB(255, 0, 0));
        gc.setForeground(forecolor);
        gc.drawRectangle(0, event.y, clientWidth, event.height - 2);
        forecolor.dispose();
        gc.setForeground(oldForeground);
        gc.setBackground(oldBackground);
        event.detail &= 0xFFFFFFFD;
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new ViewerLabelProvider();
    }

    protected IContentProvider createContentProvider() {
        return new ViewerContentProvider();
    }

    public List<MultiperTable> getMultiperTableList() {
        if (this.multiperTableList == null) {
            this.multiperTableList = new ArrayList<MultiperTable>();
        }
        return this.multiperTableList;
    }

    public void updateBackground(TableViewer itemViewer, List<MultiperTable> multiperTableList) {
        int i = 0;
        while (i < multiperTableList.size()) {
            MultiperTable multiperTable = multiperTableList.get(i);
            TableItem item = itemViewer.getTable().getItem(i);
            if (!multiperTable.isSupport()) {
                item.setBackground(this.getShell().getDisplay().getSystemColor(15));
            } else {
                item.setBackground(this.getShell().getDisplay().getSystemColor(1));
            }
            ++i;
        }
    }

    public TableViewer getItemViewer() {
        return this.itemViewer;
    }

    public boolean isvBarVisibility() {
        return this.vBarVisibility;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setMultiperTableList(List<MultiperTable> multiperTableList) {
        this.multiperTableList = multiperTableList;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public IStructuredSelection getLastSelection() {
        return this.lastSelection;
    }

    public void setLastSelection(IStructuredSelection lastSelection) {
        this.lastSelection = lastSelection;
    }

    static /* synthetic */ TableViewer access$0(MultiperTableComposite multiperTableComposite) {
        return multiperTableComposite.viewer;
    }

    static /* synthetic */ TableViewer access$1(MultiperTableComposite multiperTableComposite) {
        return multiperTableComposite.itemViewer;
    }

    static /* synthetic */ PanelComposite access$2(MultiperTableComposite multiperTableComposite) {
        return multiperTableComposite.panelComposite;
    }

    static /* synthetic */ IStructuredSelection access$3(MultiperTableComposite multiperTableComposite) {
        return multiperTableComposite.lastSelection;
    }

    static /* synthetic */ void access$4(MultiperTableComposite multiperTableComposite, IStructuredSelection iStructuredSelection) {
        multiperTableComposite.lastSelection = iStructuredSelection;
    }

    static /* synthetic */ String[] access$5() {
        return COLUMNS;
    }

    private class ViewerContentProvider
    implements IStructuredContentProvider {
        private ViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return MultiperTableComposite.this.getMultiperTableList().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MultiperTable) {
                MultiperTable item = (MultiperTable)element;
                switch (columnIndex) {
                    case 0: {
                        return item.getTableId();
                    }
                    case 1: {
                        String tableVoltage = item.getTableVoltage();
                        return tableVoltage == null ? "" : tableVoltage;
                    }
                    case 2: {
                        String tableName = item.getTableName();
                        return tableName == null ? "" : tableName;
                    }
                    case 3: {
                        if (item.getTableFile() != null) {
                            String tableFilePath = item.getTableFile().getAbsolutePath();
                            return tableFilePath == null ? "" : tableFilePath;
                        }
                        return "";
                    }
                }
            }
            return "";
        }
    }
}

