/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.utility;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BytesArrayUtils {
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;

    public static short getShort(byte[] buffer, int offset, ByteOrder order) throws IndexOutOfBoundsException {
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, 2);
        bb.order(order);
        return bb.getShort();
    }

    public static int getInt(byte[] buffer, int offset, ByteOrder order) throws IndexOutOfBoundsException {
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, 4);
        bb.order(order);
        return bb.getInt();
    }

    public static int getIntFor3bits(byte[] buffer, int offset, ByteOrder order) throws IndexOutOfBoundsException {
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, 3);
        bb.order(order);
        return bb.get(0) << 24 | bb.get(1) << 16 | bb.get(2) << 8;
    }

    public static void setShort(byte[] buffer, int offset, short value, ByteOrder order) {
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.order(order);
        bb.putShort(value);
        byte[] valueBuffer = bb.array();
        int i = 0;
        while (i < 2) {
            buffer[offset + i] = valueBuffer[i];
            ++i;
        }
    }

    public static void setInt(byte[] buffer, int offset, int value, ByteOrder order) throws IndexOutOfBoundsException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(order);
        bb.putInt(value);
        byte[] valueBuffer = bb.array();
        int i = 0;
        while (i < 4) {
            buffer[offset + i] = valueBuffer[i];
            ++i;
        }
    }

    public static void setIntFor3bytes(byte[] buffer, int offset, int value, ByteOrder order, boolean isHighBytes) throws IndexOutOfBoundsException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(order);
        bb.putInt(value);
        byte[] valueBuffer = bb.array();
        int i = 0;
        while (i < 4) {
            if (isHighBytes) {
                if (i + 1 < 4) {
                    buffer[offset + i] = valueBuffer[i];
                }
            } else if (i + 1 < 4) {
                buffer[offset + i] = valueBuffer[i + 1];
            }
            ++i;
        }
    }

    public static int getIntFor3bytes(byte[] buffer, int offset, ByteOrder order, boolean isHighBytes) throws IndexOutOfBoundsException {
        byte b0 = buffer[offset];
        byte b1 = buffer[offset + 1];
        byte b2 = buffer[offset + 2];
        if (order == ByteOrder.BIG_ENDIAN) {
            if (isHighBytes) {
                return b0 << 24 & 0xFF000000 | b1 << 16 & 0xFF0000 | b2 << 8 & 0xFF00;
            }
            return b0 << 16 & 0xFF0000 | b1 << 8 & 0xFF00 | b2 & 0xFF;
        }
        if (isHighBytes) {
            return b2 << 24 & 0xFF000000 | b1 << 16 & 0xFF0000 | b0 << 8 & 0xFF00;
        }
        return b2 << 16 & 0xFF0000 | b1 << 8 & 0xFF00 | b0 & 0xFF;
    }

    public static int get3HightBytesFromInt(int value) {
        return value & 0xFFFFFF00;
    }

    public static int get1LowBytesFromInt(int value) {
        return value & 0xFF;
    }

    public static String getString(byte[] buffer, int offset, int length) throws IndexOutOfBoundsException {
        char[] strArray = new char[length];
        int i = 0;
        while (i < length) {
            strArray[i] = (char)buffer[offset + i];
            ++i;
        }
        return new String(strArray);
    }

    public static void setString(byte[] buffer, int offset, int length, String str) throws IndexOutOfBoundsException {
        char[] strBuffer = str.toCharArray();
        int writeLen = Math.min(length, strBuffer.length);
        int i = 0;
        while (i < writeLen) {
            buffer[offset + i] = (byte)strBuffer[i];
            ++i;
        }
    }

    public static boolean isAllSame(byte value, byte[] buffer, int offset, int length) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < length) {
            if (buffer[offset + i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

