/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.utility;

import com.hisilicon.hiregbin.Messages;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileUtils {
    static final int BUFFER_SIZE = 1024;

    public static boolean isExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static String toAbsolutePath(String filePath) {
        Location location = Platform.getInstallLocation();
        if (location != null) {
            URL url = location.getURL();
            return String.valueOf(url.getPath()) + "/" + filePath;
        }
        return null;
    }

    public static byte[] readAllBytes(String filePath) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FileInputStream inStream = null;
        byte[] buffer = new byte[1024];
        try {
            try {
                inStream = new FileInputStream(filePath);
                int read = 0;
                while ((read = ((InputStream)inStream).read(buffer)) != -1) {
                    outStream.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                return null;
            }
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return outStream.toByteArray();
    }

    public static boolean copy(File oldfile, File newFile) {
        if (oldfile.getAbsoluteFile().equals(newFile.getAbsoluteFile())) {
            return true;
        }
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            try {
                int bytesum = 0;
                int byteread = 0;
                if (oldfile.exists()) {
                    inStream = new FileInputStream(oldfile);
                    fs = new FileOutputStream(newFile);
                    byte[] buffer = new byte[1024];
                    while ((byteread = inStream.read(buffer)) != -1) {
                        System.out.println(bytesum += byteread);
                        fs.write(buffer, 0, byteread);
                    }
                    fs.close();
                    inStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException io) {
                        io.printStackTrace();
                    }
                }
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException io) {
                        io.printStackTrace();
                    }
                }
                return false;
            }
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
        }
        return true;
    }

    public static boolean writeAllLines(ArrayList<String> lines, String filePath, boolean append, String charset) {
        if (lines == null || lines.size() == 0) {
            return false;
        }
        if (filePath == null || filePath.length() == 0) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(filePath, append);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                for (String line : lines) {
                    if (append) {
                        bufferedWriter.append(String.valueOf(line) + "\r\n");
                        continue;
                    }
                    bufferedWriter.write(String.valueOf(line) + "\r\n");
                }
            }
            catch (IOException e) {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e2) {
                    return false;
                }
                return false;
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean writeAllBytes(byte[] bytes, String filePath) {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(filePath);
                fos.write(bytes);
                fos.flush();
            }
            catch (FileNotFoundException e) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return false;
            }
            catch (IOException e) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static boolean saveItemToFile(File file, String str) {
        if (str == null) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getPath(), true), System.getProperty("file.encoding")));
                bw.write(str);
                bw.flush();
            }
            catch (IOException e) {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        return false;
                    }
                }
                return false;
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean createFile(File file) {
        if (file == null) {
            return false;
        }
        try {
            boolean create = file.createNewFile();
            if (!create) {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.FileCreateFailed, (Object)file.getAbsoluteFile()));
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.FileCreateFailed, (Object)file.getAbsoluteFile()));
            return false;
        }
        return true;
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        boolean delete = file.delete();
        if (!delete) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_Warning, (String)NLS.bind((String)Messages.FileDeleteFailed, (Object)file.getAbsoluteFile()));
            return false;
        }
        return true;
    }
}

