/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.monocle.MonocleApplication;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import java.io.IOException;
import java.io.InputStream;

final class MonocleCursor
extends Cursor {
    private byte[] image;
    private int hotspotX;
    private int hotspotY;

    MonocleCursor(int n) {
        super(n);
        this.image = MonocleCursor.getImage(n);
        this.hotspotX = 0;
        this.hotspotY = 0;
    }

    MonocleCursor(int n, int n2, Pixels pixels) {
        super(n, n2, pixels);
    }

    void applyCursor() {
        int n = this.getType();
        if (n == -1) {
            ((MonocleApplication)Application.GetApplication()).staticCursor_setVisible(false);
        } else {
            NativeCursor nativeCursor = NativePlatformFactory.getNativePlatform().getCursor();
            nativeCursor.setImage(this.image);
            ((MonocleApplication)Application.GetApplication()).staticCursor_setVisible(true);
        }
    }

    @Override
    protected long _createCursor(int n, int n2, Pixels pixels) {
        this.hotspotX = n;
        this.hotspotY = n2;
        this.image = pixels.asByteBuffer().array();
        return 1L;
    }

    private static String cursorResourceName(int n) {
        switch (n) {
            case 4: {
                return "ClosedHand";
            }
            case 3: {
                return "Crosshair";
            }
            case 13: {
                return "Disappear";
            }
            case 19: {
                return "Move";
            }
            case 5: {
                return "OpenHand";
            }
            case 6: {
                return "PointingHand";
            }
            case 10: {
                return "ResizeDown";
            }
            case 7: {
                return "ResizeLeft";
            }
            case 11: {
                return "ResizeLeftRight";
            }
            case 18: {
                return "ResizeNorthEast";
            }
            case 17: {
                return "ResizeNorthWest";
            }
            case 8: {
                return "ResizeRight";
            }
            case 16: {
                return "ResizeSouthEast";
            }
            case 15: {
                return "ResizeSouthWest";
            }
            case 9: {
                return "ResizeUp";
            }
            case 12: {
                return "ResizeUpDown";
            }
            case 2: {
                return "Text";
            }
            case 14: {
                return "Wait";
            }
        }
        return "Default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getImage(int n) {
        InputStream inputStream = null;
        try {
            int n2;
            inputStream = MonocleCursor.class.getResourceAsStream("Cursor" + MonocleCursor.cursorResourceName(n) + "Translucent.raw");
            byte[] byArray = new byte[1024];
            for (int i = 0; i < 1024; i += n2) {
                n2 = inputStream.read(byArray, i, 1024 - i);
                if (n2 >= 0) {
                    continue;
                }
                throw new IOException("Incomplete cursor resource");
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

