/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.model.baseparam;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.hi.baseparam.HI_UNF_DISP;
import com.hisilicon.fastplay.model.baseparam.AbstractBaseParam;
import com.hisilicon.fastplay.model.baseparam.Arc;
import com.hisilicon.fastplay.model.baseparam.Bt1120;
import com.hisilicon.fastplay.model.baseparam.Bt656;
import com.hisilicon.fastplay.model.baseparam.Cvbs;
import com.hisilicon.fastplay.model.baseparam.Dac;
import com.hisilicon.fastplay.model.baseparam.DispParamObj;
import com.hisilicon.fastplay.model.baseparam.Hdmi;
import com.hisilicon.fastplay.model.baseparam.I2SModeObj;
import com.hisilicon.fastplay.model.baseparam.I2s;
import com.hisilicon.fastplay.model.baseparam.Lcd;
import com.hisilicon.fastplay.model.baseparam.Mipi;
import com.hisilicon.fastplay.model.baseparam.MipiModeObj;
import com.hisilicon.fastplay.model.baseparam.Rgb;
import com.hisilicon.fastplay.model.baseparam.SoundHdmi;
import com.hisilicon.fastplay.model.baseparam.SoundParamObj;
import com.hisilicon.fastplay.model.baseparam.Spdif;
import com.hisilicon.fastplay.model.baseparam.SubParam;
import com.hisilicon.fastplay.model.baseparam.Svideo;
import com.hisilicon.fastplay.model.baseparam.Vga;
import com.hisilicon.fastplay.model.baseparam.Ypbpr;
import com.hisilicon.fastplay.ui.BaseparamComposite;
import com.hisilicon.fastplay.views.FastplayView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WidgetParam {
    private static final String INIT_STRING_VALUE = "-1";
    private static final int INIT_INT_VALUE = -1;
    private static final int INIT_COMBO_VALUE = 1;
    private static final int INIT_I2S_VALUE = -1;
    private static final int INIT_VOLUME_VALUE = 30;
    private final Map<Integer, Composite> dispComposite = new HashMap<Integer, Composite>();
    private final Map<Integer, DispParamObj> dispTimingDispParamObj = new HashMap<Integer, DispParamObj>();
    private final Map<Integer, DispParamObj> dispTimingDispParamObjInit = new HashMap<Integer, DispParamObj>();
    private final Map<Integer, Composite> soundComposite = new HashMap<Integer, Composite>();
    private final Map<Integer, Composite> i2sComposite = new HashMap<Integer, Composite>();

    public void addDispComposite(int dispIndex, Composite composite) {
        this.dispComposite.put(dispIndex, composite);
    }

    public void addDispTimingDispParamObj(int dispIndex, DispParamObj dispParamObj) {
        this.dispTimingDispParamObj.put(dispIndex, dispParamObj);
    }

    public void addDispTimingDispParamObjInit(int dispIndex, DispParamObj dispParamObj) {
        this.dispTimingDispParamObjInit.put(dispIndex, dispParamObj);
    }

    public void addSoundComposite(int soundIndex, Composite composite) {
        this.soundComposite.put(soundIndex, composite);
    }

    public void addI2SComposite(int i2sndex, Composite composite) {
        this.i2sComposite.put(i2sndex, composite);
    }

    public Map<Integer, Composite> getDispComposite() {
        return this.dispComposite;
    }

    public Map<Integer, Composite> getSoundComposite() {
        return this.soundComposite;
    }

    public Map<Integer, Composite> getI2sComposite() {
        return this.i2sComposite;
    }

    public Map<Integer, DispParamObj> getDispTimingDispParamObj() {
        return this.dispTimingDispParamObj;
    }

    public Map<Integer, DispParamObj> getDispTimingDispParamObjInit() {
        return this.dispTimingDispParamObjInit;
    }

    public AbstractBaseParam getBaseParam(int i2sIndex, Composite composite, AbstractBaseParam baseParam) {
        Control[] children;
        if (composite == null) {
            return null;
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            this.setBaseParam(((Group)con).getChildren(), baseParam);
            ++n2;
        }
        return baseParam;
    }

    public AbstractBaseParam setBaseParam(int index, Composite composite, AbstractBaseParam param, BaseparamComposite baseParam) {
        Control[] children;
        if (composite == null) {
            return null;
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            if (((Group)con).getText().trim().equalsIgnoreCase(Messages.BaseparamComposite_16)) {
                Composite body = baseParam.getBody();
                FormToolkit ft = baseParam.getFt();
                ScrolledForm form = baseParam.getForm();
                baseParam.readParamToInterface((Composite)((Group)con), body, ft, form, param, index);
            }
            this.setBaseParamUI(((Group)con).getChildren(), param, baseParam, index);
            ++n2;
        }
        return param;
    }

    private void setBaseParamUI(Control[] father, AbstractBaseParam param, BaseparamComposite baseParam, int index) {
        Control[] controlArray = father;
        int n = father.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            if (con != null && con.getData() != null) {
                if (param instanceof DispParamObj) {
                    DispParamObj dispParamObj = (DispParamObj)param;
                    this.toDispParamUI(con, dispParamObj, con.getData().toString());
                }
                if (param instanceof SoundParamObj) {
                    SoundParamObj soundParamObj = (SoundParamObj)param;
                    this.toSoundParamUI(con, soundParamObj, con.getData().toString());
                }
                if (param instanceof I2SModeObj) {
                    I2SModeObj i2SModeObj = (I2SModeObj)param;
                    this.toI2SModeParamUI(con, i2SModeObj, con.getData().toString());
                }
            }
            ++n2;
        }
    }

    private void setBaseParam(Control[] father, AbstractBaseParam param) {
        int i2s = 0;
        int arc = 0;
        Control[] controlArray = father;
        int n = father.length;
        int n2 = 0;
        while (n2 < n) {
            Control con = controlArray[n2];
            if (con != null && con.getData() != null) {
                if (param instanceof DispParamObj) {
                    DispParamObj dispParamObj = (DispParamObj)param;
                    if (dispParamObj.getYpbpr().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "ypbpr");
                    }
                    if (dispParamObj.getRgb().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "rgb");
                    }
                    if (dispParamObj.getCvbs().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "cvbs");
                    }
                    if (dispParamObj.getSvideo().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "svideo");
                    }
                    if (dispParamObj.getHdmi().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "hdmi");
                    }
                    if (dispParamObj.getBt656().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "bt656");
                    }
                    if (dispParamObj.getBt1120().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "bt1120");
                    }
                    if (dispParamObj.getLcd().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "lcd");
                    }
                    if (dispParamObj.getVga().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "vga");
                    }
                    if (FastplayView.isHi3796CV300Series() && dispParamObj.getMipi().size() == 0) {
                        this.toDispParam(con, (DispParamObj)param, "mipi");
                    }
                    this.toDispParam(con, dispParamObj, con.getData().toString());
                } else if (param instanceof SoundParamObj) {
                    SoundParamObj soundParamObj = (SoundParamObj)param;
                    if (soundParamObj.getI2SModel().size() == 0) {
                        this.toSoundParam(con, (SoundParamObj)param, "i2s");
                        this.toSoundParam(con, (SoundParamObj)param, "i2sVolume");
                    }
                    if (soundParamObj.getSpdif().size() == 0) {
                        this.toSoundParam(con, (SoundParamObj)param, "spdif");
                        this.toSoundParam(con, (SoundParamObj)param, "spdifVolume");
                    }
                    if (soundParamObj.getDac().size() == 0) {
                        this.toSoundParam(con, (SoundParamObj)param, "dac");
                        this.toSoundParam(con, (SoundParamObj)param, "dacVolume");
                    }
                    if (soundParamObj.getSound_hdmi().size() == 0) {
                        this.toSoundParam(con, (SoundParamObj)param, "sound_hdmi");
                        this.toSoundParam(con, (SoundParamObj)param, "sound_hdmiVolume");
                    }
                    if (soundParamObj.getArc().size() == 0) {
                        this.toSoundParam(con, (SoundParamObj)param, "arc");
                        this.toSoundParam(con, (SoundParamObj)param, "arcVolume");
                    }
                    if (SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name().equalsIgnoreCase(con.getData().toString())) {
                        con.setData("Index", (Object)i2s);
                        ++i2s;
                    }
                    if (SoundParamObj.BASE_SOUND_ATTRNAME.arc.name().equalsIgnoreCase(con.getData().toString())) {
                        con.setData("Index", (Object)arc);
                        ++arc;
                    }
                    this.toSoundParam(con, (SoundParamObj)param, con.getData().toString());
                } else if (param instanceof I2SModeObj) {
                    this.toI2SModeParam(con, (I2SModeObj)param, con.getData().toString());
                }
            }
            ++n2;
        }
    }

    private void toI2SModeParamUI(Control subControl, I2SModeObj param, String attrName) {
        Control[] findCom = new Control[1];
        if (attrName == null) {
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name()) + 1, findCom);
            ((Combo)findCom[0]).select(param.getI2smodel());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.mclk.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.mclk.name()) + 1, findCom);
            ((Combo)findCom[0]).select(param.getMclk());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.bclk.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bclk.name()) + 1, findCom);
            ((Combo)findCom[0]).select(param.getBclk());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.chnum.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.chnum.name()) + 1, findCom);
            ((Combo)findCom[0]).select(param.getChnum());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name()) + 1, findCom);
            ((Combo)findCom[0]).select(param.getBitdepth());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name()) + 1, findCom);
            ((Combo)findCom[0]).select(param.getPcmdelay());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.master.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.master.name()) + 1, findCom);
            int master = param.getMaster();
            if (master == 1) {
                ((Button)findCom[0]).setSelection(true);
            } else {
                ((Button)findCom[0]).setSelection(false);
            }
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name()) + 1, findCom);
            int pcmSampleRiseEdge = param.getPcmSampleRiseEdge();
            if (pcmSampleRiseEdge == 1) {
                ((Button)findCom[0]).setSelection(true);
            } else {
                ((Button)findCom[0]).setSelection(false);
            }
        }
    }

    private void toI2SModeParam(Control subControl, I2SModeObj param, String attrName) {
        if (attrName == null) {
            return;
        }
        Control[] findCom = new Control[1];
        if (I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.i2smodel.name()) + 1, findCom);
            param.setI2smodel(((Combo)findCom[0]).getSelectionIndex());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.mclk.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.mclk.name()) + 1, findCom);
            param.setMclk(((Combo)findCom[0]).getSelectionIndex());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.bclk.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bclk.name()) + 1, findCom);
            param.setBclk(((Combo)findCom[0]).getSelectionIndex());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.chnum.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.chnum.name()) + 1, findCom);
            param.setChnum(((Combo)findCom[0]).getSelectionIndex());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.bitdepth.name()) + 1, findCom);
            param.setBitdepth(((Combo)findCom[0]).getSelectionIndex());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmdelay.name()) + 1, findCom);
            param.setPcmdelay(((Combo)findCom[0]).getSelectionIndex());
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.master.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.master.name()) + 1, findCom);
            if (((Button)findCom[0]).getSelection()) {
                param.setMaster(1);
            } else {
                param.setMaster(0);
            }
            return;
        }
        if (I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(I2SModeObj.BASE_I2S_ATTRNAME.pcmSampleRiseEdge.name()) + 1, findCom);
            if (((Button)findCom[0]).getSelection()) {
                param.setPcmSampleRiseEdge(1);
            } else {
                param.setPcmSampleRiseEdge(0);
            }
        }
    }

    private void toSoundParamUI(Control subControl, SoundParamObj param, String attrName) {
        Control[] findCom = new Control[1];
        if (this.toSoundParamUISpdif(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toSoundParamUIDac(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toSoundParamUIHdmi(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toSoundParamUIArc(subControl, param, attrName, findCom)) {
            return;
        }
    }

    private boolean toSoundParamUIArc(Control subControl, SoundParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.arc.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 1, findCom);
            List<Arc> arcList = param.getArc();
            Arc arc = arcList.get(0);
            if (arc != null) {
                if (arc.getArc() == 1) {
                    param.getArc().remove(arc);
                } else {
                    int arcValue = arc.getArc();
                    int arcVolumeValue = arc.getArcVolume();
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 1, findCom);
                    ((Combo)findCom[0]).select(arcValue);
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 2, findCom);
                    ((Spinner)findCom[0]).setSelection(arcVolumeValue);
                }
            }
            return false;
        }
        return true;
    }

    private boolean toSoundParamUIHdmi(Control subControl, SoundParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 1, findCom);
            List<SoundHdmi> soundHdmiList = param.getSound_hdmi();
            SoundHdmi soundHdmi = soundHdmiList.get(0);
            if (soundHdmi != null) {
                if (soundHdmi.getHdmi() == 1) {
                    param.getSound_hdmi().remove(soundHdmi);
                } else {
                    int soundHdmiVolume = soundHdmi.getSoundHdmiVolume();
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 1, findCom);
                    ((Combo)findCom[0]).select(0);
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 2, findCom);
                    ((Spinner)findCom[0]).setSelection(soundHdmiVolume);
                }
            }
            return false;
        }
        return true;
    }

    private boolean toSoundParamUIDac(Control subControl, SoundParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.dac.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 1, findCom);
            List<Dac> dacList = param.getDac();
            Dac dac = dacList.get(0);
            if (dac != null) {
                if (dac.getDac() == 1) {
                    param.getDac().remove(dac);
                } else {
                    int dacValue = dac.getDac();
                    int dacVolumeValue = dac.getDacVolume();
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 1, findCom);
                    ((Combo)findCom[0]).select(dacValue);
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 2, findCom);
                    ((Spinner)findCom[0]).setSelection(dacVolumeValue);
                }
            }
            return true;
        }
        return false;
    }

    private boolean toSoundParamUISpdif(Control subControl, SoundParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 1, findCom);
            List<Spdif> spdifList = param.getSpdif();
            Spdif spdif = spdifList.get(0);
            if (spdif != null) {
                if (spdif.getSpdif() == 1) {
                    param.getSpdif().remove(spdif);
                } else {
                    int spdifValue = spdif.getSpdif();
                    int spdifVolumeValue = spdif.getSpdifVolume();
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 1, findCom);
                    ((Combo)findCom[0]).select(spdifValue);
                    WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 2, findCom);
                    ((Spinner)findCom[0]).setSelection(spdifVolumeValue);
                }
            }
            return true;
        }
        return false;
    }

    private void toSoundParam(Control subControl, SoundParamObj param, String attrName) {
        if (attrName == null) {
            return;
        }
        Control[] findCom = new Control[1];
        if (SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 1, findCom);
            if (findCom[0] == null) {
                Spdif initSpdif = new Spdif(1, 30);
                if (param.getSpdif().contains(initSpdif)) {
                    param.getSpdif().remove(initSpdif);
                } else {
                    param.addSpdifToList(initSpdif);
                }
            } else {
                int spdif = 0;
                int spdifVolume = 30;
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 1, findCom);
                spdif = ((Combo)findCom[0]).getSelectionIndex();
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.spdif.name()) + 2, findCom);
                spdifVolume = ((Spinner)findCom[0]).getSelection();
                Spdif spdifObj = new Spdif(spdif, spdifVolume);
                if (param.getSpdif().size() > 0) {
                    param.getSpdif().remove(0);
                }
                param.addSpdifToList(spdifObj);
            }
            return;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.dac.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 1, findCom);
            if (findCom[0] == null) {
                Dac initDac = new Dac(1, 30);
                if (param.getDac().contains(initDac)) {
                    param.getDac().remove(initDac);
                } else {
                    param.addDacToList(initDac);
                }
            } else {
                int dac = 0;
                int dacVolume = 30;
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 1, findCom);
                dac = ((Combo)findCom[0]).getSelectionIndex();
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.dac.name()) + 2, findCom);
                dacVolume = ((Spinner)findCom[0]).getSelection();
                Dac dacObject = new Dac(dac, dacVolume);
                if (param.getDac().size() > 0) {
                    param.getDac().remove(0);
                }
                param.addDacToList(dacObject);
            }
            return;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 1, findCom);
            if (findCom[0] == null) {
                SoundHdmi initSoundHdmi = new SoundHdmi(1, 30);
                if (param.getSound_hdmi().contains(initSoundHdmi)) {
                    param.getSound_hdmi().remove(initSoundHdmi);
                } else {
                    param.addSoundHdmiToList(initSoundHdmi);
                }
            } else {
                int soundHdmi = -1;
                int soundHdmiVolume = 30;
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 1, findCom);
                String text = ((Combo)findCom[0]).getText();
                if ("HDMI_ID_0".equals(text)) {
                    soundHdmi = 0;
                } else if ("HDMI_ID_1".equals(text)) {
                    soundHdmi = 1;
                }
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.sound_hdmi.name()) + 2, findCom);
                soundHdmiVolume = ((Spinner)findCom[0]).getSelection();
                SoundHdmi soundHdmiObj = new SoundHdmi(soundHdmi, soundHdmiVolume);
                if (param.getSound_hdmi().size() > 0) {
                    param.getSound_hdmi().remove(0);
                }
                param.addSoundHdmiToList(soundHdmiObj);
            }
            return;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.arc.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 1, findCom);
            if (findCom[0] == null || param.getArc().size() == 0) {
                if (param.getArc().size() == 0) {
                    if (FastplayView.isHi3796CV300Series()) {
                        Arc initArc = new Arc(-1, 30);
                        param.addArcToList(initArc);
                        initArc = new Arc(-1, 30);
                        param.addArcToList(initArc);
                    } else {
                        Arc initArc = new Arc(1, 30);
                        param.addArcToList(initArc);
                    }
                }
            } else {
                int arc = 0;
                int arcVolume = 30;
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 1, findCom);
                arc = ((Combo)findCom[0]).getSelectionIndex();
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.arc.name()) + 2, findCom);
                arcVolume = ((Spinner)findCom[0]).getSelection();
                int index = 0;
                try {
                    Object object = subControl.getData("Index");
                    String indexStr = String.valueOf(object);
                    index = Integer.valueOf(indexStr);
                }
                catch (NumberFormatException NumberFormatException2) {
                    NumberFormatException2.printStackTrace();
                }
                Arc arcObj = param.getArc().get(index);
                arcObj.setArc(arc);
                arcObj.setArcVolume(arcVolume);
            }
            return;
        }
        if (SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name().equals(attrName)) {
            WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 1, findCom);
            if (findCom[0] == null || param.getArc().size() == 0) {
                if (param.getArc().size() == 0) {
                    I2s initI2s = new I2s(-1, 30);
                    if (FastplayView.isHi3796CV300Series()) {
                        param.addI2sModeToList(initI2s);
                        initI2s = new I2s(-1, 30);
                        param.addI2sModeToList(initI2s);
                        initI2s = new I2s(-1, 30);
                        param.addI2sModeToList(initI2s);
                        initI2s = new I2s(-1, 30);
                        param.addI2sModeToList(initI2s);
                        initI2s = new I2s(-1, 30);
                        param.addI2sModeToList(initI2s);
                    } else {
                        param.addI2sModeToList(initI2s);
                        initI2s = new I2s(-1, 30);
                        param.addI2sModeToList(initI2s);
                    }
                }
            } else {
                int i2s = 0;
                int i2sVolume = 0;
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 1, findCom);
                i2s = ((Combo)findCom[0]).getSelectionIndex();
                WidgetParam.findControl(subControl, String.valueOf(SoundParamObj.BASE_SOUND_ATTRNAME.i2s.name()) + 2, findCom);
                i2sVolume = ((Spinner)findCom[0]).getSelection();
                int index = 0;
                try {
                    Object object = subControl.getData("Index");
                    String indexStr = String.valueOf(object);
                    index = Integer.valueOf(indexStr);
                }
                catch (NumberFormatException NumberFormatException3) {
                    NumberFormatException3.printStackTrace();
                }
                I2s i2sObj = param.getI2SModel().get(index);
                i2sObj.setI2s(i2s);
                i2sObj.setI2sVolume(i2sVolume);
            }
        }
    }

    private void toDispParamUI(Control subControl, DispParamObj param, String attrName) {
        Control[] findCom = new Control[1];
        if (this.toDispParamUIForBase(subControl, param, attrName)) {
            return;
        }
        if (this.toDispParamUIForBind(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForYpbpr(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForRgb(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForSvideo(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForCvbs(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForHdmi(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForMipi(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForBt656(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForBt1120(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForLcd(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForVga(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamUIForGraphics(subControl, param, attrName)) {
            return;
        }
    }

    private boolean toDispParamUIForGraphics(Control subControl, DispParamObj param, String attrName) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.basekeyenable.name().equals(attrName.toString())) {
            boolean isBaseKeyEnable = false;
            if (param.getBaseKeyEnable() == 1) {
                isBaseKeyEnable = true;
            }
            ((Button)subControl).setSelection(isBaseKeyEnable);
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.pixelFormat.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getPixelFormat());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.left.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getLeft()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.top.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getTop()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.right.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getRight()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bottom.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getBottom()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.virtualWidth.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getVirtualWidth()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.virtualHeight.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getVirtualHeight()));
            return true;
        }
        if (this.toDispParamUIForAspect(subControl, param, attrName)) {
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.userAspectW.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getUserAspectW()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.userAspectH.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getUserAspectH()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.vidOutMode.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getVidOutMode());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.deepColorMode.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getDeepColorMode());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.hdrType.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getHdrType());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.colorSpaceType.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getColorSpaceType());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.cvbsoutputstandardtype.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getCvbsOutputStandardType());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.vic.name().equals(attrName.toString())) {
            String value = Integer.toHexString(param.getVic());
            if (value.equalsIgnoreCase("FFFFFFFF")) {
                value = "FFFF";
            }
            ((Text)subControl).setText(value);
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.matchcontenttype.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getMatchContentType());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.scenemode.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getSceneMode());
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForAspect(Control subControl, DispParamObj param, String attrName) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.aspectRatio.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getAspectRatio());
            Text userAspectW = (Text)this.findActiveCon(subControl.getParent(), DispParamObj.BASE_DISP_ATTRNAME.userAspectW.name());
            Text userAspectH = (Text)this.findActiveCon(subControl.getParent(), DispParamObj.BASE_DISP_ATTRNAME.userAspectH.name());
            if (((Combo)subControl).getSelectionIndex() != HI_UNF_DISP.HI_UNF_DISP_ASPECT_RATIO_E.ASPECT_RATIO_USER.ordinal()) {
                if (userAspectW != null) {
                    userAspectW.setEnabled(false);
                }
                if (userAspectH != null) {
                    userAspectH.setEnabled(false);
                }
            } else {
                if (userAspectW != null) {
                    userAspectW.setEnabled(true);
                }
                if (userAspectH != null) {
                    userAspectH.setEnabled(true);
                }
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForVga(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (DispParamObj.BASE_DISP_ATTRNAME.vga.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1, findCom);
            List<SubParam> vgaList = param.getVga();
            if (vgaList != null && vgaList.size() > 0) {
                Vga vga = (Vga)vgaList.get(0);
                int v = vga.getR();
                int g = vga.getG();
                int a = vga.getB();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1, findCom);
                ((Text)findCom[0]).setText(String.valueOf(v));
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 2, findCom);
                ((Text)findCom[0]).setText(String.valueOf(g));
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 3, findCom);
                ((Text)findCom[0]).setText(String.valueOf(a));
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForLcd(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.lcd.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1, findCom);
            List<SubParam> lcdList = param.getLcd();
            if (lcdList != null && lcdList.size() > 0) {
                Lcd lcd = (Lcd)lcdList.get(0);
                int lcdValue = lcd.getLcd();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1, findCom);
                ((Combo)findCom[0]).select(lcdValue);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForBt1120(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bt1120.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1, findCom);
            List<SubParam> bt1120List = param.getBt1120();
            if (bt1120List != null && bt1120List.size() > 0) {
                Bt1120 bt1120 = (Bt1120)bt1120List.get(0);
                int bt1120Value = bt1120.getBt1120();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1, findCom);
                ((Combo)findCom[0]).select(bt1120Value);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForBt656(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bt656.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt656.name()) + 1, findCom);
            List<SubParam> bt656List = param.getBt656();
            if (bt656List != null && bt656List.size() > 0) {
                Bt656 bt656 = (Bt656)bt656List.get(0);
                int bt656Value = bt656.getBt656();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1, findCom);
                ((Combo)findCom[0]).select(bt656Value);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForMipi(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.mipi.name().equals(attrName.toString())) {
            subControl.setData("key", (Object)param.getMipiModeObj());
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForHdmi(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.hdmi.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1, findCom);
            List<SubParam> hdmiList = param.getHdmi();
            if (hdmiList != null && hdmiList.size() > 0) {
                Hdmi hdmi = (Hdmi)hdmiList.get(0);
                int hdmiValue = hdmi.getHdmi();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1, findCom);
                if (FastplayView.isHi3796CV300Series()) {
                    hdmiValue = 0;
                }
                ((Combo)findCom[0]).select(hdmiValue);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForCvbs(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.cvbs.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1, findCom);
            List<SubParam> cvbsList = param.getCvbs();
            if (cvbsList != null && cvbsList.size() > 0) {
                Cvbs cvbs = (Cvbs)cvbsList.get(0);
                String cvbsValue = cvbs.getCvbs();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1, findCom);
                ((Text)findCom[0]).setText(cvbsValue);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForSvideo(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.svideo.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1, findCom);
            List<SubParam> svideoList = param.getSvideo();
            if (svideoList != null && svideoList.size() > 0) {
                Svideo svideo = (Svideo)svideoList.get(0);
                int u8DacY = svideo.getU8DacY();
                int u8DacC = svideo.getU8DacC();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1, findCom);
                ((Text)findCom[0]).setText(String.valueOf(u8DacY));
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 2, findCom);
                ((Text)findCom[0]).setText(String.valueOf(u8DacC));
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForRgb(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.rgb.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1, findCom);
            List<SubParam> rgbList = param.getRgb();
            if (rgbList != null && rgbList.size() > 0) {
                Rgb rgb = (Rgb)rgbList.get(0);
                int r = rgb.getR();
                int g = rgb.getG();
                int b = rgb.getB();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1, findCom);
                ((Text)findCom[0]).setText(String.valueOf(r));
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 2, findCom);
                ((Text)findCom[0]).setText(String.valueOf(g));
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 3, findCom);
                ((Text)findCom[0]).setText(String.valueOf(b));
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForYpbpr(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1, findCom);
            List<SubParam> ypbprList = param.getYpbpr();
            if (ypbprList != null && ypbprList.get(0) != null) {
                Ypbpr ypbpr = (Ypbpr)ypbprList.get(0);
                String u8DacY = ypbpr.getU8DacY();
                String u8DacPb = ypbpr.getU8DacPb();
                String u8DacPr = ypbpr.getU8DacPr();
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1, findCom);
                ((Text)findCom[0]).setText(u8DacY);
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 2, findCom);
                ((Text)findCom[0]).setText(u8DacPb);
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 3, findCom);
                ((Text)findCom[0]).setText(u8DacPr);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForBind(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name(), findCom);
            int bindDisp = param.getBindDisp();
            if (bindDisp == 1) {
                ((Button)findCom[0]).setSelection(true);
            } else {
                ((Button)findCom[0]).setSelection(false);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamUIForBase(Control subControl, DispParamObj param, String attrName) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.format.name().equals(attrName.toString())) {
            ((Combo)subControl).select(param.getFormat());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.hueplus.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getHueplus()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.colortemperature.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getColorTemperature()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.logoIndex.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getLogoIndex()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.panelIndex.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getPanelIndex()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.saturation.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getSaturation()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.constrast.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getConstrast()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.brightness.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getBrightness()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColor.name().equals(attrName.toString())) {
            ((Text)subControl).setText(param.getBgColor());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColorR.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getBgColorR()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColorG.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getBgColorG()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColorB.name().equals(attrName.toString())) {
            ((Text)subControl).setText(String.valueOf(param.getBgColorB()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.gammaEnable.name().equals(attrName.toString())) {
            ((Button)subControl).setSelection(param.isGammaEnable());
            return true;
        }
        return false;
    }

    private Control findActiveCon(Composite com, String data) {
        Control[] children = com.getChildren();
        if (data == null) {
            return null;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].getData() != null && children[i].getData().equals(data)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    private void toDispParam(Control subControl, DispParamObj param, String attrName) {
        Control[] findCom = new Control[1];
        if (this.toDispParamForBase(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamForInterface(subControl, param, attrName, findCom)) {
            return;
        }
        if (this.toDispParamForGraphics(subControl, param, attrName)) {
            return;
        }
    }

    private boolean toDispParamForGraphics(Control subControl, DispParamObj param, String attrName) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.basekeyenable.name().equals(attrName.toString())) {
            boolean selection = ((Button)subControl).getSelection();
            if (selection) {
                param.setBaseKeyEnable(1);
            } else {
                param.setBaseKeyEnable(0);
            }
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.pixelFormat.name().equals(attrName.toString())) {
            param.setPixelFormat(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.left.name().equals(attrName.toString())) {
            param.setLeft(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.top.name().equals(attrName.toString())) {
            param.setTop(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.right.name().equals(attrName.toString())) {
            param.setRight(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bottom.name().equals(attrName.toString())) {
            param.setBottom(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.virtualWidth.name().equals(attrName.toString())) {
            param.setVirtualWidth(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.virtualHeight.name().equals(attrName.toString())) {
            param.setVirtualHeight(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.aspectRatio.name().equals(attrName.toString())) {
            param.setAspectRatio(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.userAspectW.name().equals(attrName.toString())) {
            param.setUserAspectW(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.userAspectH.name().equals(attrName.toString())) {
            param.setUserAspectH(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.vidOutMode.name().equals(attrName.toString())) {
            param.setVidOutMode(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.deepColorMode.name().equals(attrName.toString())) {
            param.setDeepColorMode(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.hdrType.name().equals(attrName.toString())) {
            param.setHdrType(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.colorSpaceType.name().equals(attrName.toString())) {
            param.setColorSpaceType(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.cvbsoutputstandardtype.name().equals(attrName.toString())) {
            param.setCvbsOutputStandardType(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.vic.name().equals(attrName.toString())) {
            param.setVic(Integer.parseInt(((Text)subControl).getText().trim(), 16));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.matchcontenttype.name().equals(attrName.toString())) {
            param.setMatchContentType(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.scenemode.name().equals(attrName.toString())) {
            param.setSceneMode(((Combo)subControl).getSelectionIndex());
            return true;
        }
        return false;
    }

    private boolean toDispParamForInterface(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (this.toDispYpbpr(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispRgb(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispSvideo(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispCvbs(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispHdmi(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispMipi(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispBt656(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispBt1120(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispLcd(subControl, param, attrName, findCom)) {
            return true;
        }
        if (this.toDispVga(subControl, param, attrName, findCom)) {
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.cvbsoutputstandardtype.name().equals(attrName.toString())) {
            param.setCvbsOutputStandardType(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.vic.name().equals(attrName.toString())) {
            param.setVic(Integer.parseInt(((Text)subControl).getText().trim().trim(), 16));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.matchcontenttype.name().equals(attrName.toString())) {
            param.setMatchContentType(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.scenemode.name().equals(attrName.toString())) {
            param.setSceneMode(((Combo)subControl).getSelectionIndex());
            return true;
        }
        return false;
    }

    private boolean toDispVga(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.vga.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1, findCom);
            if (findCom[0] == null) {
                Vga initVga = new Vga(-1, -1, -1);
                if (param.getVga().contains(initVga)) {
                    param.getVga().remove(initVga);
                } else {
                    param.addVgaToList(initVga);
                }
            } else {
                int v = 0;
                int g = 0;
                int a = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 1, findCom);
                v = Integer.parseInt(((Text)findCom[0]).getText().trim());
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 2, findCom);
                g = Integer.parseInt(((Text)findCom[0]).getText().trim());
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.vga.name()) + 3, findCom);
                a = Integer.parseInt(((Text)findCom[0]).getText().trim());
                Vga vga = new Vga(v, g, a);
                if (param.getVga().size() > 0) {
                    param.getVga().remove(0);
                }
                param.addVgaToList(vga);
            }
            return true;
        }
        return false;
    }

    private boolean toDispLcd(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.lcd.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1, findCom);
            if (findCom[0] == null) {
                Lcd initLcd = new Lcd(1);
                if (param.getLcd().contains(initLcd)) {
                    param.getLcd().remove(initLcd);
                } else {
                    param.addLcdToList(initLcd);
                }
            } else {
                int lcd = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.lcd.name()) + 1, findCom);
                lcd = ((Combo)findCom[0]).getSelectionIndex();
                Lcd lcdObj = new Lcd(lcd);
                if (param.getLcd().size() > 0) {
                    param.getLcd().remove(0);
                }
                param.addLcdToList(lcdObj);
            }
            return true;
        }
        return false;
    }

    private boolean toDispBt1120(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (DispParamObj.BASE_DISP_ATTRNAME.bt1120.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1, findCom);
            if (findCom[0] == null) {
                Bt1120 initBt1120 = new Bt1120(1);
                if (param.getBt1120().contains(initBt1120)) {
                    param.getBt1120().remove(initBt1120);
                } else {
                    param.addBt1120ToList(initBt1120);
                }
            } else {
                int bt1120 = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt1120.name()) + 1, findCom);
                bt1120 = ((Combo)findCom[0]).getSelectionIndex();
                Bt1120 bt1120Obj = new Bt1120(bt1120);
                if (param.getBt1120().size() > 0) {
                    param.getBt1120().remove(0);
                }
                param.addBt1120ToList(bt1120Obj);
            }
            return true;
        }
        return false;
    }

    private boolean toDispBt656(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bt656.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt656.name()) + 1, findCom);
            if (findCom[0] == null) {
                Bt656 initBt656 = new Bt656(1);
                if (param.getBt656().contains(initBt656)) {
                    param.getBt656().remove(initBt656);
                } else {
                    param.addBt656ToList(initBt656);
                }
            } else {
                int bt656 = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bt656.name()) + 1, findCom);
                bt656 = ((Combo)findCom[0]).getSelectionIndex();
                Bt656 bt656Obj = new Bt656(bt656);
                if (param.getBt656().size() > 0) {
                    param.getBt656().remove(0);
                }
                param.addBt656ToList(bt656Obj);
            }
            return true;
        }
        return false;
    }

    private boolean toDispHdmi(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.hdmi.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1, findCom);
            if (findCom[0] == null) {
                int value = 1;
                if (FastplayView.isHi3796CV300Series()) {
                    value = -1;
                }
                Hdmi initHdmi = new Hdmi(value);
                if (param.getHdmi().contains(initHdmi)) {
                    param.getHdmi().remove(initHdmi);
                } else {
                    param.addHdmiToList(initHdmi);
                }
            } else {
                String text;
                int hdmi = -1;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.hdmi.name()) + 1, findCom);
                if (findCom[0] instanceof Combo) {
                    Combo comboFind = (Combo)findCom[0];
                    String string = comboFind.getText();
                }
                if ("HDMI_ID_0".equals(text = ((Combo)findCom[0]).getText())) {
                    hdmi = 0;
                } else if ("HDMI_ID_1".equals(text)) {
                    hdmi = 1;
                }
                Hdmi hdmiObj = new Hdmi(hdmi);
                if (param.getHdmi().size() > 0) {
                    param.getHdmi().remove(0);
                }
                param.addHdmiToList(hdmiObj);
            }
            return true;
        }
        return false;
    }

    private boolean toDispCvbs(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.cvbs.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1, findCom);
            if (findCom[0] == null) {
                Cvbs initCvbs = new Cvbs(INIT_STRING_VALUE);
                if (param.getCvbs().contains(initCvbs)) {
                    param.getCvbs().remove(initCvbs);
                } else {
                    param.addCvbsToList(initCvbs);
                }
            } else {
                int cvbs = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.cvbs.name()) + 1, findCom);
                cvbs = Integer.parseInt(((Text)findCom[0]).getText().trim());
                Cvbs cvbsOjb = new Cvbs(String.valueOf(cvbs));
                if (param.getCvbs().size() > 0) {
                    param.getCvbs().remove(0);
                }
                param.addCvbsToList(cvbsOjb);
            }
            return true;
        }
        return false;
    }

    private boolean toDispMipi(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.mipi.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.mipi.name()) + 1, findCom);
            if (findCom[0] == null) {
                Mipi initMipi = new Mipi(-1);
                if (param.getMipi().contains(initMipi)) {
                    param.getMipi().remove(initMipi);
                } else {
                    param.addMipiToList(initMipi);
                }
            } else {
                Object object = subControl.getData(DispParamObj.BASE_DISP_ATTRNAME.key.name());
                if (object instanceof MipiModeObj) {
                    param.setMipiModeObj((MipiModeObj)object);
                }
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.mipi.name()) + 1, findCom);
                if (findCom[0] instanceof Combo) {
                    Combo mipiCobo = (Combo)findCom[0];
                    int mipi = mipiCobo.getSelectionIndex();
                    Mipi mipiObj = new Mipi(mipi);
                    if (param.getMipi().size() > 0) {
                        param.getMipi().remove(0);
                    }
                    param.addMipiToList(mipiObj);
                }
            }
            return true;
        }
        return false;
    }

    private boolean toDispSvideo(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.svideo.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1, findCom);
            if (findCom[0] == null) {
                Svideo initSvideo = new Svideo(-1, -1);
                if (param.getSvideo().contains(initSvideo)) {
                    param.getSvideo().remove(initSvideo);
                } else {
                    param.addSvideoToList(initSvideo);
                }
            } else {
                int u8DacY = 0;
                int u8DacC = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 1, findCom);
                u8DacY = Integer.parseInt(((Text)findCom[0]).getText().trim());
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.svideo.name()) + 2, findCom);
                u8DacC = Integer.parseInt(((Text)findCom[0]).getText().trim());
                Svideo svideo = new Svideo(u8DacY, u8DacC);
                if (param.getSvideo().size() > 0) {
                    param.getSvideo().remove(0);
                }
                param.addSvideoToList(svideo);
            }
            return true;
        }
        return false;
    }

    private boolean toDispRgb(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.rgb.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1, findCom);
            if (findCom[0] == null) {
                Rgb initRgb = new Rgb(-1, -1, -1);
                if (param.getRgb().contains(initRgb)) {
                    param.getRgb().remove(initRgb);
                } else {
                    param.addRgbToList(initRgb);
                }
            } else {
                int r = 0;
                int g = 0;
                int b = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 1, findCom);
                r = Integer.parseInt(((Text)findCom[0]).getText().trim());
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 2, findCom);
                g = Integer.parseInt(((Text)findCom[0]).getText().trim());
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.rgb.name()) + 3, findCom);
                b = Integer.parseInt(((Text)findCom[0]).getText().trim());
                Rgb rgb = new Rgb(r, g, b);
                if (param.getRgb().size() > 0) {
                    param.getRgb().remove(0);
                }
                param.addRgbToList(rgb);
            }
            return true;
        }
        return false;
    }

    private boolean toDispYpbpr(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1, findCom);
            if (findCom[0] == null) {
                Ypbpr initYpbpr = new Ypbpr(INIT_STRING_VALUE, INIT_STRING_VALUE, INIT_STRING_VALUE);
                if (param.getYpbpr().contains(initYpbpr)) {
                    param.getYpbpr().remove(initYpbpr);
                } else {
                    param.addYpbprToList(initYpbpr);
                }
            } else {
                int u8DacY = 0;
                int u8DacPb = 0;
                int u8DacPr = 0;
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 1, findCom);
                u8DacY = Integer.parseInt(((Text)findCom[0]).getText().trim());
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 2, findCom);
                u8DacPb = Integer.parseInt(((Text)findCom[0]).getText().trim());
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.ypbpr.name()) + 3, findCom);
                u8DacPr = Integer.parseInt(((Text)findCom[0]).getText().trim());
                Ypbpr ypbpr = new Ypbpr(String.valueOf(u8DacY), String.valueOf(u8DacPb), String.valueOf(u8DacPr));
                if (param.getYpbpr().size() > 0) {
                    param.getYpbpr().remove(0);
                }
                param.addYpbprToList(ypbpr);
            }
            return true;
        }
        return false;
    }

    private boolean toDispParamForBase(Control subControl, DispParamObj param, String attrName, Control[] findCom) {
        if (attrName == null) {
            return false;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.format.name().equals(attrName.toString())) {
            param.setFormat(((Combo)subControl).getSelectionIndex());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.hueplus.name().equals(attrName.toString())) {
            param.setHueplus(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.colortemperature.name().equals(attrName.toString())) {
            param.setColorTemperature(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.logoIndex.name().equals(attrName.toString())) {
            param.setLogoIndex(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.panelIndex.name().equals(attrName.toString())) {
            param.setPanelIndex(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.saturation.name().equals(attrName.toString())) {
            param.setSaturation(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.constrast.name().equals(attrName.toString())) {
            param.setConstrast(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.brightness.name().equals(attrName.toString())) {
            param.setBrightness(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColor.name().equals(attrName.toString())) {
            param.setBgColor(((Text)subControl).getText().trim());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColorR.name().equals(attrName.toString())) {
            param.setBgColorR(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColorG.name().equals(attrName.toString())) {
            param.setBgColorG(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bgColorB.name().equals(attrName.toString())) {
            param.setBgColorB(Integer.parseInt(((Text)subControl).getText().trim()));
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.gammaEnable.name().equals(attrName.toString())) {
            param.setGammaEnable(((Button)subControl).getSelection());
            return true;
        }
        if (DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name().equals(attrName.toString())) {
            WidgetParam.findControl(subControl, DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name(), findCom);
            if (((Button)findCom[0]).getSelection()) {
                WidgetParam.findControl(subControl, String.valueOf(DispParamObj.BASE_DISP_ATTRNAME.bindDisp.name()) + 1, findCom);
                if (((Button)findCom[0]).getSelection()) {
                    param.setBindDisp(1);
                } else {
                    param.setBindDisp(0);
                }
            } else {
                param.setBindDisp(0);
            }
            return true;
        }
        return false;
    }

    public static void findControl(Control fatherControl, String attrName, Control[] findCon) {
        if (attrName == null) {
            return;
        }
        if (fatherControl instanceof Composite && ((Composite)fatherControl).getChildren() != null) {
            Control[] children;
            Control[] controlArray = children = ((Composite)fatherControl).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control con = controlArray[n2];
                if (attrName.equals(con.getData())) {
                    findCon[0] = con;
                }
                ++n2;
            }
        }
    }
}

