/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.processor;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.model.Music.MusicParam;
import com.hisilicon.fastplay.processor.IBniParamServer;
import com.hisilicon.fastplay.utility.HiToolUtils;
import com.hisilicon.fastplay.utility.StatusUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MusicParamProcess
implements IBniParamServer {
    public static final String CONVERT_TOOL_NAME = "AudioConvertTool.exe";
    public static final String CONVERT_TOOL_NAME_LINUX = "AudioConvertTool";
    public static final String resourcesPath = "Resources/HiFastplay/AudioConvertTool";
    public static final String CONVER_GENERATE_NAME = "auto.pcm";
    private MusicParam musicParam;
    private String convertToolPath;

    @Override
    public Object paramProcess(Object obj) {
        this.musicParam = (MusicParam)obj;
        String srcFile = this.musicParam.getMusicFilePath();
        String hitoolPath = HiToolUtils.getInstallPath();
        this.convertToolPath = String.valueOf(hitoolPath) + resourcesPath;
        String cmd = this.makeCommand(srcFile);
        String osName = System.getProperties().getProperty("os.name");
        String checkToolPath = "";
        checkToolPath = osName.toLowerCase().startsWith("linux") ? (String.valueOf(this.convertToolPath) + File.separator + CONVERT_TOOL_NAME_LINUX).replace("\\", "/") : (String.valueOf(this.convertToolPath) + File.separator + CONVERT_TOOL_NAME).replace("\\", "/");
        if (!new File(checkToolPath).exists()) {
            return StatusUtility.error(Messages.MusicComposite_Not_Find_ConvertTool);
        }
        String converFilePath = (String.valueOf(HiToolUtils.getInstallPath()) + resourcesPath + File.separator + CONVER_GENERATE_NAME).replace("\\", "/");
        File converFile = new File(converFilePath);
        if (converFile.exists()) {
            boolean bl = converFile.delete();
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process exec = runtime.exec(cmd);
            InputStream errorStream = exec.getErrorStream();
            InputStream inputStream = exec.getInputStream();
            new MusicPrintStream(inputStream).start();
            new MusicPrintStream(errorStream).start();
            exec.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SettingComposite_14, (String)("Command is " + cmd + "\r\n" + e.getMessage()));
            return StatusUtility.error(e.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.SettingComposite_14, (String)("Command is " + cmd + "\r\n" + e.getMessage()));
            return StatusUtility.error(e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private String makeCommand(String srcFile) {
        String osName = System.getProperties().getProperty("os.name");
        StringBuilder cmdbd = new StringBuilder();
        cmdbd.append(this.convertToolPath);
        cmdbd.append(File.separator);
        if (osName.toLowerCase().startsWith("linux")) {
            cmdbd.append(CONVERT_TOOL_NAME_LINUX);
            cmdbd.append(" ");
            cmdbd.append(srcFile);
            cmdbd.append(" ");
            cmdbd.append(this.convertToolPath);
            return cmdbd.toString();
        }
        cmdbd.append(CONVERT_TOOL_NAME);
        cmdbd.append(" ");
        cmdbd.append("\"");
        cmdbd.append(srcFile);
        cmdbd.append("\"");
        cmdbd.append(" ");
        cmdbd.append("\"");
        cmdbd.append(this.convertToolPath);
        cmdbd.append("\"");
        return cmdbd.toString().replace("/", "\\");
    }

    static class MusicPrintStream
    extends Thread {
        InputStream is = null;

        public MusicPrintStream(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                while (this != null) {
                    int ch = this.is.read();
                    if (ch != -1) {
                        System.out.print((char)ch);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

