/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.processor;

import com.hisilicon.fastplay.Activator;
import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.jni.JNIMakeBin;
import com.hisilicon.fastplay.model.Music.MusicParam;
import com.hisilicon.fastplay.model.Setting;
import com.hisilicon.fastplay.model.baseparam.Arc;
import com.hisilicon.fastplay.model.baseparam.BaseParam;
import com.hisilicon.fastplay.model.baseparam.Bt1120;
import com.hisilicon.fastplay.model.baseparam.Bt656;
import com.hisilicon.fastplay.model.baseparam.Cvbs;
import com.hisilicon.fastplay.model.baseparam.Dac;
import com.hisilicon.fastplay.model.baseparam.DispParamObj;
import com.hisilicon.fastplay.model.baseparam.Hdmi;
import com.hisilicon.fastplay.model.baseparam.I2SModeObj;
import com.hisilicon.fastplay.model.baseparam.I2s;
import com.hisilicon.fastplay.model.baseparam.Lcd;
import com.hisilicon.fastplay.model.baseparam.Mipi;
import com.hisilicon.fastplay.model.baseparam.Rgb;
import com.hisilicon.fastplay.model.baseparam.SoundHdmi;
import com.hisilicon.fastplay.model.baseparam.SoundParamObj;
import com.hisilicon.fastplay.model.baseparam.Spdif;
import com.hisilicon.fastplay.model.baseparam.Svideo;
import com.hisilicon.fastplay.model.baseparam.Vga;
import com.hisilicon.fastplay.model.baseparam.Ypbpr;
import com.hisilicon.fastplay.model.dvb.DvbParam;
import com.hisilicon.fastplay.model.logoimage.LogParam;
import com.hisilicon.fastplay.model.ts.TSParam;
import com.hisilicon.fastplay.utility.ConvertUtils;
import com.hisilicon.fastplay.utility.FileUtils;
import com.hisilicon.fastplay.utility.StatusUtility;
import com.hisilicon.fastplay.views.FastplayView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PrepareSetting
implements Setting {
    private Object paramObj;
    private Object readParamObj;
    private JNIMakeBin jniMakeBin;
    private DispParamObj readDisplay0;
    private DispParamObj readDisplay1;
    private DispParamObj readDisplay2;
    private SoundParamObj readSound0;
    private SoundParamObj readSound1;
    private SoundParamObj readSound2;
    private List<I2SModeObj> i2SModeObjList = new ArrayList<I2SModeObj>();

    public PrepareSetting(Object paramObj) {
        this.paramObj = paramObj;
        this.jniMakeBin = new JNIMakeBin();
    }

    public Object getParamObj() {
        return this.paramObj;
    }

    public void setParamObj(Object paramObj) {
        this.paramObj = paramObj;
    }

    public Object getReadParamObj() {
        return this.readParamObj;
    }

    public void setReadParamObj(Object readParamObj) {
        this.readParamObj = readParamObj;
    }

    @Override
    public IStatus checkInfo() {
        return null;
    }

    @Override
    public IStatus create(File file) {
        this.convertVersionAndSetting((DvbParam)this.paramObj);
        this.jniMakeBin.makeDvbBin((DvbParam)this.paramObj, file.getAbsolutePath());
        return null;
    }

    private boolean convertVersionAndSetting(DvbParam dvbParam) {
        try {
            String hiFastplayVersion = Activator.getPlugin().getBundle().getVersion().toString();
            String versionNum = hiFastplayVersion.substring(0, hiFastplayVersion.lastIndexOf("."));
            String[] split = versionNum.split("\\.");
            int intVersion = (Integer.parseInt(split[0]) & 0xFF) << 16 | (Integer.parseInt(split[1]) & 0xFF) << 8 | Integer.parseInt(split[2]) & 0xFF;
            dvbParam.setToolVersion(intVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public IStatus createBaseBin(String fileName) {
        int result;
        DispParamObj[] dispParamArray = ((BaseParam)this.paramObj).getDispParamArray();
        SoundParamObj[] soundParayArray = ((BaseParam)this.paramObj).getSoundParayArray();
        I2SModeObj[] i2sModeParamArray = ((BaseParam)this.paramObj).getI2SModeParamArray();
        if (dispParamArray == null || soundParayArray == null) {
            return StatusUtility.error(Messages.Baseparam_3);
        }
        if (FastplayView.isHi3796CV300Series()) {
            SoundParamObj[] soundParamObjArray = soundParayArray;
            int n = soundParayArray.length;
            int n2 = 0;
            while (n2 < n) {
                List<Arc> arcList;
                SoundParamObj soundParamObj = soundParamObjArray[n2];
                if (soundParamObj != null && (arcList = soundParamObj.getArc()) != null && soundParamObj.getArc().size() == 2 && arcList.get(0).getArc() == arcList.get(1).getArc() && arcList.get(0).getArc() != -1) {
                    return StatusUtility.error(Messages.ARC_ERROR);
                }
                ++n2;
            }
        }
        if (i2sModeParamArray == null) {
            ArrayList<I2SModeObj> i2SModeParam = new ArrayList<I2SModeObj>();
            I2SModeObj i2s = new I2SModeObj();
            i2s.setBclk(3);
            i2s.setBitdepth(0);
            i2s.setChnum(1);
            i2s.setI2smodel(0);
            i2s.setMclk(1);
            i2s.setPcmdelay(0);
            i2SModeParam.add(i2s);
            if (i2SModeParam != null && !i2SModeParam.isEmpty()) {
                i2sModeParamArray = new I2SModeObj[i2SModeParam.size()];
                int i = 0;
                while (i < i2SModeParam.size()) {
                    i2sModeParamArray[i] = (I2SModeObj)i2SModeParam.get(i);
                    ++i;
                }
            }
        }
        if ((result = this.jniMakeBin.makeBaseBin(dispParamArray, soundParayArray, i2sModeParamArray, fileName, FastplayView.getCurrentChip())) == -1) {
            return StatusUtility.error(Messages.Baseparam_3);
        }
        return Status.OK_STATUS;
    }

    public IStatus readBaseparamBin(String fileName) {
        boolean readArrayToDisResult;
        String bgColor;
        if (fileName == null || !FileUtils.isExists(fileName)) {
            return null;
        }
        this.readDisplay0 = new DispParamObj();
        this.readDisplay0 = this.jniMakeBin.readDisplay(0, this.readDisplay0, fileName, FastplayView.getCurrentChip());
        if (this.readDisplay0 == null) {
            System.out.println("readDisplay0 is null!");
        } else {
            bgColor = this.readDisplay0.getBgColor();
            this.readDisplay0.setBgColor(this.checkHexFlag(bgColor));
            readArrayToDisResult = this.readArrayToDisy(this.readDisplay0);
            if (!readArrayToDisResult) {
                return StatusUtility.error(Messages.Composite_Int_Type_Conversion_Error);
            }
        }
        this.readDisplay1 = new DispParamObj();
        this.readDisplay1 = this.jniMakeBin.readDisplay(1, this.readDisplay1, fileName, FastplayView.getCurrentChip());
        if (this.readDisplay1 == null) {
            System.out.println("readDisplay1 is null!");
        } else {
            bgColor = this.readDisplay1.getBgColor();
            this.readDisplay1.setBgColor(this.checkHexFlag(bgColor));
            readArrayToDisResult = this.readArrayToDisy(this.readDisplay1);
            if (!readArrayToDisResult) {
                return StatusUtility.error(Messages.Composite_Int_Type_Conversion_Error);
            }
        }
        if (FastplayView.isHi3796CV300Series()) {
            this.readDisplay2 = new DispParamObj();
            this.readDisplay2 = this.jniMakeBin.readDisplay(2, this.readDisplay2, fileName, FastplayView.getCurrentChip());
            if (this.readDisplay2 == null) {
                System.out.println("readDisplay2 is null!");
            } else {
                bgColor = this.readDisplay1.getBgColor();
                this.readDisplay1.setBgColor(this.checkHexFlag(bgColor));
                readArrayToDisResult = this.readArrayToDisy(this.readDisplay2);
                if (!readArrayToDisResult) {
                    return StatusUtility.error(Messages.Composite_Int_Type_Conversion_Error);
                }
            }
        }
        this.readSound0 = new SoundParamObj();
        this.readSound0 = this.jniMakeBin.readSound(0, this.readSound0, fileName, FastplayView.getCurrentChip());
        if (this.readSound0 == null) {
            this.readSound0 = new SoundParamObj();
            System.out.println("readSound0 is null!");
        } else {
            this.i2SModeObjList.clear();
            boolean readArrayToSoundResult = this.readArrayToSound(this.readSound0);
            if (!readArrayToSoundResult) {
                return StatusUtility.error(Messages.Composite_Int_Type_Conversion_Error);
            }
            List<I2s> i2sModel = this.readSound0.getI2SModel();
            if (i2sModel != null && i2sModel.size() > 0) {
                int i = 0;
                while (i < i2sModel.size()) {
                    I2s i2s = i2sModel.get(i);
                    if (i2s != null) {
                        I2SModeObj i2SModeObj = new I2SModeObj();
                        i2SModeObj = this.jniMakeBin.readI2SMode(i, 0, i2SModeObj, fileName, FastplayView.getCurrentChip());
                        this.i2SModeObjList.add(i2SModeObj);
                    }
                    ++i;
                }
            }
        }
        this.readSound1 = new SoundParamObj();
        this.readSound1 = this.jniMakeBin.readSound(1, this.readSound1, fileName, FastplayView.getCurrentChip());
        if (this.readSound1 == null) {
            this.readSound1 = new SoundParamObj();
            System.out.println("readSound1 is null!");
        } else {
            this.readArrayToSound(this.readSound1);
        }
        this.readSound2 = new SoundParamObj();
        this.readSound2 = this.jniMakeBin.readSound(2, this.readSound2, fileName, FastplayView.getCurrentChip());
        if (this.readSound2 == null) {
            this.readSound2 = new SoundParamObj();
            System.out.println("readSound2 is null!");
        } else {
            this.readArrayToSound(this.readSound2);
        }
        if (this.readDisplay0 == null) {
            return Status.CANCEL_STATUS;
        }
        if (this.readDisplay1 == null && this.readDisplay2 == null && this.readSound0 == null && this.readSound1 == null && this.readSound2 == null) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private String checkHexFlag(String param) {
        if (!param.startsWith("0x")) {
            param = "0x" + param;
        }
        return param;
    }

    public boolean readArrayToSound(SoundParamObj soundParamObj) {
        try {
            int arc2;
            String[] arcValue;
            int arc;
            int i2s1;
            String[] soundHdmiValue;
            int hdmi;
            String[] dacValue;
            int dac;
            String[] spdifValue = this.getInterfaceSoundValue(soundParamObj, 0);
            int spdif = Integer.parseInt(spdifValue[0]);
            if (spdif != -1) {
                int spdifVolume = Integer.parseInt(spdifValue[1]);
                Spdif spdifObj = new Spdif(spdif, spdifVolume);
                soundParamObj.getSpdif().add(spdifObj);
            }
            if ((dac = Integer.parseInt((dacValue = this.getInterfaceSoundValue(soundParamObj, 6))[0])) != -1) {
                int dacVolume = Integer.parseInt(dacValue[1]);
                Dac dacObj = new Dac(dac, dacVolume);
                soundParamObj.getDac().add(dacObj);
            }
            if ((hdmi = Integer.parseInt((soundHdmiValue = this.getInterfaceSoundValue(soundParamObj, 12))[0])) != -1) {
                int soundHdmiVolume = Integer.parseInt(soundHdmiValue[1]);
                SoundHdmi soundHdmiObj = new SoundHdmi(hdmi, soundHdmiVolume);
                soundParamObj.getSound_hdmi().add(soundHdmiObj);
            }
            String[] i2sValue = this.getInterfaceSoundValue(soundParamObj, 18);
            int i2s0 = Integer.parseInt(i2sValue[0]);
            int i2sDefaultValue = 2;
            if (FastplayView.isHi3796CV300Series()) {
                i2sDefaultValue = -1;
            }
            if (i2s0 != i2sDefaultValue) {
                int i2sVolume0 = Integer.parseInt(i2sValue[1]);
                I2s i2sObj0 = new I2s(i2s0, i2sVolume0);
                soundParamObj.getI2SModel().add(i2sObj0);
            }
            if ((i2s1 = Integer.parseInt(i2sValue[2])) != i2sDefaultValue) {
                int i2sVolume1 = Integer.parseInt(i2sValue[3]);
                I2s i2sObj1 = new I2s(i2s1, i2sVolume1);
                soundParamObj.getI2SModel().add(i2sObj1);
            }
            if (FastplayView.isHi3796CV300Series()) {
                this.addI2sToHi3796CV300(soundParamObj, i2sValue);
            }
            if ((arc = Integer.parseInt((arcValue = this.getInterfaceSoundValue(soundParamObj, 24))[0])) != -1) {
                int arcVolume = Integer.parseInt(arcValue[1]);
                Arc arcObj = new Arc(arc, arcVolume);
                soundParamObj.getArc().add(arcObj);
            }
            if (FastplayView.isHi3796CV300Series() && (arc2 = Integer.parseInt(arcValue[2])) != -1) {
                int arcVolume2 = Integer.parseInt(arcValue[3]);
                Arc arcObj2 = new Arc(arc2, arcVolume2);
                soundParamObj.getArc().add(arcObj2);
            }
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void addI2sToHi3796CV300(SoundParamObj soundParamObj, String[] i2sValue) {
        int i2s4;
        int i2s3;
        int i2s2 = Integer.parseInt(i2sValue[4]);
        if (i2s2 != -1) {
            int i2sVolume2 = Integer.parseInt(i2sValue[5]);
            I2s i2sObj2 = new I2s(i2s2, i2sVolume2);
            soundParamObj.getI2SModel().add(i2sObj2);
        }
        if ((i2s3 = Integer.parseInt(i2sValue[6])) != -1) {
            int i2sVolume3 = Integer.parseInt(i2sValue[7]);
            I2s i2sObj3 = new I2s(i2s3, i2sVolume3);
            soundParamObj.getI2SModel().add(i2sObj3);
        }
        if ((i2s4 = Integer.parseInt(i2sValue[8])) != -1) {
            int i2sVolume4 = Integer.parseInt(i2sValue[9]);
            I2s i2sObj4 = new I2s(i2s4, i2sVolume4);
            soundParamObj.getI2SModel().add(i2sObj4);
        }
    }

    private String[] getInterfaceSoundValue(SoundParamObj soundParamObj, int start) {
        String[] interfaceArray = soundParamObj.getInterfaceValueArray();
        String value = interfaceArray[start];
        if (value != null && value.endsWith(",")) {
            value = value.substring(0, value.lastIndexOf(","));
        }
        String[] split = null;
        if (value != null) {
            split = value.split(",");
        }
        return split;
    }

    public boolean readArrayToDisy(DispParamObj dispParamObj) {
        try {
            String[] ypbprValue = this.getInterfaceValue(dispParamObj, 0);
            String u8DacY = ypbprValue[0];
            String u8DacPb = ypbprValue[1];
            String u8DacPr = ypbprValue[2];
            Ypbpr ypbpr = new Ypbpr(u8DacY, u8DacPb, u8DacPr);
            dispParamObj.getYpbpr().add(ypbpr);
            String[] rgbValue = this.getInterfaceValue(dispParamObj, 6);
            int r = Integer.parseInt(rgbValue[0]);
            int g = Integer.parseInt(rgbValue[1]);
            int b = Integer.parseInt(rgbValue[2]);
            Rgb rgb = new Rgb(r, g, b);
            dispParamObj.getRgb().add(rgb);
            String[] cvbsValue = this.getInterfaceValue(dispParamObj, 12);
            String cvbs = cvbsValue[0];
            Cvbs cvbsObj = new Cvbs(cvbs);
            dispParamObj.getCvbs().add(cvbsObj);
            String[] svideoValue = this.getInterfaceValue(dispParamObj, 18);
            int svideo_u8DacY = Integer.parseInt(svideoValue[0]);
            int svideo_u8DacC = Integer.parseInt(svideoValue[1]);
            Svideo svideo = new Svideo(svideo_u8DacY, svideo_u8DacC);
            dispParamObj.getSvideo().add(svideo);
            String[] hdmiValue = this.getInterfaceValue(dispParamObj, 24);
            int hdmi = Integer.parseInt(hdmiValue[0]);
            Hdmi hdmiObj = new Hdmi(hdmi);
            dispParamObj.getHdmi().add(hdmiObj);
            String[] bt656Value = this.getInterfaceValue(dispParamObj, 30);
            int bt656 = Integer.parseInt(bt656Value[0]);
            Bt656 bt656Obj = new Bt656(bt656);
            dispParamObj.getBt656().add(bt656Obj);
            String[] bt1120Value = this.getInterfaceValue(dispParamObj, 36);
            int bt1120 = Integer.parseInt(bt1120Value[0]);
            Bt1120 bt1120Obj = new Bt1120(bt1120);
            dispParamObj.getBt1120().add(bt1120Obj);
            String[] lcdValue = this.getInterfaceValue(dispParamObj, 42);
            int lcd = Integer.parseInt(lcdValue[0]);
            Lcd lcdObj = new Lcd(lcd);
            dispParamObj.getLcd().add(lcdObj);
            String[] vgaValue = this.getInterfaceValue(dispParamObj, 48);
            int vga_v = Integer.parseInt(vgaValue[0]);
            int vga_g = Integer.parseInt(vgaValue[1]);
            int vga_a = Integer.parseInt(vgaValue[2]);
            Vga vgaObj = new Vga(vga_v, vga_g, vga_a);
            dispParamObj.getVga().add(vgaObj);
            if (FastplayView.isHi3796CV300Series()) {
                String[] mipiValue = this.getInterfaceValue(dispParamObj, 54);
                int mipi = Integer.parseInt(mipiValue[0]);
                if (mipi != -1) {
                    dispParamObj.readMipiModeObj();
                }
                Mipi mipiObj = new Mipi(mipi);
                dispParamObj.addMipiToList(mipiObj);
            }
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String[] getInterfaceValue(DispParamObj dispParamObj, int start) {
        String[] interfaceArray = dispParamObj.getInterfaceArray();
        String value = interfaceArray[start];
        if (value != null && value.endsWith(",")) {
            value = value.substring(0, value.lastIndexOf(","));
        }
        String[] split = null;
        if (value != null) {
            split = value.split(",");
        }
        return split;
    }

    public IStatus createDvbBin(File file) {
        if (this.paramObj instanceof DvbParam) {
            DvbParam dvbParam = (DvbParam)this.paramObj;
            String absolutePath = file.getAbsolutePath();
            this.convertVersionAndSetting(dvbParam);
            int result = this.jniMakeBin.makeDvbBin(dvbParam, absolutePath);
            if (result == -1) {
                return StatusUtility.error(Messages.Baseparam_DVB);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus createMusicBin(String fileName) {
        if (this.paramObj instanceof MusicParam) {
            MusicParam musicParam = (MusicParam)this.paramObj;
            int result = this.jniMakeBin.makeMusicBin(musicParam, musicParam.getMusicFilePath(), fileName);
            if (result == -1) {
                return StatusUtility.error(Messages.MusicComposite_Make_Bin_Error);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private void deleteTempFile(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        File file = new File(fileName);
        if (file.exists()) {
            this.isDelete(file);
        }
    }

    public IStatus createLogoBin(File file) {
        if (this.paramObj instanceof LogParam) {
            LogParam logParam = (LogParam)this.paramObj;
            String logFilePath = logParam.getLogFileName();
            String logFilePath1 = logParam.getLogFileName1();
            if (logFilePath.contains("\u00a0")) {
                return StatusUtility.error(Messages.LogoComposite_CHECK_HAS_BLACK);
            }
            String tempLogFilePath1 = "";
            if (logFilePath.endsWith("gif") || logFilePath.endsWith("GIF")) {
                tempLogFilePath1 = ConvertUtils.gifConvertToJPEG(logFilePath);
                if (tempLogFilePath1 == null) {
                    return Status.CANCEL_STATUS;
                }
                logFilePath = tempLogFilePath1;
            }
            String tempLogFilePath2 = "";
            if (logFilePath1 != null && (logFilePath1.endsWith("gif") || logFilePath1.endsWith("GIF"))) {
                tempLogFilePath2 = ConvertUtils.gifConvertToJPEG(logFilePath1);
                if (tempLogFilePath2 == null) {
                    return Status.CANCEL_STATUS;
                }
                logFilePath1 = tempLogFilePath2;
            }
            int result = this.jniMakeBin.makeLogoBin(logFilePath, logFilePath1, file.getAbsolutePath(), logParam.getLogQuality(), logParam.getLogQuality1(), logParam.isLogNotConvertJpg(), FastplayView.getCurrentChip());
            this.deleteTempFile(tempLogFilePath1);
            this.deleteTempFile(tempLogFilePath2);
            if (result == -1) {
                return StatusUtility.error(Messages.Logo_6);
            }
            if (result == 2) {
                return StatusUtility.error(Messages.Logo_4);
            }
            if (result == 3) {
                return StatusUtility.error(Messages.Logo_5);
            }
            if (result == 4) {
                return StatusUtility.error(Messages.Logo_6);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus convertImageToJPG(File file) {
        if (this.paramObj instanceof LogParam) {
            int result;
            LogParam logParam = (LogParam)this.paramObj;
            String logFilePath = logParam.getLogFileName();
            if (logFilePath.endsWith("gif") || logFilePath.endsWith("GIF")) {
                String tempLogFilePath = ConvertUtils.gifConvertToJPEG(logFilePath);
                if (tempLogFilePath == null) {
                    return Status.CANCEL_STATUS;
                }
                result = this.jniMakeBin.convertLogoToJPG(tempLogFilePath, file.getAbsolutePath(), logParam.getLogQuality(), FastplayView.getCurrentChip());
                File tempFile = new File(tempLogFilePath);
                if (tempFile.exists()) {
                    this.isDelete(tempFile);
                }
            } else {
                result = this.jniMakeBin.convertLogoToJPG(logFilePath, file.getAbsolutePath(), logParam.getLogQuality(), FastplayView.getCurrentChip());
            }
            if (result == 2) {
                return StatusUtility.error(Messages.Logo_4);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus createTsBin(File file) {
        if (this.paramObj instanceof TSParam) {
            TSParam TSParam2 = (TSParam)this.paramObj;
            int result = this.jniMakeBin.makeTsBin(TSParam2, TSParam2.getTsSrcPath(), file.getAbsolutePath());
            if (result == -1) {
                return StatusUtility.error(Messages.Logo_8);
            }
            if (result == 2) {
                return StatusUtility.error(Messages.Logo_4);
            }
            if (result == 3) {
                return StatusUtility.error(Messages.Logo_5);
            }
            if (result == 4) {
                return StatusUtility.error(Messages.Logo_8);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus createMultiTsBin(File file) {
        if (this.paramObj instanceof TSParam) {
            int result = this.jniMakeBin.makeMultiTsBin(((TSParam)this.paramObj).getMsArray(), ((TSParam)this.paramObj).getTsSrcPath(), file.getAbsolutePath());
            if (result == -1) {
                return StatusUtility.error(Messages.Logo_8);
            }
            if (result == 2) {
                return StatusUtility.error(Messages.Logo_4);
            }
            if (result == 3) {
                return StatusUtility.error(Messages.Logo_5);
            }
            if (result == 4) {
                return StatusUtility.error(Messages.Logo_8);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public boolean isDelete(File file) {
        return file.delete();
    }

    public DispParamObj getReadDisplay0() {
        return this.readDisplay0;
    }

    public DispParamObj getReadDisplay1() {
        return this.readDisplay1;
    }

    public DispParamObj getReadDisplay2() {
        return this.readDisplay2;
    }

    public SoundParamObj getReadSound0() {
        return this.readSound0;
    }

    public SoundParamObj getReadSound1() {
        return this.readSound1;
    }

    public SoundParamObj getReadSound2() {
        return this.readSound2;
    }

    public List<I2SModeObj> getI2SModeObjList() {
        return this.i2SModeObjList;
    }
}

